/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.export;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.privacyresearch.equation.model.MessageRecord;
import java.util.List;

public class ExportMessage {
    @JsonProperty
    long timestamp;
    @JsonProperty
    String authorName;
    @JsonProperty
    String body;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Quote quote;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    List<Reaction> reactions;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    List<Attachment> attachments;

    public ExportMessage() {
    }

    public ExportMessage(MessageRecord message) {
        this.timestamp = message.dateSent();
        this.authorName = message.sender().name();
        this.body = message.body();
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setQuote(Quote quote) {
        this.quote = quote;
    }

    public void setReactions(List<Reaction> reactions) {
        this.reactions = reactions;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return om.writeValueAsString((Object)this);
    }

    public JsonNode toJsonNode() throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return om.valueToTree((Object)this);
    }

    public static ExportMessage fromString(String src) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        ExportMessage result = (ExportMessage)om.readValue(src, ExportMessage.class);
        return result;
    }

    public static class Quote {
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        long quoteTimestamp;
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String quote;

        public Quote(long timestamp, String body) {
            this.quoteTimestamp = timestamp;
            this.quote = body;
        }
    }

    public static class Attachment {
        @JsonProperty
        String path;
        @JsonProperty
        String contentType;
        @JsonProperty
        long creationDate;

        public Attachment(String path, String contentType, long creationDate) {
            this.path = path;
            this.contentType = contentType;
            this.creationDate = creationDate;
        }
    }

    public static class Reaction {
        @JsonProperty
        String emoji;
        @JsonProperty
        String authorName;

        public Reaction(String emoji, String author) {
            this.emoji = emoji;
            this.authorName = author;
        }
    }
}

