/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasEntryDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.draft.DraftRecord;
import io.privacyresearch.clientdata.draft.UpdateDraftRequest;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.keys.IdentityStoreRecord;
import io.privacyresearch.clientdata.keyvalue.Preferences;
import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptDbRecord;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.quote.QuoteKey;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.reaction.CreateReactionRequest;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.search.SearchMessageRecord;
import io.privacyresearch.clientdata.sticker.StickerPackRecord;
import io.privacyresearch.clientdata.sticker.StickerRecord;
import io.privacyresearch.clientdata.user.UnidentifiedAccessUtil;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.AccountManager;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.CanvasService;
import io.privacyresearch.equation.CheatManager;
import io.privacyresearch.equation.EquationAPI;
import io.privacyresearch.equation.GroupManager;
import io.privacyresearch.equation.IncomingSignalAPI;
import io.privacyresearch.equation.MessageCollector;
import io.privacyresearch.equation.MessageContentProcessor;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.ProfileManager;
import io.privacyresearch.equation.ReactionService;
import io.privacyresearch.equation.SignalServiceDataStoreImpl;
import io.privacyresearch.equation.StorageManager;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.UsernameService;
import io.privacyresearch.equation.WaveCallManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.attachment.AttachmentService;
import io.privacyresearch.equation.attachment.BackfillRequestUpdate;
import io.privacyresearch.equation.backup.BackupStatus;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.export.ExportOptions;
import io.privacyresearch.equation.export.ExportService;
import io.privacyresearch.equation.groups.GroupService;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import io.privacyresearch.equation.incoming.SyncMessageProcessor;
import io.privacyresearch.equation.internal.KeyUtil;
import io.privacyresearch.equation.internal.LockImpl;
import io.privacyresearch.equation.mediaserver.LocalMediaServer;
import io.privacyresearch.equation.message.MessageService;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.DeviceLinkOptions;
import io.privacyresearch.equation.model.FullQuoteRecord;
import io.privacyresearch.equation.model.Message;
import io.privacyresearch.equation.model.MessageRecord;
import io.privacyresearch.equation.model.ReactionRecord;
import io.privacyresearch.equation.model.RegistrationResponse;
import io.privacyresearch.equation.model.SendStickerRequest;
import io.privacyresearch.equation.model.UpdateCanvasRequest;
import io.privacyresearch.equation.model.json.OneTimePreKeyCounts;
import io.privacyresearch.equation.net.ProfileCipherInputStream;
import io.privacyresearch.equation.provision.ProvisioningClient;
import io.privacyresearch.equation.provision.ProvisioningManager;
import io.privacyresearch.equation.signal.DummySignalBridge;
import io.privacyresearch.equation.signal.MessageAnalysisEntry;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.storage.SignalStorageRecord;
import io.privacyresearch.equation.user.Account;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.equation.util.AvatarHelper;
import io.privacyresearch.equation.util.Goodies;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.metadata.ProtocolDuplicateMessageException;
import org.signal.libsignal.metadata.ProtocolNoSessionException;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.SignalGroupSessionBuilder;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipherResult;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.ProvisioningProtos;
import org.whispersystems.signalservice.internal.SignalServiceProtos;
import org.whispersystems.signalservice.internal.storage.AccountRecord;
import org.whispersystems.signalservice.internal.storage.ContactRecord;
import org.whispersystems.signalservice.internal.storage.GroupV2Record;
import org.whispersystems.signalservice.internal.storage.StorageRecord;

public class EquationManager
implements EquationAPI,
IncomingSignalAPI {
    private static final Logger LOG = Logger.getLogger(EquationManager.class.getName());
    public Path SIGNAL_FX_ATTACHMENT_DIR;
    public ProfileManager profileManager;
    private final StoryService storyService;
    private final SqliteStorageBean sqliteStorageBean;
    private final Path storageRoot;
    private final NetworkMonitor networkMonitor;
    private final UserService userService;
    private final GroupService groupService;
    private final AttachmentService attachmentService;
    private final MessageService messageService;
    private SignalBridge signalBridge;
    private WaveCallManager waveCallManager;
    private final AvatarHelper avatarHelper;
    private StorageManager storageManager;
    private final CheatManager cheatManager;
    private AccountManager accountManager;
    private GroupManager groupManager;
    private final CanvasService canvasService;
    private MessagingClient messageListener;
    private LocalMediaServer lms;
    private final LockImpl lock;
    private Account account;
    private CredentialsProvider credentialsProvider;
    private int localDeviceId;
    private SignalServiceAddress mySignalServiceAddress;
    private final WaveStore aciStore;
    private final WaveStore pniStore;
    private final SignalServiceDataStore signalServiceDataStore;
    private ProvisioningManager provisioningManager;
    private SyncMessageProcessor syncMessageProcessor;
    private final ExecutorService internalExecutor = Executors.newCachedThreadPool();
    private final Map<String, Object> config = new HashMap<String, Object>();
    private StorageKey storageKey;
    private boolean validAccount = false;
    private boolean test;
    private boolean senderTest;
    private MessageCollector messageCollector;

    public EquationManager() {
        this(new SqliteStorageBean(), Map.of());
    }

    public EquationManager(SqliteStorageBean sqliteStorageBean) {
        this(sqliteStorageBean, Map.of());
    }

    public EquationManager(Map<String, Object> config) {
        this(new SqliteStorageBean(), config);
    }

    public EquationManager(SqliteStorageBean sqliteStorageBean, Map<String, Object> inconfig) {
        this.config.putAll(inconfig);
        this.test = Boolean.TRUE.equals(this.config.get("testMode"));
        this.senderTest = Boolean.TRUE.equals(this.config.get("senderTestMode"));
        LOG.info("TEST = " + this.test);
        this.lock = new LockImpl();
        this.sqliteStorageBean = sqliteStorageBean;
        this.storageRoot = this.sqliteStorageBean.getStorageRoot();
        this.networkMonitor = new NetworkMonitor();
        this.avatarHelper = new AvatarHelper(this.storageRoot);
        this.cheatManager = new CheatManager(this);
        this.userService = new UserService(sqliteStorageBean.getBadgeData(), sqliteStorageBean.getRecipientData(), sqliteStorageBean.getUserData(), this.avatarHelper);
        this.groupService = new GroupService(sqliteStorageBean.getGroupData(), sqliteStorageBean.getUserData(), this);
        this.attachmentService = new AttachmentService(this, sqliteStorageBean.getAttachmentData());
        this.storyService = new StoryService(this, sqliteStorageBean.getMessageData());
        this.messageService = new MessageService(this, sqliteStorageBean.getMessageData());
        this.aciStore = new WaveStore(WaveStore.Type.ACI, sqliteStorageBean, this.userService);
        this.pniStore = new WaveStore(WaveStore.Type.PNI, sqliteStorageBean, this.userService);
        this.signalServiceDataStore = new SignalServiceDataStoreImpl(this.aciStore, this.pniStore);
        this.canvasService = new CanvasService(this, sqliteStorageBean);
        this.config.put("useLibsignalNet", this.isUseLibsignalNet());
        ServiceId.Aci myAci = this.sqliteStorageBean.account().getAci();
        LOG.info("myAci = " + String.valueOf(myAci));
        if (myAci != null) {
            this.account = this.retrieveAccount(myAci);
            this.storageKey = sqliteStorageBean.storage().getStorageKey();
            LOG.info("StorageKey = " + (this.storageKey == null ? "NULL" : Goodies.obfuscate(this.storageKey.serialize())));
        } else {
            LOG.warning("Starting Equation without aci, we are not registered yet.");
        }
    }

    @Override
    public boolean initialize() {
        return this.initialize(true);
    }

    @Override
    public boolean initialize(boolean syncRequested) {
        boolean answer = false;
        try {
            this.doInitialize(syncRequested);
            LOG.info("Equation successfully initialised");
            answer = true;
        }
        catch (Exception ex) {
            LOG.warning("Error trying to initialize Equation: " + String.valueOf(ex));
            ex.printStackTrace();
        }
        return answer;
    }

    private boolean doInitialize(boolean syncRequested) throws IOException {
        LOG.severe("Start initializing Equation, should we sync? " + syncRequested);
        ServiceId.Aci myAci = this.sqliteStorageBean.account().getAci();
        LOG.info("myAci = " + String.valueOf(myAci));
        this.credentialsProvider = this.aciStore.getCredentialsProvider();
        this.localDeviceId = this.credentialsProvider.getDeviceId();
        LOG.info("LocalDeviceId = " + this.localDeviceId);
        if (Boolean.TRUE.equals(this.config.get("testMode"))) {
            System.err.println("TEST");
            this.signalBridge = new DummySignalBridge(this, this.config, this.signalServiceDataStore, null, this.userService);
        } else {
            System.err.println("NOTEST");
            this.signalBridge = new SignalBridge(this, this.config, this.signalServiceDataStore, null, this.userService);
        }
        LOG.info("SignalBridge = " + String.valueOf(this.signalBridge));
        this.waveCallManager = new WaveCallManager(this, this.sqliteStorageBean.getCallData(), this.userService, this.groupService, this.signalBridge);
        this.signalBridge.setMessagingClient(this.messageListener);
        this.profileManager = new ProfileManager(this, this.sqliteStorageBean);
        this.syncMessageProcessor = new SyncMessageProcessor(this);
        this.accountManager = new AccountManager(this.signalBridge.getNetworkConfiguration(), this.aciStore.getCredentialsProvider(), this.signalBridge.getNetworkAPI());
        this.storageManager = new StorageManager(this);
        this.mySignalServiceAddress = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        this.SIGNAL_FX_ATTACHMENT_DIR = this.storageRoot.resolve("attachments");
        this.SIGNAL_FX_ATTACHMENT_DIR.toFile().mkdirs();
        AttachmentUtil.deleteDownloadingFiles(this.SIGNAL_FX_ATTACHMENT_DIR.toFile());
        if (this.account == null) {
            LOG.severe("We don't have an account yet, so we can't initialize");
            return true;
        }
        LOG.info("Get our sendercertificate");
        try {
            if (!this.test && !this.senderTest) {
                byte[] senderCertificate = this.accountManager.getSenderCertificate();
                UnidentifiedAccessUtil.setSenderCertificate((byte[])senderCertificate);
                if (syncRequested) {
                    this.internalExecutor.submit(() -> this.syncStorage());
                }
            }
        }
        catch (AuthorizationFailedException ex) {
            LOG.severe("Equation initialization failed.");
            LOG.severe("TODO: propagate this to UI");
            return false;
        }
        catch (IOException ex) {
            Logger.getLogger(EquationManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.validAccount = true;
        try {
            this.attachmentService.startDownloading();
        }
        catch (SQLException ex) {
            Logger.getLogger(EquationManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.groupManager = new GroupManager(this, this.sqliteStorageBean, this.accountManager, this.credentialsProvider);
        this.accountManager.checkOneTyimeKeys().whenComplete((result, error) -> {
            if (result != null) {
                this.handleOTP((OneTimePreKeyCounts)result);
            }
        });
        this.lms = new LocalMediaServer(this);
        return true;
    }

    public SignalServiceAddress getLocalAddress() {
        return this.mySignalServiceAddress;
    }

    public int getLocalDeviceId() {
        return this.localDeviceId;
    }

    void handleOTP(OneTimePreKeyCounts otpk) {
        int ecCount = otpk.getEcCount();
        int kyberCount = otpk.getKyberCount();
        if (ecCount < 10 || kyberCount < 10) {
            try {
                this.generateAndRegisterKeysForType(ServiceId.Kind.ACI, this.aciStore);
            }
            catch (IOException ex) {
                LOG.warning("Could not register new prekeys ");
                ex.printStackTrace();
            }
        }
    }

    public SqliteStorageBean getSqliteStorageBean() {
        return this.sqliteStorageBean;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public SignalServiceDataStore getSignalServiceDataStore() {
        return this.signalServiceDataStore;
    }

    public MessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    void setSignalBridge(SignalBridge bridge) {
        this.signalBridge = bridge;
    }

    public SignalBridge getSignalBridge() {
        return this.signalBridge;
    }

    public WaveCallManager getWaveCallManager() {
        return this.waveCallManager;
    }

    public CheatManager getCheatManager() {
        return this.cheatManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public Map<String, Object> getConfiguration() {
        return this.config;
    }

    public NetworkMonitor getNetworkMonitor() {
        return this.networkMonitor;
    }

    @Override
    public boolean addNetworkListener(Consumer<Boolean> a) {
        return this.networkMonitor.addNetworkListener(a);
    }

    @Override
    public void setMessageListener(MessagingClient mc) {
        this.messageListener = mc;
        LOG.info("Set messagingClient to " + String.valueOf(mc) + " with signalbridge = " + String.valueOf(this.signalBridge));
        if (this.signalBridge != null) {
            this.signalBridge.setMessagingClient(mc);
        }
    }

    @Override
    public MessagingClient getWaveClient() {
        return this.messageListener;
    }

    @Override
    public Path getStorageRoot() {
        return this.storageRoot;
    }

    public WaveStore getAciStore() {
        return this.aciStore;
    }

    public MessageContentProcessor getMessageContentProcessor() {
        return this.signalBridge.getMessageContentProcessor();
    }

    @Override
    public void shutdown() {
        LOG.info("We should shutdown Equation");
        if (this.signalBridge != null) {
            this.signalBridge.shutdown();
        }
        if (this.lms != null) {
            this.lms.shutdown();
        }
        if (this.messageCollector != null) {
            this.messageCollector.shutdown();
        }
        if (this.sqliteStorageBean != null) {
            this.sqliteStorageBean.shutdown();
        }
    }

    public void internalCreateAccount() throws IOException {
        SecureRandom secureRandom = new SecureRandom();
        ServiceId.Aci aci = new ServiceId.Aci(UUID.randomUUID());
        LOG.info("create ia " + String.valueOf(aci));
        ServiceId.Pni pni = new ServiceId.Pni(UUID.randomUUID());
        byte[] b = new byte[16];
        secureRandom.nextBytes(b);
        String password = new String(b, StandardCharsets.UTF_8);
        password = Base64.getEncoder().encodeToString(password.getBytes());
        password = password.substring(0, password.length() - 2);
        int registrationId = new SecureRandom().nextInt(16384) & 0x3FFF;
        int pniRegistrationId = new SecureRandom().nextInt(16384) & 0x3FFF;
        this.sqliteStorageBean.account().setAci(aci);
        this.sqliteStorageBean.account().setPni(pni);
        this.sqliteStorageBean.account().setServicePassword(password);
        this.sqliteStorageBean.account().setDeviceId(1);
        this.localDeviceId = 1;
        this.sqliteStorageBean.account().setRegistrationId(String.valueOf(registrationId));
        this.sqliteStorageBean.account().setPniRegistrationId(String.valueOf(pniRegistrationId));
        this.aciStore.reinitialize();
        this.pniStore.reinitialize();
        IdentityKeyPair aciKeyPair = KeyUtil.generateIdentityKeyPair();
        this.sqliteStorageBean.account().setAciIdentityPrivateKey(aciKeyPair.getPrivateKey().serialize());
        this.sqliteStorageBean.account().setAciIdentityPublicKey(aciKeyPair.getPublicKey().serialize());
        IdentityKeyPair pniKeyPair = KeyUtil.generateIdentityKeyPair();
        this.sqliteStorageBean.account().setPniIdentityPrivateKey(pniKeyPair.getPrivateKey().serialize());
        this.sqliteStorageBean.account().setPniIdentityPublicKey(pniKeyPair.getPublicKey().serialize());
        SignedPreKeyRecord aciPreKeyRecord = KeyUtil.generateSignedPreKey(aciKeyPair.getPrivateKey());
        System.err.println("acipk = " + String.valueOf(aciPreKeyRecord) + " with id " + aciPreKeyRecord.getId());
        this.aciStore.storeSignedPreKey(aciPreKeyRecord.getId(), aciPreKeyRecord);
        SignedPreKeyRecord pniPreKeyRecord = KeyUtil.generateSignedPreKey(pniKeyPair.getPrivateKey());
        System.err.println("pnipk = " + String.valueOf(pniPreKeyRecord) + " with id " + pniPreKeyRecord.getId());
        this.pniStore.storeSignedPreKey(pniPreKeyRecord.getId(), pniPreKeyRecord);
        KyberPreKeyRecord aciKyberPreKeyRecord = KeyUtil.generateKyberPreKey(aciKeyPair.getPrivateKey());
        byte[] skbytes = new byte[32];
        secureRandom.nextBytes(skbytes);
        StorageKey storageKey = new StorageKey(skbytes);
        this.sqliteStorageBean.storage().setStorageKey(storageKey);
    }

    @Override
    public RegistrationResponse registerAccount(String number, String token, String transport) {
        try {
            this.internalCreateAccount();
            return this.signalBridge.registerAccount(number, token, transport, this.aciStore);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new RegistrationResponse(ex.getMessage(), 600);
        }
    }

    @Override
    public RegistrationResponse confirmRegistrationCode(String code) {
        RegistrationResponse answer = this.signalBridge.confirmRegistrationCode(code);
        if (answer.getStatusCode() == 200) {
            this.initialize();
        }
        return answer;
    }

    @Override
    public boolean isProvisioned() {
        return this.aciStore.isInitialized();
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            this.account = this.retrieveAccount();
        }
        return this.account;
    }

    @Override
    public List<UserRecord> getAllUsers() {
        return this.userService.getAllUsers();
    }

    @Override
    public UserRecord getUserByRecipientKey(RecipientKey recipientKey) {
        return this.userService.getUserByRecipientKey(recipientKey);
    }

    public ServiceId getServiceId(RecipientKey recipientKey) {
        UserRecord user = this.userService.getUserByRecipientKey(recipientKey);
        return user.getServiceId().orElse(null);
    }

    private Account retrieveAccount() {
        ServiceId.Aci myAci = this.sqliteStorageBean.account().getAci();
        return this.retrieveAccount(myAci);
    }

    private Account retrieveAccount(ServiceId.Aci aci) {
        return this.userService.getUserByServiceId((ServiceId)aci).map(this::getAccountFromUserRecord).get();
    }

    private Account getAccountFromUserRecord(UserRecord user) {
        Account account = new Account(user);
        Preferences preferences = this.sqliteStorageBean.preference().getPreferences();
        account.setPreferences(preferences);
        account.setUsernameLink(this.sqliteStorageBean.account().getUsernameLink());
        if (account.getUsernameLink() != null) {
            LOG.info("Retrieving account with usernamelink = " + account.getUsernameLink().getLink());
        } else {
            LOG.info("No usernamelink for this account");
        }
        return account;
    }

    @Override
    public Username reserveUsername(String nick) {
        LOG.info("Need to create a username");
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        Username answer = us.generateUsername(nick);
        return answer;
    }

    @Override
    public boolean confirmReservation(Username reservedUsername) {
        LOG.info("Need to confirm " + String.valueOf(reservedUsername));
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        UsernameLink link = us.confirmUsername(reservedUsername);
        this.storeUsernameLinkForAccountKVS(link);
        try {
            this.storageManager.updateStorageAccount(this.account);
        }
        catch (IOException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.messageListener.updateAccount(this.retrieveAccount());
        return true;
    }

    @Override
    public void updateUsernameLink(UsernameLink link) {
        this.storeUsernameLinkForAccountKVS(link);
        this.account = this.retrieveAccount();
        try {
            this.storageManager.updateStorageAccount(this.account);
        }
        catch (IOException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        this.messageListener.updateAccount(this.account);
    }

    @Override
    public UserRecord searchByUsername(String username) {
        LOG.info("Search for " + username);
        UsernameService us = new UsernameService(this.signalBridge.getNetworkAPI());
        String aci = us.getAciByUsername(username);
        return aci != null ? (UserRecord)this.userService.getUserByServiceId((ServiceId)new ServiceId.Aci(UUID.fromString(aci))).orElse(null) : null;
    }

    private void storeUsernameLinkForAccountKVS(UsernameLink link) {
        LOG.info("Storing usernamelink into account kvs");
        if (link != null) {
            this.sqliteStorageBean.account().setUsernameLinkEntropy(link.getEntropy());
            this.sqliteStorageBean.account().setUsernameLinkServerId(link.getServerId());
            this.sqliteStorageBean.account().setUsernameLinkColor(link.getColor());
        }
    }

    public Optional<GroupRecord> getGroupByMasterKey(byte[] masterKeyBytes) {
        if (masterKeyBytes == null || masterKeyBytes.length == 0) {
            LOG.severe("Can not find a group without master key!");
            return null;
        }
        LOG.info("asked to find group with masterKeyBytes[0] = " + masterKeyBytes[0]);
        Optional answer = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes);
        LOG.info("Will return " + String.valueOf(answer));
        return answer;
    }

    public Optional<RecipientRecord> getGroupRecipient(SignalServiceProtos.GroupContextV2 groupContextV2) {
        if (groupContextV2 != null) {
            Optional<RecipientRecord> answer = this.getGroupByMasterKey(groupContextV2.getMasterKey().toByteArray()).map(GroupRecord::recipient);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("GOT GG " + String.valueOf(answer));
            }
            return answer;
        }
        return Optional.empty();
    }

    @Override
    public List<GroupRecord> getAllGroups() {
        try {
            return this.sqliteStorageBean.getGroupData().findAll();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public GroupRecord getGroupRecordByRecipientKey(RecipientKey recipientKey) {
        return this.sqliteStorageBean.getGroupData().getGroupByRecipientKey(recipientKey);
    }

    public Set<UserKey> getGroupUsers(GroupRecord group) {
        UserKey selfKey = this.getAccount().getUser().key();
        return group.members().stream().map(MembershipRecord::userKey).filter(memberUserKey -> !memberUserKey.equals((Object)selfKey)).collect(Collectors.toSet());
    }

    @Override
    public List<ChannelRecord> getAllChannels() {
        try {
            LOG.info("Need to retrieve all channels");
            List answer = this.sqliteStorageBean.getChannelData().findAll();
            LOG.info("Retrieved " + answer.size() + " channels");
            return answer;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Optional<DraftRecord> getDraftForChannel(ChannelKey channelKey) {
        return this.sqliteStorageBean.getDraftData().findDraftForChannel(channelKey);
    }

    @Override
    public void updateDraft(ChannelKey channelKey, UpdateDraftRequest updateDraftRequest) {
        this.sqliteStorageBean.getDraftData().updateDraft(channelKey, updateDraftRequest);
        this.sqliteStorageBean.getDraftData().findDraftForChannel(channelKey).ifPresent(this.messageListener::updatedDraft);
    }

    @Override
    public void clearDraft(ChannelKey channelKey) {
        LOG.info("Clear draft with sql bean = " + String.valueOf(this.sqliteStorageBean));
        this.sqliteStorageBean.getDraftData().clearDraft(channelKey);
        this.messageListener.clearedDraft(channelKey);
    }

    @Override
    public ChannelRecord getChannelByRecipientKey(RecipientKey recipientKey) {
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(recipientKey);
        if (channelKey != null) {
            return (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        }
        LOG.info("Asked to find channel with recipient key " + String.valueOf(recipientKey) + ", but couldn't find it.");
        return null;
    }

    @Override
    public List<CanvasDbRecord> getCanvasListByChannel(ChannelKey channelKey) {
        return this.canvasService.getCanvasListByChannel(channelKey);
    }

    @Override
    public List<CanvasEntryDbRecord> getCanvasHistory(ChannelKey channelKey, String canvasIdentifier) {
        return this.canvasService.getCanvasHistory(channelKey, canvasIdentifier);
    }

    @Override
    public CanvasDbRecord createCanvas(ChannelKey channelKey) {
        return this.canvasService.createCanvas(channelKey);
    }

    @Override
    public CanvasDbRecord updateCanvas(UpdateCanvasRequest request) {
        CanvasDbRecord storedRecord = this.canvasService.updateCanvas(request);
        if (this.messageListener != null) {
            this.messageListener.gotCanvasUpdate(storedRecord);
        }
        try {
            this.signalBridge.sendCanvasMessage(storedRecord);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return storedRecord;
    }

    @Override
    public boolean deleteCanvas(CanvasKey canvasKey) {
        return this.canvasService.deleteCanvas(canvasKey);
    }

    @Override
    public void ignoreCall() {
        this.waveCallManager.ignoreCall();
    }

    @Override
    public void hangupCall(Call call) {
        this.waveCallManager.hangupCall(call);
    }

    @Override
    public void acceptCall() {
        this.waveCallManager.acceptCall();
    }

    @Override
    public List<CallRecord> getAllCalls() {
        return this.waveCallManager.getAllCalls();
    }

    @Override
    public void sendCallHangupMessage(Call call) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public void enableVideoCall(boolean enable) {
        this.waveCallManager.enableVideoCall(enable);
    }

    @Override
    public Call prepareOutgoingCall(RecipientKey recipientKey, boolean enableVideo) {
        return this.waveCallManager.prepareOutgoingCall(recipientKey, enableVideo);
    }

    @Override
    public Call prepareOutgoingGroupCall(RecipientKey recipientKey, boolean enableVideo) {
        return this.waveCallManager.prepareOutgoingGroupCall(recipientKey, enableVideo);
    }

    @Override
    public void startOutgoingCall() {
        this.waveCallManager.startOutgoingCall();
    }

    @Override
    public void startOutgoingGroupCall() {
        this.waveCallManager.startOutgoingGroupCall();
    }

    @Override
    public MessageRecord getMessageByKey(MessageKey key) {
        return this.getMessageRecordFromDb((MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)key));
    }

    public MessageRecord getMessageRecordFromDb(MessageDbRecord db) {
        UserRecord sender = this.userService.getUserByUserKey(db.senderKey());
        ChannelKey channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(db.receiverKey());
        return new MessageRecord(db.key(), channelKey, sender, db.receiverKey(), db.body(), db.bodyRanges(), db.dateSent(), db.dateReceived(), db.receiptType(), db.receiptTimestamp(), db.expiresIn(), db.expireStarted(), db.storyType(), db.infoMessage(), null, db.read(), db.viewOnce(), db.flags(), db.originalMessageKey(), db.parentPath(), db.threadRootKey());
    }

    @Override
    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey recipientKey) {
        LOG.info("Ready to retrieve messages from recipient " + String.valueOf(recipientKey));
        return this.sqliteStorageBean.getMessageData().getByToRecipientKey(recipientKey).stream().filter(r -> r.storyType() == StoryType.NONE).map(this::getMessageRecordFromDb).toList();
    }

    @Override
    public List<MessageRecord> getMessagesForRecipientKey(RecipientKey recipientKey, long endTime, int maxItems) {
        return this.sqliteStorageBean.getMessageData().getByToRecipientKeyBefore(recipientKey, endTime, maxItems).stream().filter(r -> r.storyType() == StoryType.NONE).filter(r -> r.storyType() == StoryType.NONE).map(this::getMessageRecordFromDb).toList();
    }

    @Override
    public FullQuoteRecord getQuoteByMessageKey(MessageKey messageKey) {
        QuoteRecord basis = this.sqliteStorageBean.getQuoteData().findQuoteByMessageKey(messageKey);
        if (basis == null) {
            return null;
        }
        MessageDbRecord messageRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)basis.quotedMessageKey());
        UserRecord userRecord = messageRecord == null ? null : this.userService.getUserByUserKey(messageRecord.senderKey());
        return FullQuoteRecord.fromQuote(basis, userRecord == null ? null : userRecord.name());
    }

    @Override
    public List<ReactionRecord> getReactionsByMessageKey(MessageKey messageKey) {
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        return this.sqliteStorageBean.getReactionData().findByMessageKey(messageKey).stream().map(rs::getReactionRecordFromDb).toList();
    }

    @Override
    public List<AttachmentRecord> getAttachmentsByMessageKey(MessageKey messageKey) {
        return this.sqliteStorageBean.getAttachmentData().findByMessageKey(messageKey);
    }

    public void handleEditedMessage(long origTimestamp, RecipientKey recipientKey, InsertMessageRequest messageRequest) {
        MessageDbRecord originalMessage;
        if (origTimestamp > 0L && (originalMessage = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(recipientKey, origTimestamp)) != null) {
            messageRequest.setOriginalMessageKey(originalMessage.key());
        }
    }

    @Override
    public void clientRead(ChannelKey channelKey, long timestamp) {
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        LOG.info("client has read channel " + String.valueOf(channelKey) + " up to " + timestamp + " and we had " + channelRecord.lastRead());
        if (timestamp > channelRecord.lastRead()) {
            List allRecords = this.sqliteStorageBean.getMessageData().getByToRecipientKeyInterval(channelRecord.recipient().key(), channelRecord.lastRead(), timestamp);
            UserKey accountKey = this.getAccount().getUser().key();
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Lastread was " + channelRecord.lastRead() + " and raw = " + allRecords.size() + " and selfkey = " + String.valueOf(accountKey));
            }
            List<MessageDbRecord> records = EquationManager.getNotMyMessageDbRecords(allRecords, accountKey);
            LOG.info("we need to send receipts for " + records.size() + " messages");
            if (records.size() > 0) {
                boolean notifyCollector = false;
                for (MessageDbRecord messageRecord : records) {
                    if (messageRecord.expireStarted() != 0L || messageRecord.expiresIn() <= 0) continue;
                    this.sqliteStorageBean.getMessageData().updateExpireStarted(messageRecord.key(), timestamp);
                    notifyCollector = true;
                    LOG.info("ExpireTimer started for msg with content = " + messageRecord.body());
                }
                if (notifyCollector) {
                    this.messageCollector.trigger();
                }
                LOG.info("Client asks to set lastread for channel " + String.valueOf(channelKey) + " to " + timestamp);
                this.sqliteStorageBean.getChannelData().updateLastRead(channelKey, timestamp);
                List<Long> timestamps = records.stream().map(record -> record.dateSent()).toList();
                UserRecord destUser = this.userService.getUserByUserKey(records.get(0).senderKey());
                ServiceId dest = destUser.getServiceId().orElse(null);
                this.sendReadReceipt(timestamps, dest);
            }
        }
        this.checkUnreadMessagesForChannel(channelKey);
    }

    static List<MessageDbRecord> getNotMyMessageDbRecords(List<MessageDbRecord> allRecords, UserKey accountKey) {
        return allRecords.stream().filter(record -> record.infoMessage() == null && !record.senderKey().serialize().equals(accountKey.serialize())).toList();
    }

    public void sendReadReceipt(List<Long> timestamps, ServiceId serviceId) {
        if (this.cheatManager.hasCheatFor(CheatManager.CHEAT_RECEIPT)) {
            LOG.info("Read receipt not sent to " + String.valueOf(serviceId) + " because we are cheating");
            return;
        }
        try {
            this.signalBridge.sendReadReceipt(timestamps, serviceId);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public CompletableFuture<InputStream> getAttachmentInputStream(AttachmentKey key) {
        CompletableFuture<InputStream> answer = new CompletableFuture<InputStream>();
        this.internalExecutor.submit(() -> {
            AttachmentRecord record = (AttachmentRecord)this.sqliteStorageBean.getAttachmentData().findByKey((EntityKey)key);
            LOG.info("Need to get inputstream for " + String.valueOf(record));
            try {
                InputStream is0 = AttachmentUtil.getInputStream(record);
                if (is0 == null) {
                    answer.completeExceptionally(new IOException("No file found for attachment with key " + String.valueOf(key)));
                }
                InputStream is = AttachmentUtil.getAvailableInputStream(is0);
                answer.complete(is);
            }
            catch (IOException | TimeoutException ex) {
                LOG.log(Level.SEVERE, null, ex);
                answer.completeExceptionally(ex);
            }
        });
        return answer;
    }

    @Override
    public Attachment.LocalDownloadStatus getAttachmentStatus(AttachmentKey key) {
        return this.attachmentService.getAttachmentStatus(key);
    }

    public void exportCloudBackup() {
        this.exportCloudBackup(new BackupStatus());
    }

    @Override
    public void exportCloudBackup(BackupStatus backupStatus) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public void exportFileBackup(BackupStatus backupStatus, Path path) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    @Override
    public void requestBackfill(MessageKey messageKey, Consumer<BackfillRequestUpdate> consumer) {
        this.internalExecutor.submit(() -> {
            MessageDbRecord messageDbRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
            LOG.info("Request backfill for " + String.valueOf(messageKey) + " with ts = " + messageDbRecord.dateSent());
            this.attachmentService.registerBackfillRequest(messageKey, consumer);
            this.syncMessageProcessor.requestBackfill(this.getMessageRecordFromDb(messageDbRecord));
        });
    }

    @Override
    public long sendMessage(RecipientKey receiverKey, Message waveMessage, long timestamp, List<Attachment> attachment) throws IOException {
        if (waveMessage.getAttachment().size() == 0 && attachment != null && attachment.size() > 0) {
            for (Attachment att : attachment) {
                waveMessage.attachment(att);
            }
        }
        this.signalBridge.sendMessage(receiverKey, waveMessage);
        return timestamp;
    }

    @Override
    public long sendMessage(RecipientKey receiverKey, Message waveMessage) throws IOException {
        this.signalBridge.sendMessage(receiverKey, waveMessage);
        return 0L;
    }

    @Override
    public long sendGroupMessage(RecipientKey groupRecipientKey, Message waveMessage, List<Attachment> attachment) throws IOException, InvalidCertificateException, InvalidInputException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        if (waveMessage.getAttachment().size() == 0 && attachment != null && attachment.size() > 0) {
            for (Attachment att : attachment) {
                waveMessage.attachment(att);
            }
        }
        this.signalBridge.sendGroupMessage(groupRecipientKey, waveMessage);
        return 0L;
    }

    @Override
    public long sendGroupMessage(RecipientKey groupRecipientKey, Message message) throws IOException {
        try {
            this.signalBridge.sendGroupMessage(groupRecipientKey, message);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
        return message.getTimestamp();
    }

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    @Override
    public void startListening() {
        if (!this.validAccount) {
            throw new IllegalArgumentException("No valid account");
        }
        LOG.info("Start startlistening. From now on, Equation may call into Wave.");
        try {
            this.messageCollector = new MessageCollector(this.messageListener, this.sqliteStorageBean.getMessageData(), this.storyService, this::getMessageRecordFromDb);
            this.messageCollector.start();
            this.signalBridge.startListening();
        }
        catch (Exception ex) {
            LOG.info("We can't start listening due to " + String.valueOf(ex));
            ex.printStackTrace();
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public StorageKey getStorageKey() {
        if (this.storageKey == null) {
            try {
                this.requestStorageKey();
            }
            catch (IOException ex) {
                LOG.severe("Could not request storageKey");
                ex.printStackTrace();
            }
        }
        return this.storageKey;
    }

    private void requestStorageKey() throws IOException {
        this.signalBridge.requestStorageKey();
    }

    public void storeQuoteInfo(MessageKey messageKey, MessageKey quotedMessageKey, SignalServiceProtos.DataMessage.Quote quote) {
        QuoteRecord qr = new QuoteRecord(new QuoteKey(), messageKey, quotedMessageKey, quote.getText(), List.of(), QuoteRecord.Type.NORMAL);
        this.sqliteStorageBean.getQuoteData().addQuote(qr);
    }

    @Override
    public MessageRecord sendExpireTimerMessage(RecipientKey receiverKey, int timer) {
        LOG.info("Update timer to " + timer);
        RecipientRecord rec = (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)receiverKey);
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        long now = System.currentTimeMillis();
        messageRequest.setTimestamp(now);
        messageRequest.setSenderKey(this.sqliteStorageBean.getUserCache().getSelf().key());
        messageRequest.setReceiverKey(receiverKey);
        try {
            if (rec.isGroup()) {
                this.sendModifyGroupTimerMessage(receiverKey, timer);
            } else {
                this.signalBridge.sendModifyUserTimerMessage(receiverKey, timer);
                this.sqliteStorageBean.getRecipientData().setExpireMessages(receiverKey, timer);
                int oldVersion = ((RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)receiverKey)).expireTimerVersion();
                this.sqliteStorageBean.getRecipientData().setExpireTimerVersion(receiverKey, oldVersion + 1);
            }
            InfoMessage infoMessage = this.createTimerInfoMessage(timer);
            messageRequest.setInfoMessage(infoMessage);
            MessageKey messageKey = this.sqliteStorageBean.getMessageData().insertMessage(messageRequest);
            this.messageListener.gotRecipientExpirationUpdate(receiverKey, timer);
            return this.getMessageByKey(messageKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.log(Level.SEVERE, "send expire timer message failed ", e);
            return null;
        }
    }

    public int sendModifyGroupTimerMessage(RecipientKey groupRecipientKey, int timer) {
        GroupRecord group = this.groupService.getGroupByRecipientKey(groupRecipientKey);
        LOG.info("Need to update grouptimer to " + timer + " for group " + String.valueOf(group.getGroupIdentifier()) + " with rev = " + group.revision());
        try {
            return this.groupManager.updateGroupTimer(group, timer);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    private InsertMessageRequest createInfoMessageRequest(InfoMessage infoMessage, RecipientKey receiverKey, long timestamp) {
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setTimestamp(timestamp);
        messageRequest.setSenderKey(this.account.getUser().key());
        messageRequest.setReceiverKey(receiverKey);
        messageRequest.setInfoMessage(infoMessage);
        return messageRequest;
    }

    @Override
    public void deleteMessage(MessageKey messageKey, boolean remote) {
        LOG.info("Wave asks us to delete message " + String.valueOf(messageKey) + ", remote = " + remote);
        MessageDbRecord dbRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
        RecipientRecord recipient = (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)dbRecord.receiverKey());
        if (remote) {
            ServiceId.Aci destination = null;
            if (recipient.type() == RecipientRecord.Type.CONTACT) {
                UserDbRecord target = this.sqliteStorageBean.getUserData().findByRecipientKey(recipient.key());
                destination = target.aci();
                this.deleteUserMessage((ServiceId)destination, dbRecord.dateSent());
            } else if (recipient.isGroup()) {
                GroupRecord groupRecord = this.sqliteStorageBean.getGroupData().getGroupByRecipientKey(recipient.key());
                this.deleteGroupMessage(groupRecord, dbRecord.dateSent());
            } else {
                LOG.severe("We need to delete something that is not related to a contact or a group?!");
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.sqliteStorageBean.getMessageData().remoteDelete(messageKey);
        if (this.messageListener != null) {
            this.messageListener.gotMessageRemoved(recipient.key(), messageKey, remote);
        }
    }

    private void deleteUserMessage(ServiceId target, long timestamp) {
        try {
            this.signalBridge.sendRemoteDeleteMessage(timestamp, target, null);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void deleteGroupMessage(GroupRecord myGroup, long timestamp) {
        try {
            this.signalBridge.sendRemoteDeleteMessage(timestamp, null, myGroup);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public long sendReaction(String emoji, MessageKey messageKey, boolean remove) throws IOException {
        RecipientKey myRecipientKey = this.getAccount().getUser().recipient().key();
        MessageDbRecord messageRecord = (MessageDbRecord)this.sqliteStorageBean.getMessageData().findByKey((EntityKey)messageKey);
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        rs.storeAndNotifyReaction(emoji, remove, messageRecord.key(), messageRecord.receiverKey(), myRecipientKey, System.currentTimeMillis());
        this.signalBridge.sendReaction(emoji, messageRecord, remove);
        return 0L;
    }

    @Override
    public void startProvisioning(ProvisioningClient provisioningClient) {
        LOG.info("We are requested to start the provisioning flow");
        this.provisioningManager = new ProvisioningManager(this, this.sqliteStorageBean, provisioningClient);
        this.provisioningManager.start();
    }

    @Override
    public void createPrimaryAccount() {
        try {
            this.internalCreateAccount();
            this.signalBridge.registerAccount(this.aciStore);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void createAccount(ProvisioningProtos.ProvisionMessage pm, String deviceName, DeviceLinkOptions options, Consumer<String> updates) throws IOException {
        if (this.provisioningManager == null) {
            LOG.severe("We are asked to create an account, but there is no provisioningmanager yet. Aborting.");
            throw new IllegalArgumentException("No provisioningmanager created");
        }
        String nr = pm.getNumber();
        updates.accept("Creating local account");
        boolean cloudImport = options.isCloudImport();
        boolean fileImport = options.isFileImport();
        boolean transfer = options.isTransfer();
        Path backupPath = options.getBackupPath();
        byte[] profileKey = this.provisioningManager.createAccount(nr, deviceName, this.aciStore, this.pniStore);
        ServiceId.Aci aci = (ServiceId.Aci)this.aciStore.getServiceId();
        ServiceId.Pni pni = (ServiceId.Pni)this.pniStore.getServiceId();
        this.userService.storePniVerified(aci, pni, nr, profileKey);
        LOG.info("Created aci: " + String.valueOf(aci) + " of class " + String.valueOf(aci.getClass()));
        LOG.info("Created pni: " + String.valueOf(pni) + " of class " + String.valueOf(pni.getClass()));
        this.account = this.retrieveAccount(aci);
        this.credentialsProvider = this.aciStore.getCredentialsProvider();
        this.mySignalServiceAddress = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        this.provisioningManager.stop();
    }

    @Override
    public CompletableFuture<Void> requestTransfer(Consumer<String> updates, byte[] ephemeralBackupKey, ServiceId.Aci aci) {
        return CompletableFuture.runAsync(() -> {
            this.signalBridge.requestTransfer(updates, ephemeralBackupKey, aci);
            LOG.info("Transfer ok, now create indexes");
            this.sqliteStorageBean.createIndexes();
            LOG.info("Indexes created");
            this.sqliteStorageBean.resetConnection();
            LOG.info("sqlitestoragebean has been reset");
            this.account = this.retrieveAccount();
            LOG.info("Retrieved account");
            this.messageListener.updateAccount(this.account);
            try {
                LOG.info("Start processQuotes");
                this.getMessageContentProcessor().processQuotes();
                LOG.info("Now start downloading attachments");
                this.attachmentService.startDownloading();
                LOG.info("Started downloading attachments");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.log(Level.SEVERE, null, ex);
            }
        });
    }

    @Override
    public void unlink() {
        try {
            this.signalBridge.unlink();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public WaveStore getWaveStore() {
        return this.aciStore;
    }

    private void generateAndRegisterKeysForType(ServiceId.Kind type, WaveStore myWaveStore) throws IOException {
        try {
            KeyUtil keyUtil = new KeyUtil(myWaveStore);
            IdentityKeyPair identityKeypair = myWaveStore.getIdentityKeyPair();
            LOG.info("Generate signedPrekey and prekeys for " + String.valueOf(type));
            SignedPreKeyRecord signedPreKey = keyUtil.generateSignedPreKey(identityKeypair, true);
            List<PreKeyRecord> records = keyUtil.generatePreKeys(50);
            KyberPreKeyRecord kyberLastResortRecord = keyUtil.generateAndStoreKyberPreKey(identityKeypair.getPrivateKey());
            List<KyberPreKeyRecord> kyberPrekeys = keyUtil.generateAndStoreKyberPreKeys(identityKeypair.getPrivateKey(), 50);
            this.accountManager.setPreKeys(type, identityKeypair.getPublicKey(), signedPreKey, records, kyberLastResortRecord, kyberPrekeys);
            LOG.info("Finished generateAndRegisterKeys");
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, "Wrong key", ex);
        }
    }

    public RecipientRecord createGroupRecipient(SignalServiceProtos.GroupContextV2 groupContextV2) {
        try {
            LOG.info("We need to create a new GroupRecipient");
            GroupRecord groupRecord = this.retrieveGroupFromMasterKeyBytes(groupContextV2.getMasterKey().toByteArray());
            LOG.info("Created a group: " + String.valueOf(groupRecord));
            return groupRecord.recipient();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void processCallMessage(SignalServiceProtos.Content content, UserRecord sender, int senderDeviceId, long timestamp) {
        SignalServiceProtos.CallMessage callMessage = content.getCallMessage();
        LOG.info("Process callmessage");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("we got a callmsg, Content = " + String.valueOf(content) + " and callmessage = " + String.valueOf(callMessage) + " and timestamp = " + timestamp);
        }
        try {
            if (callMessage.hasOpaque()) {
                this.handleCallOpaqueMessage(sender.aci(), senderDeviceId, callMessage.getOpaque());
            }
            if (callMessage.hasOffer()) {
                this.handleCallOfferMessage(content, callMessage.getOffer(), sender, senderDeviceId, timestamp);
            }
            if (callMessage.hasAnswer()) {
                this.handleCallAnswerMessage(content, callMessage.getAnswer(), sender, senderDeviceId);
            }
            if (callMessage.hasHangup()) {
                this.handleHangupMessage(callMessage.getHangup(), timestamp);
            }
            if (!callMessage.getIceUpdateList().isEmpty()) {
                this.handleIceMessages(content, callMessage.getIceUpdateList(), senderDeviceId);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Error processing callmessage. We ignore and proceed", t);
        }
        LOG.info("Handled callmsg");
    }

    private void handleCallOpaqueMessage(ServiceId.Aci aci, int senderDeviceId, SignalServiceProtos.CallMessage.Opaque omsg) {
        LOG.info("handle opaque message from " + String.valueOf(aci));
        this.waveCallManager.receivedOpaqueMessage(aci, senderDeviceId, omsg.getData().toByteArray());
        LOG.info("handled opaque call.");
    }

    void handleCallOfferMessage(SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Offer message, UserRecord sender, int senderDeviceId, long timestamp) {
        Call call = this.waveCallManager.handleCallOfferMessage(content, message, sender, senderDeviceId, timestamp);
        if (call != null) {
            this.messageListener.gotCallUpdate(call);
        } else {
            LOG.info("No call created, offer is ignored.");
        }
    }

    private void handleCallAnswerMessage(SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Answer message, UserRecord sender, int senderDeviceId) {
        long callId = message.getId();
        ServiceId senderId = sender.getServiceId().get();
        SignalServiceAddress senderAddress = new SignalServiceAddress(senderId);
        try {
            this.waveCallManager.receivedAnswer(callId, content, message, senderAddress, senderDeviceId);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private void handleHangupMessage(SignalServiceProtos.CallMessage.Hangup hm, long timestamp) {
        if (this.waveCallManager.handleHangupSignalMessage(hm, timestamp, this.localDeviceId)) {
            this.messageListener.gotCallUpdate(null);
        }
    }

    public void clientNotifyCallMessage(long callId, InfoMessage.Type type, long timestamp) {
        try {
            CallKey callKey = this.sqliteStorageBean.getCallData().findByCallId(callId);
            this.clientNotifyCallMessage(callKey, type, timestamp);
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void clientNotifyCallMessage(CallKey callKey, InfoMessage.Type type, long timestamp) {
        CallDbRecord callRecord = (CallDbRecord)this.sqliteStorageBean.getCallData().findByKey((EntityKey)callKey);
        RecipientKey key = callRecord.conversationRecipient().key();
        InfoMessage infoMessage = new InfoMessage(type, new String[0]);
        InsertMessageRequest imr = this.createInfoMessageRequest(infoMessage, key, timestamp);
        MessageKey messageKey = this.sqliteStorageBean.getMessageData().insertMessage(imr);
        MessageRecord messageRecord = this.getMessageByKey(messageKey);
        this.messageListener.gotMessageRecord(messageRecord);
    }

    private void handleIceMessages(SignalServiceProtos.Content content, List<SignalServiceProtos.CallMessage.IceUpdate> icemessages, int senderDeviceId) {
        if (icemessages == null) {
            LOG.log(Level.SEVERE, "Null icemessages, should be fatal!", new NullPointerException());
            return;
        }
        LOG.info("We will handle  " + icemessages.size() + " received iceMessages");
        this.waveCallManager.handleReceivedIceCandidates(senderDeviceId, icemessages);
        LOG.info("Handled receivedIceMessage");
    }

    public SignalServiceCipherResult mydecrypt(SignalServiceEnvelope sse) throws Exception {
        LOG.info("Decrypt with acistore = " + String.valueOf(this.aciStore) + " with sid = " + String.valueOf(this.aciStore.getServiceId()));
        SignalServiceCipher cipher = new SignalServiceCipher(this.mySignalServiceAddress, this.localDeviceId, (SignalServiceAccountDataStore)this.aciStore, (SignalSessionLock)new LockImpl(), SignalBridge.getCertificateValidator());
        ServiceId.Aci aci = this.credentialsProvider.getAci();
        ServiceId.Pni pni = this.credentialsProvider.getPni();
        SignalServiceCipherResult answer = null;
        int myHash = Objects.hashCode(sse);
        try {
            int bl = sse.getContent().length;
            LOG.info("I need to decrypt envelope " + myHash + " with " + bl + " bytes and ts = " + sse.getTimestamp());
            SignalServiceProtos.Envelope envelope = sse.getEnvelope();
            ServiceId destination = envelope.hasDestinationServiceId() ? ServiceId.parseFromString((String)envelope.getDestinationServiceId()) : null;
            LOG.info("DESTID = " + destination.toServiceIdString() + " and aci = " + this.credentialsProvider.getAci().toServiceIdString());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("envelope = " + String.valueOf(sse.getEnvelope()));
            }
            if (destination == null) {
                LOG.log(Level.SEVERE, "Got envelope without destination address, ignore!");
                return null;
            }
            if (!aci.equals((Object)destination) && !pni.equals((Object)destination)) {
                LOG.log(Level.SEVERE, " Got envelope with destination that is not us: " + String.valueOf(destination));
                return null;
            }
            if (pni.equals((Object)destination) && envelope.hasSourceServiceId()) {
                LOG.info("Received a message at our PNI. Marking as needing a PNI signature");
                LOG.log(Level.SEVERE, "NOT SUPPORTED!");
                return null;
            }
            answer = cipher.decrypt(sse.getEnvelope(), sse.getServerDeliveredTimestamp());
            if (answer.getContent().hasSenderKeyDistributionMessage()) {
                this.handleSenderKeyDistributionMessage(envelope, answer.getMetadata().getSourceServiceId(), answer.getMetadata().getSourceDeviceId(), new SenderKeyDistributionMessage(answer.getContent().getSenderKeyDistributionMessage().toByteArray()), this.signalServiceDataStore.aci());
            }
            LOG.info("Decryption done.");
        }
        catch (ProtocolNoSessionException e) {
            SignalServiceAddress address = new SignalServiceAddress((ServiceId)e.getSenderAci());
            this.signalBridge.sendNullMessage(address);
        }
        catch (ProtocolDuplicateMessageException pdme) {
            LOG.warning("We got a duplicate message, ignore this message. " + String.valueOf((Object)pdme));
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("mydecrypt will return " + String.valueOf(answer));
        }
        return answer;
    }

    public void processSyncMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.SyncMessage sssm, UserRecord sender, RecipientRecord threadRecipient) throws InvalidMessageException, IOException {
        this.syncMessageProcessor.processSyncMessage(envelope, sssm, sender, threadRecipient);
    }

    public CompletableFuture<SignalServiceProfile> retrieveAndStoreProfile(ServiceId.Aci aci, byte[] profileKeyBytes) {
        if (aci == null) {
            throw new IllegalArgumentException("Empty ACI");
        }
        Optional<UserRecord> userRecord = this.userService.getUserByServiceId((ServiceId)aci);
        RecipientKey recipientKey = userRecord.map(user -> user.recipient().key()).orElse(null);
        if (recipientKey == null) {
            LOG.severe("Can't find a record for a user which profile we have to retrieve!");
        }
        return this.retrieveAndStoreProfile(aci, profileKeyBytes, recipientKey);
    }

    private CompletableFuture<SignalServiceProfile> retrieveAndStoreProfile(ServiceId.Aci aci, byte[] profileKeyBytes, RecipientKey recipientKey) {
        return this.profileManager.retrieveAndStoreProfile(aci, profileKeyBytes, recipientKey);
    }

    private void processReadMessages(List<SignalServiceProtos.SyncMessage.Read> messages, long expireStarted) {
        HashMap<RecipientKey, Long> receiverKey_timestamp = new HashMap<RecipientKey, Long>();
        boolean notifyCollector = false;
        for (SignalServiceProtos.SyncMessage.Read msg : messages) {
            Long v;
            ServiceId.Aci senderId = new ServiceId.Aci(UUID.fromString(msg.getSenderAci()));
            UserRecord sender = this.userService.getUserByServiceId((ServiceId)senderId).orElse(null);
            if (sender == null) {
                LOG.info("Can't find sender from read notification");
                return;
            }
            MessageDbRecord message = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(sender.recipient().key(), msg.getTimestamp());
            if (message == null) {
                LOG.info("Can't find message from read notification, might be expired and deleted");
                return;
            }
            LOG.info("Got read message for " + String.valueOf(message.receiverKey()) + " with expin = " + message.expiresIn() + " and started = " + message.expireStarted());
            if (message.expiresIn() > 0 && message.expireStarted() == 0L) {
                this.sqliteStorageBean.getMessageData().updateExpireStarted(message.key(), expireStarted);
                LOG.info("expireStarted = " + expireStarted + " and exp = " + message.expiresIn() + " for " + String.valueOf(message.key()));
                notifyCollector = true;
            }
            if ((v = (Long)receiverKey_timestamp.get(message.receiverKey())) != null && v >= msg.getTimestamp()) continue;
            receiverKey_timestamp.put(message.receiverKey(), msg.getTimestamp());
        }
        if (notifyCollector) {
            this.messageCollector.trigger();
        }
        HashSet<ChannelKey> channelKeys = new HashSet<ChannelKey>();
        for (Map.Entry entry : receiverKey_timestamp.entrySet()) {
            ChannelRecord channelRecord;
            RecipientKey receiverKey = (RecipientKey)entry.getKey();
            long time = (Long)entry.getValue();
            if (time <= (channelRecord = this.getChannelByRecipientKey(receiverKey)).lastRead()) continue;
            channelKeys.add(channelRecord.key());
            this.sqliteStorageBean.getChannelData().updateLastRead(channelRecord.key(), time);
            int unreadCount = this.sqliteStorageBean.getMessageData().getNumberOfMessagesAfter(receiverKey, time);
            LOG.info("check unread messages will return " + unreadCount);
            this.messageListener.gotReadUpdate(receiverKey, time, unreadCount);
        }
        channelKeys.forEach(k -> this.checkUnreadMessagesForChannel((ChannelKey)k));
    }

    public int checkUnreadMessagesForChannel(ChannelKey channelKey) {
        ChannelRecord channelRecord = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)channelKey);
        int unreadCount = this.sqliteStorageBean.getMessageData().getNumberOfMessagesAfter(channelRecord.recipient().key(), channelRecord.lastRead());
        LOG.info("check unread messages will return " + unreadCount);
        if (this.messageListener != null) {
            this.messageListener.gotReadUpdate(channelRecord.recipient().key(), channelRecord.lastRead(), unreadCount);
        }
        return unreadCount;
    }

    @Override
    public List<ChannelRecord> searchChannels(String query, int limit, int offset) {
        return this.sqliteStorageBean.getChannelData().queryChannels(query, limit, offset);
    }

    @Override
    public void retrieveUserByUuidAndProfileKey(UUID uuid, byte[] pkb) {
        try {
            LOG.info("Trying to get profile for " + uuid.toString());
            ProfileKey profileKey = new ProfileKey(pkb);
            ServiceId.Aci aci = new ServiceId.Aci(uuid);
            CompletableFuture<SignalServiceProfile> fut = this.retrieveAndStoreProfile(aci, pkb);
            ((CompletableFuture)fut.thenAccept(ssp -> {
                LOG.info("Got new profile, notify client");
                this.messageListener.updateUser(this.userService.getUserByServiceId((ServiceId)aci).get());
            })).exceptionally(ex -> {
                LOG.severe("Got exception! " + String.valueOf(ex));
                return null;
            });
        }
        catch (Exception ex2) {
            LOG.log(Level.SEVERE, null, ex2);
            ex2.printStackTrace();
        }
    }

    @Override
    public List<ReceiptDbRecord> getReceiptsByMessageKey(MessageKey messageKey) {
        return this.sqliteStorageBean.getReceiptData().findByMessageKey(messageKey);
    }

    public void processIncomingReaction(SignalServiceProtos.DataMessage.Reaction reaction, RecipientKey senderKey, long msgTimestamp) {
        UserRecord user = this.userService.getUserByServiceId((ServiceId)new ServiceId.Aci(UUID.fromString(reaction.getTargetAuthorAci()))).orElse(null);
        MessageDbRecord originalMessage = this.sqliteStorageBean.getMessageData().getByFromRecipientKeyAndDateSent(user.recipient().key(), reaction.getTargetSentTimestamp());
        if (originalMessage == null) {
            throw new IllegalArgumentException("Could not find reaction with timestamp " + reaction.getTargetSentTimestamp() + " and userkey = " + user.recipient().key().serialize());
        }
        LOG.info("REACTION, senderKey = " + String.valueOf(senderKey) + ", targetauthoraci = " + reaction.getTargetAuthorAci());
        ReactionService rs = new ReactionService(this.sqliteStorageBean, this.messageListener);
        String emoji = reaction.getEmoji();
        if (this.hasCheatFor(CheatManager.CHEAT_INCOMING_THUMB_SWITCH)) {
            emoji = new String(CheatManager.flipThumbsUpDown(reaction.getEmojiBytes().toByteArray()));
        }
        rs.storeAndNotifyReaction(emoji, reaction.getRemove(), originalMessage.key(), originalMessage.receiverKey(), senderKey, msgTimestamp);
    }

    public void syncStorage() {
        LOG.info("SyncStorage, delegate to StorageManager");
        this.storageManager.syncStorage();
        LOG.info("SyncStorage done");
    }

    public GroupRecord getGroupByGroupIdentifier(byte[] groupIdentifierBytes) {
        try {
            return this.sqliteStorageBean.getGroupData().getGroupByGroupIdentifier(new GroupIdentifier(groupIdentifierBytes)).orElse(null);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    void processGroup(SignalStorageRecord signalStorageRecord) {
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        LOG.info("Process (group) storageRecord " + String.valueOf(storageRecord));
        GroupV2Record groupV2Record = storageRecord.getGroupV2();
        try {
            GroupMasterKey groupMasterKey = new GroupMasterKey(groupV2Record.getMasterKey().toByteArray());
            GroupKey groupKey = this.sqliteStorageBean.getGroupData().createOrUpdate(signalStorageRecord.getId(), groupV2Record);
            GroupRecord group = this.retrieveGroupFromMasterKeyBytes(groupMasterKey.serialize());
            if (group == null) {
                LOG.info("Could not retrieve group from signalgrouprecord, maybe we left?");
                return;
            }
            this.messageListener.updateGroupRecord(group);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    void processContact(SignalStorageRecord signalStorageRecord, ExecutorService workerService) {
        IdentityStoreRecord oldIdentity;
        ContactRecord scr;
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        LOG.info("Process signalSR = " + String.valueOf(signalStorageRecord));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process storageRecord = " + String.valueOf(storageRecord));
        }
        if ((scr = storageRecord.getContact()).getAci() == null || scr.getAci().isEmpty()) {
            LOG.warning("We have a contact without an ACI, which we don't add for now.");
            return;
        }
        String aciUuid = scr.getAci();
        LOG.info("processing " + aciUuid + " with pni = " + scr.getPni() + " and nr = " + scr.getE164() + " and hidden = " + scr.getHidden() + "and muteuntil = " + scr.getMutedUntilTimestamp() + " and uts = " + scr.getUnregisteredAtTimestamp());
        UserRecord user = this.userService.storeContactRecord(signalStorageRecord.getId(), scr);
        byte[] pkb = scr.getProfileKey().toByteArray();
        LOG.info("We have a profile");
        if (scr.getAci() != null && scr.getUnregisteredAtTimestamp() == 0L) {
            LOG.info("Send a job to workerService from thread " + String.valueOf(Thread.currentThread()));
            workerService.submit(() -> {
                LOG.severe("SHOULD retrieving profile for " + aciUuid);
                this.retrieveAndStoreProfile(new ServiceId.Aci(UUID.fromString(aciUuid)), pkb, user.recipient().key());
                LOG.severe("DID NOT retrieving profile for " + aciUuid);
            });
        }
        if ((oldIdentity = this.sqliteStorageBean.getIdentityData().findByAddress(new SignalProtocolAddress(aciUuid, 1))) == null) {
            LOG.info("No identity key for " + scr.getAci());
        } else {
            byte[] newb = scr.getIdentityKey().toByteArray();
            if (Arrays.equals(newb, oldIdentity.identityKey().getPublicKey().serialize())) {
                LOG.info("IdentityKey for " + scr.getAci() + " did not change");
            } else {
                LOG.info("We have a new identityKey for " + scr.getAci());
            }
        }
        this.messageListener.updateUser(this.userService.getUserByUserKey(user.key()));
    }

    void processAccount(SignalStorageRecord signalStorageRecord) {
        LOG.info("Before processing, account = " + String.valueOf(this.account.getUser().aci()));
        StorageId storageId = signalStorageRecord.getId();
        StorageRecord storageRecord = signalStorageRecord.getRecord();
        AccountRecord accountRecord = storageRecord.getAccount();
        try {
            LOG.info("Process account record");
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("record = " + String.valueOf(accountRecord));
            }
            int pcc = accountRecord.getPinnedConversationsCount();
            this.userService.storeAccountRecord(storageId, this.account.getUser().key(), accountRecord);
            this.sqliteStorageBean.preference().storeAccountRecord(accountRecord);
            this.sqliteStorageBean.account().storeAccountRecord(accountRecord);
            this.processPinnedInfo(accountRecord);
            String avatarUrl = accountRecord.getAvatarUrlPath();
            if (avatarUrl != null && !avatarUrl.isEmpty()) {
                LOG.info("Account has avatar");
                ProfileKey pk = new ProfileKey(accountRecord.getProfileKey().toByteArray());
                this.storeAvatar(avatarUrl, pk, this.getAccount().getUser().recipient().key());
            } else {
                LOG.info("Account explicitly has no avatar");
                this.avatarHelper.clearAvatarFile(this.getAccount().getUser().recipient().key());
            }
            this.account = this.retrieveAccount();
            LOG.info("Inform messageListener about our account");
            if (this.messageListener != null) {
                LOG.info("We should inform the app about a new account for " + String.valueOf(this.account.getUser().aci()));
                this.messageListener.updateAccount(this.account);
            }
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "This is a real major error, please report.", ex);
        }
    }

    void processPinnedInfo(AccountRecord accountRecord) throws SQLException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Process pinned info for " + String.valueOf(accountRecord));
        }
        List allRecords = this.sqliteStorageBean.getChannelData().findAll();
        ArrayList oldPinned = allRecords.stream().filter(r -> r.pinned()).collect(Collectors.toCollection(ArrayList::new));
        if (accountRecord.getPinnedConversationsCount() > 0) {
            for (AccountRecord.PinnedConversation conv : accountRecord.getPinnedConversationsList()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("Process conv " + String.valueOf(conv));
                }
                ChannelKey channelKey = null;
                if (conv.hasContact()) {
                    String serviceId = conv.getContact().getServiceId();
                    try {
                        ServiceId realServiceId = ServiceId.parseFromString((String)serviceId);
                        UserDbRecord user = this.sqliteStorageBean.getUserData().getUserForServiceId(realServiceId);
                        channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(user.recipientKey());
                    }
                    catch (ServiceId.InvalidServiceIdException ex) {
                        LOG.severe("Wrong serviceId: " + serviceId);
                    }
                }
                if (conv.hasGroupMasterKey()) {
                    byte[] gmk = conv.getGroupMasterKey().toByteArray();
                    GroupRecord groupRecord = this.groupService.getGroupByMasterKey(gmk);
                    channelKey = this.sqliteStorageBean.getChannelData().findByRecipientKey(groupRecord.recipient().key());
                }
                if (channelKey == null) continue;
                boolean pinned = this.sqliteStorageBean.getChannelData().pin(channelKey);
                ChannelRecord cr = (ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey(channelKey);
                if (this.messageListener != null) {
                    this.messageListener.recipientUpdateNeeded(cr.recipient().key());
                }
                oldPinned.remove(cr);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("channel = " + String.valueOf(cr));
                }
                if (!LOG.isLoggable(Level.FINER)) continue;
                LOG.finer("Pinning channel resulted in " + pinned);
            }
        }
        if (oldPinned.size() > 0) {
            LOG.info("We need to unpin " + oldPinned.size() + " elements.");
            for (ChannelRecord oldOne : oldPinned) {
                boolean pinremoved = this.sqliteStorageBean.getChannelData().unpin(oldOne.key());
                if (this.messageListener == null) continue;
                this.messageListener.recipientUpdateNeeded(oldOne.recipient().key());
            }
        }
    }

    void storeAvatar(String urlPath, ProfileKey pk, RecipientKey recipientKey) throws IOException {
        File avatarFile = Files.createTempFile("avt", "prof", new FileAttribute[0]).toFile();
        this.signalBridge.getNetworkAPI().retrieveProfileAvatar(urlPath, avatarFile);
        ProfileCipherInputStream is = new ProfileCipherInputStream(new FileInputStream(avatarFile), pk);
        this.avatarHelper.setAvatar(recipientKey, is);
        avatarFile.delete();
    }

    Path storeGroupAvatar(String urlPath, GroupSecretParams gsp, RecipientKey recipientKey) throws IOException {
        InputStream is = this.signalBridge.storeGroupAvatar(urlPath, gsp, recipientKey);
        Path destination = this.avatarHelper.setAvatar(recipientKey, is);
        return destination;
    }

    public GroupRecord retrieveGroupFromMasterKeyBytes(byte[] masterKeyBytes) throws IOException {
        try {
            LOG.info("We will ask the server to retrieve a group with known master key");
            GroupMasterKey groupMasterKey = new GroupMasterKey(masterKeyBytes);
            DecryptedGroup decryptedGroup = this.requestDecryptedGroup(groupMasterKey);
            if (decryptedGroup == null) {
                LOG.warning("We can't get a decryptedgroup for these mkb, return null");
                return null;
            }
            GroupRecord group = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes).orElse(null);
            if (group == null) {
                group = this.createNewGroup(masterKeyBytes);
            }
            String avatarPathString = null;
            if (decryptedGroup != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("We will update group named " + decryptedGroup.getTitle());
                }
                String avatarUrl = decryptedGroup.getAvatar();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("finer for " + decryptedGroup.getTitle() + " = " + avatarUrl);
                }
                if (!avatarUrl.isEmpty()) {
                    Path avatarPath = this.storeGroupAvatar(avatarUrl, GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey), group.recipient().key());
                    avatarPathString = avatarPath.toString();
                }
                this.sqliteStorageBean.getGroupData().updateWithAvatar(groupMasterKey, decryptedGroup, avatarPathString);
                group = this.sqliteStorageBean.getGroupData().getGroupByMasterKeyBytes(masterKeyBytes).orElse(null);
            } else {
                LOG.info("No decrypted group could be obtained for this group. Return stored version.");
            }
            return group;
        }
        catch (InvalidInputException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    private GroupRecord createNewGroup(byte[] mkb) {
        byte[] idb = new byte[32];
        new SecureRandom().nextBytes(idb);
        StorageId id = StorageId.forGroupV2((byte[])idb);
        GroupV2Record.Builder builder = GroupV2Record.newBuilder();
        builder.setMasterKey(ByteString.copyFrom((byte[])mkb));
        GroupKey key = this.sqliteStorageBean.getGroupData().createOrUpdate(StorageId.forGroupV2((byte[])idb), builder.build());
        return (GroupRecord)this.sqliteStorageBean.getGroupData().findByKey((EntityKey)key);
    }

    private void handleSenderKeyDistributionMessage(SignalServiceProtos.Envelope envelope, ServiceId serviceId, int deviceId, SenderKeyDistributionMessage message, SignalServiceAccountDataStore senderKeyStore) {
        LOG.info("Handle SKDM for " + String.valueOf(serviceId));
        SignalProtocolAddress sender = new SignalProtocolAddress(serviceId.toServiceIdString(), deviceId);
        new SignalGroupSessionBuilder((SignalSessionLock)this.lock, new GroupSessionBuilder((SenderKeyStore)senderKeyStore)).process(sender, message);
    }

    void processCallEnded(CallDbRecord dbRecord) {
        LOG.severe("CALL ENDED, NEED TO PROCESS INFO AND ADD CALLRECORD");
    }

    private DecryptedGroup requestDecryptedGroup(GroupMasterKey groupMasterKey) {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        int days = (int)LocalDate.now(ZoneId.of("UTC")).toEpochDay();
        GroupsV2AuthorizationString authorization = this.accountManager.getAuthorization(groupSecretParams);
        try {
            DecryptedGroup dgroup = this.accountManager.getGroupsV2Api().getGroup(groupSecretParams, authorization);
            return dgroup;
        }
        catch (NonSuccessfulResponseCodeException e) {
            int res = e.getCode();
            if (res == 403) {
                LOG.info("No permission to get this group info");
            }
            LOG.info("We were requested to decrypt a group that we're not a member of, return null");
            return null;
        }
        catch (IOException | VerificationFailedException | InvalidGroupStateException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static BodyRange.Style getStyleFromProto(int protoStyle) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Need to process proto BodyRange with style = " + protoStyle);
        }
        return switch (protoStyle) {
            case 1 -> BodyRange.Style.BOLD;
            case 2 -> BodyRange.Style.ITALIC;
            case 3 -> BodyRange.Style.SPOILER;
            case 4 -> BodyRange.Style.STRIKETHROUGH;
            case 5 -> BodyRange.Style.MONOSPACE;
            default -> {
                LOG.warning("Unrecognized style: " + protoStyle);
                yield BodyRange.Style.NONE;
            }
        };
    }

    @Override
    public boolean updateMuteUntil(RecipientKey recipientKey, long muteUntil) {
        try {
            this.storageManager.setMuteUntil(recipientKey, muteUntil);
            this.syncStorage();
            return true;
        }
        catch (IOException | InvalidKeyException ex) {
            ex.printStackTrace();
            System.getLogger(EquationManager.class.getName()).log(System.Logger.Level.ERROR, (String)null, ex);
            return false;
        }
    }

    InfoMessage createTimerInfoMessage(int timer) {
        return this.createTimerInfoMessage(timer, null);
    }

    public InfoMessage createTimerInfoMessage(int timer, ServiceId.Aci aci) {
        if (aci == null) {
            return timer == 0 ? new InfoMessage(InfoMessage.Type.INFO_TIMER_DISABLED_ME, new String[0]) : new InfoMessage(InfoMessage.Type.INFO_TIMER_ME, new String[]{String.valueOf(timer)});
        }
        return timer == 0 ? new InfoMessage(InfoMessage.Type.INFO_TIMER_DISABLED_OTHER, new String[]{aci.toServiceIdString()}) : new InfoMessage(InfoMessage.Type.INFO_TIMER_OTHER, new String[]{aci.toServiceIdString(), String.valueOf(timer)});
    }

    @Override
    public boolean isUseProxy() {
        return this.sqliteStorageBean.preference().getBoolean("proxy.use", false);
    }

    @Override
    public void setUseProxy(boolean v) {
        this.sqliteStorageBean.preference().putBoolean("proxy.use", v);
    }

    @Override
    public boolean isUseQuic() {
        return this.sqliteStorageBean.preference().getBoolean("useQuic", false);
    }

    @Override
    public void setUseQuic(boolean v) {
        this.sqliteStorageBean.preference().putBoolean("useQuic", v);
    }

    @Override
    public final boolean isUseLibsignalNet() {
        return this.sqliteStorageBean.preference().getBoolean("useLibsignalNet", false);
    }

    @Override
    public void setUseLibsignalNet(boolean v) {
        this.sqliteStorageBean.preference().putBoolean("useLibsignalNet", v);
    }

    @Override
    public ChannelRecord getChannelByKey(ChannelKey key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SearchMessageRecord> searchMessages(String query) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<SearchMessageRecord> searchMessagesByRecipientKey(String query, RecipientKey recipientKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<StickerPackRecord, List<StickerRecord>> getStickerPacks() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void storeReactionRecord(CreateReactionRequest request) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void sendReaction(RecipientKey destinationKey, RecipientKey authorKey, String emoji, MessageKey messageKey, boolean remove) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long sendGroupReaction(GroupRecord group, RecipientKey authorKey, String emoji, MessageKey messageKey, boolean remove) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long sendStickerMessage(RecipientKey receiverKey, SendStickerRequest stickerRequest) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DistributionListDbRecord createDistributionList(String name, Set<RecipientKey> recipients) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void processStoryMessage(SignalServiceProtos.Envelope envelope, UserDbRecord sender, SignalServiceProtos.StoryMessage msg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<MessageAnalysisEntry> getMessageAnalysisEntries() {
        return this.signalBridge.getMessageAnalyzer().getEntries();
    }

    @Override
    public void setPin(ChannelKey key, boolean b) {
        LOG.info("Set pin for conversation " + String.valueOf(key) + " to " + b);
        try {
            LOG.info("update");
            this.sqliteStorageBean.getChannelData().setPin(key, b);
            this.storageManager.updateStorageAccount(this.account);
            RecipientKey rKey = ((ChannelRecord)this.sqliteStorageBean.getChannelData().findByKey((EntityKey)key)).recipient().key();
            this.messageListener.recipientUpdateNeeded(rKey);
            LOG.info("update done");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<ExportService.Status> exportConversation(RecipientKey key, ExportOptions options, File destination) {
        ExportService exportService = new ExportService(this);
        return exportService.export(key, options, destination);
    }
}

