/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.groups.v2.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.thoughtcrime.securesms.groups.v2.processing.AdvanceGroupStateResult;
import org.thoughtcrime.securesms.groups.v2.processing.GlobalGroupState;
import org.thoughtcrime.securesms.groups.v2.processing.LocalGroupLogEntry;
import org.thoughtcrime.securesms.groups.v2.processing.ServerGroupLogEntry;
import org.thoughtcrime.securesms.groups.v2.processing.StateChain;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupUtil;
import org.whispersystems.signalservice.api.groupsv2.GroupChangeReconstruct;
import org.whispersystems.signalservice.api.groupsv2.GroupChangeUtil;
import org.whispersystems.signalservice.api.groupsv2.NotAbleToApplyGroupV2ChangeException;

final class GroupStateMapper {
    private static final Logger LOG = Logger.getLogger(GroupStateMapper.class.getName());
    static final int LATEST = Integer.MAX_VALUE;
    static final int PLACEHOLDER_REVISION = -1;
    static final int RESTORE_PLACEHOLDER_REVISION = -2;
    private static final Comparator<ServerGroupLogEntry> BY_REVISION = (o1, o2) -> Integer.compare(o1.getRevision(), o2.getRevision());

    private GroupStateMapper() {
    }

    static AdvanceGroupStateResult partiallyAdvanceGroupState(GlobalGroupState inputState, int maximumRevisionToApply) {
        AdvanceGroupStateResult groupStateResult = GroupStateMapper.processChanges(inputState, maximumRevisionToApply);
        return GroupStateMapper.cleanDuplicatedChanges(groupStateResult, inputState.getLocalState());
    }

    private static AdvanceGroupStateResult processChanges(GlobalGroupState inputState, int maximumRevisionToApply) {
        HashMap<Integer, ServerGroupLogEntry> statesToApplyNow = new HashMap<Integer, ServerGroupLogEntry>(inputState.getServerHistory().size());
        ArrayList<ServerGroupLogEntry> statesToApplyLater = new ArrayList<ServerGroupLogEntry>(inputState.getServerHistory().size());
        DecryptedGroup current = inputState.getLocalState();
        StateChain<DecryptedGroup, DecryptedGroupChange> stateChain = GroupStateMapper.createNewMapper();
        if (inputState.getServerHistory().isEmpty()) {
            return new AdvanceGroupStateResult(Collections.emptyList(), new GlobalGroupState(current, Collections.emptyList()));
        }
        for (ServerGroupLogEntry entry : inputState.getServerHistory()) {
            if (entry.getRevision() > maximumRevisionToApply) {
                statesToApplyLater.add(entry);
                continue;
            }
            statesToApplyNow.put(entry.getRevision(), entry);
        }
        Collections.sort(statesToApplyLater, BY_REVISION);
        int from = Math.max(0, inputState.getEarliestRevisionNumber());
        int to = Math.min(inputState.getLatestRevisionNumber(), maximumRevisionToApply);
        if (current != null && current.getRevision() == -1) {
            LOG.info("Ignoring place holder group state");
        } else {
            stateChain.push(current, null);
        }
        for (int revision = from; revision >= 0 && revision <= to; ++revision) {
            ServerGroupLogEntry entry = (ServerGroupLogEntry)statesToApplyNow.get(revision);
            if (entry == null) {
                LOG.warning("Could not find group log on server V" + revision);
                continue;
            }
            if (stateChain.getLatestState() == null && entry.getGroup() != null && current != null && current.getRevision() == -1) {
                DecryptedGroup previousState = DecryptedGroup.newBuilder((DecryptedGroup)entry.getGroup()).setTitle(current.getTitle()).setAvatar(current.getAvatar()).build();
                stateChain.push(previousState, null);
            }
            stateChain.push(entry.getGroup(), entry.getChange());
        }
        List<StateChain.Pair<DecryptedGroup, DecryptedGroupChange>> mapperList = stateChain.getList();
        ArrayList<LocalGroupLogEntry> appliedChanges = new ArrayList<LocalGroupLogEntry>(mapperList.size());
        for (StateChain.Pair<DecryptedGroup, DecryptedGroupChange> entry : mapperList) {
            if (current != null && entry.getDelta() == null) continue;
            appliedChanges.add(new LocalGroupLogEntry(entry.getState(), entry.getDelta()));
        }
        return new AdvanceGroupStateResult(appliedChanges, new GlobalGroupState(stateChain.getLatestState(), statesToApplyLater));
    }

    private static AdvanceGroupStateResult cleanDuplicatedChanges(AdvanceGroupStateResult groupStateResult, DecryptedGroup previousGroupState) {
        if (previousGroupState == null) {
            return groupStateResult;
        }
        ArrayList<LocalGroupLogEntry> appliedChanges = new ArrayList<LocalGroupLogEntry>(groupStateResult.getProcessedLogEntries().size());
        for (LocalGroupLogEntry entry : groupStateResult.getProcessedLogEntries()) {
            DecryptedGroupChange change = entry.getChange();
            if (change != null) {
                change = GroupChangeUtil.resolveConflict((DecryptedGroup)previousGroupState, (DecryptedGroupChange)change).build();
            }
            appliedChanges.add(new LocalGroupLogEntry(entry.getGroup(), change));
            previousGroupState = entry.getGroup();
        }
        return new AdvanceGroupStateResult(appliedChanges, groupStateResult.getNewGlobalGroupState());
    }

    private static StateChain<DecryptedGroup, DecryptedGroupChange> createNewMapper() {
        return new StateChain<DecryptedGroup, DecryptedGroupChange>((group, change) -> {
            try {
                return DecryptedGroupUtil.applyWithoutRevisionCheck((DecryptedGroup)group, (DecryptedGroupChange)change);
            }
            catch (NotAbleToApplyGroupV2ChangeException e) {
                LOG.log(Level.WARNING, "Unable to apply V" + change.getRevision(), e);
                return null;
            }
        }, (groupB, groupA) -> GroupChangeReconstruct.reconstructGroupChange((DecryptedGroup)groupA, (DecryptedGroup)groupB), (groupA, groupB) -> groupA.getRevision() == groupB.getRevision() && DecryptedGroupUtil.changeIsEmpty((DecryptedGroupChange)GroupChangeReconstruct.reconstructGroupChange((DecryptedGroup)groupA, (DecryptedGroup)groupB)));
    }
}

