/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal;

import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.signal.MessageAnalysisEntry;
import io.privacyresearch.equation.signal.MessageAnalyzer;
import io.privacyresearch.proto.WireProtos;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Logger;
import org.signal.libsignal.metadata.SealedSessionCipher;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidSessionException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.SessionCipher;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UntrustedIdentityException;
import org.signal.libsignal.protocol.UsePqRatchet;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeContent;
import org.whispersystems.signalservice.api.crypto.SignalSealedSessionCipher;
import org.whispersystems.signalservice.api.crypto.SignalSessionCipher;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.push.OutgoingPushMessage;
import org.whispersystems.signalservice.api.push.PushTransportDetails;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class MySignalCipher {
    private final SignalServiceAccountDataStore signalProtocolStore;
    private final SignalSessionLock sessionLock;
    private final SignalServiceAddress localAddress;
    private final int localDeviceId;
    private final CertificateValidator certificateValidator;
    private final UsePqRatchet usePqRatchet;
    private static final Logger LOG = Logger.getLogger(MySignalCipher.class.getName());

    public MySignalCipher(SignalServiceAddress localAddress, int localDeviceId, SignalServiceAccountDataStore signalProtocolStore, SignalSessionLock sessionLock, CertificateValidator certificateValidator, UsePqRatchet usePqRatchet) {
        this.signalProtocolStore = signalProtocolStore;
        this.sessionLock = sessionLock;
        this.localAddress = localAddress;
        this.localDeviceId = localDeviceId;
        this.certificateValidator = certificateValidator;
        this.usePqRatchet = usePqRatchet;
    }

    public OutgoingPushMessage encrypt(SignalProtocolAddress destination, Optional<UnidentifiedAccess> unidentifiedAccess, EnvelopeContent content, ContentHint contentHint) throws UntrustedIdentityException, InvalidKeyException {
        try {
            SignalSessionCipher sessionCipher = new SignalSessionCipher(this.sessionLock, new SessionCipher((SignalProtocolStore)this.signalProtocolStore, destination), this.usePqRatchet);
            if (unidentifiedAccess.isPresent()) {
                SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher(this.sessionLock, new SealedSessionCipher((SignalProtocolStore)this.signalProtocolStore, this.localAddress.getServiceId().getRawUUID(), (String)this.localAddress.getNumber().orElse(null), this.localDeviceId), this.usePqRatchet);
                return this.processSealedSender(content, contentHint, sessionCipher, sealedSessionCipher, destination, unidentifiedAccess.get().getUnidentifiedCertificate());
            }
            long now = System.currentTimeMillis();
            String destinationId = destination.getServiceId().toServiceIdString();
            int deviceId = destination.getDeviceId();
            MessageAnalysisEntry entry = new MessageAnalysisEntry(MessageAnalysisEntry.Direction.OUTGOING, now, false, 0, content.size(), destinationId, deviceId, 0);
            return content.processUnsealedSender(sessionCipher, destination);
        }
        catch (NoSessionException e) {
            e.printStackTrace();
            throw new InvalidSessionException("Session not found.");
        }
    }

    private OutgoingPushMessage processSealedSender(EnvelopeContent envelopeContent, ContentHint contentHint, SignalSessionCipher sessionCipher, SignalSealedSessionCipher sealedSessionCipher, SignalProtocolAddress destination, SenderCertificate senderCertificate) throws UntrustedIdentityException, InvalidKeyException, NoSessionException {
        if (contentHint == null) {
            contentHint = ContentHint.DEFAULT;
        }
        SignalServiceProtos.Content content = (SignalServiceProtos.Content)envelopeContent.getContent().get();
        PushTransportDetails transportDetails = new PushTransportDetails();
        CiphertextMessage message = sessionCipher.encrypt(transportDetails.getPaddedMessageBody(content.toByteArray()));
        int mtype = message.getType();
        int pqSize = 0;
        if (mtype == 2) {
            byte[] sc = message.serialize();
            byte[] mc = new byte[sc.length - 9];
            System.arraycopy(sc, 1, mc, 0, mc.length);
            try {
                WireProtos.SignalMessage signalMessage = WireProtos.SignalMessage.parseFrom((byte[])mc);
                if (signalMessage.hasPqRatchet()) {
                    pqSize = signalMessage.getPqRatchet().size();
                    LOG.info("PQRatchetsize = " + pqSize);
                }
                if (signalMessage.hasRatchetKey()) {
                    LOG.info("Ratchetkeysize = " + signalMessage.getRatchetKey().size());
                }
            }
            catch (InvalidProtocolBufferException ex) {
                LOG.info("Error: ");
                ex.printStackTrace();
            }
        }
        UnidentifiedSenderMessageContent messageContent = new UnidentifiedSenderMessageContent(message, senderCertificate, contentHint.getType(), Optional.empty());
        byte[] ciphertext = sealedSessionCipher.encrypt(destination, messageContent);
        String body = Base64.getEncoder().encodeToString(ciphertext);
        int remoteRegistrationId = sealedSessionCipher.getRemoteRegistrationId(destination);
        String destinationId = destination.getServiceId().toServiceIdString();
        int deviceId = destination.getDeviceId();
        long now = System.currentTimeMillis();
        MessageAnalysisEntry entry = new MessageAnalysisEntry(MessageAnalysisEntry.Direction.OUTGOING, now, true, mtype, ciphertext.length, destinationId, deviceId, pqSize);
        MessageAnalyzer analyzer = MessageAnalyzer.getInstance();
        if (analyzer != null) {
            analyzer.addEntry(entry);
        }
        return new OutgoingPushMessage(6, destination.getDeviceId(), remoteRegistrationId, body);
    }
}

