/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.privacyresearch.equation.model.json.AccountAttributes;
import io.privacyresearch.equation.model.json.ApnRegistrationId;
import io.privacyresearch.equation.model.json.DeviceActivationRequest;
import io.privacyresearch.equation.model.json.ECSignedPreKey;
import io.privacyresearch.equation.model.json.GcmRegistrationId;
import io.privacyresearch.equation.model.json.IdentityKeyAdapter;
import io.privacyresearch.equation.model.json.KEMSignedPreKey;
import io.privacyresearch.equation.model.json.SignedPreKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.signal.libsignal.protocol.IdentityKey;

public class RegistrationRequest {
    private String sessionId;
    private byte[] recoveryPassword;
    AccountAttributes accountAttributes;
    private boolean skipDeviceTransfer;
    @JsonSerialize(using=IdentityKeyAdapter.Serializer.class)
    @JsonDeserialize(using=IdentityKeyAdapter.Deserializer.class)
    IdentityKey aciIdentityKey;
    @JsonSerialize(using=IdentityKeyAdapter.Serializer.class)
    @JsonDeserialize(using=IdentityKeyAdapter.Deserializer.class)
    IdentityKey pniIdentityKey;
    @JsonUnwrapped
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    DeviceActivationRequest deviceActivationRequest;

    public RegistrationRequest() {
    }

    @JsonCreator
    public RegistrationRequest(@JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="recoveryPassword") byte[] recoveryPassword, @JsonProperty(value="accountAttributes") AccountAttributes accountAttributes, @JsonProperty(value="skipDeviceTransfer") boolean skipDeviceTransfer, @JsonProperty(value="aciIdentityKey") IdentityKey aciIdentityKey, @JsonProperty(value="pniIdentityKey") IdentityKey pniIdentityKey, @JsonProperty(value="aciSignedPreKey") ECSignedPreKey aciSignedPreKey, @JsonProperty(value="pniSignedPreKey") ECSignedPreKey pniSignedPreKey, @JsonProperty(value="aciPqLastResortPreKey") KEMSignedPreKey aciPqLastResortPreKey, @JsonProperty(value="pniPqLastResortPreKey") KEMSignedPreKey pniPqLastResortPreKey, @JsonProperty(value="apnToken") Optional<ApnRegistrationId> apnToken, @JsonProperty(value="gcmToken") Optional<GcmRegistrationId> gcmToken) {
        DeviceActivationRequest deviceActivationRequest = new DeviceActivationRequest(aciSignedPreKey, pniSignedPreKey, aciPqLastResortPreKey, pniPqLastResortPreKey);
        this.setDeviceActivationRequest(deviceActivationRequest);
        this.recoveryPassword = recoveryPassword;
        this.accountAttributes = accountAttributes;
        this.skipDeviceTransfer = skipDeviceTransfer;
        this.aciIdentityKey = aciIdentityKey;
        this.pniIdentityKey = pniIdentityKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public byte[] getRecoveryPassword() {
        return this.recoveryPassword;
    }

    public void setRecoveryPassword(byte[] recoveryPassword) {
        this.recoveryPassword = recoveryPassword;
    }

    public boolean isSkipDeviceTransfer() {
        return this.skipDeviceTransfer;
    }

    public void setSkipDeviceTransfer(boolean skipDeviceTransfer) {
        this.skipDeviceTransfer = skipDeviceTransfer;
    }

    public AccountAttributes getAccountAttributes() {
        return this.accountAttributes;
    }

    public void setAccountAttributes(AccountAttributes accountAttributes) {
        this.accountAttributes = accountAttributes;
    }

    public IdentityKey getAciIdentityKey() {
        return this.aciIdentityKey;
    }

    public void setAciIdentityKey(IdentityKey aciIdentityKey) {
        this.aciIdentityKey = aciIdentityKey;
    }

    public IdentityKey getPniIdentityKey() {
        return this.pniIdentityKey;
    }

    public void setPniIdentityKey(IdentityKey pniIdentityKey) {
        this.pniIdentityKey = pniIdentityKey;
    }

    public DeviceActivationRequest getDeviceActivationRequest() {
        return this.deviceActivationRequest;
    }

    public void setDeviceActivationRequest(DeviceActivationRequest deviceActivationRequest) {
        this.deviceActivationRequest = deviceActivationRequest;
    }

    @JsonIgnore
    public boolean isEverySignedKeyValid() {
        if (this.deviceActivationRequest.getAciSignedPreKey() == null || this.deviceActivationRequest.getPniSignedPreKey() == null || this.deviceActivationRequest.getAciPqLastResortPreKey() == null || this.deviceActivationRequest.getPniPqLastResortPreKey() == null) {
            System.err.println("At least one null key!");
            return false;
        }
        boolean answer = RegistrationRequest.validatePreKeySignatures(this.aciIdentityKey, List.of(this.deviceActivationRequest.getAciSignedPreKey(), this.deviceActivationRequest.getAciPqLastResortPreKey()));
        if (!answer) {
            System.err.println("ACI key invalid");
            boolean pk = RegistrationRequest.validatePreKeySignatures(this.aciIdentityKey, List.of(this.deviceActivationRequest.getAciSignedPreKey()));
            System.err.println("PK = " + pk);
        }
        answer = RegistrationRequest.validatePreKeySignatures(this.pniIdentityKey, List.of(this.deviceActivationRequest.getPniSignedPreKey(), this.deviceActivationRequest.getPniPqLastResortPreKey()));
        System.err.println("PNI key valid? " + answer);
        return answer;
    }

    public static boolean validatePreKeySignatures(IdentityKey identityKey, Collection<SignedPreKey<?>> signedPreKeys) {
        boolean success = signedPreKeys.stream().allMatch(signedPreKey -> signedPreKey.signatureValid(identityKey));
        return success;
    }
}

