/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.user.UserRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;

public class GroupCall
extends Call {
    private final GroupRecord groupRecord;
    private final List<Participant> participants = new ArrayList<Participant>();
    private static final Logger LOG = Logger.getLogger(GroupCall.class.getName());

    public GroupCall(CallKey callKey, Call.Direction direction, long callId, UserRecord user, GroupRecord group) {
        super(callKey, direction, callId, user);
        this.groupRecord = group;
        this.setType(CallDbRecord.Type.VIDEO_CALL);
        LOG.info("Created GroupCall object, direction = " + String.valueOf((Object)direction));
    }

    @Override
    public GroupRecord getGroupRecord() {
        return this.groupRecord;
    }

    public List<Participant> getParticipants() {
        return this.participants;
    }

    @Override
    public boolean isGroupCall() {
        return true;
    }

    @Override
    public RecipientRecord getCallRecipient() {
        return this.groupRecord.recipient();
    }

    public static class Participant {
        public ServiceId.Aci aci;
        public byte[] lastImage;
        public long lastImageTimestamp;
        public boolean camera;
        public boolean mic;
        public boolean presenting;
        public boolean raiseHand;
        public long raiseHandTimestamp;
    }
}

