/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.log;

import java.text.MessageFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ResourceBundle;
import org.signal.libsignal.protocol.logging.SignalProtocolLogger;
import org.signal.libsignal.protocol.logging.SignalProtocolLoggerProvider;

public class WaveLogger
implements System.Logger,
SignalProtocolLogger {
    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss");
    private int myLevel;
    private System.Logger.Level sysLevel;
    private final String WAVE_LOGGER = "WaveLogger";

    public WaveLogger() {
        this(System.Logger.Level.INFO);
    }

    public WaveLogger(System.Logger.Level level) {
        this.setLevel(level);
        SignalProtocolLoggerProvider.setProvider((SignalProtocolLogger)this);
    }

    public void setLevel(System.Logger.Level level) {
        System.err.println("SETLEVEL for " + String.valueOf(this) + " to " + String.valueOf((Object)level));
        this.sysLevel = level;
        this.myLevel = 4;
        switch (level) {
            case TRACE: {
                this.myLevel = 2;
                break;
            }
            case DEBUG: {
                this.myLevel = 3;
                break;
            }
            case INFO: {
                this.myLevel = 4;
                break;
            }
            case WARNING: {
                this.myLevel = 5;
                break;
            }
            case ERROR: {
                this.myLevel = 6;
            }
        }
        System.err.println("after setlevel, mylevel = " + this.myLevel);
    }

    public void log(int priority, String tag, String message) {
        if (priority >= this.myLevel) {
            String format = this.dtf.format(LocalTime.now());
            System.err.println(format + " " + priority + " [" + tag + "] " + message);
        }
    }

    @Override
    public String getName() {
        return "WaveLogger";
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return level.compareTo(this.sysLevel) >= 0;
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle rb, String content, Throwable t) {
        if (this.isLoggable(level)) {
            String format = this.dtf.format(LocalTime.now());
            System.err.printf(format + " [%s] [WaveLogger] %s - %s%n", new Object[]{level, content, t});
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle rb, String content, Object ... params) {
        if (this.isLoggable(level)) {
            String format = this.dtf.format(LocalTime.now());
            String msg = content;
            if (params != null) {
                msg = MessageFormat.format(content, params);
            }
            System.err.printf(format + " [%s] [WaveLogger] %s%n", new Object[]{level, msg});
        }
    }
}

