/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.groups;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.group.GroupData;
import io.privacyresearch.clientdata.group.GroupKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.group.MembershipRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.user.UserData;
import io.privacyresearch.clientdata.user.UserDbRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.groups.ClientZkGroupCipher;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.storageservice.protos.groups.GroupExternalCredential;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;

public class GroupService {
    private final GroupData groupData;
    private final UserData userData;
    private final EquationManager equation;

    public GroupService(GroupData groupData, UserData userData, EquationManager equation) {
        this.groupData = groupData;
        this.userData = userData;
        this.equation = equation;
    }

    public GroupRecord getGroupByMasterKey(GroupMasterKey groupMasterKey) {
        return this.getGroupByMasterKey(groupMasterKey.serialize());
    }

    public GroupRecord getGroupByMasterKey(byte[] gmk) {
        return this.groupData.getGroupByMasterKeyBytes(gmk).orElse(null);
    }

    public GroupExternalCredential getGroupExternalCredential(GroupMasterKey gmk) throws IOException {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)gmk);
        GroupsV2AuthorizationString authorization = this.equation.getAccountManager().getAuthorization(groupSecretParams);
        GroupExternalCredential answer = this.equation.getAccountManager().getGroupsV2Api().getGroupExternalCredential(authorization);
        return answer;
    }

    public Map<UUID, UuidCiphertext> getUuidCipherTexts(GroupMasterKey groupMasterKey, GroupKey groupKey) {
        HashMap<UUID, UuidCiphertext> answer = new HashMap<UUID, UuidCiphertext>();
        ClientZkGroupCipher clientZkGroupCipher = new ClientZkGroupCipher(GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey));
        Set groupMembers = this.groupData.getGroupMembers(groupKey);
        for (MembershipRecord groupMember : groupMembers) {
            UserDbRecord user = (UserDbRecord)this.userData.findByKey((EntityKey)groupMember.userKey());
            UUID uuid = user.aci().getRawUUID();
            UuidCiphertext value = clientZkGroupCipher.encrypt((ServiceId)user.aci());
            answer.put(uuid, value);
        }
        return answer;
    }

    public GroupRecord getGroupByRecipientKey(RecipientKey recipientKey) {
        return this.groupData.getGroupByRecipientKey(recipientKey);
    }

    public SignalServiceGroupV2 getV2Group(GroupRecord group) {
        return this.getV2Group(group, null);
    }

    public SignalServiceGroupV2 getV2Group(GroupRecord group, byte[] change) {
        GroupMasterKey masterKey = group.getMasterKey();
        SignalServiceGroupV2.Builder groupBuilder = SignalServiceGroupV2.newBuilder((GroupMasterKey)masterKey).withRevision(group.revision());
        if (change != null) {
            groupBuilder.withSignedGroupChange(change);
        }
        return groupBuilder.build();
    }
}

