/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.attachment;

import java.util.Optional;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public final class SignalServiceAttachmentRemoteId {
    private final Optional<Long> v2;
    private final Optional<String> v3;

    public SignalServiceAttachmentRemoteId(long v2) {
        this.v2 = Optional.of(v2);
        this.v3 = Optional.empty();
    }

    public SignalServiceAttachmentRemoteId(String v3) {
        this.v2 = Optional.empty();
        this.v3 = Optional.of(v3);
    }

    public Optional<Long> getV2() {
        return this.v2;
    }

    public Optional<String> getV3() {
        return this.v3;
    }

    public String toString() {
        if (this.v2.isPresent()) {
            return this.v2.get().toString();
        }
        return this.v3.get();
    }

    public static SignalServiceAttachmentRemoteId from(SignalServiceProtos.AttachmentPointer attachmentPointer) throws InvalidMessageStructureException {
        switch (attachmentPointer.getAttachmentIdentifierCase()) {
            case CDNID: {
                return new SignalServiceAttachmentRemoteId(attachmentPointer.getCdnId());
            }
            case CDNKEY: {
                return new SignalServiceAttachmentRemoteId(attachmentPointer.getCdnKey());
            }
            case ATTACHMENTIDENTIFIER_NOT_SET: {
                throw new InvalidMessageStructureException((Exception)((Object)new InvalidMessageException("AttachmentPointer CDN location not set")), null, 0);
            }
        }
        return null;
    }

    public static SignalServiceAttachmentRemoteId from(String string) {
        try {
            return new SignalServiceAttachmentRemoteId(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            return new SignalServiceAttachmentRemoteId(string);
        }
    }
}

