/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.canvas.CanvasDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasEntryDbRecord;
import io.privacyresearch.clientdata.canvas.CanvasKey;
import io.privacyresearch.clientdata.canvas.CreateCanvasRequest;
import io.privacyresearch.clientdata.canvas.InsertCanvasEntryRequest;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.model.UpdateCanvasRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;

public class CanvasService {
    private static final Logger LOG = Logger.getLogger(CanvasService.class.getName());
    private final SqliteStorageBean sqliteStorageBean;
    private final EquationManager equation;

    public CanvasService(EquationManager equation, SqliteStorageBean sqliteStorageBean) {
        this.sqliteStorageBean = sqliteStorageBean;
        this.equation = equation;
    }

    public List<CanvasDbRecord> getCanvasListByChannel(ChannelKey channelKey) {
        return this.sqliteStorageBean.getCanvasData().getByChannel(channelKey);
    }

    public List<CanvasEntryDbRecord> getCanvasHistory(ChannelKey channelKey, String identifierForCanvas) {
        List canvasesByChannel = this.sqliteStorageBean.getCanvasData().getByChannel(channelKey);
        Optional<CanvasKey> canvasKey = canvasesByChannel.stream().filter(canvas -> identifierForCanvas.equals(canvas.identifier())).map(CanvasDbRecord::key).findFirst();
        return canvasKey.map(key -> this.sqliteStorageBean.getCanvasEntryData().getByCanvas(key, 20)).orElseGet(() -> new LinkedList());
    }

    CanvasDbRecord createCanvas(ChannelKey channelKey) {
        String canvasIdentifier = UUID.randomUUID().toString();
        CanvasKey canvasKey = this.sqliteStorageBean.getCanvasData().createCanvas(new CreateCanvasRequest(channelKey, canvasIdentifier));
        return (CanvasDbRecord)this.sqliteStorageBean.getCanvasData().findByKey((EntityKey)canvasKey);
    }

    CanvasDbRecord updateCanvas(UpdateCanvasRequest request) {
        CanvasDbRecord canvas = (CanvasDbRecord)this.sqliteStorageBean.getCanvasData().findByKey((EntityKey)request.key());
        long newVersion = canvas.latestEntry() == null ? 0L : canvas.latestEntry().version() + 1L;
        InsertCanvasEntryRequest insertCanvasEntryRequest = new InsertCanvasEntryRequest(request.key(), this.equation.getAccount().getUser().recipient().key(), request.title(), request.body(), request.bodyRanges(), newVersion);
        this.sqliteStorageBean.getCanvasEntryData().insertCanvasEntry(insertCanvasEntryRequest);
        return (CanvasDbRecord)this.sqliteStorageBean.getCanvasData().findByKey((EntityKey)canvas.key());
    }

    boolean deleteCanvas(CanvasKey canvasKey) {
        return this.sqliteStorageBean.getCanvasData().delete((EntityKey)canvasKey);
    }
}

