/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl.doubt;

import com.gluonhq.snl.doubt.MultipartBody;
import com.gluonhq.snl.doubt.MultipartFormDataChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultipartBodyPublisher
implements HttpRequest.BodyPublisher {
    private String boundary;
    private Charset charset;
    private final HttpRequest.BodyPublisher delegate;
    private final byte[] rawData;
    private List<MultipartBody.Part> parts;
    private static final Logger LOG = Logger.getLogger(MultipartBodyPublisher.class.getName());

    public MultipartBodyPublisher(List<MultipartBody.Part> parts, String boundary, Charset charset) {
        this.parts = parts;
        this.boundary = boundary;
        this.charset = charset;
        MultipartFormDataChannel mpfd = new MultipartFormDataChannel(this.boundary, this.parts, this.charset);
        ByteBuffer bb = ByteBuffer.allocate(16384);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int read = mpfd.read(bb);
            while (read > -1) {
                baos.write(bb.array(), 0, read);
                bb = ByteBuffer.allocate(16384);
                read = mpfd.read(bb);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MultipartBodyPublisher.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.rawData = baos.toByteArray();
        this.delegate = HttpRequest.BodyPublishers.ofByteArray(this.rawData);
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public long contentLength() {
        long answer = this.delegate.contentLength();
        LOG.info("Sending multipartbody content with length " + answer);
        return answer;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        this.delegate.subscribe(subscriber);
    }
}

