/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Base64;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T fromJson(byte[] serialized, Class<T> clazz) throws IOException {
        return JsonUtils.fromJson(new String(serialized), clazz);
    }

    public static <T> T fromJson(String serialized, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(serialized, clazz);
    }

    public static <T> T fromJson(InputStream serialized, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(serialized, clazz);
    }

    public static <T> T fromJson(Reader serialized, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(serialized, clazz);
    }

    public static String toJson(Object object) throws IOException {
        return objectMapper.writeValueAsString(object);
    }

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public static class IdentityKeyDeserializer
    extends JsonDeserializer<IdentityKey> {
        public IdentityKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new IdentityKey(Base64.getDecoder().decode(p.getValueAsString()));
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
        }
    }

    public static class IdentityKeySerializer
    extends JsonSerializer<IdentityKey> {
        public void serialize(IdentityKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.getEncoder().withoutPadding().encodeToString(value.serialize()));
        }
    }
}

