/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.util;

import io.privacyresearch.clientdata.recipient.RecipientKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.core.util.StreamUtil;

public class AvatarHelper {
    private static final Logger LOG = Logger.getLogger(AvatarHelper.class.getName());
    private final Path storageRoot;

    public AvatarHelper(Path storageRoot) {
        this.storageRoot = storageRoot.resolve("avatars");
        try {
            Files.createDirectories(this.storageRoot, new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public InputStream getAvatar(RecipientKey recipientKey) throws IOException {
        return new FileInputStream(this.getAvatarFile(recipientKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path setAvatar(RecipientKey recipientKey, InputStream inputStream) throws IOException {
        Path path;
        String keyString = recipientKey.serialize();
        LOG.info("Set avatar for " + keyString);
        if (inputStream == null) {
            LOG.info("Need to remove avatar for " + keyString);
        }
        FileOutputStream outputStream = null;
        try {
            File destination = this.getAvatarFile(recipientKey);
            outputStream = new FileOutputStream(destination);
            StreamUtil.copy(inputStream, outputStream);
            path = destination.toPath();
        }
        catch (Throwable throwable) {
            StreamUtil.close(outputStream);
            throw throwable;
        }
        StreamUtil.close(outputStream);
        return path;
    }

    public File getAvatarFile(RecipientKey recipientKey) {
        String keyString = recipientKey.serialize();
        LOG.info("Asked avatar for " + keyString);
        return this.storageRoot.resolve(keyString).toFile();
    }

    public void clearAvatarFile(RecipientKey recipientKey) {
        String keyString = recipientKey.serialize();
        LOG.info("Need to delete avatar for " + keyString);
        File current = this.storageRoot.resolve(keyString).toFile();
        if (current.exists()) {
            boolean bl = current.delete();
        } else {
            LOG.info("Avatar didn't exist");
        }
    }
}

