/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal.todo;

import io.privacyresearch.equation.signal.todo.DecryptedGroupHistoryEntry;
import io.privacyresearch.equation.signal.todo.GroupHistory;
import java.util.List;

public final class GroupHistoryPage {
    private final List<DecryptedGroupHistoryEntry> results;
    private final PagingData pagingData;

    public GroupHistoryPage(List<DecryptedGroupHistoryEntry> results, PagingData pagingData) {
        this.results = results;
        this.pagingData = pagingData;
    }

    public List<DecryptedGroupHistoryEntry> getResults() {
        return this.results;
    }

    public PagingData getPagingData() {
        return this.pagingData;
    }

    public static final class PagingData {
        public static final PagingData NONE = new PagingData(false, -1);
        private final boolean hasMorePages;
        private final int nextPageRevision;

        public static PagingData fromGroup(GroupHistory groupHistory) {
            return new PagingData(groupHistory.hasMore(), groupHistory.hasMore() ? groupHistory.getNextPageStartGroupRevision() : -1);
        }

        private PagingData(boolean hasMorePages, int nextPageRevision) {
            this.hasMorePages = hasMorePages;
            this.nextPageRevision = nextPageRevision;
        }

        public boolean hasMorePages() {
            return this.hasMorePages;
        }

        public int getNextPageRevision() {
            return this.nextPageRevision;
        }
    }
}

