/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.proxy.ProxyKey;
import io.privacyresearch.clientdata.proxy.ProxyRecord;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.proxy.QuicServerTransport;
import io.privacyresearch.equation.signal.SignalBridge;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyManager {
    private final EquationManager equation;
    private final SqliteStorageBean sqliteStorageBean;
    private final SignalBridge signalBridge;
    private Map<ProxyRecord, ChannelKey> live = new HashMap<ProxyRecord, ChannelKey>();
    ScheduledExecutorService pingService = Executors.newScheduledThreadPool(1);
    private static final Logger LOG = Logger.getLogger(ProxyManager.class.getName());

    public ProxyManager(EquationManager equation) {
        this.equation = equation;
        this.sqliteStorageBean = equation.getSqliteStorageBean();
        this.signalBridge = equation.getSignalBridge();
    }

    public void shareProxyWithChannel(ChannelKey channelKey) {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        int port = QuicServerTransport.DEFAULT_PORT;
        long verification = new Random().nextLong();
        int remoteId = 0;
        ProxyRecord proxy = new ProxyRecord(null, hostName, port, verification, (long)remoteId);
        ProxyKey key = this.sqliteStorageBean.getProxyData().createProxy(proxy);
        this.pingService.scheduleAtFixedRate(() -> this.sendPing(proxy, channelKey), 0L, 1L, TimeUnit.MINUTES);
    }

    private void sendPing(ProxyRecord proxy, ChannelKey channelKey) {
        if (!this.live.containsValue(channelKey)) {
            LOG.info("Send proxy ping to " + String.valueOf(channelKey));
            Thread.dumpStack();
            throw new RuntimeException();
        }
        LOG.info("NOT sending ping to " + String.valueOf(channelKey) + " because we already did and are not sending updates yet");
    }

    public void setEnableServerProxy(boolean v) {
        this.sqliteStorageBean.preference().putBoolean("proxyserver.enabled", v);
    }

    public ProxyRecord findBestProxy() {
        ProxyRecord bestMatch = null;
        try {
            List proxies = this.sqliteStorageBean.getProxyData().findAll();
            LOG.info("We have " + proxies.size() + " proxies");
            Optional best = proxies.stream().findAny();
            if (best.isPresent()) {
                bestMatch = (ProxyRecord)best.get();
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        LOG.info("Best proxy asked, will return " + String.valueOf(bestMatch));
        return bestMatch;
    }
}

