/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.keyvalue.UsernameLink;
import io.privacyresearch.equation.net.NetworkAPI;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;

public class UsernameService {
    private static final Logger LOG = Logger.getLogger(UsernameService.class.getName());
    int maxlen = 32;
    private final NetworkAPI networkAPI;

    public UsernameService(NetworkAPI networkAPI) {
        this.networkAPI = networkAPI;
    }

    public Username generateUsername(String nick) {
        Function<List<Username>, Username> bs = a -> this.tryReserve((List<Username>)a);
        return this.generateUsername(nick, bs);
    }

    public Username generateUsername(String nick, Function<List<Username>, Username> bs) {
        try {
            if (nick.length() > this.maxlen) {
                throw new IllegalArgumentException("Username nick should be " + this.maxlen + " max, but got " + nick.length());
            }
            List candidates = Username.candidatesFrom((String)nick, (int)0, (int)this.maxlen);
            Username reserved = bs.apply(candidates);
            if (reserved != null) {
                LOG.info("Got reservation: " + String.valueOf(reserved));
                return reserved;
            }
            LOG.warning("All candidates failed, return null!");
            return null;
        }
        catch (BaseUsernameException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public UsernameLink confirmUsername(Username username) {
        try {
            byte[] hashBytes = username.getHash();
            Username.UsernameLink ulink = username.generateLink();
            byte[] linkBytes = ulink.getEncryptedUsername();
            byte[] entropy = new byte[32];
            Random random = new Random();
            random.nextBytes(entropy);
            byte[] proofBytes = username.generateProofWithRandomness(entropy);
            String hash = Base64.getUrlEncoder().encodeToString(hashBytes);
            String proof = Base64.getUrlEncoder().encodeToString(proofBytes);
            String link = Base64.getUrlEncoder().encodeToString(linkBytes);
            String response = this.networkAPI.confirmUsername(hash, proof, link);
            int idx = response.indexOf("usernameLink");
            int start = response.indexOf(":", idx) + 2;
            int end = response.length() - 2;
            String serverid = response.substring(start, end);
            LOG.finer("Response = " + response + ", hence serverid = " + serverid);
            UUID uuid = UUID.fromString(serverid);
            UsernameLink answer = new UsernameLink(entropy, uuid);
            LOG.finer("Generated link = " + answer.getLink());
            return answer;
        }
        catch (BaseUsernameException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getAciByUsername(String name) {
        try {
            Username u = new Username(name);
            byte[] hashBytes = u.getHash();
            String hash = Base64.getUrlEncoder().encodeToString(hashBytes);
            LOG.info("search " + name + " with hash " + hash);
            String aciname = this.networkAPI.getAciByUsernameHash(hash);
            System.err.println("GOT aci: " + aciname);
            return aciname;
        }
        catch (BaseUsernameException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private Username tryReserve(List<Username> candidate) {
        String response = this.networkAPI.reserveUsername(candidate);
        if (response.contains("usernameHash")) {
            int idx = response.indexOf(":");
            String val = response.substring(idx + 2, response.length() - 2);
            byte[] d = Base64.getUrlDecoder().decode(val);
            Optional<Username> match = candidate.stream().filter(c -> Arrays.equals(d, c.getHash())).findFirst();
            if (match.isPresent()) {
                LOG.info("Server reserves the username " + String.valueOf(match.get()));
                return match.get();
            }
            LOG.info("No username matches, return null");
            return null;
        }
        return null;
    }
}

