/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.equation.groups.ClientZkOperations;
import io.privacyresearch.equation.groups.GroupsV2Api;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import io.privacyresearch.equation.groups.GroupsV2Operations;
import io.privacyresearch.equation.model.json.KyberPreKeyEntity;
import io.privacyresearch.equation.model.json.OneTimePreKeyCounts;
import io.privacyresearch.equation.model.json.PreKeyEntity;
import io.privacyresearch.equation.model.json.PreKeyState;
import io.privacyresearch.equation.model.json.SignedPreKeyEntity;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.storage.SignalStorageModels;
import io.privacyresearch.equation.storage.SignalStorageRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.thoughtcrime.securesms.groups.GroupsV2Authorization;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.push.ServiceIds;
import org.whispersystems.signalservice.api.storage.SignalStorageCipher;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageCipherKey;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.storage.StorageManifestKey;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.storage.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.ReadOperation;
import org.whispersystems.signalservice.internal.storage.StorageItem;
import org.whispersystems.signalservice.internal.storage.StorageItems;
import org.whispersystems.signalservice.internal.storage.StorageManifest;
import org.whispersystems.signalservice.internal.storage.WriteOperation;

public class AccountManager {
    private final CredentialsProvider credentialsProvider;
    private final GroupsV2Operations groupsV2Operations;
    private GroupsV2Api groupsV2Api;
    private static final Logger LOG = Logger.getLogger(AccountManager.class.getName());
    private final NetworkAPI networkAPI;
    private GroupsV2Authorization groupsV2Authorization;
    private boolean test = false;

    public AccountManager(NetworkConfiguration networkConfig, CredentialsProvider credentialsProvider, NetworkAPI networkApi) {
        this.test = networkConfig.isTestMode();
        LOG.info("Create AccountManager, testmode = " + this.test);
        this.credentialsProvider = credentialsProvider;
        this.networkAPI = networkApi;
        this.groupsV2Operations = new GroupsV2Operations(ClientZkOperations.create(networkConfig), 1000);
        this.groupsV2Api = new GroupsV2Api(networkApi, this.groupsV2Operations);
    }

    public GroupsV2Operations getGroupsV2Operations() {
        return this.groupsV2Operations;
    }

    public GroupsV2Api getGroupsV2Api() {
        return this.groupsV2Api;
    }

    public byte[] getSenderCertificate() throws IOException {
        if (this.test) {
            throw new UnsupportedOperationException();
        }
        return this.networkAPI.getSenderCertificate(this.credentialsProvider);
    }

    private GroupsV2Authorization getGroupsV2Authorization() {
        if (this.groupsV2Authorization == null) {
            this.groupsV2Authorization = new GroupsV2Authorization(this.groupsV2Api);
        }
        return this.groupsV2Authorization;
    }

    public GroupsV2AuthorizationString getAuthorization(GroupSecretParams params) {
        ServiceId.Aci aci = this.credentialsProvider.getAci();
        ServiceId.Pni pni = this.credentialsProvider.getPni();
        ServiceIds serviceIds = new ServiceIds(aci, pni);
        try {
            GroupsV2AuthorizationString answer = this.getGroupsV2Authorization().getAuthorizationForToday(serviceIds, params);
            return answer;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Couldn't get groupsv2AuthString", ex);
        }
        catch (VerificationFailedException ex) {
            LOG.log(Level.SEVERE, "Verification failed while creating groupsv2AuthString", ex);
        }
        return null;
    }

    public String setPreKeys(ServiceId.Kind serviceIdType, IdentityKey identityKey, SignedPreKeyRecord signedPreKey, List<PreKeyRecord> oneTimePreKeys, KyberPreKeyRecord lastResortKyberPreKey, List<KyberPreKeyRecord> kyberPreKeys) throws IOException, InvalidKeyException {
        LOG.info("prepare prekeys to be sent");
        SignedPreKeyEntity spke = new SignedPreKeyEntity(signedPreKey);
        ArrayList<PreKeyEntity> pke = new ArrayList<PreKeyEntity>();
        for (PreKeyRecord preKeyRecord : oneTimePreKeys) {
            pke.add(new PreKeyEntity(preKeyRecord));
        }
        ArrayList<KyberPreKeyEntity> kpke = new ArrayList<KyberPreKeyEntity>();
        for (KyberPreKeyRecord record : kyberPreKeys) {
            kpke.add(new KyberPreKeyEntity(record));
        }
        KyberPreKeyEntity kyberPreKeyEntity = new KyberPreKeyEntity(lastResortKyberPreKey);
        PreKeyState pks = new PreKeyState(spke, pke, kyberPreKeyEntity, kpke);
        this.networkAPI.registerPreKeys(serviceIdType, pks);
        LOG.info("Prekeys registered");
        return "ok";
    }

    public CompletableFuture<OneTimePreKeyCounts> checkOneTyimeKeys() {
        LOG.info("Done startListening, get OTP count now");
        CompletableFuture<OneTimePreKeyCounts> otpk = this.networkAPI.getNumberOfPreKeys(ServiceId.Kind.ACI);
        CompletionStage answer = otpk.whenComplete((result, error) -> {
            if (error != null) {
                LOG.warning("Couldn't get onetimeprekeycounts due to " + String.valueOf(error.getCause()));
                error.getCause().printStackTrace();
            } else {
                LOG.info("#prekeys = " + result.getEcCount() + " and #pqk = " + result.getKyberCount());
            }
        });
        return answer;
    }

    public TurnServerInfo getTurnServerInfo() throws IOException {
        LOG.info("Getting turnserverInfo");
        TurnServerInfo answer = this.networkAPI.getTurnServerInfo();
        LOG.info("Got TurnServerInfo");
        return answer;
    }

    public Optional<SignalStorageManifest> writeStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<SignalStorageRecord> inserts, List<byte[]> deletes) throws IOException, InvalidKeyException {
        return this.writeStorageRecords(storageKey, manifest, inserts, deletes, false);
    }

    private Optional<SignalStorageManifest> writeStorageRecords(StorageKey storageKey, SignalStorageManifest manifest, List<SignalStorageRecord> inserts, List<byte[]> deletes, boolean clearAll) throws IOException, InvalidKeyException {
        ManifestRecord.Builder manifestRecordBuilder = ManifestRecord.newBuilder().setVersion(manifest.getVersion());
        for (StorageId id : manifest.getStorageIds()) {
            ManifestRecord.Identifier idProto = ManifestRecord.Identifier.newBuilder().setRaw(ByteString.copyFrom((byte[])id.getRaw())).setTypeValue(id.getType()).build();
            manifestRecordBuilder.addIdentifiers(idProto);
        }
        String authToken = this.networkAPI.getStorageAuth();
        StorageManifestKey manifestKey = storageKey.deriveManifestKey(manifest.getVersion());
        byte[] encryptedRecord = SignalStorageCipher.encrypt((StorageCipherKey)manifestKey, (byte[])manifestRecordBuilder.build().toByteArray());
        StorageManifest storageManifest = StorageManifest.newBuilder().setVersion(manifest.getVersion()).setValue(ByteString.copyFrom((byte[])encryptedRecord)).build();
        WriteOperation.Builder writeBuilder = WriteOperation.newBuilder().setManifest(storageManifest);
        for (SignalStorageRecord insert : inserts) {
            writeBuilder.addInsertItem(SignalStorageModels.localToRemoteStorageRecord(insert, storageKey, manifest.getIkm()));
        }
        if (clearAll) {
            writeBuilder.setClearAll(true);
        } else {
            for (byte[] delete : deletes) {
                writeBuilder.addDeleteKey(ByteString.copyFrom((byte[])delete));
            }
        }
        StorageItems writeStorageItems = this.networkAPI.getStorageNetworkAPI().writeStorageItems(authToken, writeBuilder.build());
        LOG.info("GOT " + String.valueOf(writeStorageItems));
        return Optional.empty();
    }

    public List<SignalStorageRecord> readStorageRecords(StorageKey storageKey, List<StorageId> storageKeys, byte[] ikm) throws IOException, InvalidKeyException {
        if (storageKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SignalStorageRecord> result = new ArrayList<SignalStorageRecord>();
        HashMap<ByteString, Integer> typeMap = new HashMap<ByteString, Integer>();
        LinkedList<ReadOperation> readOperations = new LinkedList<ReadOperation>();
        ReadOperation.Builder currentOperation = ReadOperation.newBuilder();
        for (StorageId key : storageKeys) {
            typeMap.put(ByteString.copyFrom((byte[])key.getRaw()), key.getType());
            if (currentOperation.getReadKeyCount() >= 500) {
                LOG.info("Going over max read items. Starting a new read operation.");
                readOperations.add(currentOperation.build());
                currentOperation = ReadOperation.newBuilder();
            }
            if (!StorageId.isKnownType((int)key.getType())) continue;
            currentOperation.addReadKey(ByteString.copyFrom((byte[])key.getRaw()));
        }
        if (currentOperation.getReadKeyCount() > 0) {
            readOperations.add(currentOperation.build());
        }
        LOG.info("Reading " + storageKeys.size() + " items split over " + readOperations.size() + " page(s).");
        String authToken = this.networkAPI.getStorageAuth();
        for (ReadOperation readOperation : readOperations) {
            StorageItems items = this.networkAPI.readStorageItems(authToken, readOperation);
            for (StorageItem item : items.getItemsList()) {
                Integer type = (Integer)typeMap.get(item.getKey());
                if (type != null) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Add type = " + type);
                    }
                    result.add(SignalStorageModels.remoteToLocalStorageRecord(item, type, storageKey, ikm));
                    continue;
                }
                LOG.info("No type found! Skipping.");
            }
        }
        return result;
    }
}

