/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal;

import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.internal.LockImpl;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.signal.MessageAnalysisEntry;
import io.privacyresearch.proto.WireProtos;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.metadata.SealedSessionCipher;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.UsePqRatchet;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.crypto.SignalSealedSessionCipher;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class MessageAnalyzer {
    static Logger LOG = Logger.getLogger(MessageAnalyzer.class.getName());
    private final EquationManager equation;
    private final WaveStore aciStore;
    private final List<MessageAnalysisEntry> entries = new LinkedList<MessageAnalysisEntry>();
    private static MessageAnalyzer instance = null;

    public MessageAnalyzer(EquationManager equation) {
        this.equation = equation;
        this.aciStore = equation.getAciStore();
        instance = this;
    }

    public static MessageAnalyzer getInstance() {
        return instance;
    }

    public List<MessageAnalysisEntry> getEntries() {
        LOG.info("Entries asked, return " + this.entries.size() + " entries.");
        return this.entries;
    }

    public void analyze(SignalServiceEnvelope envelope) {
        byte[] content = envelope.getEnvelope().getContent().toByteArray();
        long timestamp = envelope.getTimestamp();
        int envType = envelope.getType();
        int length = content.length;
        LOG.info("Get message with " + content.length + " bytes and type " + envelope.getType() + " and envelope type = " + String.valueOf(envelope.getEnvelope().getType()));
        MessageAnalysisEntry entry = null;
        if (envelope.getType() == 1) {
            entry = new MessageAnalysisEntry(MessageAnalysisEntry.Direction.INCOMING, timestamp, false, envType, length, envelope.getSourceIdentifier(), envelope.getSourceDevice(), 0);
        } else if (envelope.getType() == 6) {
            UnidentifiedSenderMessageContent usmc = this.processSealedSenderMessage(envelope.getEnvelope());
            SenderCertificate sCert = usmc.getSenderCertificate();
            int pqSize = 0;
            LOG.info("unidentified sender, type = " + usmc.getType());
            if (usmc.getType() == 2) {
                byte[] sc = usmc.getContent();
                byte[] mc = new byte[sc.length - 9];
                System.arraycopy(sc, 1, mc, 0, mc.length);
                try {
                    WireProtos.SignalMessage signalMessage = WireProtos.SignalMessage.parseFrom((byte[])mc);
                    if (signalMessage.hasPqRatchet()) {
                        pqSize = signalMessage.getPqRatchet().size();
                        LOG.info("PQRatchetsize = " + pqSize);
                    }
                    if (signalMessage.hasRatchetKey()) {
                        LOG.info("Ratchetkeysize = " + signalMessage.getRatchetKey().size());
                    }
                }
                catch (InvalidProtocolBufferException ex) {
                    System.getLogger(MessageAnalyzer.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
                }
            }
            entry = new MessageAnalysisEntry(MessageAnalysisEntry.Direction.INCOMING, timestamp, true, usmc.getType(), length, sCert.getSenderUuid(), sCert.getSenderDeviceId(), pqSize);
        } else {
            entry = new MessageAnalysisEntry(MessageAnalysisEntry.Direction.INCOMING, timestamp, false, envType, length, "unknown", 0, 0);
        }
        this.addEntry(entry);
    }

    public void addEntry(MessageAnalysisEntry entry) {
        this.entries.add(entry);
        MessagingClient waveClient = this.equation.getWaveClient();
        if (waveClient != null) {
            waveClient.gotMessageAnalysisEntry(entry);
        }
    }

    public boolean hasPqRatchet(SignalServiceEnvelope envelope) {
        LOG.info("Check pqratchet for envelope with type " + String.valueOf(envelope));
        boolean answer = false;
        try {
            byte[] content = envelope.getEnvelope().getContent().toByteArray();
            SealedSessionCipher ssc = new SealedSessionCipher((SignalProtocolStore)this.aciStore, UUID.fromString(this.aciStore.getMyUuid()), null, 0);
            long pointer = Native.SealedSessionCipher_DecryptToUsmc((byte[])content, (IdentityKeyStore)this.aciStore);
            UnidentifiedSenderMessageContent usmc = new UnidentifiedSenderMessageContent(pointer);
            byte[] sc = usmc.getContent();
            LOG.info("type = " + usmc.getType() + " and version? " + sc[0]);
            byte[] mc = new byte[sc.length - 9];
            System.arraycopy(sc, 1, mc, 0, mc.length);
            WireProtos.SignalMessage signalMessage = WireProtos.SignalMessage.parseFrom((byte[])mc);
            answer = signalMessage.hasPqRatchet();
            LOG.info("USMCS, has ratchet = " + answer);
        }
        catch (Throwable t) {
            LOG.info("Not a valid signalMessage, envelope type = " + envelope.getType());
            t.printStackTrace();
        }
        return answer;
    }

    UnidentifiedSenderMessageContent processSealedSenderMessage(SignalServiceProtos.Envelope envelope) {
        try {
            UsePqRatchet usePqRatchet = UsePqRatchet.YES;
            LockImpl sessionLock = new LockImpl();
            SignalServiceAddress localAddress = this.equation.getLocalAddress();
            int localDeviceId = this.equation.getLocalDeviceId();
            SignalSealedSessionCipher sealedSessionCipher = new SignalSealedSessionCipher((SignalSessionLock)sessionLock, new SealedSessionCipher((SignalProtocolStore)this.equation.getWaveStore(), localAddress.getServiceId().getRawUUID(), (String)localAddress.getNumber().orElse(null), localDeviceId), usePqRatchet);
            long pointer = Native.SealedSessionCipher_DecryptToUsmc((byte[])envelope.getContent().toByteArray(), (IdentityKeyStore)this.aciStore);
            UnidentifiedSenderMessageContent usmc = new UnidentifiedSenderMessageContent(pointer);
            return usmc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

