/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.registration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.gluonhq.snl.Response;
import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.keyvalue.AccountStorage;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.internal.KeyUtil;
import io.privacyresearch.equation.model.RegistrationException;
import io.privacyresearch.equation.model.RegistrationResponse;
import io.privacyresearch.equation.model.json.AccountAttributes;
import io.privacyresearch.equation.model.json.AccountIdentityResponse;
import io.privacyresearch.equation.model.json.Device;
import io.privacyresearch.equation.model.json.DeviceActivationRequest;
import io.privacyresearch.equation.model.json.ECSignedPreKey;
import io.privacyresearch.equation.model.json.KEMSignedPreKey;
import io.privacyresearch.equation.model.json.RegistrationRequest;
import io.privacyresearch.equation.model.json.UpdateVerificationSessionRequest;
import io.privacyresearch.equation.model.json.VerificationSessionResponse;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.UserRecord;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.storage.AccountRecord;

public class AccountRegistration {
    private static final Logger LOG = Logger.getLogger(AccountRegistration.class.getName());
    private final String serverAddress;
    private final SignalBridge signalBridge;
    private final ObjectMapper mapper;
    private final EquationManager waveManager;
    private String number;
    private WaveStore aciStore;
    private String sessionId;
    private final SqliteStorageBean sqliteStorageBean;

    public AccountRegistration(EquationManager waveManager, SqliteStorageBean sqliteStorageBean) {
        this.waveManager = waveManager;
        this.signalBridge = waveManager.getSignalBridge();
        this.serverAddress = this.signalBridge.getServerAddress();
        LOG.info("We will talk to URL " + this.serverAddress);
        this.sqliteStorageBean = sqliteStorageBean;
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public RegistrationResponse registerAccount(String number, String token, String transport, WaveStore aciStore) {
        try {
            this.number = number;
            this.aciStore = aciStore;
            LOG.info("We will verify a registration token with nr = " + number + " using " + transport);
            LOG.finer("and token = " + token);
            String sessionId = this.createSession(number);
            this.addCaptchTokenToSession(token);
            RegistrationResponse response = this.requestCode(transport);
            return response;
        }
        catch (RegistrationException ex) {
            LOG.info("Got error " + ex.getCode() + " during registration: " + ex.getMessage());
            return new RegistrationResponse(ex.getMessage(), ex.getCode());
        }
        catch (IOException | URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new RegistrationResponse(ex.getMessage(), 600);
        }
    }

    public RegistrationResponse submitCode(String code) {
        try {
            LOG.info("We will verify this code");
            if (!this.verifyCode(this.sessionId, code)) {
                return new RegistrationResponse("Code not accepted", 601);
            }
            LOG.info("Code verified, now create account");
            this.createAccount(this.sessionId);
            LOG.info("Account created, return");
            return new RegistrationResponse("", 200);
        }
        catch (RegistrationException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new RegistrationResponse(ex.getMessage(), ex.getCode());
        }
        catch (IOException | URISyntaxException | SQLException | InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return new RegistrationResponse(ex.getMessage(), 600);
        }
    }

    public String createSession(String number) throws IOException, URISyntaxException, RegistrationException {
        String response;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        requestBuilder.header("Content-Type", "application/json");
        String payload = "{\"number\":\"" + number + "\"}";
        LOG.finer("Payload = " + payload);
        requestBuilder.method("POST", HttpRequest.BodyPublishers.ofString(payload));
        URI uri = new URI(this.serverAddress + "/v1/verification/session");
        requestBuilder.uri(uri);
        HttpRequest request = requestBuilder.build();
        LOG.finer("Headers = " + String.valueOf(request.headers()));
        Response resp = this.sendRequest(request, payload.getBytes(StandardCharsets.UTF_8));
        String string = response = resp.body() == null ? null : resp.body().string();
        if (resp.getStatusCode() != 200) {
            LOG.warning("Creating session failed, statusCode = " + resp.getStatusCode() + " and content = " + response);
            throw new RegistrationException(resp.getStatusCode(), response);
        }
        VerificationSessionResponse vsr = (VerificationSessionResponse)this.mapper.readValue(response, VerificationSessionResponse.class);
        LOG.info("registerresponse = " + response + " and statusCode = " + resp.getStatusCode());
        this.sessionId = vsr.getId();
        return this.sessionId;
    }

    void addCaptchTokenToSession(String token) throws URISyntaxException, IOException, RegistrationException {
        String response2;
        LOG.info("Add captchatoken to session");
        HttpRequest.Builder requestBuilder2 = HttpRequest.newBuilder();
        requestBuilder2.header("Content-Type", "application/json");
        URI uri2 = new URI(this.serverAddress + "/v1/verification/session/" + this.sessionId);
        requestBuilder2.uri(uri2);
        UpdateVerificationSessionRequest uvsr = new UpdateVerificationSessionRequest(null, null, null, token, null, null);
        LOG.finer("uvsr = " + String.valueOf(uvsr));
        StringWriter payloadWriter2 = new StringWriter();
        this.mapper.writeValue((Writer)payloadWriter2, (Object)uvsr);
        String payload2 = payloadWriter2.toString();
        payload2 = payload2.replaceFirst("challenge", "registration");
        LOG.finer("payload2 = " + payload2);
        requestBuilder2.method("PATCH", HttpRequest.BodyPublishers.ofString(payload2));
        HttpRequest request2 = requestBuilder2.build();
        Response resp2 = this.sendRequest(request2, payload2.getBytes(StandardCharsets.UTF_8));
        String string = response2 = resp2.body() == null ? null : resp2.body().string();
        if (resp2.getStatusCode() != 200) {
            throw new RegistrationException(resp2.getStatusCode(), response2);
        }
        LOG.info("registerresponse2 = " + response2 + " and statusCode = " + resp2.getStatusCode());
    }

    public RegistrationResponse requestCode(String transport) throws URISyntaxException, IOException {
        String payload = "{\"client\":\"ios\",\"transport\":\"" + transport + "\"}";
        LOG.info("We will now request a code, with payload " + payload);
        URI uri = new URI(this.serverAddress + "/v1/verification/session/" + this.sessionId + "/code");
        HttpRequest.Builder requestBuilder = this.createHttpRequestBuilder(uri);
        Locale locale = Locale.getDefault();
        requestBuilder.header("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
        requestBuilder.method("POST", HttpRequest.BodyPublishers.ofString(payload));
        Response resp = this.sendRequest(requestBuilder.build(), payload.getBytes(StandardCharsets.UTF_8));
        String response = resp.body() == null ? null : resp.body().string();
        LOG.info("registerresponse3 = " + response + " and statusCode = " + resp.getStatusCode());
        return new RegistrationResponse(response, resp.getStatusCode());
    }

    public boolean verifyCode(String sessionId, String code) throws URISyntaxException, IOException, RegistrationException {
        String payload = "{\"code\":\"" + code + "\"}";
        LOG.info("Payload = " + payload);
        URI uri = new URI(this.serverAddress + "/v1/verification/session/" + sessionId + "/code");
        HttpRequest.Builder requestBuilder = this.createHttpRequestBuilder(uri);
        requestBuilder.method("PUT", HttpRequest.BodyPublishers.ofString(payload));
        Response resp = this.sendRequest(requestBuilder.build(), payload.getBytes(StandardCharsets.UTF_8));
        String rawResponse = resp == null ? null : resp.body().string();
        LOG.info("registerresponse = " + rawResponse + " and statusCode = " + resp.getStatusCode());
        if (resp.getStatusCode() != 200) {
            throw new RegistrationException(resp.getStatusCode(), rawResponse);
        }
        VerificationSessionResponse response = (VerificationSessionResponse)this.mapper.readValue(rawResponse, VerificationSessionResponse.class);
        return response.isVerified();
    }

    public void createAccount(String sessionId) throws IOException, URISyntaxException, SQLException, RegistrationException, InvalidKeyException {
        byte[] b = new byte[16];
        new SecureRandom().nextBytes(b);
        String password = new String(b, StandardCharsets.UTF_8);
        password = Base64.getEncoder().encodeToString(password.getBytes());
        password = password.substring(0, password.length() - 2);
        AccountStorage storage = this.sqliteStorageBean.account();
        storage.setE164(this.number);
        String registrationId = storage.getRegistrationId();
        String pniRegistrationId = storage.getPniRegistrationId();
        LOG.info("regid = " + registrationId + " and pniRegid = " + pniRegistrationId);
        IdentityKeyPair aciKeyPair = storage.getAciIdentityKey();
        SignedPreKeyRecord aciPreKeyRecord = KeyUtil.generateSignedPreKey(aciKeyPair.getPrivateKey());
        ECSignedPreKey aciSignedPreKey = new ECSignedPreKey(aciPreKeyRecord.getId(), aciPreKeyRecord.getKeyPair().getPublicKey(), aciPreKeyRecord.getSignature());
        IdentityKeyPair pniKeyPair = storage.getPniIdentityKey();
        SignedPreKeyRecord pniPreKeyRecord = KeyUtil.generateSignedPreKey(pniKeyPair.getPrivateKey());
        ECSignedPreKey pniSignedPreKey = new ECSignedPreKey(pniPreKeyRecord.getId(), pniPreKeyRecord.getKeyPair().getPublicKey(), pniPreKeyRecord.getSignature());
        KyberPreKeyRecord aciKyberPreKeyRecord = KeyUtil.generateKyberPreKey(aciKeyPair.getPrivateKey());
        KEMSignedPreKey aciKemSignedPreKey = new KEMSignedPreKey(aciKyberPreKeyRecord.getId(), aciKyberPreKeyRecord.getKeyPair().getPublicKey(), aciKyberPreKeyRecord.getSignature());
        KyberPreKeyRecord pniKyberPreKeyRecord = KeyUtil.generateKyberPreKey(pniKeyPair.getPrivateKey());
        KEMSignedPreKey pniKemSignedPreKey = new KEMSignedPreKey(pniKyberPreKeyRecord.getId(), pniKyberPreKeyRecord.getKeyPair().getPublicKey(), pniKyberPreKeyRecord.getSignature());
        Device.DeviceCapabilities dcap = new Device.DeviceCapabilities(true, true, true, true);
        AccountAttributes attributes = new AccountAttributes();
        attributes.setCapabilities(dcap);
        attributes.setRegistrationId(Integer.parseInt(registrationId));
        attributes.setPniRegistrationId(Integer.parseInt(pniRegistrationId));
        ECPublicKey publicKey = aciPreKeyRecord.getKeyPair().getPublicKey();
        DeviceActivationRequest dar = new DeviceActivationRequest(aciSignedPreKey, pniSignedPreKey, aciKemSignedPreKey, pniKemSignedPreKey);
        RegistrationRequest request = new RegistrationRequest();
        request.setSessionId(sessionId);
        request.setAccountAttributes(attributes);
        request.setSkipDeviceTransfer(true);
        request.setAciIdentityKey(storage.getAciIdentityKey().getPublicKey());
        request.setPniIdentityKey(storage.getPniIdentityKey().getPublicKey());
        request.setDeviceActivationRequest(dar);
        StringWriter payloadWriter = new StringWriter();
        this.mapper.writeValue((Writer)payloadWriter, (Object)request);
        String payload = payloadWriter.toString();
        LOG.finer("Every key valid? " + request.isEverySignedKeyValid());
        LOG.info("Payload = " + payload);
        URI uri = new URI(this.serverAddress + "/v1/registration");
        HttpRequest.Builder requestBuilder = this.createHttpRequestBuilder(uri);
        String authorizationHeader = this.getAuthorizationHeader(this.aciStore.getCredentialsProvider());
        LOG.info("Authheader = " + authorizationHeader);
        requestBuilder.header("Authorization", authorizationHeader);
        requestBuilder.method("POST", HttpRequest.BodyPublishers.ofString(payload));
        Response resp = this.sendRequest(requestBuilder.build(), payload.getBytes(StandardCharsets.UTF_8));
        String response = resp == null ? null : resp.body().string();
        LOG.info("response = " + response + " and statusCode = " + resp.getStatusCode());
        if (resp.getStatusCode() != 200) {
            throw new RegistrationException(resp.getStatusCode(), response);
        }
        AccountIdentityResponse accountIdentity = (AccountIdentityResponse)this.mapper.readValue(response, AccountIdentityResponse.class);
        UserRecord userRecord = this.createEquationAccount(accountIdentity);
        ServiceId.Aci aci = userRecord.aci();
        ServiceId.Pni pni = userRecord.pni();
        this.sqliteStorageBean.getSignedPreKeyData().add((ServiceId)aci, aciPreKeyRecord);
        this.sqliteStorageBean.getSignedPreKeyData().add((ServiceId)pni, pniPreKeyRecord);
        this.sqliteStorageBean.getKyberPreKeyData().add((ServiceId)aci, aciKyberPreKeyRecord.getId(), aciKyberPreKeyRecord, true);
        this.sqliteStorageBean.getKyberPreKeyData().add((ServiceId)pni, pniKyberPreKeyRecord.getId(), pniKyberPreKeyRecord, true);
    }

    public UserRecord createEquationAccount(AccountIdentityResponse accountIdentity) {
        ServiceId.Aci aci = new ServiceId.Aci(accountIdentity.getUuid());
        ServiceId.Pni pni = new ServiceId.Pni(accountIdentity.getPni());
        String retNumber = accountIdentity.getNumber();
        byte[] storageIdBytes = new byte[32];
        new SecureRandom().nextBytes(storageIdBytes);
        StorageId storageId = StorageId.forAccount((byte[])storageIdBytes);
        byte[] pkBytes = new byte[32];
        new SecureRandom().nextBytes(pkBytes);
        AccountRecord accountRecord = AccountRecord.newBuilder().setGivenName("you").setProfileKey(ByteString.copyFrom((byte[])pkBytes)).build();
        UserRecord user = this.waveManager.getUserService().createAccount(aci, pni, retNumber, storageId, accountRecord);
        AccountStorage accountStorage = this.sqliteStorageBean.account();
        accountStorage.setAci(aci);
        accountStorage.setPni(pni);
        accountStorage.setE164(retNumber);
        return user;
    }

    private HttpRequest.Builder createHttpRequestBuilder(URI uri) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        requestBuilder.header("Content-Type", "application/json");
        requestBuilder.uri(uri);
        return requestBuilder;
    }

    public Response sendRequest(HttpRequest request, byte[] payload) throws IOException {
        LOG.info("Sending a " + request.method() + " request to " + String.valueOf(request.uri()));
        return this.signalBridge.sendRequest(request, payload);
    }

    private String getAuthorizationHeader(CredentialsProvider credentialsProvider) {
        Object identifier = credentialsProvider.getE164();
        if (credentialsProvider.getDeviceId() != 1) {
            identifier = (String)identifier + "." + credentialsProvider.getDeviceId();
        }
        LOG.info("Number from store = " + (String)identifier + " and we will use " + this.number);
        identifier = this.number;
        return "Basic " + Base64.getEncoder().encodeToString(((String)identifier + ":" + credentialsProvider.getPassword()).getBytes(StandardCharsets.UTF_8));
    }
}

