/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.proxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.proxy.QuicServerTransport;
import io.privacyresearch.equation.proxy.WebSocketBridge;
import io.privacyresearch.equation.proxy.WebSocketBridgeFactory;
import io.privacyresearch.equation.proxystub.SignalRpcMessage;
import io.privacyresearch.equation.proxystub.SignalRpcReply;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignalWebSocketBridge
implements WebSocketBridge {
    private final WebSocket websocket;
    private final String uriString;
    private final QuicServerTransport.PWaveApplicationProtocolConnection pwave;
    private boolean connected = false;
    private boolean destroyed = false;
    private static final Logger LOG = Logger.getLogger(SignalWebSocketBridge.class.getName());
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public SignalWebSocketBridge(QuicServerTransport.PWaveApplicationProtocolConnection p, String uriString, Map<String, String> headers, Consumer<byte[]> messageCallback) {
        this.pwave = p;
        this.uriString = uriString;
        SignalWebSocketListener swsl = new SignalWebSocketListener(this, messageCallback);
        this.websocket = this.createWebSocket(uriString, headers, swsl);
        LOG.info("Created " + String.valueOf(this));
    }

    @Override
    public void sendData(byte[] payload) {
        LOG.finer("Received from Quic Endpoint, Sending data to Signal WebSocket " + String.valueOf(this));
        try {
            SignalRpcMessage message = SignalRpcMessage.parseFrom(payload);
            byte[] orig = message.getBody().toByteArray();
            byte[] processed = this.processIncomingClientData(orig);
            LOG.info("Received QUIC LEN = " + orig.length + ", send WS length = " + processed.length);
            this.websocket.sendBinary(ByteBuffer.wrap(processed), true);
        }
        catch (InvalidProtocolBufferException ex) {
            ex.printStackTrace();
            LOG.log(Level.SEVERE, "SHOULD NEVER HAPPEN! EXAMINE THIS", ex);
        }
        LOG.fine("Done sending data to Signal WebSocket " + String.valueOf(this));
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void close() {
        LOG.info("We're asked to close " + String.valueOf(this));
        this.websocket.abort();
        this.connected = false;
    }

    private byte[] processIncomingClientData(byte[] orig) throws InvalidProtocolBufferException {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    private WebSocket createWebSocket(String uriString, Map<String, String> headers, WebSocket.Listener listener) {
        HttpClient client = HttpClient.newBuilder().build();
        URI uri = URI.create(uriString);
        WebSocket.Builder wsBuilder = client.newWebSocketBuilder();
        headers.forEach((k, v) -> {
            if (k.toLowerCase().startsWith("x-signal")) {
                wsBuilder.header((String)k, (String)v);
            }
        });
        CompletableFuture<WebSocket> buildAsync = wsBuilder.buildAsync(uri, listener);
        WebSocket webSocket = buildAsync.join();
        this.connected = true;
        LOG.info("websocket built for " + String.valueOf(this));
        Thread t = new Thread("keepalive"){

            @Override
            public void run() {
                while (SignalWebSocketBridge.this.connected) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Throwable t) {
                        LOG.severe("LET ME KNOW WHEN THIS HAPPENS");
                        t.printStackTrace();
                    }
                    SignalWebSocketBridge.this.sendKeepAlive();
                }
            }
        };
        t.start();
        return webSocket;
    }

    void sendKeepAlive() {
        long id = System.currentTimeMillis();
        byte[] id128 = this.longToBase128(id);
        byte[] part1 = new byte[]{8, 1, 18, 27, 10, 3, 71, 69, 84, 18, 13, 47, 118, 49, 47, 107, 101, 101, 112, 97, 108, 105, 118, 101, 32};
        ByteBuffer buffer = ByteBuffer.allocate(part1.length + id128.length);
        buffer.put(part1);
        buffer.put(id128);
        buffer.flip();
        LOG.fine("Sending keepalive");
        this.websocket.sendBinary(buffer, true);
    }

    private byte[] longToBase128(long number) {
        byte[] work = new byte[10];
        int pos = 0;
        while ((number & 0xFFFFFFFFFFFFFF80L) != 0L) {
            work[pos] = (byte)(number & 0x7FL | 0x80L);
            number >>>= 7;
            ++pos;
        }
        work[pos] = (byte)number;
        byte[] answer = new byte[pos + 1];
        System.arraycopy(work, 0, answer, 0, pos + 1);
        return answer;
    }

    private long base128ToLong(byte[] byteArray) {
        long number = 0L;
        for (int i = 0; i < byteArray.length; ++i) {
            byte b = byteArray[i];
            number <<= 7;
            number |= (long)b & 0x7FL;
            if (((long)b & 0x80L) == 0L) break;
        }
        return number;
    }

    public static String toJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOG.severe("can't convert " + String.valueOf(object) + " to json ");
            e.printStackTrace();
            return "";
        }
    }

    public String toString() {
        return "SWS@" + Objects.hashCode(this) + " with baseUrl KWAAAK and qc = " + this.pwave.getConnectionInfo();
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    static class SignalWebSocketListener
    implements WebSocket.Listener {
        private final Consumer<byte[]> messageCallback;
        private final SignalWebSocketBridge sws;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public SignalWebSocketListener(SignalWebSocketBridge sws, Consumer<byte[]> cb) {
            this.messageCallback = cb;
            this.sws = sws;
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            LOG.info("WS got err: " + String.valueOf(error));
            LOG.info("This should never happen.");
            error.printStackTrace();
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            LOG.info("WS Got close for " + String.valueOf(this.sws) + " with statusCode " + statusCode + " and reason = " + reason);
            this.sws.destroyed = true;
            Thread.dumpStack();
            return null;
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            LOG.finest(" WS got binary data for " + String.valueOf(webSocket));
            webSocket.request(1L);
            byte[] buff = new byte[data.remaining()];
            data.get(buff);
            try {
                this.baos.write(buff);
                if (last) {
                    byte[] completed = this.baos.toByteArray();
                    this.baos = new ByteArrayOutputStream();
                    LOG.info("WS got binary data for a total size from external WS message = " + completed.length);
                    ByteString bytestring = ByteString.copyFrom((byte[])completed);
                    SignalRpcReply reply = SignalRpcReply.newBuilder().setMessage(bytestring).build();
                    this.messageCallback.accept(reply.toByteArray());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                LOG.log(Level.SEVERE, "error in receiving ws data", t);
            }
            LOG.finest(" WS passed binary data for " + String.valueOf(webSocket));
            return null;
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            LOG.info("WS Got text");
            webSocket.request(1L);
            return null;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            LOG.info("WS Got Open!");
            webSocket.request(1L);
        }
    }

    public static class SignalWebSocketBridgeFactory
    implements WebSocketBridgeFactory {
        @Override
        public WebSocketBridge createWebSocketBridge(QuicServerTransport.PWaveApplicationProtocolConnection p, String uriString, Map<String, String> headers, Consumer<byte[]> messageCallback) {
            return new SignalWebSocketBridge(p, uriString, headers, messageCallback);
        }
    }
}

