/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.signal.core.util.StreamUtil;
import org.signal.libsignal.crypto.Aes256GcmDecryption;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;

public class ProfileCipherInputStream
extends FilterInputStream {
    private Aes256GcmDecryption aes;
    private byte[] buffer = new byte[16];
    private byte[] swapBuffer = new byte[16];

    public ProfileCipherInputStream(InputStream in, ProfileKey key) throws IOException {
        super(in);
        try {
            byte[] nonce = new byte[12];
            StreamUtil.readFully(in, nonce);
            StreamUtil.readFully(in, this.buffer);
            this.aes = new Aes256GcmDecryption(key.serialize(), nonce, new byte[0]);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() {
        throw new AssertionError((Object)"Not supported!");
    }

    @Override
    public int read(byte[] input) throws IOException {
        return this.read(input, 0, input.length);
    }

    @Override
    public int read(byte[] output, int outputOffset, int outputLength) throws IOException {
        if (this.aes == null) {
            return -1;
        }
        int read = this.in.read(output, outputOffset, outputLength);
        if (read == -1) {
            Aes256GcmDecryption aes = this.aes;
            this.aes = null;
            if (!aes.verifyTag(this.buffer)) {
                throw new IOException("authentication of decrypted data failed");
            }
            return -1;
        }
        if (read < 16) {
            System.arraycopy(this.buffer, read, this.swapBuffer, 0, 16 - read);
            System.arraycopy(output, outputOffset, this.swapBuffer, 16 - read, read);
            System.arraycopy(this.buffer, 0, output, outputOffset, read);
        } else if (read == 16) {
            System.arraycopy(output, outputOffset, this.swapBuffer, 0, read);
            System.arraycopy(this.buffer, 0, output, outputOffset, read);
        } else {
            System.arraycopy(output, outputOffset + read - 16, this.swapBuffer, 0, 16);
            System.arraycopy(output, outputOffset, output, outputOffset + 16, read - 16);
            System.arraycopy(this.buffer, 0, output, outputOffset, 16);
        }
        byte[] temp = this.buffer;
        this.buffer = this.swapBuffer;
        this.swapBuffer = temp;
        this.aes.decrypt(output, outputOffset, read);
        return read;
    }
}

