/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Base64;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.whispersystems.signalservice.api.crypto.Curve;

public class PreKeyEntity {
    @JsonProperty
    private int keyId;
    @JsonProperty
    @JsonSerialize(using=ECPublicKeySerializer.class)
    @JsonDeserialize(using=ECPublicKeyDeserializer.class)
    private ECPublicKey publicKey;

    public PreKeyEntity() {
    }

    public PreKeyEntity(int keyId, ECPublicKey publicKey) {
        this.keyId = keyId;
        this.publicKey = publicKey;
    }

    public PreKeyEntity(PreKeyRecord record) throws InvalidKeyException {
        this(record.getId(), record.getKeyPair().getPublicKey());
    }

    public int getKeyId() {
        return this.keyId;
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    private static class ECPublicKeyDeserializer
    extends JsonDeserializer<ECPublicKey> {
        private ECPublicKeyDeserializer() {
        }

        public ECPublicKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return Curve.decodePoint((byte[])Base64.getDecoder().decode(p.getValueAsString()), (int)0);
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
        }
    }

    private static class ECPublicKeySerializer
    extends JsonSerializer<ECPublicKey> {
        private ECPublicKeySerializer() {
        }

        public void serialize(ECPublicKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.getEncoder().withoutPadding().encodeToString(value.serialize()));
        }
    }
}

