/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

public class StoryDistributionList {
    private final String name;
    private final UUID identifier;
    private List<String> recipients;

    public StoryDistributionList(String name, byte[] uuidb, List<String> recipients) {
        this.name = name;
        this.identifier = StoryDistributionList.bytesToUuid(uuidb);
        this.recipients = recipients;
    }

    public StoryDistributionList(String name, String id) {
        this.name = name;
        this.identifier = UUID.fromString(id);
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public String getName() {
        return this.name;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public List<String> getRecipientUuids() {
        return this.recipients;
    }

    static final UUID bytesToUuid(byte[] b) {
        ByteBuffer wrap = ByteBuffer.wrap(b);
        long hi = wrap.getLong();
        long lo = wrap.getLong();
        return new UUID(hi, lo);
    }
}

