/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

import io.privacyresearch.clientdata.distributionlist.DistributionListDbRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.model.StoryDistributionList;
import io.privacyresearch.equation.user.UserRecord;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.whispersystems.signalservice.api.messages.SignalServiceTextAttachment;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class Story {
    private static final Logger LOG = Logger.getLogger(Story.class.getName());
    private MessageKey messageKey;
    private long timestamp;
    private long expiration;
    private UserRecord author;
    private Optional<GroupRecord> group = Optional.empty();
    private Optional<DistributionListDbRecord> distributionList = Optional.empty();
    private Optional<String> authorId = Optional.empty();
    private Optional<String> groupId = Optional.empty();
    private List<String> distributionListId = new LinkedList<String>();
    private List<StoryDistributionList> storyDistributionList = new LinkedList<StoryDistributionList>();
    private Optional<TextStory> textStory = Optional.empty();
    private Optional<FileStory> fileStory = Optional.empty();

    public UserRecord getAuthor() {
        return this.author;
    }

    public void setAuthor(UserRecord author) {
        this.author = author;
    }

    public void setDistributionListId(List<String> listId) {
        if (listId == null) {
            listId = List.of();
        }
        this.distributionListId = listId;
    }

    public List<String> getDistributionListId() {
        return this.distributionListId;
    }

    public void setDistributionList(List<StoryDistributionList> l) {
        this.storyDistributionList = l;
    }

    public List<StoryDistributionList> getDistributionList() {
        return this.storyDistributionList;
    }

    public void setFileStory(FileStory t) {
        this.fileStory = Optional.of(t);
    }

    public void setTextStory(TextStory t) {
        this.textStory = Optional.of(t);
    }

    public void setExpiration(long exp) {
        this.expiration = exp;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setTimestamp(long exp) {
        this.timestamp = exp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public MessageKey getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(MessageKey messageKey) {
        this.messageKey = messageKey;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiration;
    }

    public void setDistributionList(DistributionListDbRecord distributionList) {
        this.distributionList = Optional.of(distributionList);
    }

    public Optional<DistributionListDbRecord> distributionList() {
        return this.distributionList;
    }

    public void setGroup(GroupRecord group) {
        this.group = Optional.of(group);
    }

    public Optional<GroupRecord> group() {
        return this.group;
    }

    public Optional<String> groupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = Optional.of(groupId);
    }

    public void setGroupIdentifier(GroupIdentifier groupIdentifier) {
        this.groupId = Optional.of(this.encode(groupIdentifier.serialize()));
    }

    public Optional<String> authorId() {
        return this.authorId;
    }

    public Optional<TextStory> textStory() {
        return this.textStory;
    }

    public Optional<FileStory> fileStory() {
        return this.fileStory;
    }

    public RecipientKey getRecipientKey() {
        if (this.group.isPresent()) {
            return this.group.get().recipient().key();
        }
        return this.author.recipient().key();
    }

    private String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static enum Style {
        DEFAULT,
        REGULAR,
        BOLD,
        SERIF,
        SCRIPT,
        CONDENSED;

    }

    public static class Gradient {
        private final Optional<Integer> angle;
        private final List<Integer> colors;
        private final List<Float> positions;

        public Gradient(Optional<Integer> angle, List<Integer> colors, List<Float> positions) {
            this.angle = angle;
            this.colors = colors;
            this.positions = positions;
        }

        public Gradient(SignalServiceProtos.TextAttachment.Gradient g) {
            this.angle = Optional.of(g.getAngle());
            this.colors = g.getColorsList();
            this.positions = g.getPositionsList();
        }

        public Gradient(SignalServiceTextAttachment.Gradient g) {
            this.angle = g.getAngle();
            this.colors = g.getColors();
            this.positions = g.getPositions();
        }

        public Optional<Integer> getAngle() {
            return this.angle;
        }

        public List<Integer> getColors() {
            return this.colors;
        }

        public List<Float> getPositions() {
            return this.positions;
        }
    }

    public static class TextStory {
        private Optional<String> text;
        private Optional<Integer> backgroundColor = Optional.of(-1);
        private Optional<Integer> textBackgroundColor = Optional.of(-1);
        private Optional<Integer> textForegroundColor = Optional.of(-1);
        private Optional<Gradient> backgroundGradient = Optional.empty();
        private Optional<Style> style = Optional.of(Style.REGULAR);

        public Optional<Integer> getBackgroundColor() {
            return this.backgroundColor;
        }

        public Optional<Gradient> getBackgroundGradient() {
            return this.backgroundGradient;
        }

        public Optional<Integer> getTextBackgroundColor() {
            return this.textBackgroundColor;
        }

        public Optional<Integer> getTextForegroundColor() {
            return this.textForegroundColor;
        }

        @Deprecated
        public TextStory(int backgroundColor, Integer textBackgroundColor, Integer textForegroundColor, Integer style, String txt) {
            this(backgroundColor, null, textBackgroundColor, textForegroundColor, style, txt);
        }

        public TextStory(int backgroundColor, Gradient gradient, Integer textBackgroundColor, Integer textForegroundColor, Integer style, String txt) {
            this.backgroundColor = Optional.of(backgroundColor);
            this.backgroundGradient = Optional.ofNullable(gradient);
            this.textBackgroundColor = Optional.ofNullable(textBackgroundColor);
            this.textForegroundColor = Optional.ofNullable(textForegroundColor);
            this.style = Optional.of(Style.values()[style]);
            this.text = Optional.of(txt);
        }

        public TextStory(SignalServiceProtos.TextAttachment ssta) {
            this.text = Optional.of(ssta.getText());
            this.backgroundColor = Optional.of(ssta.getColor());
            this.textBackgroundColor = Optional.of(ssta.getTextBackgroundColor());
            this.textForegroundColor = Optional.of(ssta.getTextForegroundColor());
            Optional<SignalServiceProtos.TextAttachment.Gradient> gradient = Optional.ofNullable(ssta.getGradient());
            if (gradient.isPresent()) {
                this.backgroundGradient = Optional.of(new Gradient(gradient.get()));
            }
            if (ssta.hasTextStyle()) {
                int ordinal = ssta.getTextStyle().ordinal();
                this.style = Optional.of(Style.values()[ordinal]);
            }
        }

        public TextStory(SignalServiceTextAttachment ssta) {
            this.text = ssta.getText();
            this.backgroundColor = ssta.getBackgroundColor();
            this.textBackgroundColor = ssta.getTextBackgroundColor();
            this.textForegroundColor = ssta.getTextForegroundColor();
            Optional gradient = ssta.getBackgroundGradient();
            if (gradient.isPresent()) {
                this.backgroundGradient = Optional.of(new Gradient((SignalServiceTextAttachment.Gradient)gradient.get()));
            }
            ssta.getStyle().ifPresent(style -> {
                this.style = Optional.of(Style.values()[style.ordinal()]);
            });
        }

        public TextStory(Optional<String> text) {
            this.text = text;
        }

        public void setBackgroundGradient(Optional<Gradient> gradient) {
            this.backgroundGradient = gradient;
        }

        public Optional<String> getText() {
            return this.text;
        }

        public Optional<Style> getStyle() {
            return this.style;
        }
    }

    public static class FileStory {
        private String contentType;
        private Path destination;
        private Path media;
        private Optional<String> caption;

        public FileStory(Path destination, String contentType, Optional<String> caption) {
            this.contentType = contentType;
            this.destination = destination;
            this.caption = caption;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Path getDestination() {
            return this.destination;
        }

        public void setMedia(Path p) {
            this.media = p;
        }

        public Path getMedia() {
            if (this.media != null) {
                return this.media;
            }
            try {
                this.media = Files.list(this.destination).filter(path -> {
                    try {
                        return Files.isRegularFile(path, new LinkOption[0]) && !Files.isHidden(path);
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }).findFirst().orElse(null);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            return this.media;
        }

        public Optional<String> getCaption() {
            return this.caption;
        }
    }
}

