/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.AccountManager;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.GroupMutation;
import io.privacyresearch.equation.groups.GroupChangeFailedException;
import io.privacyresearch.equation.groups.GroupInsufficientRightsException;
import io.privacyresearch.equation.groups.GroupNotAMemberException;
import io.privacyresearch.equation.groups.GroupsV2Api;
import io.privacyresearch.equation.groups.GroupsV2Operations;
import io.privacyresearch.equation.signal.util.UuidUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class GroupManager {
    private final EquationManager waveManager;
    private final SqliteStorageBean sqliteStorageBean;
    private final GroupsV2Api groupsV2Api;
    private final CredentialsProvider credentialsProvider;
    private final GroupsV2Operations groupsV2Operations;
    private static final Logger LOG = Logger.getLogger(GroupManager.class.getName());
    private final AccountManager accountManager;

    public GroupManager(EquationManager waveManager, SqliteStorageBean sqliteStorageBean, AccountManager accountManager, CredentialsProvider credentialsProvider) {
        this.waveManager = waveManager;
        this.sqliteStorageBean = sqliteStorageBean;
        this.accountManager = accountManager;
        this.groupsV2Api = accountManager.getGroupsV2Api();
        this.credentialsProvider = credentialsProvider;
        this.groupsV2Operations = accountManager.getGroupsV2Operations();
        long day = TimeUnit.DAYS.toSeconds(TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis()));
    }

    public DecryptedGroupChange decryptChange(GroupMasterKey groupMasterKey, byte[] signedGroupChange) {
        GroupUpdater updater = new GroupUpdater(groupMasterKey);
        DecryptedGroupChange answer = updater.getDecryptedGroupChange(signedGroupChange);
        return answer;
    }

    public int updateGroupTimer(GroupRecord groupRecord, int timer) throws IOException {
        LOG.info("Asked to update group timer, current revision = " + groupRecord.revision());
        int day = (int)LocalDate.now(ZoneId.of("UTC")).toEpochDay();
        SignalServiceGroupV2 groupV2 = this.waveManager.getGroupService().getV2Group(groupRecord);
        GroupSecretParams params = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupV2.getMasterKey());
        int newRevision = groupV2.getRevision() + 1;
        GroupsV2Operations.GroupOperations groupOp = this.groupsV2Operations.forGroup(params);
        GroupChange.Actions.Builder change = groupOp.createModifyGroupTimerChange(timer);
        change.setRevision(newRevision);
        try {
            this.commitChange(groupRecord, change, params);
        }
        catch (GroupChangeFailedException | GroupInsufficientRightsException | GroupNotAMemberException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return newRevision;
    }

    private GroupChange commitChange(GroupRecord group, GroupChange.Actions.Builder change, GroupSecretParams groupSecretParams) throws GroupNotAMemberException, GroupChangeFailedException, IOException, GroupInsufficientRightsException {
        try {
            LOG.info("Modify group, current revision = " + group.revision());
            group = this.waveManager.retrieveGroupFromMasterKeyBytes(group.masterKeyBytes());
            GroupsV2Operations.GroupOperations groupOperations = this.groupsV2Operations.forGroup(groupSecretParams);
            int revision = group.revision();
            int nextRevision = revision + 1;
            ByteString sourceServiceId = UuidUtil.toByteString(this.waveManager.getAccount().getUser().aci().getRawUUID());
            GroupChange.Actions changeActions = change.setRevision(nextRevision).setSourceServiceId(sourceServiceId).build();
            GroupChange signedGroupChange = this.commitToServer(changeActions, groupSecretParams);
            DecryptedGroupChange decryptedChange = groupOperations.decryptChange(signedGroupChange, true).get();
            SignalServiceProtos.DataMessage message = SignalServiceProtos.DataMessage.newBuilder().setTimestamp(System.currentTimeMillis()).setGroupV2(SignalServiceProtos.GroupContextV2.newBuilder().setMasterKey(ByteString.copyFrom((byte[])group.getMasterKey().serialize())).setRevision(revision).setGroupChange(signedGroupChange.toByteString())).build();
            this.waveManager.getSignalBridge().sendSignalGroupMessage(message, null, group, 0L, null);
            return signedGroupChange;
        }
        catch (InvalidProtocolBufferException | VerificationFailedException | InvalidGroupStateException ex) {
            Logger.getLogger(GroupManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "global error", e);
        }
        return null;
    }

    private GroupChange commitToServer(GroupChange.Actions change, GroupSecretParams groupSecretParams) throws IOException, GroupNotAMemberException, GroupInsufficientRightsException {
        return this.groupsV2Api.patchGroup(change, this.accountManager.getAuthorization(groupSecretParams), Optional.empty());
    }

    @Deprecated
    void sendGroupUpdate(RecipientKey recipientKey, GroupMasterKey masterKey, GroupMutation groupMutation, GroupChange signedGroupChange, boolean sendToMembers) {
        DecryptedGroupChange plainGroupChange = groupMutation.getGroupChange();
        SignalServiceGroupV2.Builder ssgBuilder = SignalServiceGroupV2.newBuilder((GroupMasterKey)masterKey).withRevision(0);
        if (signedGroupChange != null) {
            ssgBuilder.withSignedGroupChange(signedGroupChange.toByteArray());
        }
        SignalServiceGroupV2 signalServiceGroupV2 = ssgBuilder.build();
        long now = System.currentTimeMillis();
        LOG.severe("Group update messages are sent in WaveManager!");
    }

    final class GroupUpdater {
        private final GroupMasterKey groupMasterKey;

        GroupUpdater(GroupMasterKey groupMasterKey) {
            this.groupMasterKey = groupMasterKey;
        }

        public DecryptedGroupChange getDecryptedGroupChange(byte[] signedGroupChange) {
            if (signedGroupChange != null && signedGroupChange.length > 0) {
                GroupsV2Operations.GroupOperations groupOperations = GroupManager.this.groupsV2Operations.forGroup(GroupSecretParams.deriveFromMasterKey((GroupMasterKey)this.groupMasterKey));
                try {
                    return groupOperations.decryptChange(GroupChange.parseFrom((byte[])signedGroupChange), true).orElse(null);
                }
                catch (InvalidProtocolBufferException | VerificationFailedException | InvalidGroupStateException e) {
                    LOG.log(Level.WARNING, "Unable to verify supplied group change", e);
                }
            }
            return null;
        }
    }
}

