/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.EquationAPI;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.GroupCall;
import java.util.logging.Logger;

public abstract class AbstractCallManager {
    static final Logger LOG = Logger.getLogger(AbstractCallManager.class.getName());
    protected EquationAPI equation;
    protected Call activeCall;

    public AbstractCallManager(EquationAPI equation) {
        this.equation = equation;
    }

    public abstract Call prepareOutgoingCall(RecipientKey var1, boolean var2);

    public abstract GroupCall prepareOutgoingGroupCall(RecipientKey var1, boolean var2);

    public void enableVideoCall(boolean enableVideo) {
        if (this.activeCall == null) {
            throw new IllegalStateException("Can not toggle video calls if we don't have a call object yet");
        }
        LOG.info("Toggle video call to " + enableVideo);
        if (this.activeCall.getState() == Call.CallState.IDLE) {
            this.activeCall.setType(enableVideo ? CallDbRecord.Type.VIDEO_CALL : CallDbRecord.Type.AUDIO_CALL);
        }
        if (enableVideo) {
            this.startShowAndSendMyVideo();
            this.activeCall.setWebcamRunning(true);
        } else {
            this.stopShowAndSendMyVideo();
            this.activeCall.setWebcamRunning(false);
        }
        this.equation.getWaveClient().gotCallUpdate(this.activeCall);
    }

    protected abstract void startShowAndSendMyVideo();

    protected abstract void stopShowAndSendMyVideo();

    public void startOutgoingCall() {
        LOG.info("Start outgoing call");
        this.activeCall.modifyState(Call.CallState.DIALING);
        this.equation.getWaveClient().gotCallUpdate(this.activeCall);
    }
}

