/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtcrime.securesms.crypto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Base64;
import org.thoughtcrime.securesms.util.JsonUtils;

public class AttachmentSecret {
    @JsonProperty
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    private byte[] classicCipherKey;
    @JsonProperty
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    private byte[] classicMacKey;
    @JsonProperty
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    private byte[] modernKey;

    public AttachmentSecret(byte[] classicCipherKey, byte[] classicMacKey, byte[] modernKey) {
        this.classicCipherKey = classicCipherKey;
        this.classicMacKey = classicMacKey;
        this.modernKey = modernKey;
    }

    public AttachmentSecret() {
    }

    @JsonIgnore
    byte[] getClassicCipherKey() {
        return this.classicCipherKey;
    }

    @JsonIgnore
    byte[] getClassicMacKey() {
        return this.classicMacKey;
    }

    @JsonIgnore
    public byte[] getModernKey() {
        return this.modernKey;
    }

    @JsonIgnore
    void setClassicCipherKey(byte[] classicCipherKey) {
        this.classicCipherKey = classicCipherKey;
    }

    @JsonIgnore
    void setClassicMacKey(byte[] classicMacKey) {
        this.classicMacKey = classicMacKey;
    }

    public String serialize() {
        try {
            return JsonUtils.toJson(this);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static AttachmentSecret fromString(String value) {
        try {
            return JsonUtils.fromJson(value, AttachmentSecret.class);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Base64.getDecoder().decode(p.getValueAsString());
        }
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.getEncoder().withoutPadding().encodeToString(value));
        }
    }
}

