/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.util;

import java.nio.file.Path;
import java.util.HexFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Goodies {
    public static final char FSI = '\u2068';
    public static final char PDI = '\u2069';
    public static final String NULL_BYTE_ARRAY = "NULL byte array";
    public static final String EMPTY_BYTE_ARRAY = "EMPTY byte array";
    public static final String SINGLE_BYTE_ARRAY = "single byte array";
    private static final Logger LOG = Logger.getLogger(Goodies.class.getName());
    static Path homePath;

    public static String stripBidi(String orig) {
        if (orig == null || orig.isEmpty()) {
            return orig;
        }
        int first = orig.indexOf(8296);
        int last = orig.indexOf(8297);
        if (first == 0 && last == orig.length() - 1) {
            return orig.substring(1, last);
        }
        return orig;
    }

    public static String relHomePath(String p) {
        if (p == null) {
            return "NULLPATH!";
        }
        return Goodies.relHomePath(Path.of(p, new String[0]));
    }

    public static String relHomePath(Path p) {
        if (p == null) {
            return "NULLPATH!";
        }
        if (homePath != null) {
            boolean absHome = homePath.isAbsolute();
            if (p.isAbsolute() != absHome) {
                LOG.log(Level.SEVERE, "HomePath " + String.valueOf(homePath) + " and  " + String.valueOf(p) + " have different absolute types!");
                return "{HOMEPATH UNKNOWN}";
            }
            return "{HOME}" + String.valueOf(homePath.relativize(p));
        }
        return "{HOMEPATH UNKNOWN}";
    }

    public static String obfuscate(byte[] b) {
        if (b == null) {
            return NULL_BYTE_ARRAY;
        }
        int size = b.length;
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (size == 1) {
            return SINGLE_BYTE_ARRAY;
        }
        int nbytes = Math.min(size / 2, 5);
        HexFormat hexFormat = HexFormat.of().withPrefix("0x").withDelimiter(", ");
        return hexFormat.formatHex(b, 0, nbytes) + " ... " + size;
    }

    static {
        try {
            homePath = Path.of(System.getProperty("user.home"), new String[0]);
        }
        catch (Throwable t) {
            homePath = null;
            LOG.log(Level.SEVERE, "Problem getting userhome", t);
            t.printStackTrace();
        }
    }
}

