/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal;

import java.util.Random;
import java.util.UUID;

public record MessageAnalysisEntry(Direction dir, long timestamp, boolean sealedSender, int envelopeType, int byteLength, String sourceServiceId, int sourceDeviceId, int pqRatchet) {
    public Direction getDirection() {
        return this.dir;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getEnvelopeType() {
        return this.envelopeType;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public String getSourceServiceId() {
        return this.sourceServiceId;
    }

    public int getSourceDeviceId() {
        return this.sourceDeviceId;
    }

    public boolean isSealedSender() {
        return this.sealedSender;
    }

    public int getPqRatchet() {
        return this.pqRatchet;
    }

    public static MessageAnalysisEntry newRandomEntry() {
        Random random = new Random();
        UUID uuid = UUID.randomUUID();
        long ts = System.currentTimeMillis() - random.nextLong(50000L);
        Direction dir = random.nextBoolean() ? Direction.INCOMING : Direction.OUTGOING;
        return new MessageAnalysisEntry(dir, ts, random.nextBoolean(), random.nextInt(8), random.nextInt(3000), uuid.toString(), random.nextInt(6), random.nextBoolean() ? 0 : random.nextInt(300));
    }

    public static enum Direction {
        INCOMING,
        OUTGOING;

    }
}

