/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.storage.SignalStorageModels;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.storage.ReadOperation;
import org.whispersystems.signalservice.internal.storage.StorageItems;
import org.whispersystems.signalservice.internal.storage.StorageManifest;
import org.whispersystems.signalservice.internal.storage.WriteOperation;

public class StorageNetworkAPI {
    private final String endpoint;
    private final NetworkMonitor monitor;
    private final NetworkConfiguration config;
    private final Optional<CredentialsProvider> cp;
    private NetworkClient storageClient;
    private static final Logger LOG = Logger.getLogger(StorageNetworkAPI.class.getName());

    public StorageNetworkAPI(NetworkMonitor monitor, NetworkConfiguration config, Optional<CredentialsProvider> cp, String endpoint) {
        this.monitor = monitor;
        this.config = config;
        this.cp = cp;
        this.endpoint = endpoint;
    }

    public StorageManifest getStorageManifest(String authToken) throws IOException {
        try {
            NetworkClient client;
            Response response;
            URI uri = new URI(this.endpoint + "/v1/storage/manifest");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            if ((response = (client = this.getStorageClient()).sendRequest(uri, "GET", new byte[0], headers)) == null) {
                throw new IOException("Missing body!");
            }
            return StorageManifest.parseFrom((InputStream)new ByteArrayInputStream(response.body().bytes()));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public SignalStorageManifest getSignalStorageManifest(String authToken, StorageKey storageKey) throws IOException, InvalidKeyException {
        return SignalStorageModels.remoteToLocalStorageManifest(this.getStorageManifest(authToken), storageKey);
    }

    public StorageManifest getStorageManifestIfDifferentVersion(String authToken, long version) throws IOException {
        try {
            NetworkClient client;
            Response response;
            URI uri = new URI(this.endpoint + "/v1/storage/manifest/version/" + version);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            if ((response = (client = this.getStorageClient()).sendRequest(uri, "GET", new byte[0], headers)) == null) {
                throw new IOException("Missing body!");
            }
            return StorageManifest.parseFrom((InputStream)new ByteArrayInputStream(response.body().bytes()));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public StorageItems writeStorageItems(String authToken, WriteOperation operation) throws IOException {
        try {
            URI uri = new URI(this.endpoint + "/v1/storage");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            headers.put("Content-Type", List.of("application/x-protobuf"));
            NetworkClient client = this.getStorageClient();
            Response response = client.sendRequest(uri, "PUT", operation.toByteArray(), headers);
            if (response == null) {
                throw new IOException("Missing body!");
            }
            return StorageItems.parseFrom((byte[])response.body().bytes());
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public StorageItems readStorageItems(String authToken, ReadOperation operation) throws IOException {
        try {
            URI uri = new URI(this.endpoint + "/v1/storage/read");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            headers.put("Content-Type", List.of("application/x-protobuf"));
            NetworkClient client = this.getStorageClient();
            Response response = client.sendRequest(uri, "PUT", operation.toByteArray(), headers);
            if (response == null) {
                throw new IOException("Missing body!");
            }
            return StorageItems.parseFrom((byte[])response.body().bytes());
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    private synchronized NetworkClient getStorageClient() {
        if (this.storageClient == null) {
            this.storageClient = NetworkClient.createStorageClient(this.monitor, this.config, NetworkConfiguration.Purpose.SERVICE, this.cp);
        }
        return this.storageClient;
    }
}

