/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Base64;
import org.signal.libsignal.protocol.InvalidKeyException;

abstract class AbstractPublicKeyDeserializer<K>
extends JsonDeserializer<K> {
    AbstractPublicKeyDeserializer() {
    }

    public K deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        byte[] publicKeyBytes;
        try {
            publicKeyBytes = Base64.getDecoder().decode(parser.getValueAsString());
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException(parser, "Could not parse public key as a base64-encoded value", (Throwable)e);
        }
        if (publicKeyBytes.length == 0) {
            return null;
        }
        try {
            return this.deserializePublicKey(publicKeyBytes);
        }
        catch (InvalidKeyException e) {
            throw new JsonParseException(parser, "Could not interpret key bytes as a public key", (Throwable)e);
        }
    }

    protected abstract K deserializePublicKey(byte[] var1) throws InvalidKeyException;
}

