/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.groups;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.groups.ClientZkOperations;
import io.privacyresearch.equation.groups.GroupCandidate;
import io.privacyresearch.equation.groups.PartialDecryptedGroup;
import io.privacyresearch.equation.signal.util.UuidUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.NotarySignature;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.ClientZkAuthOperations;
import org.signal.libsignal.zkgroup.groups.ClientZkGroupCipher;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialPresentation;
import org.signal.storageservice.protos.groups.AccessControl;
import org.signal.storageservice.protos.groups.BannedMember;
import org.signal.storageservice.protos.groups.Group;
import org.signal.storageservice.protos.groups.GroupAttributeBlob;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupJoinInfo;
import org.signal.storageservice.protos.groups.Member;
import org.signal.storageservice.protos.groups.PendingMember;
import org.signal.storageservice.protos.groups.RequestingMember;
import org.signal.storageservice.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.protos.groups.local.DecryptedGroupJoinInfo;
import org.signal.storageservice.protos.groups.local.DecryptedMember;
import org.signal.storageservice.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.protos.groups.local.DecryptedString;
import org.signal.storageservice.protos.groups.local.DecryptedTimer;
import org.signal.storageservice.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;

public final class GroupsV2Operations {
    private static final String TAG = GroupsV2Operations.class.getSimpleName();
    public static final UUID UNKNOWN_UUID = UuidUtil.UNKNOWN_UUID;
    public static final int HIGHEST_KNOWN_EPOCH = 5;
    private final ServerPublicParams serverPublicParams;
    private final ClientZkProfileOperations clientZkProfileOperations;
    private final ClientZkAuthOperations clientZkAuthOperations;
    private final int maxGroupSize;
    private final SecureRandom random;

    public GroupsV2Operations(ClientZkOperations clientZkOperations, int maxGroupSize) {
        this.serverPublicParams = clientZkOperations.getServerPublicParams();
        this.clientZkProfileOperations = clientZkOperations.getProfileOperations();
        this.clientZkAuthOperations = clientZkOperations.getAuthOperations();
        this.maxGroupSize = maxGroupSize;
        this.random = new SecureRandom();
    }

    public NewGroup createNewGroup(GroupSecretParams groupSecretParams, String title, Optional<byte[]> avatar, GroupCandidate self, Set<GroupCandidate> members, Member.Role memberRole, int disappearingMessageTimerSeconds) {
        if (members.contains(self)) {
            throw new IllegalArgumentException("Members must not contain self");
        }
        GroupOperations groupOperations = this.forGroup(groupSecretParams);
        Group.Builder group = Group.newBuilder().setRevision(0).setPublicKey(ByteString.copyFrom((byte[])groupSecretParams.getPublicParams().serialize())).setTitle(groupOperations.encryptTitle(title)).setDisappearingMessagesTimer(groupOperations.encryptTimer(disappearingMessageTimerSeconds)).setAccessControl(AccessControl.newBuilder().setAttributes(AccessControl.AccessRequired.MEMBER).setMembers(AccessControl.AccessRequired.MEMBER));
        group.addMembers(groupOperations.member(self.requireExpiringProfileKeyCredential(), Member.Role.ADMINISTRATOR));
        for (GroupCandidate credential : members) {
            ExpiringProfileKeyCredential expiringProfileKeyCredential = credential.getExpiringProfileKeyCredential().orElse(null);
            if (expiringProfileKeyCredential != null) {
                group.addMembers(groupOperations.member(expiringProfileKeyCredential, memberRole));
                continue;
            }
            group.addPendingMembers(groupOperations.invitee(credential.getServiceId(), memberRole));
        }
        return new NewGroup(groupSecretParams, group.build(), avatar);
    }

    public GroupOperations forGroup(GroupSecretParams groupSecretParams) {
        return new GroupOperations(groupSecretParams);
    }

    public ClientZkProfileOperations getProfileOperations() {
        return this.clientZkProfileOperations;
    }

    public ClientZkAuthOperations getAuthOperations() {
        return this.clientZkAuthOperations;
    }

    private ByteString fromServiceId(ServiceId serviceId) {
        return ByteString.copyFrom((byte[])serviceId.toServiceIdBinary());
    }

    public final class GroupOperations {
        private final GroupSecretParams groupSecretParams;
        private final ClientZkGroupCipher clientZkGroupCipher;

        private GroupOperations(GroupSecretParams groupSecretParams) {
            this.groupSecretParams = groupSecretParams;
            this.clientZkGroupCipher = new ClientZkGroupCipher(groupSecretParams);
        }

        public GroupChange.Actions.Builder createModifyGroupTitle(String title) {
            return GroupChange.Actions.newBuilder().setModifyTitle(GroupChange.Actions.ModifyTitleAction.newBuilder().setTitle(this.encryptTitle(title)));
        }

        public GroupChange.Actions.ModifyDescriptionAction.Builder createModifyGroupDescriptionAction(String description) {
            return GroupChange.Actions.ModifyDescriptionAction.newBuilder().setDescription(this.encryptDescription(description));
        }

        public GroupChange.Actions.Builder createModifyGroupDescription(String description) {
            return GroupChange.Actions.newBuilder().setModifyDescription(this.createModifyGroupDescriptionAction(description));
        }

        public GroupChange.Actions.Builder createModifyGroupMembershipChange(Set<GroupCandidate> membersToAdd, Set<ServiceId> bannedMembers, ServiceId.Aci selfAci) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            Set<ServiceId> membersToUnban = membersToAdd.stream().map(GroupCandidate::getServiceId).filter(bannedMembers::contains).collect(Collectors.toSet());
            GroupChange.Actions.Builder actions = membersToUnban.isEmpty() ? GroupChange.Actions.newBuilder() : this.createUnbanServiceIdsChange(membersToUnban);
            for (GroupCandidate credential : membersToAdd) {
                Member.Role newMemberRole = Member.Role.DEFAULT;
                ExpiringProfileKeyCredential expiringProfileKeyCredential = credential.getExpiringProfileKeyCredential().orElse(null);
                if (expiringProfileKeyCredential != null) {
                    actions.addAddMembers(GroupChange.Actions.AddMemberAction.newBuilder().setAdded(groupOperations.member(expiringProfileKeyCredential, newMemberRole)));
                    continue;
                }
                actions.addAddPendingMembers(GroupChange.Actions.AddPendingMemberAction.newBuilder().setAdded(groupOperations.invitee(credential.getServiceId(), newMemberRole).setAddedByUserId(this.encryptServiceId((ServiceId)selfAci))));
            }
            return actions;
        }

        public GroupChange.Actions.Builder createGroupJoinRequest(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            GroupChange.Actions.Builder actions = GroupChange.Actions.newBuilder();
            actions.addAddRequestingMembers(GroupChange.Actions.AddRequestingMemberAction.newBuilder().setAdded(groupOperations.requestingMember(expiringProfileKeyCredential)));
            return actions;
        }

        public GroupChange.Actions.Builder createGroupJoinDirect(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            GroupChange.Actions.Builder actions = GroupChange.Actions.newBuilder();
            actions.addAddMembers(GroupChange.Actions.AddMemberAction.newBuilder().setAdded(groupOperations.member(expiringProfileKeyCredential, Member.Role.DEFAULT)));
            return actions;
        }

        public GroupChange.Actions.Builder createRefuseGroupJoinRequest(Set<? extends ServiceId> requestsToRemove, boolean alsoBan, List<DecryptedBannedMember> bannedMembers) {
            GroupChange.Actions.Builder actions = alsoBan ? this.createBanServiceIdsChange(requestsToRemove, false, bannedMembers) : GroupChange.Actions.newBuilder();
            for (ServiceId serviceId : requestsToRemove) {
                if (!(serviceId instanceof ServiceId.Aci)) continue;
                actions.addDeleteRequestingMembers(GroupChange.Actions.DeleteRequestingMemberAction.newBuilder().setDeletedUserId(this.encryptServiceId(serviceId)));
            }
            return actions;
        }

        public GroupChange.Actions.Builder createApproveGroupJoinRequest(Set<UUID> requestsToApprove) {
            GroupChange.Actions.Builder actions = GroupChange.Actions.newBuilder();
            for (UUID uuid : requestsToApprove) {
                actions.addPromoteRequestingMembers(GroupChange.Actions.PromoteRequestingMemberAction.newBuilder().setRole(Member.Role.DEFAULT).setUserId(this.encryptServiceId((ServiceId)new ServiceId.Aci(uuid))));
            }
            return actions;
        }

        public GroupChange.Actions.Builder createRemoveMembersChange(Set<ServiceId.Aci> membersToRemove, boolean alsoBan, List<DecryptedBannedMember> bannedMembers) {
            GroupChange.Actions.Builder actions = alsoBan ? this.createBanServiceIdsChange(membersToRemove, false, bannedMembers) : GroupChange.Actions.newBuilder();
            for (ServiceId.Aci remove : membersToRemove) {
                actions.addDeleteMembers(GroupChange.Actions.DeleteMemberAction.newBuilder().setDeletedUserId(this.encryptServiceId((ServiceId)remove)));
            }
            return actions;
        }

        public GroupChange.Actions.Builder createLeaveAndPromoteMembersToAdmin(ServiceId.Aci self, List<UUID> membersToMakeAdmin) {
            GroupChange.Actions.Builder actions = this.createRemoveMembersChange(Collections.singleton(self), false, Collections.emptyList());
            for (UUID member : membersToMakeAdmin) {
                actions.addModifyMemberRoles(GroupChange.Actions.ModifyMemberRoleAction.newBuilder().setUserId(this.encryptServiceId((ServiceId)new ServiceId.Aci(member))).setRole(Member.Role.ADMINISTRATOR));
            }
            return actions;
        }

        public GroupChange.Actions.Builder createModifyGroupTimerChange(int timerDurationSeconds) {
            return GroupChange.Actions.newBuilder().setModifyDisappearingMessagesTimer(GroupChange.Actions.ModifyDisappearingMessagesTimerAction.newBuilder().setTimer(this.encryptTimer(timerDurationSeconds)));
        }

        public GroupChange.Actions.Builder createUpdateProfileKeyCredentialChange(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, expiringProfileKeyCredential);
            return GroupChange.Actions.newBuilder().addModifyMemberProfileKeys(GroupChange.Actions.ModifyMemberProfileKeyAction.newBuilder().setPresentation(ByteString.copyFrom((byte[])presentation.serialize())));
        }

        public GroupChange.Actions.Builder createAcceptInviteChange(ExpiringProfileKeyCredential credential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, credential);
            return GroupChange.Actions.newBuilder().addPromotePendingMembers(GroupChange.Actions.PromotePendingMemberAction.newBuilder().setPresentation(ByteString.copyFrom((byte[])presentation.serialize())));
        }

        public GroupChange.Actions.Builder createAcceptPniInviteChange(ExpiringProfileKeyCredential credential) {
            ByteString presentation = ByteString.copyFrom((byte[])GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, credential).serialize());
            return GroupChange.Actions.newBuilder().addPromotePendingPniAciMembers(GroupChange.Actions.PromotePendingPniAciMemberProfileKeyAction.newBuilder().setPresentation(presentation));
        }

        public GroupChange.Actions.Builder createRemoveInvitationChange(Set<UuidCiphertext> uuidCipherTextsFromInvitesToRemove) {
            GroupChange.Actions.Builder builder = GroupChange.Actions.newBuilder();
            for (UuidCiphertext uuidCipherText : uuidCipherTextsFromInvitesToRemove) {
                builder.addDeletePendingMembers(GroupChange.Actions.DeletePendingMemberAction.newBuilder().setDeletedUserId(ByteString.copyFrom((byte[])uuidCipherText.serialize())));
            }
            return builder;
        }

        public GroupChange.Actions.Builder createModifyGroupLinkPasswordChange(byte[] groupLinkPassword) {
            return GroupChange.Actions.newBuilder().setModifyInviteLinkPassword(GroupChange.Actions.ModifyInviteLinkPasswordAction.newBuilder().setInviteLinkPassword(ByteString.copyFrom((byte[])groupLinkPassword)));
        }

        public GroupChange.Actions.Builder createModifyGroupLinkPasswordAndRightsChange(byte[] groupLinkPassword, AccessControl.AccessRequired newRights) {
            GroupChange.Actions.Builder change = this.createModifyGroupLinkPasswordChange(groupLinkPassword);
            return change.setModifyAddFromInviteLinkAccess(GroupChange.Actions.ModifyAddFromInviteLinkAccessControlAction.newBuilder().setAddFromInviteLinkAccess(newRights));
        }

        public GroupChange.Actions.Builder createChangeJoinByLinkRights(AccessControl.AccessRequired newRights) {
            return GroupChange.Actions.newBuilder().setModifyAddFromInviteLinkAccess(GroupChange.Actions.ModifyAddFromInviteLinkAccessControlAction.newBuilder().setAddFromInviteLinkAccess(newRights));
        }

        public GroupChange.Actions.Builder createChangeMembershipRights(AccessControl.AccessRequired newRights) {
            return GroupChange.Actions.newBuilder().setModifyMemberAccess(GroupChange.Actions.ModifyMembersAccessControlAction.newBuilder().setMembersAccess(newRights));
        }

        public GroupChange.Actions.Builder createChangeAttributesRights(AccessControl.AccessRequired newRights) {
            return GroupChange.Actions.newBuilder().setModifyAttributesAccess(GroupChange.Actions.ModifyAttributesAccessControlAction.newBuilder().setAttributesAccess(newRights));
        }

        public GroupChange.Actions.Builder createAnnouncementGroupChange(boolean isAnnouncementGroup) {
            return GroupChange.Actions.newBuilder().setModifyAnnouncementsOnly(GroupChange.Actions.ModifyAnnouncementsOnlyAction.newBuilder().setAnnouncementsOnly(isAnnouncementGroup));
        }

        public GroupChange.Actions.Builder createBanServiceIdsChange(Set<? extends ServiceId> banServiceIds, boolean rejectJoinRequest, List<DecryptedBannedMember> bannedMembersList) {
            GroupChange.Actions.Builder builder = rejectJoinRequest ? this.createRefuseGroupJoinRequest(banServiceIds, false, Collections.emptyList()) : GroupChange.Actions.newBuilder();
            int spacesToFree = bannedMembersList.size() + banServiceIds.size() - GroupsV2Operations.this.maxGroupSize;
            if (spacesToFree > 0) {
                List unban = bannedMembersList.stream().sorted(Comparator.comparingLong(DecryptedBannedMember::getTimestamp)).limit(spacesToFree).map(DecryptedBannedMember::getServiceIdBytes).collect(Collectors.toList());
                for (ByteString serviceIdBinary : unban) {
                    try {
                        builder.addDeleteBannedMembers(GroupChange.Actions.DeleteBannedMemberAction.newBuilder().setDeletedUserId(this.encryptServiceId(ServiceId.parseFromBinary((byte[])serviceIdBinary.toByteArray()))));
                    }
                    catch (ServiceId.InvalidServiceIdException ex) {
                        Logger.getLogger(GroupsV2Operations.class.getName()).log(Level.SEVERE, null, ex);
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
            for (ServiceId serviceId : banServiceIds) {
                builder.addAddBannedMembers(GroupChange.Actions.AddBannedMemberAction.newBuilder().setAdded(BannedMember.newBuilder().setUserId(this.encryptServiceId(serviceId)).build()));
            }
            return builder;
        }

        public GroupChange.Actions.Builder createUnbanServiceIdsChange(Set<ServiceId> serviceIds) {
            GroupChange.Actions.Builder builder = GroupChange.Actions.newBuilder();
            for (ServiceId serviceId : serviceIds) {
                builder.addDeleteBannedMembers(GroupChange.Actions.DeleteBannedMemberAction.newBuilder().setDeletedUserId(this.encryptServiceId(serviceId)).build());
            }
            return builder;
        }

        public GroupChange.Actions.Builder replaceAddMembers(GroupChange.Actions.Builder change, List<GroupCandidate> candidates) throws InvalidInputException {
            if (change.getAddMembersCount() != candidates.size()) {
                throw new InvalidInputException("Replacement candidates not same size as original add");
            }
            for (int i = 0; i < change.getAddMembersCount(); ++i) {
                GroupChange.Actions.AddMemberAction original = change.getAddMembers(i);
                GroupCandidate candidate = candidates.get(i);
                ExpiringProfileKeyCredential expiringProfileKeyCredential = candidate.getExpiringProfileKeyCredential().orElse(null);
                if (expiringProfileKeyCredential == null) {
                    throw new InvalidInputException("Replacement candidate missing credential");
                }
                change.setAddMembers(i, GroupChange.Actions.AddMemberAction.newBuilder().setAdded(this.member(expiringProfileKeyCredential, original.getAdded().getRole())));
            }
            return change;
        }

        private Member.Builder member(ExpiringProfileKeyCredential credential, Member.Role role) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(new SecureRandom(), this.groupSecretParams, credential);
            return Member.newBuilder().setRole(role).setPresentation(ByteString.copyFrom((byte[])presentation.serialize()));
        }

        private RequestingMember.Builder requestingMember(ExpiringProfileKeyCredential credential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(new SecureRandom(), this.groupSecretParams, credential);
            return RequestingMember.newBuilder().setPresentation(ByteString.copyFrom((byte[])presentation.serialize()));
        }

        public PendingMember.Builder invitee(ServiceId serviceId, Member.Role role) {
            UuidCiphertext uuidCiphertext = this.clientZkGroupCipher.encrypt(serviceId);
            Member member = Member.newBuilder().setRole(role).setUserId(ByteString.copyFrom((byte[])uuidCiphertext.serialize())).build();
            return PendingMember.newBuilder().setMember(member);
        }

        public PartialDecryptedGroup partialDecryptGroup(Group group) throws VerificationFailedException, InvalidGroupStateException {
            List membersList = group.getMembersList();
            List pendingMembersList = group.getPendingMembersList();
            ArrayList<DecryptedMember> decryptedMembers = new ArrayList<DecryptedMember>(membersList.size());
            ArrayList<DecryptedPendingMember> decryptedPendingMembers = new ArrayList<DecryptedPendingMember>(pendingMembersList.size());
            for (Member member : membersList) {
                ServiceId.Aci memberAci = this.decryptAci(member.getUserId());
                decryptedMembers.add(DecryptedMember.newBuilder().setAciBytes(ByteString.copyFrom((byte[])memberAci.toServiceIdBinary())).setJoinedAtRevision(member.getJoinedAtRevision()).build());
            }
            for (Member member : pendingMembersList) {
                ServiceId pendingMemberServiceId = this.decryptServiceIdOrUnknown(member.getMember().getUserId());
                decryptedPendingMembers.add(DecryptedPendingMember.newBuilder().setServiceIdBytes(ByteString.copyFrom((byte[])pendingMemberServiceId.toServiceIdBinary())).build());
            }
            DecryptedGroup decryptedGroup = DecryptedGroup.newBuilder().setRevision(group.getRevision()).addAllMembers(decryptedMembers).addAllPendingMembers(decryptedPendingMembers).build();
            return new PartialDecryptedGroup(group, decryptedGroup, GroupsV2Operations.this, this.groupSecretParams);
        }

        public DecryptedGroup decryptGroup(Group group) throws VerificationFailedException, InvalidGroupStateException {
            List membersList = group.getMembersList();
            List pendingMembersList = group.getPendingMembersList();
            List requestingMembersList = group.getRequestingMembersList();
            ArrayList<DecryptedMember> decryptedMembers = new ArrayList<DecryptedMember>(membersList.size());
            ArrayList<DecryptedPendingMember> decryptedPendingMembers = new ArrayList<DecryptedPendingMember>(pendingMembersList.size());
            ArrayList<DecryptedRequestingMember> decryptedRequestingMembers = new ArrayList<DecryptedRequestingMember>(requestingMembersList.size());
            ArrayList<DecryptedBannedMember> decryptedBannedMembers = new ArrayList<DecryptedBannedMember>(group.getBannedMembersCount());
            for (Member member : membersList) {
                try {
                    decryptedMembers.add(this.decryptMember(member).build());
                }
                catch (InvalidInputException e) {
                    throw new InvalidGroupStateException(e);
                }
            }
            for (Member member : pendingMembersList) {
                decryptedPendingMembers.add(this.decryptMember((PendingMember)member));
            }
            for (Member member : requestingMembersList) {
                decryptedRequestingMembers.add(this.decryptRequestingMember((RequestingMember)member));
            }
            for (Member member : group.getBannedMembersList()) {
                decryptedBannedMembers.add(DecryptedBannedMember.newBuilder().setServiceIdBytes(this.decryptServiceIdToBinary(member.getUserId())).setTimestamp(member.getTimestamp()).build());
            }
            return DecryptedGroup.newBuilder().setTitle(this.decryptTitle(group.getTitle())).setDescription(this.decryptDescription(group.getDescription())).setIsAnnouncementGroup(group.getAnnouncementsOnly() ? EnabledState.ENABLED : EnabledState.DISABLED).setAvatar(group.getAvatar()).setAccessControl(group.getAccessControl()).setRevision(group.getRevision()).addAllMembers(decryptedMembers).addAllPendingMembers(decryptedPendingMembers).addAllRequestingMembers(decryptedRequestingMembers).setDisappearingMessagesTimer(DecryptedTimer.newBuilder().setDuration(this.decryptDisappearingMessagesTimer(group.getDisappearingMessagesTimer()))).setInviteLinkPassword(group.getInviteLinkPassword()).addAllBannedMembers(decryptedBannedMembers).build();
        }

        public Optional<DecryptedGroupChange> decryptChange(GroupChange groupChange, boolean verifySignature) throws InvalidProtocolBufferException, VerificationFailedException, InvalidGroupStateException {
            if (groupChange.getChangeEpoch() > 5) {
                Log.w((String)TAG, (String)String.format(Locale.US, "Ignoring change from Epoch %d. Highest known Epoch is %d", groupChange.getChangeEpoch(), 5));
                return Optional.empty();
            }
            GroupChange.Actions actions = verifySignature ? this.getVerifiedActions(groupChange) : this.getActions(groupChange);
            return Optional.of(this.decryptChange(actions));
        }

        public DecryptedGroupChange decryptChange(GroupChange.Actions actions) throws VerificationFailedException, InvalidGroupStateException {
            return this.decryptChange(actions, null);
        }

        public DecryptedGroupChange decryptChange(GroupChange.Actions actions, ServiceId source) throws VerificationFailedException, InvalidGroupStateException {
            ProfileKey profileKey;
            ServiceId.Aci aci;
            ProfileKeyCredentialPresentation presentation;
            DecryptedGroupChange.Builder builder = DecryptedGroupChange.newBuilder();
            if (source != null) {
                builder.setEditorServiceIdBytes(ByteString.copyFrom((byte[])source.toServiceIdBinary()));
            } else {
                builder.setEditorServiceIdBytes(this.decryptServiceIdToBinary(actions.getSourceServiceId()));
            }
            builder.setRevision(actions.getRevision());
            for (GroupChange.Actions.AddMemberAction addMemberAction : actions.getAddMembersList()) {
                try {
                    builder.addNewMembers(this.decryptMember(addMemberAction.getAdded()).setJoinedAtRevision(actions.getRevision()));
                }
                catch (InvalidInputException e) {
                    throw new InvalidGroupStateException(e);
                }
            }
            for (GroupChange.Actions.DeleteMemberAction deleteMemberAction : actions.getDeleteMembersList()) {
                builder.addDeleteMembers(this.decryptAciToBinary(deleteMemberAction.getDeletedUserId()));
            }
            for (GroupChange.Actions.ModifyMemberRoleAction modifyMemberRoleAction : actions.getModifyMemberRolesList()) {
                builder.addModifyMemberRoles(DecryptedModifyMemberRole.newBuilder().setRole(modifyMemberRoleAction.getRole()).setAciBytes(this.decryptAciToBinary(modifyMemberRoleAction.getUserId())));
            }
            for (GroupChange.Actions.ModifyMemberProfileKeyAction modifyMemberProfileKeyAction : actions.getModifyMemberProfileKeysList()) {
                try {
                    if (modifyMemberProfileKeyAction.getUserId().isEmpty() || modifyMemberProfileKeyAction.getProfileKey().isEmpty()) {
                        presentation = new ProfileKeyCredentialPresentation(modifyMemberProfileKeyAction.getPresentation().toByteArray());
                        aci = this.decryptAci(ByteString.copyFrom((byte[])presentation.getUuidCiphertext().serialize()));
                        profileKey = this.decryptProfileKey(ByteString.copyFrom((byte[])presentation.getProfileKeyCiphertext().serialize()), aci);
                    } else {
                        aci = this.decryptAci(modifyMemberProfileKeyAction.getUserId());
                        profileKey = this.decryptProfileKey(modifyMemberProfileKeyAction.getProfileKey(), aci);
                    }
                    builder.addModifiedProfileKeys(DecryptedMember.newBuilder().setRole(Member.Role.UNKNOWN).setJoinedAtRevision(-1).setAciBytes(ByteString.copyFrom((byte[])aci.toServiceIdBinary())).setProfileKey(ByteString.copyFrom((byte[])profileKey.serialize())));
                }
                catch (InvalidInputException e) {
                    throw new InvalidGroupStateException(e);
                }
            }
            for (GroupChange.Actions.AddPendingMemberAction addPendingMemberAction : actions.getAddPendingMembersList()) {
                PendingMember added = addPendingMemberAction.getAdded();
                Member member = added.getMember();
                ByteString serviceIdCipherText = member.getUserId();
                ServiceId serviceId = this.decryptServiceIdOrUnknown(serviceIdCipherText);
                builder.addNewPendingMembers(DecryptedPendingMember.newBuilder().setServiceIdBytes(ByteString.copyFrom((byte[])serviceId.toServiceIdBinary())).setServiceIdCipherText(serviceIdCipherText).setRole(member.getRole()).setAddedByAci(this.decryptAciToBinary(added.getAddedByUserId())).setTimestamp(added.getTimestamp()));
            }
            for (GroupChange.Actions.DeletePendingMemberAction deletePendingMemberAction : actions.getDeletePendingMembersList()) {
                ByteString serviceIdCipherText = deletePendingMemberAction.getDeletedUserId();
                ServiceId serviceId = this.decryptServiceIdOrUnknown(serviceIdCipherText);
                builder.addDeletePendingMembers(DecryptedPendingMemberRemoval.newBuilder().setServiceIdBytes(ByteString.copyFrom((byte[])serviceId.toServiceIdBinary())).setServiceIdCipherText(serviceIdCipherText));
            }
            for (GroupChange.Actions.PromotePendingMemberAction promotePendingMemberAction : actions.getPromotePendingMembersList()) {
                try {
                    if (promotePendingMemberAction.getUserId().isEmpty() || promotePendingMemberAction.getProfileKey().isEmpty()) {
                        presentation = new ProfileKeyCredentialPresentation(promotePendingMemberAction.getPresentation().toByteArray());
                        aci = this.decryptAci(ByteString.copyFrom((byte[])presentation.getUuidCiphertext().serialize()));
                        profileKey = this.decryptProfileKey(ByteString.copyFrom((byte[])presentation.getProfileKeyCiphertext().serialize()), aci);
                    } else {
                        aci = this.decryptAci(promotePendingMemberAction.getUserId());
                        profileKey = this.decryptProfileKey(promotePendingMemberAction.getProfileKey(), aci);
                    }
                    builder.addPromotePendingMembers(DecryptedMember.newBuilder().setJoinedAtRevision(-1).setRole(Member.Role.DEFAULT).setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setProfileKey(ByteString.copyFrom((byte[])profileKey.serialize())));
                }
                catch (InvalidInputException e) {
                    throw new InvalidGroupStateException(e);
                }
            }
            if (actions.hasModifyTitle()) {
                builder.setNewTitle(DecryptedString.newBuilder().setValue(this.decryptTitle(actions.getModifyTitle().getTitle())));
            }
            if (actions.hasModifyAvatar()) {
                builder.setNewAvatar(DecryptedString.newBuilder().setValue(actions.getModifyAvatar().getAvatar()));
            }
            if (actions.hasModifyDisappearingMessagesTimer()) {
                int duration = this.decryptDisappearingMessagesTimer(actions.getModifyDisappearingMessagesTimer().getTimer());
                builder.setNewTimer(DecryptedTimer.newBuilder().setDuration(duration));
            }
            if (actions.hasModifyAttributesAccess()) {
                builder.setNewAttributeAccess(actions.getModifyAttributesAccess().getAttributesAccess());
            }
            if (actions.hasModifyMemberAccess()) {
                builder.setNewMemberAccess(actions.getModifyMemberAccess().getMembersAccess());
            }
            if (actions.hasModifyAddFromInviteLinkAccess()) {
                builder.setNewInviteLinkAccess(actions.getModifyAddFromInviteLinkAccess().getAddFromInviteLinkAccess());
            }
            for (GroupChange.Actions.AddRequestingMemberAction request : actions.getAddRequestingMembersList()) {
                builder.addNewRequestingMembers(this.decryptRequestingMember(request.getAdded()));
            }
            for (GroupChange.Actions.DeleteRequestingMemberAction delete : actions.getDeleteRequestingMembersList()) {
                builder.addDeleteRequestingMembers(this.decryptServiceIdToBinary(delete.getDeletedUserId()));
            }
            for (GroupChange.Actions.PromoteRequestingMemberAction promote : actions.getPromoteRequestingMembersList()) {
                builder.addPromoteRequestingMembers(DecryptedApproveMember.newBuilder().setRole(promote.getRole()).setAciBytes(this.decryptAciToBinary(promote.getUserId())));
            }
            if (actions.hasModifyInviteLinkPassword()) {
                builder.setNewInviteLinkPassword(actions.getModifyInviteLinkPassword().getInviteLinkPassword());
            }
            if (actions.hasModifyDescription()) {
                builder.setNewDescription(DecryptedString.newBuilder().setValue(this.decryptDescription(actions.getModifyDescription().getDescription())));
            }
            if (actions.hasModifyAnnouncementsOnly()) {
                builder.setNewIsAnnouncementGroup(actions.getModifyAnnouncementsOnly().getAnnouncementsOnly() ? EnabledState.ENABLED : EnabledState.DISABLED);
            }
            for (GroupChange.Actions.AddBannedMemberAction action : actions.getAddBannedMembersList()) {
                builder.addNewBannedMembers(DecryptedBannedMember.newBuilder().setServiceIdBytes(this.decryptServiceIdToBinary(action.getAdded().getUserId())).setTimestamp(action.getAdded().getTimestamp()).build());
            }
            for (GroupChange.Actions.AddBannedMemberAction action : actions.getDeleteBannedMembersList()) {
                builder.addDeleteBannedMembers(DecryptedBannedMember.newBuilder().setServiceIdBytes(this.decryptServiceIdToBinary(action.getDeletedUserId())).build());
            }
            for (GroupChange.Actions.PromotePendingPniAciMemberProfileKeyAction promotePendingPniAciMemberAction : actions.getPromotePendingPniAciMembersList()) {
                aci = this.decryptAci(promotePendingPniAciMemberAction.getUserId());
                ServiceId pni = this.decryptServiceId(promotePendingPniAciMemberAction.getPni());
                ProfileKey profileKey2 = this.decryptProfileKey(promotePendingPniAciMemberAction.getProfileKey(), aci);
                if (!(pni instanceof ServiceId.Pni)) {
                    throw new InvalidGroupStateException();
                }
                builder.setEditorServiceIdBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).addPromotePendingPniAciMembers(DecryptedMember.newBuilder().setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setRole(Member.Role.DEFAULT).setProfileKey(ByteString.copyFrom((byte[])profileKey2.serialize())).setJoinedAtRevision(actions.getRevision()).setPniBytes(GroupsV2Operations.this.fromServiceId(pni)));
            }
            return builder.build();
        }

        public DecryptedGroupJoinInfo decryptGroupJoinInfo(GroupJoinInfo joinInfo) {
            return DecryptedGroupJoinInfo.newBuilder().setTitle(this.decryptTitle(joinInfo.getTitle())).setAvatar(joinInfo.getAvatar()).setMemberCount(joinInfo.getMemberCount()).setAddFromInviteLink(joinInfo.getAddFromInviteLink()).setRevision(joinInfo.getRevision()).setPendingAdminApproval(joinInfo.getPendingAdminApproval()).setDescription(this.decryptDescription(joinInfo.getDescription())).build();
        }

        private DecryptedMember.Builder decryptMember(Member member) throws InvalidGroupStateException, VerificationFailedException, InvalidInputException {
            if (member.getPresentation().isEmpty()) {
                ServiceId.Aci aci = this.decryptAci(member.getUserId());
                return DecryptedMember.newBuilder().setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setJoinedAtRevision(member.getJoinedAtRevision()).setProfileKey(this.decryptProfileKeyToByteString(member.getProfileKey(), aci)).setRole(member.getRole());
            }
            ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(member.getPresentation().toByteArray());
            ServiceId serviceId = this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext());
            if (!(serviceId instanceof ServiceId.Aci)) {
                throw new InvalidGroupStateException();
            }
            ServiceId.Aci aci = (ServiceId.Aci)serviceId;
            ProfileKey profileKey = this.clientZkGroupCipher.decryptProfileKey(profileKeyCredentialPresentation.getProfileKeyCiphertext(), aci);
            return DecryptedMember.newBuilder().setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setJoinedAtRevision(member.getJoinedAtRevision()).setProfileKey(ByteString.copyFrom((byte[])profileKey.serialize())).setRole(member.getRole());
        }

        private DecryptedPendingMember decryptMember(PendingMember member) throws InvalidGroupStateException, VerificationFailedException {
            ByteString userIdCipherText = member.getMember().getUserId();
            ServiceId serviceId = this.decryptServiceIdOrUnknown(userIdCipherText);
            ServiceId.Aci addedBy = this.decryptAci(member.getAddedByUserId());
            Member.Role role = member.getMember().getRole();
            if (role != Member.Role.ADMINISTRATOR && role != Member.Role.DEFAULT) {
                role = Member.Role.DEFAULT;
            }
            return DecryptedPendingMember.newBuilder().setServiceIdBytes(GroupsV2Operations.this.fromServiceId(serviceId)).setServiceIdCipherText(userIdCipherText).setAddedByAci(GroupsV2Operations.this.fromServiceId((ServiceId)addedBy)).setRole(role).setTimestamp(member.getTimestamp()).build();
        }

        private DecryptedRequestingMember decryptRequestingMember(RequestingMember member) throws InvalidGroupStateException, VerificationFailedException {
            ProfileKeyCredentialPresentation profileKeyCredentialPresentation;
            if (member.getPresentation().isEmpty()) {
                ServiceId.Aci aci = this.decryptAci(member.getUserId());
                return DecryptedRequestingMember.newBuilder().setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setProfileKey(this.decryptProfileKeyToByteString(member.getProfileKey(), aci)).setTimestamp(member.getTimestamp()).build();
            }
            try {
                profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(member.getPresentation().toByteArray());
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
            ServiceId serviceId = this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext());
            if (!(serviceId instanceof ServiceId.Aci)) {
                throw new InvalidGroupStateException();
            }
            ServiceId.Aci aci = (ServiceId.Aci)serviceId;
            ProfileKey profileKey = this.clientZkGroupCipher.decryptProfileKey(profileKeyCredentialPresentation.getProfileKeyCiphertext(), aci);
            return DecryptedRequestingMember.newBuilder().setAciBytes(GroupsV2Operations.this.fromServiceId((ServiceId)aci)).setProfileKey(ByteString.copyFrom((byte[])profileKey.serialize())).build();
        }

        private ProfileKey decryptProfileKey(ByteString profileKey, ServiceId.Aci aci) throws VerificationFailedException, InvalidGroupStateException {
            try {
                ProfileKeyCiphertext profileKeyCiphertext = new ProfileKeyCiphertext(profileKey.toByteArray());
                return this.clientZkGroupCipher.decryptProfileKey(profileKeyCiphertext, aci);
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
        }

        private ByteString decryptProfileKeyToByteString(ByteString profileKey, ServiceId.Aci aci) throws VerificationFailedException, InvalidGroupStateException {
            return ByteString.copyFrom((byte[])this.decryptProfileKey(profileKey, aci).serialize());
        }

        private ByteString decryptServiceIdToBinary(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            return GroupsV2Operations.this.fromServiceId(this.decryptServiceId(userId));
        }

        private ByteString decryptAciToBinary(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            return GroupsV2Operations.this.fromServiceId((ServiceId)this.decryptAci(userId));
        }

        public ByteString encryptServiceId(ServiceId serviceId) {
            return ByteString.copyFrom((byte[])this.clientZkGroupCipher.encrypt(serviceId).serialize());
        }

        private ServiceId decryptServiceId(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            try {
                return this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray()));
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
        }

        private ServiceId.Aci decryptAci(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            ServiceId result = this.decryptServiceId(userId);
            if (result instanceof ServiceId.Aci) {
                return (ServiceId.Aci)result;
            }
            throw new InvalidGroupStateException();
        }

        private ServiceId decryptServiceIdOrUnknown(ByteString userId) {
            try {
                return this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray()));
            }
            catch (InvalidInputException | VerificationFailedException e) {
                return null;
            }
        }

        private ServiceId.Aci decryptAciOrUnknown(ByteString userId) {
            try {
                ServiceId result = this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray()));
                if (result instanceof ServiceId.Aci) {
                    return (ServiceId.Aci)result;
                }
                return null;
            }
            catch (InvalidInputException | VerificationFailedException e) {
                return null;
            }
        }

        ByteString encryptTitle(String title) {
            try {
                GroupAttributeBlob blob = GroupAttributeBlob.newBuilder().setTitle(title).build();
                return ByteString.copyFrom((byte[])this.clientZkGroupCipher.encryptBlob(blob.toByteArray()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private String decryptTitle(ByteString cipherText) {
            return this.decryptBlob(cipherText).getTitle().trim();
        }

        ByteString encryptDescription(String description) {
            try {
                GroupAttributeBlob blob = GroupAttributeBlob.newBuilder().setDescription(description).build();
                return ByteString.copyFrom((byte[])this.clientZkGroupCipher.encryptBlob(blob.toByteArray()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private String decryptDescription(ByteString cipherText) {
            return this.decryptBlob(cipherText).getDescription().trim();
        }

        private int decryptDisappearingMessagesTimer(ByteString encryptedTimerMessage) {
            return this.decryptBlob(encryptedTimerMessage).getDisappearingMessagesDuration();
        }

        public byte[] decryptAvatar(byte[] bytes) {
            return this.decryptBlob(bytes).getAvatar().toByteArray();
        }

        private GroupAttributeBlob decryptBlob(ByteString blob) {
            return this.decryptBlob(blob.toByteArray());
        }

        private GroupAttributeBlob decryptBlob(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return GroupAttributeBlob.getDefaultInstance();
            }
            if (bytes.length < 29) {
                Log.w((String)TAG, (String)"Bad encrypted blob length");
                return GroupAttributeBlob.getDefaultInstance();
            }
            try {
                return GroupAttributeBlob.parseFrom((byte[])this.clientZkGroupCipher.decryptBlob(bytes));
            }
            catch (InvalidProtocolBufferException | VerificationFailedException e) {
                Log.w((String)TAG, (String)"Bad encrypted blob");
                return GroupAttributeBlob.getDefaultInstance();
            }
        }

        ByteString encryptTimer(int timerDurationSeconds) {
            try {
                GroupAttributeBlob timer = GroupAttributeBlob.newBuilder().setDisappearingMessagesDuration(timerDurationSeconds).build();
                return ByteString.copyFrom((byte[])this.clientZkGroupCipher.encryptBlob(timer.toByteArray()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private GroupChange.Actions getVerifiedActions(GroupChange groupChange) throws VerificationFailedException, InvalidProtocolBufferException {
            NotarySignature signature;
            byte[] actionsByteArray = groupChange.getActions().toByteArray();
            try {
                signature = new NotarySignature(groupChange.getServerSignature().toByteArray());
            }
            catch (InvalidInputException e) {
                Log.w((String)TAG, (String)"Invalid input while verifying group change", (Throwable)e);
                throw new VerificationFailedException();
            }
            GroupsV2Operations.this.serverPublicParams.verifySignature(actionsByteArray, signature);
            return GroupChange.Actions.parseFrom((byte[])actionsByteArray);
        }

        private GroupChange.Actions getActions(GroupChange groupChange) throws InvalidProtocolBufferException {
            return GroupChange.Actions.parseFrom((ByteString)groupChange.getActions());
        }

        public GroupChange.Actions.Builder createChangeMemberRole(ServiceId.Aci memberAci, Member.Role role) {
            return GroupChange.Actions.newBuilder().addModifyMemberRoles(GroupChange.Actions.ModifyMemberRoleAction.newBuilder().setUserId(this.encryptServiceId((ServiceId)memberAci)).setRole(role));
        }

        public List<ServiceId> decryptAddMembers(List<GroupChange.Actions.AddMemberAction> addMembers) throws InvalidInputException, VerificationFailedException {
            ArrayList<ServiceId> ids = new ArrayList<ServiceId>(addMembers.size());
            for (int i = 0; i < addMembers.size(); ++i) {
                GroupChange.Actions.AddMemberAction addMember = addMembers.get(i);
                ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(addMember.getAdded().getPresentation().toByteArray());
                ids.add(this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext()));
            }
            return ids;
        }
    }

    public static class NewGroup {
        private final GroupSecretParams groupSecretParams;
        private final Group newGroupMessage;
        private final Optional<byte[]> avatar;

        private NewGroup(GroupSecretParams groupSecretParams, Group newGroupMessage, Optional<byte[]> avatar) {
            this.groupSecretParams = groupSecretParams;
            this.newGroupMessage = newGroupMessage;
            this.avatar = avatar;
        }

        public GroupSecretParams getGroupSecretParams() {
            return this.groupSecretParams;
        }

        public Group getNewGroupMessage() {
            return this.newGroupMessage;
        }

        public Optional<byte[]> getAvatar() {
            return this.avatar;
        }
    }
}

