/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.cache;

import java.lang.ref.SoftReference;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TimedCache<K, V> {
    private final ConcurrentMap<K, CacheEntry<V>> map = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final long ttl;

    public TimedCache() {
        this(Long.MAX_VALUE);
    }

    public TimedCache(Duration duration) {
        this(duration.toMillis());
    }

    public TimedCache(long ttl) {
        this.ttl = ttl;
    }

    public void put(K key, V value) {
        this.map.put(key, new CacheEntry<V>(value, System.currentTimeMillis()));
    }

    public void evict(K key) {
        this.map.remove(key);
    }

    public V get(K key) {
        CacheEntry exists = (CacheEntry)this.map.get(key);
        if (exists == null) {
            return null;
        }
        if (System.currentTimeMillis() - exists.timestamp > this.ttl) {
            exists.valueRef.clear();
            this.map.remove(key);
            return null;
        }
        return exists.valueRef.get();
    }

    private static class CacheEntry<V> {
        final long timestamp;
        final SoftReference<V> valueRef;

        CacheEntry(V value, long timestamp) {
            this.timestamp = timestamp;
            this.valueRef = new SoftReference<V>(value);
        }
    }
}

