/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.call.CallData;
import io.privacyresearch.clientdata.call.CallDbRecord;
import io.privacyresearch.clientdata.call.CallKey;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.util.UUIDUtil;
import io.privacyresearch.equation.AbstractCallManager;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.equation.call.CallRecord;
import io.privacyresearch.equation.groups.GroupService;
import io.privacyresearch.equation.model.Call;
import io.privacyresearch.equation.model.GroupCall;
import io.privacyresearch.equation.ring.CameraManager;
import io.privacyresearch.equation.ring.CaptureCameraManager;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.user.UserService;
import io.privacyresearch.tringapi.PeekInfo;
import io.privacyresearch.tringapi.TringApi;
import io.privacyresearch.tringapi.TringBridge;
import io.privacyresearch.tringapi.TringFrame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.storageservice.protos.groups.GroupExternalCredential;
import org.whispersystems.signalservice.api.messages.calls.AnswerMessage;
import org.whispersystems.signalservice.api.messages.calls.IceUpdateMessage;
import org.whispersystems.signalservice.api.messages.calls.OfferMessage;
import org.whispersystems.signalservice.api.messages.calls.OpaqueMessage;
import org.whispersystems.signalservice.api.messages.calls.SignalServiceCallMessage;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class WaveCallManager
extends AbstractCallManager
implements TringApi {
    private static final Logger LOG = Logger.getLogger(WaveCallManager.class.getName());
    private final EquationManager waveManager;
    private final WaveStore waveStore;
    private final CallData callDb;
    private final UserService userService;
    private final GroupService groupService;
    private final SignalBridge signalBridge;
    private final CameraManager cameraManager;
    private boolean acceptVideo = true;
    private boolean outgoingVideo = false;
    private boolean nativeTring = true;
    TringBridge tringBridge;
    private List demuxIds;

    public WaveCallManager(EquationManager waveManager, CallData callDb, UserService userService, GroupService groupService, SignalBridge signalBridge) {
        super(waveManager);
        this.waveManager = waveManager;
        this.waveStore = waveManager.getWaveStore();
        this.userService = userService;
        this.groupService = groupService;
        this.signalBridge = signalBridge;
        this.callDb = callDb;
        this.cameraManager = new CaptureCameraManager();
    }

    public void disableTring() {
        this.nativeTring = false;
    }

    void setActiveCall(Call call) {
        LOG.info("Asked to change activecall from " + String.valueOf(this.activeCall) + " to " + String.valueOf(call));
        if (this.activeCall != null && call != null) {
            LOG.severe("Can not set activeCall to " + String.valueOf(call) + " since we have an activeCall at " + String.valueOf(this.activeCall));
            throw new IllegalArgumentException("Trying to overwrite existing activeCall");
        }
        this.activeCall = call;
        if (this.waveManager.getWaveClient() != null) {
            this.waveManager.getWaveClient().gotCallUpdate(this.activeCall);
        }
    }

    public Call handleCallOfferMessage(SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Offer message, UserRecord sender, int senderDeviceId, long timestamp) {
        long callId = message.getId();
        if (this.dbHasCallId(callId)) {
            LOG.info("We already have this call in our db. Fail");
            throw new IllegalArgumentException("Calloffer for existing call " + callId);
        }
        ServiceId serviceId = sender.getServiceId().get();
        SignalServiceAddress senderAddress = new SignalServiceAddress(serviceId);
        LOG.info("Got callOffser from " + String.valueOf(serviceId));
        CallDbRecord.Type type = CallDbRecord.Type.UNKNOWN;
        if (message.getType() == SignalServiceProtos.CallMessage.Offer.Type.OFFER_AUDIO_CALL) {
            type = CallDbRecord.Type.AUDIO_CALL;
        } else if (message.getType() == SignalServiceProtos.CallMessage.Offer.Type.OFFER_VIDEO_CALL) {
            type = CallDbRecord.Type.VIDEO_CALL;
        }
        CallKey callKey = this.callDb.createIncomingCall(callId, sender.recipient().key(), sender.recipient().key(), type);
        long timediff = System.currentTimeMillis() - timestamp;
        if (timediff > 60000L) {
            LOG.info("Incoming call stored, don't process anymore, ts = " + timestamp + " and diff = " + timediff);
            return null;
        }
        Call call = new Call(callKey, Call.Direction.IN, callId, sender, senderDeviceId);
        call.setType(type);
        this.receivedOffer(call, content, message, senderAddress, senderDeviceId);
        return call;
    }

    void receivedOffer(Call call, SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Offer message, SignalServiceAddress senderAddress, int senderDeviceId) {
        this.ensureTringBridge();
        LOG.info("Offer received, setting activeCall from " + String.valueOf(this.activeCall) + " to " + String.valueOf(call));
        if (this.activeCall != null) {
            throw new IllegalStateException("Can't answer offer while we have an active call");
        }
        this.activeCall = call;
        byte[] opaque = message.getOpaque().toByteArray();
        int localDeviceId = this.getLocalDeviceId();
        SignalProtocolAddress addy = new SignalProtocolAddress(senderAddress.getIdentifier(), senderDeviceId);
        byte[] senderKey = this.waveStore.getIdentity(addy).getPublicKey().getPublicKeyBytes();
        byte[] receiverKey = this.waveStore.getIdentityKeyPair().getPublicKey().getPublicKey().getPublicKeyBytes();
        if (this.nativeTring) {
            this.tringBridge.receivedOffer("REMOTEPEER", call.getCallId(), senderDeviceId, localDeviceId, senderKey, receiverKey, opaque);
        }
    }

    void receivedAnswer(long callId, SignalServiceProtos.Content content, SignalServiceProtos.CallMessage.Answer message, SignalServiceAddress senderAddress, int senderDeviceId) {
        LOG.info("Process receivedAnswer");
        this.ensureTringBridge();
        byte[] opaque = message.getOpaque().toByteArray();
        int localDeviceId = this.getLocalDeviceId();
        SignalProtocolAddress addy = new SignalProtocolAddress(senderAddress.getIdentifier(), senderDeviceId);
        byte[] senderKey = this.waveStore.getIdentity(addy).getPublicKey().getPublicKeyBytes();
        byte[] receiverKey = this.waveStore.getIdentityKeyPair().getPublicKey().getPublicKey().getPublicKeyBytes();
        this.tringBridge.receivedAnswer("REMOTEPEER", callId, senderDeviceId, senderKey, receiverKey, opaque);
    }

    boolean handleHangupSignalMessage(SignalServiceProtos.CallMessage.Hangup hm, long timestamp, int localDeviceId) {
        LOG.info("[CLEAN] Hangup message received, type = " + String.valueOf(hm.getType()) + ", devid = " + hm.getDeviceId() + " and id = " + hm.getId());
        if (hm.getType() == SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_ACCEPTED) {
            int deviceId = hm.getDeviceId();
            LOG.info("Hangup because accepted on other device: " + deviceId);
            if (deviceId == localDeviceId) {
                LOG.info("Doh, that's us. Ignore hangup.");
                return false;
            }
        }
        try {
            CallKey callKey = this.callDb.findByCallId(hm.getId());
            if (callKey != null) {
                this.callDb.updateState(callKey, CallDbRecord.State.COMPLETED);
                if (hm.getType() == SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_DECLINED || hm.getType() == SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_NORMAL) {
                    CallDbRecord callRecord;
                    if (this.activeCall != null) {
                        this.activeCall.modifyState(Call.CallState.TERMINATED);
                    }
                    InfoMessage.Type type = CallDbRecord.Type.VIDEO_CALL.equals((Object)(callRecord = (CallDbRecord)this.callDb.findByKey((EntityKey)callKey)).type()) ? InfoMessage.Type.INFO_CALL_MISSED_INCOMING_VIDEO_CALL : InfoMessage.Type.INFO_CALL_MISSED_INCOMING_AUDIO_CALL;
                    this.waveManager.clientNotifyCallMessage(callKey, type, timestamp);
                }
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        return true;
    }

    Call receivedOpaqueMessage(ServiceId.Aci aci, int senderDeviceId, byte[] omsg) {
        LOG.info("Process opaquemessage");
        this.ensureTringBridge();
        if (this.activeCall != null) {
            LOG.info("We have a matching call");
            LOG.info("ar = " + String.valueOf(this.activeCall.getRecipient()));
            if (this.activeCall.getRecipient() != null) {
                LOG.info("ars = " + String.valueOf(this.activeCall.getRecipient().getServiceId()));
                LOG.info("Aci = " + String.valueOf(aci));
                LOG.info("eq? " + this.activeCall.getRecipient().getServiceId().equals(aci));
                LOG.info("eq?2 " + this.activeCall.getRecipient().getServiceId().get().equals((Object)aci));
            }
        } else {
            LOG.info("We will create a new call object for this one");
            long id = new Random().nextLong();
            this.activeCall = this.userService.getUserByServiceId((ServiceId)aci).map(user -> {
                CallKey callKey = this.callDb.createIncomingCall(id, user.recipient().key(), user.recipient().key(), CallDbRecord.Type.GROUP_CALL);
                return new GroupCall(callKey, Call.Direction.IN, id, (UserRecord)user, null);
            }).orElse(null);
        }
        this.waveManager.getWaveClient().gotCallUpdate(this.activeCall);
        LOG.warning("CHECK ME, sending aci as bytes to tringbridge, hope that works?");
        this.tringBridge.receivedOpaqueMessage(aci.toServiceIdBinary(), senderDeviceId, this.getLocalDeviceId(), omsg, 0L);
        return this.activeCall;
    }

    void acceptCall() {
        this.ensureTringBridge();
        LOG.info("App accepts call, tell ringtc and use call " + String.valueOf(this.activeCall));
        if (this.activeCall instanceof GroupCall) {
            byte[] groupId = new byte[]{};
            this.tringBridge.createGroupCallClient(groupId, "https://sfu.voip.signal.org", new byte[0]);
            LOG.info("GroupCallClient created");
            this.startSendingVideo();
            this.startAcceptingVideo();
        } else {
            this.tringBridge.acceptCall();
            LOG.info("App accepts call, told ringtc");
        }
        this.activeCall.modifyState(Call.CallState.CONNECTED);
    }

    void ignoreCall() {
        this.ensureTringBridge();
        this.tringBridge.ignoreCall();
    }

    void hangupCall(Call call) {
        Call.CallState status = (Call.CallState)((Object)call.state().get());
        LOG.info("WaveManager is asked to hangup a call with status " + String.valueOf((Object)status));
        if (status == Call.CallState.REMOTE_RINGING) {
            SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setHangup(SignalServiceProtos.CallMessage.Hangup.newBuilder().setType(SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_NORMAL).setDeviceId(0).setId(call.getCallId())).build();
            this.signalBridge.sendCallMessage(call.getRecipient(), message);
        }
        try {
            CallKey callKey = this.callDb.findByCallId(call.getCallId());
            if (callKey != null) {
                this.callDb.updateState(callKey, CallDbRecord.State.COMPLETED);
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        this.hangupCall();
    }

    void hangupCall() {
        LOG.info("App hangsup call, tell ringtc");
        this.cameraManager.stopListening();
        if (this.tringBridge != null) {
            this.tringBridge.enableOutgoingVideo(false);
            this.tringBridge.hangupCall();
        }
        LOG.info("App hangsup call, told ringtc");
    }

    @Override
    protected void startShowAndSendMyVideo() {
        this.cameraManager.startListening(frame -> this.gotSelfFrame((CameraManager.Frame)frame));
        if (this.nonIdleCall()) {
            this.startSendingVideo();
        }
    }

    @Override
    protected void stopShowAndSendMyVideo() {
        this.cameraManager.stopListening();
        if (this.nonIdleCall()) {
            this.stopSendingVideo();
        }
    }

    boolean nonIdleCall() {
        return this.activeCall != null && this.activeCall.getState() != Call.CallState.IDLE;
    }

    @Override
    public Call prepareOutgoingCall(RecipientKey recipientKey, boolean enableVideo) {
        LOG.info("Prepare outgoing call: recipientKey = " + String.valueOf(recipientKey) + " and enableVideo = " + enableVideo);
        if (this.activeCall != null) {
            throw new IllegalStateException("We still have an active call, can't prepare a new one.");
        }
        UserRecord user = this.userService.getUserByRecipientKey(recipientKey);
        CallDbRecord.Type type = enableVideo ? CallDbRecord.Type.VIDEO_CALL : CallDbRecord.Type.AUDIO_CALL;
        long callId = new Random().nextInt();
        CallKey callKey = this.callDb.createOutgoingCall(callId, recipientKey, this.waveManager.getAccount().getUser().recipient().key(), type);
        Call call = new Call(callKey, Call.Direction.OUT, callId, user);
        call.setType(type);
        this.setActiveCall(call);
        return call;
    }

    @Override
    public GroupCall prepareOutgoingGroupCall(RecipientKey recipientKey, boolean enableVideo) {
        LOG.info("Prepare outgoing call: recipientKey = " + String.valueOf(recipientKey) + " and enableVideo = " + enableVideo);
        if (this.activeCall != null) {
            throw new IllegalStateException("We still have an active call, can't prepare a new one.");
        }
        GroupRecord group = this.groupService.getGroupByRecipientKey(recipientKey);
        if (group == null) {
            throw new IllegalArgumentException("Can not prepare a groupcall when recipient doesn't link to a group");
        }
        LOG.info("GROUP = " + String.valueOf(group) + " with groupid = " + String.valueOf(group.getGroupIdentifier()));
        CallDbRecord.Type type = enableVideo ? CallDbRecord.Type.VIDEO_CALL : CallDbRecord.Type.AUDIO_CALL;
        long callId = new Random().nextInt();
        CallKey callKey = this.callDb.createOutgoingCall(callId, recipientKey, this.waveManager.getAccount().getUser().recipient().key(), type);
        GroupCall call = new GroupCall(callKey, Call.Direction.OUT, callId, null, group);
        call.setType(CallDbRecord.Type.GROUP_CALL);
        this.setActiveCall(call);
        this.ensureTringBridge();
        byte[] groupId = this.activeCall.getGroupRecord().getGroupIdentifier().serialize();
        this.tringBridge.createGroupCallClient(groupId, "https://sfu.voip.signal.org", new byte[0]);
        LOG.info("All set for a new groupcall");
        return call;
    }

    @Override
    public void startOutgoingCall() {
        LOG.info("Start outgoing call");
        if (this.activeCall == null) {
            throw new IllegalStateException("Can't start a call as we have not prepared a call yet");
        }
        if (this.activeCall.getState() != Call.CallState.IDLE) {
            throw new IllegalStateException("Can not start a call in state " + String.valueOf((Object)this.activeCall.getState()));
        }
        String peerId = this.activeCall.getRecipient().getServiceId().get().toString();
        boolean enableVideo = this.activeCall.getType().equals((Object)CallDbRecord.Type.VIDEO_CALL);
        this.ensureTringBridge();
        LOG.info("App starts outgoing call with id = " + this.activeCall.getCallId() + " and recipient = " + String.valueOf(this.activeCall.getRecipient()) + " and peer = " + peerId + " and enableVideo = " + enableVideo);
        this.activeCall.modifyState(Call.CallState.DIALING);
        this.tringBridge.startOutgoingCall(this.activeCall.getCallId(), peerId, this.getLocalDeviceId(), enableVideo);
        this.outgoingVideo = enableVideo;
    }

    public void startOutgoingGroupCall() {
        LOG.info("Now really start ougoing call");
        this.tringBridge.joinGroupCall();
        LOG.info("Outgoing group call started");
    }

    void handleReceivedIceCandidates(int senderDeviceId, List<SignalServiceProtos.CallMessage.IceUpdate> iceMessages) {
        if (iceMessages.size() < 1) {
            LOG.warning("Got an empty receivedIce update, ignoring.");
            return;
        }
        if (this.activeCall == null) {
            LOG.warning("We received ice candidates but have no active call. Ignore.");
            return;
        }
        long callid = -1L;
        ArrayList<byte[]> ice = new ArrayList<byte[]>();
        for (SignalServiceProtos.CallMessage.IceUpdate msg : iceMessages) {
            callid = msg.getId();
            ice.add(msg.getOpaque().toByteArray());
        }
        LOG.info("Dealing with received icecandidates, callid = " + callid + " and activecallid = " + this.activeCall.getCallId());
        this.tringBridge.receivedIce(callid, senderDeviceId, ice);
    }

    void ensureTringBridge() {
        if (!this.nativeTring) {
            return;
        }
        if (this.tringBridge == null) {
            byte[] me = UUIDUtil.toByteArray((UUID)this.waveManager.getAccount().getUser().aci().getRawUUID());
            this.tringBridge = new TringBridge((TringApi)this, me);
        }
    }

    public byte[] getCallLinkBytes(String url) {
        this.ensureTringBridge();
        return this.tringBridge.getCallLinkBytes(url);
    }

    void cleanupCall() {
        LOG.info("CLEANCALL, state = " + String.valueOf(this.activeCall.state().get()));
        this.stopSendingVideo();
        this.stopAcceptingVideo();
        try {
            CallKey callKey = this.callDb.findByCallId(this.activeCall.getCallId());
            CallDbRecord record = (CallDbRecord)this.callDb.findByKey((EntityKey)callKey);
            this.waveManager.processCallEnded(record);
            this.waveManager.getWaveClient().gotCallUpdate(null);
            LOG.info("set activeCall to null NOW");
            this.activeCall = null;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    void checkActiveCall() {
        if (this.activeCall == null) {
            LOG.severe("We need an active call, but don't have one!");
            throw new IllegalArgumentException("No active call!");
        }
    }

    public void statusCallback(long callId, long peerId, int direction, int type) {
        LOG.info("Got statusCall with dir = " + direction + " and type = " + type + " and callId = " + callId + " and activeCallId = " + this.activeCall.getCallId());
        if (direction == 0) {
            this.handleIncomingCall(callId);
            return;
        }
        if (direction == 1) {
            this.handleOutgoingCall(callId);
            return;
        }
        if (direction == 10) {
            this.checkActiveCall();
            boolean incoming = this.activeCall.getDirection() == Call.Direction.IN;
            LOG.info("Call with state " + String.valueOf((Object)this.activeCall.getState()) + " will be moved to state " + (incoming ? "LOCAL_RINGING" : "REMOTE_RINGING"));
            this.activeCall.modifyState(incoming ? Call.CallState.LOCAL_RINGING : Call.CallState.REMOTE_RINGING);
            this.waveManager.clientNotifyCallMessage(callId, InfoMessage.Type.INFO_NONE, System.currentTimeMillis());
        }
        if (direction == 20) {
            this.checkActiveCall();
            LOG.info("Call with state " + String.valueOf((Object)this.activeCall.getState()) + " will be moved to state CONNECTED");
            this.activeCall.modifyState(Call.CallState.CONNECTED);
            LOG.info("We are notified about state CONNECTED. Enable outgoing video? " + this.outgoingVideo);
            if (this.outgoingVideo) {
                this.tringBridge.enableOutgoingVideo(true);
            }
        }
        if (direction == 40) {
            this.checkActiveCall();
            LOG.info("Call with state " + String.valueOf(this.activeCall.state().get()) + " will be moved to state TERMINATED");
            this.activeCall.modifyState(Call.CallState.TERMINATED);
            this.cleanupCall();
        }
        if (direction == 70) {
            LOG.info("call state changed to ended, but no signaling needed");
        }
        if (direction == 11) {
            LOG.info("Hangup, type = " + type + " and Device = " + peerId);
            if (type == 1) {
                this.acceptedOnOtherDevice(callId, (int)peerId);
            }
        }
        if (direction == 22) {
            if (type == 31) {
                LOG.info("Remote video enabled.");
                this.startAcceptingVideo();
            }
            if (type == 32) {
                LOG.info("Remote video disabled.");
                this.stopAcceptingVideo();
            }
            if (type == 33) {
                LOG.info("Remote ScreenShare enabled");
            }
            if (type == 34) {
                LOG.info("Remote ScreenShare disabled");
            }
        }
    }

    public void answerCallback(byte[] opaque) {
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        boolean multiring = true;
        LOG.info("We are asked by tring to send answer to the other side.");
        long callId = this.activeCall.getCallId();
        AnswerMessage answerMessage = new AnswerMessage(callId, null, opaque);
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setAnswer(SignalServiceProtos.CallMessage.Answer.newBuilder().setOpaque(ByteString.copyFrom((byte[])opaque)).setId(callId)).build();
        this.sendCallMessage(message);
        LOG.info("Done sending answer to the other side");
    }

    public void offerCallback(byte[] opaque) {
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        boolean multiring = true;
        LOG.info("Send offer, opaque = " + Arrays.toString(opaque));
        LOG.info("And activeCall = " + String.valueOf(this.activeCall) + " with recipient = " + String.valueOf(this.activeCall.getRecipient()) + " and otherdevice = " + this.activeCall.getOtherDeviceId());
        long callId = this.activeCall.getCallId();
        OfferMessage offerMessage = new OfferMessage(callId, null, OfferMessage.Type.AUDIO_CALL, opaque);
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setOffer(SignalServiceProtos.CallMessage.Offer.newBuilder().setId(callId).setType(this.activeCall.getType() == CallDbRecord.Type.VIDEO_CALL ? SignalServiceProtos.CallMessage.Offer.Type.OFFER_VIDEO_CALL : SignalServiceProtos.CallMessage.Offer.Type.OFFER_AUDIO_CALL).setOpaque(ByteString.copyFrom((byte[])opaque))).build();
        SignalServiceCallMessage sscm = SignalServiceCallMessage.forOffer((OfferMessage)offerMessage, (boolean)multiring, broadcast ? null : Integer.valueOf(this.activeCall.getOtherDeviceId()));
        this.sendCallMessage(message);
        LOG.info("Done sending answer");
    }

    public void iceUpdateCallback(List<byte[]> iceCandidates) {
        LOG.info("App is notified by ringrtc that we have local iceCandidates");
        boolean broadcast = this.activeCall.getOtherDeviceId() < 0;
        long callId = this.activeCall.getCallId();
        SignalServiceProtos.CallMessage.Builder callMessageBuilder = SignalServiceProtos.CallMessage.newBuilder();
        for (byte[] iceBytes : iceCandidates) {
            callMessageBuilder.addIceUpdate(SignalServiceProtos.CallMessage.IceUpdate.newBuilder().setId(callId).setOpaque(ByteString.copyFrom((byte[])iceBytes)));
        }
        List<IceUpdateMessage> iceUpdateMessages = iceCandidates.stream().map(c -> new IceUpdateMessage(this.activeCall.getCallId(), c, null)).toList();
        if (!broadcast) {
            callMessageBuilder.setDestinationDeviceId(this.activeCall.getOtherDeviceId());
        }
        SignalServiceProtos.CallMessage callMessage = callMessageBuilder.build();
        LOG.info("sending " + iceUpdateMessages.size() + " iceupdates to other party, other deviceId = " + this.activeCall.getOtherDeviceId());
        LOG.info("Sending iceUpdate to other party");
        this.sendCallMessage(callMessage);
        LOG.info("Done sending iceUpdate to other party");
    }

    public void groupCallUpdateRing(byte[] groupIdentifier, long ringId, byte[] senderBytes, int statusByte) {
        try {
            LOG.info("App is notified by ringrtc that we have a groupcall update, new statusByte = " + statusByte);
            RingUpdate status = RingUpdate.from(statusByte);
            GroupRecord target = this.waveManager.getGroupByGroupIdentifier(groupIdentifier);
            LOG.info("Call is for group " + String.valueOf(target) + " and status = " + String.valueOf((Object)status));
            GroupExternalCredential groupExternalCredential = this.waveManager.getGroupService().getGroupExternalCredential(target.getMasterKey());
            ByteBuffer buff = groupExternalCredential.getTokenBytes().asReadOnlyByteBuffer();
            int len = buff.remaining();
            LOG.info("buff has " + len + " bytes");
            byte[] token = new byte[len];
            buff.get(token);
            byte[] gm = this.getGroupMemberInfo(target);
            LOG.info("Will now peek groupcall");
            this.tringBridge.peekGroupCall(token, gm);
            LOG.info("Peeked groupcall");
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public byte[] requestGroupMemberInfo(byte[] groupId) {
        GroupRecord target = this.waveManager.getGroupByGroupIdentifier(groupId);
        return this.getGroupMemberInfo(target);
    }

    public byte[] getGroupMemberInfo(GroupRecord target) {
        Map<UUID, UuidCiphertext> uuidCipherTexts = this.waveManager.getGroupService().getUuidCipherTexts(target.getMasterKey(), target.key());
        int expected = 81 * uuidCipherTexts.size();
        ByteBuffer bb = ByteBuffer.allocate(expected);
        for (Map.Entry<UUID, UuidCiphertext> entry : uuidCipherTexts.entrySet()) {
            UUID key = entry.getKey();
            bb.putLong(key.getMostSignificantBits());
            bb.putLong(key.getLeastSignificantBits());
            byte[] ct = entry.getValue().serialize();
            System.err.println("CTLEN = " + ct.length);
            bb.put(ct);
        }
        byte[] gm = bb.array();
        return gm;
    }

    public void receivedGroupCallPeekForRingingCheck(PeekInfo peekInfo) {
        LOG.info("Ringingcheck, peekInfo = " + String.valueOf(peekInfo) + " with eraId = " + peekInfo.getEraId());
        LOG.info("Joined members = " + String.valueOf(peekInfo.getJoinedMembers()) + " and deviceCount = " + peekInfo.getDeviceCount());
        if (peekInfo.getDeviceCount() == 0L) {
            LOG.warning("No devices in call! Exit.");
            this.setActiveCall(null);
            return;
        }
        UUID mine = this.waveManager.getAccount().getUser().aci().getRawUUID();
        if (peekInfo.getJoinedMembers().contains(mine)) {
            LOG.warning("I am already in the joined list, exit!");
            return;
        }
        LOG.info("Requesting new ring");
        this.activeCall.state().set((Object)Call.CallState.LOCAL_RINGING);
        this.activeCall.state().set((Object)(this.activeCall.getDirection() == Call.Direction.IN ? Call.CallState.LOCAL_RINGING : Call.CallState.REMOTE_RINGING));
        this.waveManager.getWaveClient().gotCallUpdate(this.activeCall);
    }

    public byte[] requestGroupMembershipToken(byte[] groupIdentifier) {
        GroupRecord target = this.waveManager.getGroupByGroupIdentifier(groupIdentifier);
        byte[] token = new byte[]{};
        try {
            token = this.waveManager.getGroupService().getGroupExternalCredential(target.getMasterKey()).getTokenBytes().toByteArray();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return token;
    }

    public void sendOpaqueGroupCallMessage(byte[] groupIdentifier, byte[] opaque, int urgency) {
        GroupRecord target = this.waveManager.getGroupByGroupIdentifier(groupIdentifier);
        SignalServiceProtos.CallMessage callMessage = SignalServiceProtos.CallMessage.newBuilder().setOpaque(SignalServiceProtos.CallMessage.Opaque.newBuilder().setData(ByteString.copyFrom((byte[])opaque)).setUrgency(SignalServiceProtos.CallMessage.Opaque.Urgency.forNumber((int)urgency))).build();
        LOG.info("Send to " + String.valueOf(target));
        try {
            this.signalBridge.sendGroupCallMessage(target, callMessage);
        }
        catch (IOException ex) {
            Logger.getLogger(WaveCallManager.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
    }

    public void sendOpaqueCallMessage(byte[] recipient, byte[] opaque, int urgency) {
        LOG.info("Need to send opaquemessage, urgency = " + urgency + ", recipient = " + String.valueOf(recipient));
        OpaqueMessage opaqueMessage = new OpaqueMessage(opaque, OpaqueMessage.Urgency.DROPPABLE);
        SignalServiceCallMessage msg = SignalServiceCallMessage.forOpaque((OpaqueMessage)opaqueMessage, (boolean)true, null);
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setOpaque(SignalServiceProtos.CallMessage.Opaque.newBuilder().setData(ByteString.copyFrom((byte[])opaque))).build();
        ServiceId serviceId = null;
        try {
            serviceId = ServiceId.parseFromBinary((byte[])recipient);
            Optional<UserRecord> userByServiceId = this.userService.getUserByServiceId(serviceId);
            UserRecord destUser = userByServiceId.get();
            this.signalBridge.sendCallMessage(destUser, message);
        }
        catch (ServiceId.InvalidServiceIdException ex) {
            Logger.getLogger(WaveCallManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void updateRemoteDevices(List<Long> demuxIds) {
        LOG.info("Update demuxIds to " + String.valueOf(demuxIds));
        Thread.dumpStack();
        this.demuxIds = demuxIds;
        if (demuxIds.size() > 0 && this.activeCall.getState() != Call.CallState.CONNECTED) {
            this.activeCall.modifyState(Call.CallState.CONNECTED);
        }
    }

    private void handleIncomingCall(long callId) {
        LOG.info("startCall asked with callId = " + callId + " and activeCallId = " + this.activeCall.getCallId());
        TurnServerInfo tsi = this.retrieveTurnServers();
        LOG.info("statusCall will now invoke proceed");
        this.tringBridge.proceed(callId, tsi.getUsername(), tsi.getPassword(), "", tsi.getUrls());
        LOG.info("statusCall proceeded");
    }

    private void handleOutgoingCall(long callId) {
        LOG.info("startCall asked with callId = " + callId);
        if (this.activeCall.getCallId() != callId) {
            LOG.severe("Wrong callId!");
        }
        TurnServerInfo tsi = this.retrieveTurnServers();
        LOG.info("statusCall will now invoke proceed");
        this.tringBridge.proceed(callId, tsi.getUsername(), tsi.getPassword(), "", tsi.getUrls());
        LOG.info("statusCall proceeded, outgoing video = " + this.outgoingVideo);
        if (this.outgoingVideo) {
            this.tringBridge.enableOutgoingVideo(true);
            this.enableVideoCall(true);
        }
    }

    private void acceptedOnOtherDevice(long callId, int deviceId) {
        SignalServiceProtos.CallMessage message = SignalServiceProtos.CallMessage.newBuilder().setHangup(SignalServiceProtos.CallMessage.Hangup.newBuilder().setId(callId).setType(SignalServiceProtos.CallMessage.Hangup.Type.HANGUP_ACCEPTED).setDeviceId(deviceId)).build();
        this.sendCallMessage(message);
    }

    private void startSendingVideo() {
        this.tringBridge.enableOutgoingVideo(true);
        LOG.warning("VIDEO NOW ENABLED");
    }

    private void stopSendingVideo() {
        this.cameraManager.stopListening();
        this.tringBridge.enableOutgoingVideo(false);
    }

    private void startAcceptingVideo() {
        this.acceptVideo = true;
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    long l0 = System.currentTimeMillis();
                    long c0 = 0L;
                    long c1 = 0L;
                    while (WaveCallManager.this.acceptVideo) {
                        TringFrame frame;
                        int demuxId = 0;
                        if (WaveCallManager.this.demuxIds != null && !WaveCallManager.this.demuxIds.isEmpty()) {
                            LOG.info("Retrieve demuxId " + String.valueOf(WaveCallManager.this.demuxIds.get(0)));
                            demuxId = (Integer)WaveCallManager.this.demuxIds.get(0);
                        }
                        if ((frame = WaveCallManager.this.tringBridge.getRemoteVideoFrame((long)demuxId)) != null) {
                            LOG.info("Got frame w = " + frame.width + " and h = " + frame.height + " and demuxId = " + demuxId);
                            WaveCallManager.this.activeCall.addImage(frame.width, frame.height, frame.data);
                            ++c0;
                        } else {
                            ++c1;
                        }
                        long l1 = System.currentTimeMillis();
                        LOG.info("took " + (l1 - l0) + " ms, c0 = " + c0 + ", c1 = " + c1);
                        l0 = l1;
                        Thread.sleep(10L);
                    }
                    if (WaveCallManager.this.activeCall != null) {
                        WaveCallManager.this.activeCall.addImage(0, 0, new byte[0]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void stopAcceptingVideo() {
        this.acceptVideo = false;
    }

    private void gotSelfFrame(CameraManager.Frame frame) {
        LOG.info("We got a self frame, callstate = " + String.valueOf(this.activeCall.state().get()));
        this.activeCall.addMyImage(frame.getWidth(), frame.getHeight(), frame.getPixelFormat(), frame.getData());
        if (this.activeCall.state().get() == Call.CallState.CONNECTED) {
            if (frame.getPixelFormat() > 100) {
                frame = new CameraManager.Frame(frame.getWidth(), frame.getHeight(), 0, frame.getData());
            }
            this.sendVideoFrame(frame);
        }
    }

    private void sendVideoFrame(CameraManager.Frame frame) {
        LOG.info("Send videoFrame from Equation to Tring, pixelFormat = " + frame.getPixelFormat());
        this.tringBridge.sendVideoFrame(frame.getWidth(), frame.getHeight(), frame.getPixelFormat(), frame.getData());
    }

    TurnServerInfo retrieveTurnServers() {
        try {
            TurnServerInfo turnServerInfo = this.waveManager.getAccountManager().getTurnServerInfo();
            return turnServerInfo;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private int getLocalDeviceId() {
        return this.waveStore.getCredentialsProvider().getDeviceId();
    }

    void sendCallMessage(SignalServiceProtos.CallMessage sscm) {
        this.signalBridge.sendCallMessage(this.activeCall.getRecipient(), sscm);
    }

    public void processCallEvent(SignalServiceProtos.SyncMessage.CallEvent callEvent) {
        if (this.dbHasCallId(callEvent.getId())) {
            LOG.info("We already have a call in db with this id, don't store again.");
            return;
        }
        ByteString bs = callEvent.getConversationId();
        UUID uuid = UUIDUtil.bytesToUuid((byte[])bs.toByteArray());
        ServiceId.Aci aci = new ServiceId.Aci(uuid);
        if (aci != null) {
            this.userService.getUserByServiceId((ServiceId)aci).ifPresent(user -> {
                long callId = callEvent.getId();
                RecipientKey recipientKey = user.recipient().key();
                CallDbRecord.Type callType = switch (callEvent.getType()) {
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.AUDIO_CALL -> CallDbRecord.Type.AUDIO_CALL;
                    case SignalServiceProtos.SyncMessage.CallEvent.Type.VIDEO_CALL -> CallDbRecord.Type.VIDEO_CALL;
                    default -> CallDbRecord.Type.UNKNOWN;
                };
                this.callDb.createIncomingCall(callId, recipientKey, recipientKey, callType);
            });
        }
    }

    public void processCallLogEvent(SignalServiceProtos.SyncMessage.CallLogEvent callLogEvent) {
        LOG.info("Process callLogEvent " + String.valueOf(callLogEvent));
        LOG.log(Level.SEVERE, "CallLogEvent not yet supported");
    }

    boolean dbHasCallId(long callId) {
        try {
            if (this.callDb.findByCallId(callId) != null) {
                LOG.info("We already have a call in db with this id, don't store again.");
                return true;
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public List<CallRecord> getAllCalls() {
        try {
            return this.callDb.findAll().stream().map(this::getCallRecordFromDb).toList();
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public CallRecord getCallRecordFromDb(CallDbRecord db) {
        UserRecord userRecord = this.userService.getUserByRecipientKey(db.ringerRecipient().key());
        return new CallRecord(db.key(), db.outgoing(), db.conversationRecipient(), userRecord, db.type(), db.state(), db.timestamp());
    }

    public void processCallLinkUpdate(SignalServiceProtos.SyncMessage.CallLinkUpdate callLinkUpdate) {
        LOG.severe("CallLink update not yet supported!");
        LOG.info("clu = " + String.valueOf(callLinkUpdate));
    }

    public static enum RingUpdate {
        REQUESTED(0),
        EXPIRED_REQUEST(1),
        ACCEPTED_ON_ANOTHER_DEVICE(2),
        DECLINED_ON_ANOTHER_DEVICE(3),
        BUSY_LOCALLY(4),
        BUSY_ON_ANOTHER_DEVICE(5),
        CANCELED_BY_RINGER(6);

        int val;

        private RingUpdate(int v) {
            this.val = v;
        }

        public static RingUpdate from(int v) {
            for (RingUpdate candidate : RingUpdate.values()) {
                if (candidate.val != v) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Ringupdate with value " + v + " doesn't exist.");
        }
    }
}

