/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import com.google.protobuf.ByteString;
import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.AccountManager;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.net.NetworkAPI;
import io.privacyresearch.equation.net.StorageNetworkAPI;
import io.privacyresearch.equation.storage.SignalStorageModels;
import io.privacyresearch.equation.storage.SignalStorageRecord;
import io.privacyresearch.equation.user.Account;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.util.Goodies;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.push.exceptions.NoContentException;
import org.whispersystems.signalservice.api.storage.SignalStorageCipher;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageCipherKey;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageItemKey;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.storage.StorageManifestKey;
import org.whispersystems.signalservice.internal.SignalServiceProtos;
import org.whispersystems.signalservice.internal.storage.AccountRecord;
import org.whispersystems.signalservice.internal.storage.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.StorageItem;
import org.whispersystems.signalservice.internal.storage.StorageManifest;
import org.whispersystems.signalservice.internal.storage.StorageRecord;
import org.whispersystems.signalservice.internal.storage.WriteOperation;

public class StorageManager {
    private final AccountManager accountManager;
    private SignalStorageManifest localManifest;
    private final EquationManager waveManager;
    private final SqliteStorageBean sqliteStorageBean;
    private final int localDeviceId;
    private final StorageNetworkAPI storageNetworkAPI;
    private final NetworkAPI networkAPI;
    private StorageKey storageKey;
    private static final Logger LOG = Logger.getLogger(StorageManager.class.getName());

    public StorageManager(EquationManager waveManager) {
        this.waveManager = waveManager;
        this.accountManager = waveManager.getAccountManager();
        this.localDeviceId = waveManager.getLocalDeviceId();
        this.sqliteStorageBean = waveManager.getSqliteStorageBean();
        this.networkAPI = waveManager.getSignalBridge().getNetworkAPI();
        this.storageNetworkAPI = waveManager.getSignalBridge().getNetworkAPI().getStorageNetworkAPI();
    }

    private void ensureStorageKey() {
        if (this.storageKey == null) {
            LOG.info("No storageKey locally yet, retrieve from DB");
            this.storageKey = this.getStorageKey();
            if (this.storageKey == null) {
                LOG.info("No storageKey in DB, requested from Signal Server");
                return;
            }
        }
    }

    public void syncStorage() {
        LOG.info("SyncStorage");
        try {
            if (this.storageKey == null) {
                LOG.info("No storageKey locally yet, retrieve from DB");
                this.storageKey = this.getStorageKey();
                if (this.storageKey == null) {
                    LOG.info("No storageKey in DB, requested from Signal Server");
                    return;
                }
            }
            LOG.info("StorageKey = " + Goodies.obfuscate(this.storageKey.serialize()));
            SignalStorageManifest storageManifest = this.getStorageManifest(this.storageKey);
            LOG.info("StorageManifest = " + String.valueOf(storageManifest) + " with version = " + storageManifest.getVersion());
            LOG.finest("StorageIds = " + String.valueOf(storageManifest.getStorageIdsByType()));
            List<StorageId> storageIds = storageManifest.getStorageIds();
            LOG.info("Got " + storageIds.size() + " storageIds and manifest version = " + storageManifest.getVersion());
            try {
                storageIds = this.removeByType(storageIds, 5);
                LOG.info("After removing distribution ids, we have " + storageIds.size() + " left.");
                storageIds = this.removeByType(storageIds, 6);
                LOG.info("After removing stickerpack ids, we have " + storageIds.size() + " left.");
                List<StorageId> localGroups = this.sqliteStorageBean.getRecipientData().getGroupV2StorageIds().stream().map(storageId -> StorageId.forGroupV2((byte[])storageId)).toList();
                storageIds = this.removeExisting(storageIds, localGroups);
                LOG.info("After removing exiting group ids (" + localGroups.size() + "), we have " + storageIds.size() + " left.");
                List localUsers = this.sqliteStorageBean.getRecipientData().getContactStorageIds().stream().map(storageId -> StorageId.forContact((byte[])storageId)).collect(Collectors.toCollection(ArrayList::new));
                LOG.info("We got local info about " + localUsers.size() + " contacts");
                byte[] raw = this.sqliteStorageBean.getRecipientData().getStorageIdByRecipientKey(this.waveManager.getAccount().getUser().recipient().key());
                localUsers.add(StorageId.forAccount((byte[])raw));
                storageIds = this.removeExisting(storageIds, localUsers);
                LOG.info("After removing exiting user ids, we have " + storageIds.size() + " left.");
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "(caught) error when trying to diff StorageIds", t);
            }
            Optional accountStorageId = storageManifest.getAccountStorageId();
            byte[] ikm = storageManifest.getIkm();
            List<SignalStorageRecord> records = this.accountManager.readStorageRecords(this.storageKey, storageIds, ikm);
            ExecutorService syncStorageWorkerService = Executors.newFixedThreadPool(8);
            for (SignalStorageRecord record : records) {
                LOG.info("Record " + String.valueOf(record) + " with type " + record.getType());
                LOG.info("Record " + String.valueOf(record) + " with id " + String.valueOf(Base64.getEncoder().encode(record.getId().getRaw())) + " and type " + record.getType());
                try {
                    if (record.isGroupV2()) {
                        this.waveManager.processGroup(record);
                    }
                    if (record.isContact()) {
                        this.waveManager.processContact(record, syncStorageWorkerService);
                    }
                    if (!record.isAccount()) continue;
                    this.waveManager.processAccount(record);
                }
                catch (Exception e) {
                    System.err.println("ERR!!! " + String.valueOf(e));
                    LOG.log(Level.SEVERE, "Major error parsing a storagerecord", e);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
            LOG.severe("Our StorageKey is invalid. Request a new one and return.");
            try {
                this.storageKey = null;
                this.requestStorageKey();
                return;
            }
            catch (IOException ex1) {
                LOG.log(Level.SEVERE, null, ex1);
            }
        }
    }

    List<StorageId> removeByType(List<StorageId> storageIds, int type) {
        return storageIds.stream().filter(sid -> sid.getType() != type).toList();
    }

    List<StorageId> removeExisting(List<StorageId> remote, List<StorageId> local) {
        LOG.fine("#elements in local list = " + local.size());
        return remote.stream().filter(rem -> !local.contains(rem)).toList();
    }

    public void updateStorageAccount(Account act) throws IOException, InvalidKeyException {
        LOG.info("update " + String.valueOf(act));
        StorageKey sk = this.waveManager.getStorageKey();
        SignalStorageManifest manifest = this.localManifest != null ? this.getStorageManifestIfDifferentVersion(sk, this.localManifest.getVersion()).orElse(this.localManifest) : this.getStorageManifest(sk);
        List storageIds = manifest.getStorageIds();
        byte[] ikm = manifest.getIkm();
        LOG.info("storageIds = " + String.valueOf(storageIds));
        List<StorageId> accounts = storageIds.stream().filter(sid -> sid.getType() == 4).toList();
        if (accounts.size() == 0) {
            throw new IllegalArgumentException("No account in manifest");
        }
        if (accounts.size() > 1) {
            throw new IllegalArgumentException("More than 1 account in manifest");
        }
        StorageId accountStorageId = accounts.get(0);
        List<SignalStorageRecord> records = this.accountManager.readStorageRecords(sk, List.of(accountStorageId), ikm);
        if (records.size() != 1) {
            throw new IllegalArgumentException("Required exactly 1 record");
        }
        SignalStorageRecord ssr = records.get(0);
        LOG.finest("Old record = " + String.valueOf(ssr.getRecord()));
        StorageRecord.Builder storageRecordBuilder = this.merge(ssr.getRecord(), act);
        StorageRecord storageRecord = storageRecordBuilder.build();
        LOG.finest("New record = " + String.valueOf(storageRecord));
        StorageId newStorageId = this.sendStorageUpdate(storageRecordBuilder.build(), accountStorageId, ikm, 4, manifest);
        LOG.info("Done uploading new manifest, new storageId = " + String.valueOf(newStorageId));
        SignalServiceProtos.SyncMessage syncMessage = SignalServiceProtos.SyncMessage.newBuilder().setFetchLatest(SignalServiceProtos.SyncMessage.FetchLatest.newBuilder().setType(SignalServiceProtos.SyncMessage.FetchLatest.Type.STORAGE_MANIFEST)).build();
        this.waveManager.getSignalBridge().sendSyncMessage(syncMessage);
        LOG.info("Done sending sync message to other devices");
    }

    public void setMuteUntil(RecipientKey recipientKey, long muteUntil) throws IOException, InvalidKeyException {
        LOG.info("Will set mute for " + String.valueOf(recipientKey) + " to " + muteUntil);
        SignalStorageManifest oldManifest = this.getStorageManifest(this.storageKey);
        byte[] ikm = oldManifest.getIkm();
        RecipientRecord recipientRecord = (RecipientRecord)this.sqliteStorageBean.getRecipientData().findByKey((EntityKey)recipientKey);
        byte[] raw = this.sqliteStorageBean.getRecipientData().getStorageIdByRecipientKey(recipientKey);
        StorageId storageId = recipientRecord.isGroup() ? StorageId.forGroupV2((byte[])raw) : StorageId.forContact((byte[])raw);
        SignalStorageRecord storageRecord = this.getStorageRecord(storageId);
        LOG.finest("Got storageRecord " + String.valueOf(storageRecord) + " with real record " + String.valueOf(storageRecord.getRecord()));
        StorageRecord.Builder newStorageRecordBuilder = StorageRecord.newBuilder((StorageRecord)storageRecord.getRecord());
        int type = 0;
        if (storageRecord.isContact()) {
            newStorageRecordBuilder.getContactBuilder().setMutedUntilTimestamp(muteUntil);
            type = 1;
        } else {
            newStorageRecordBuilder.getGroupV2Builder().setMutedUntilTimestamp(muteUntil);
            type = 3;
        }
        StorageRecord newStorageRecord = newStorageRecordBuilder.build();
        StorageId newStorageId = this.sendStorageUpdate(newStorageRecord, storageId, ikm, type, oldManifest);
        this.sqliteStorageBean.getRecipientData().updateUserRecipient(recipientKey, newStorageId.getRaw(), RecipientRecord.Type.CONTACT);
        LOG.info("Done setting mute for " + String.valueOf(recipientKey) + " to " + muteUntil);
    }

    StorageId sendStorageUpdate(StorageRecord newStorageRecord, StorageId oldStorageId, byte[] ikm, int type, SignalStorageManifest oldManifest) throws IOException {
        byte[] rawId = new byte[16];
        Random r = new Random();
        r.nextBytes(rawId);
        StorageId storageId = StorageId.forType((byte[])rawId, (int)type);
        StorageItemKey itemKey = this.storageKey.deriveItemKey(rawId, ikm);
        LOG.finest("New storageRecord = " + String.valueOf(newStorageRecord));
        byte[] encryptedRecord = SignalStorageCipher.encrypt((StorageCipherKey)itemKey, (byte[])newStorageRecord.toByteArray());
        StorageItem storageItem = StorageItem.newBuilder().setKey(ByteString.copyFrom((byte[])rawId)).setValue(ByteString.copyFrom((byte[])encryptedRecord)).build();
        List storageIds = oldManifest.getStorageIds();
        storageIds.remove(oldStorageId);
        storageIds.add(storageId);
        long manifestVersion = oldManifest.getVersion() + 1L;
        StorageManifestKey manifestKey = this.storageKey.deriveManifestKey(manifestVersion);
        ManifestRecord.Builder manifestRecordBuilder = ManifestRecord.newBuilder().setRecordIkm(ByteString.copyFrom((byte[])oldManifest.getIkm())).setSourceDevice(this.localDeviceId).setVersion(manifestVersion);
        for (StorageId id : storageIds) {
            ManifestRecord.Identifier idProto = ManifestRecord.Identifier.newBuilder().setRaw(ByteString.copyFrom((byte[])id.getRaw())).setTypeValue(id.getType()).build();
            manifestRecordBuilder.addIdentifiers(idProto);
        }
        ManifestRecord newManifestRecord = manifestRecordBuilder.build();
        LOG.finest("Ready to upload new manifestrecord: " + String.valueOf(newManifestRecord));
        byte[] encryptedManifestRecord = SignalStorageCipher.encrypt((StorageCipherKey)manifestKey, (byte[])newManifestRecord.toByteArray());
        StorageManifest storageManifest = StorageManifest.newBuilder().setVersion(manifestVersion).setValue(ByteString.copyFrom((byte[])encryptedManifestRecord)).build();
        WriteOperation.Builder writeBuilder = WriteOperation.newBuilder().setManifest(storageManifest);
        writeBuilder.addInsertItem(storageItem);
        String authToken = this.networkAPI.getStorageAuth();
        this.networkAPI.getStorageNetworkAPI().writeStorageItems(authToken, writeBuilder.build());
        SignalServiceProtos.SyncMessage syncMessage = SignalServiceProtos.SyncMessage.newBuilder().setFetchLatest(SignalServiceProtos.SyncMessage.FetchLatest.newBuilder().setType(SignalServiceProtos.SyncMessage.FetchLatest.Type.STORAGE_MANIFEST)).build();
        this.waveManager.getSignalBridge().sendSyncMessage(syncMessage);
        return storageId;
    }

    private SignalStorageRecord getStorageRecord(StorageId storageId) throws IOException, InvalidKeyException {
        this.ensureStorageKey();
        String authToken = this.networkAPI.getStorageAuth();
        StorageKey sk = this.waveManager.getStorageKey();
        StorageManifest manifest = this.localManifest != null ? this.storageNetworkAPI.getStorageManifestIfDifferentVersion(authToken, this.localManifest.getVersion()) : this.storageNetworkAPI.getStorageManifest(authToken);
        byte[] rawRecord = SignalStorageCipher.decrypt((StorageCipherKey)this.storageKey.deriveManifestKey(manifest.getVersion()), (byte[])manifest.getValue().toByteArray());
        ManifestRecord manifestRecord = ManifestRecord.parseFrom((byte[])rawRecord);
        byte[] ikm = manifestRecord.getRecordIkm().toByteArray();
        List<SignalStorageRecord> records = this.accountManager.readStorageRecords(this.storageKey, List.of(storageId), ikm);
        return records.get(0);
    }

    private StorageRecord.Builder merge(StorageRecord orig, Account act) {
        StorageRecord.Builder result = StorageRecord.newBuilder((StorageRecord)orig);
        AccountRecord.Builder builder = result.getAccountBuilder();
        try {
            builder.clearPinnedConversations();
            List<ChannelRecord> pinned = this.waveManager.getSqliteStorageBean().getChannelData().findAll().stream().filter(cr -> cr.pinned()).toList();
            LOG.info("pinned conversations = " + String.valueOf(pinned));
            for (ChannelRecord channelRecord : pinned) {
                if (channelRecord.recipient().isGroup()) {
                    RecipientKey recipientKey = channelRecord.recipient().key();
                    GroupRecord groupRecord = this.waveManager.getGroupRecordByRecipientKey(recipientKey);
                    byte[] mkb = groupRecord.masterKeyBytes();
                    AccountRecord.PinnedConversation pc = AccountRecord.PinnedConversation.newBuilder().setGroupMasterKey(ByteString.copyFrom((byte[])mkb)).build();
                    builder.addPinnedConversations(pc);
                    continue;
                }
                UserRecord userRecord = this.waveManager.getUserByRecipientKey(channelRecord.recipient().key());
                AccountRecord.PinnedConversation pc = AccountRecord.PinnedConversation.newBuilder().setContact(AccountRecord.PinnedConversation.Contact.newBuilder().setServiceId(userRecord.aci().toServiceIdString()).build()).build();
                builder.addPinnedConversations(pc);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private AccountRecord merge(AccountRecord orig, Account act) {
        AccountRecord.Builder builder = AccountRecord.newBuilder((AccountRecord)orig);
        try {
            builder.clearPinnedConversations();
            List<ChannelRecord> pinned = this.waveManager.getSqliteStorageBean().getChannelData().findAll().stream().filter(cr -> cr.pinned()).toList();
            for (ChannelRecord channelRecord : pinned) {
                if (!channelRecord.recipient().isGroup()) continue;
                RecipientKey recipientKey = channelRecord.recipient().key();
                GroupRecord groupRecord = this.waveManager.getGroupRecordByRecipientKey(recipientKey);
                byte[] mkb = groupRecord.masterKeyBytes();
                AccountRecord.PinnedConversation pc = AccountRecord.PinnedConversation.newBuilder().setGroupMasterKey(ByteString.copyFrom((byte[])mkb)).build();
                builder.addPinnedConversations(pc);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return builder.build();
    }

    public static StorageItem storageRecordToItem(StorageRecord record, StorageKey storageKey) {
        byte[] storageId = new byte[]{};
        StorageItemKey itemKey = storageKey.deriveItemKey(storageId);
        byte[] encryptedRecord = SignalStorageCipher.encrypt((StorageCipherKey)itemKey, (byte[])record.toByteArray());
        return StorageItem.newBuilder().setKey(ByteString.copyFrom((byte[])storageId)).setValue(ByteString.copyFrom((byte[])encryptedRecord)).build();
    }

    public StorageKey getStorageKey() {
        if (this.storageKey == null) {
            this.storageKey = this.waveManager.getSqliteStorageBean().storage().getStorageKey();
            if (this.storageKey == null) {
                try {
                    this.requestStorageKey();
                }
                catch (IOException ex) {
                    LOG.severe("Could not request storageKey");
                    ex.printStackTrace();
                }
            }
        }
        return this.storageKey;
    }

    private void requestStorageKey() throws IOException {
        this.waveManager.getSignalBridge().requestStorageKey();
    }

    public Optional<SignalStorageManifest> getStorageManifestIfDifferentVersion(StorageKey storageKey, long manifestVersion) throws IOException, InvalidKeyException {
        try {
            String authToken = this.networkAPI.getStorageAuth();
            StorageManifest storageManifest = this.storageNetworkAPI.getStorageManifestIfDifferentVersion(authToken, manifestVersion);
            if (storageManifest.getValue().isEmpty()) {
                LOG.warning("Got an empty storage manifest!");
                return Optional.empty();
            }
            return Optional.of(SignalStorageModels.remoteToLocalStorageManifest(storageManifest, storageKey));
        }
        catch (NoContentException e) {
            return Optional.empty();
        }
    }

    public SignalStorageManifest getStorageManifest(StorageKey storageKey) throws IOException, InvalidKeyException {
        String authToken = this.networkAPI.getStorageAuth();
        return this.storageNetworkAPI.getSignalStorageManifest(authToken, storageKey);
    }
}

