/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl;

import com.gluonhq.snl.ConnectivityListener;
import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.google.protobuf.ByteString;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.net.SignalUrl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.WebSocket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.Network;
import org.whispersystems.signalservice.api.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.websocket.WebSocketProtos;

public class LibSignalNetworkClient
extends NetworkClient {
    private static final Logger LOG = Logger.getLogger(LibSignalNetworkClient.class.getName());
    final Optional<CredentialsProvider> cred;
    ChatConnection chatConnection;

    public LibSignalNetworkClient(NetworkMonitor monitor, SignalUrl url, Optional<CredentialsProvider> cp, String signalAgent, Optional<ConnectivityListener> connectivityListener, boolean allowStories) {
        super(monitor, url, cp, signalAgent, connectivityListener, allowStories);
        this.cred = cp;
        this.connect();
    }

    private void connect() {
        LOG.info("Try to connect");
        Network network = new Network(Network.Environment.PRODUCTION, "Wave1.2.74");
        ChatConnectionListener listener = new ChatConnectionListener(){

            public void onReceivedAlerts(ChatConnection chat, String[] alerts) {
                LOG.severe("Alerts for " + String.valueOf(chat) + ": " + String.valueOf(List.of(alerts)));
            }

            public void onQueueEmpty(ChatConnection chat) {
                LOG.info("Queue is empty");
                WebSocketProtos.WebSocketMessage msg = WebSocketProtos.WebSocketMessage.newBuilder().setType(WebSocketProtos.WebSocketMessage.Type.REQUEST).setRequest(WebSocketProtos.WebSocketRequestMessage.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[0])).setPath("/api/v1/queue/empty").setVerb("PUT")).build();
                try {
                    LibSignalNetworkClient.this.rawByteQueue.put(msg.toByteArray());
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(LibSignalNetworkClient.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            public void onIncomingMessage(ChatConnection chat, byte[] envelope, long serverDeliveryTimestamp, ChatConnectionListener.ServerMessageAck sendAck) {
                LOG.info("GOT INCOMING MESSAGE");
                try {
                    WebSocketProtos.WebSocketMessage msg = WebSocketProtos.WebSocketMessage.newBuilder().setType(WebSocketProtos.WebSocketMessage.Type.REQUEST).setRequest(WebSocketProtos.WebSocketRequestMessage.newBuilder().setBody(ByteString.copyFrom((byte[])envelope)).setPath("/api/v1/message").setVerb("PUT").setId(serverDeliveryTimestamp)).build();
                    LibSignalNetworkClient.this.rawByteQueue.put(msg.toByteArray());
                    LOG.info("Let's ack this message");
                    sendAck.send();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(LibSignalNetworkClient.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ChatServiceException ex) {
                    Logger.getLogger(LibSignalNetworkClient.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        try {
            this.chatConnection = this.cred.isPresent() ? (ChatConnection)network.connectAuthChat(this.cred.get().getAci().toServiceIdString() + "." + this.cred.get().getDeviceId(), this.cred.get().getPassword(), true, listener).get() : (ChatConnection)network.connectUnauthChat(listener).get();
            this.chatConnection.start();
            LOG.info("Created libsignalclient with cred? " + this.cred.isPresent() + ", this = " + String.valueOf(this) + " and chatConnection = " + String.valueOf(this.chatConnection));
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "error creating chatconnection", e);
        }
    }

    @Override
    void sendAck(WebSocketProtos.WebSocketResponseMessage response) {
        LOG.info("No ack needed");
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(HttpRequest request, byte[] raw) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected CompletableFuture<Response> implAsyncSendRequest(URI uri, String method, byte[] body, Map<String, List<String>> headers) throws IOException {
        return this.implAsyncSendRequest(uri, method, body, headers, -1L);
    }

    protected CompletableFuture<Response> implAsyncSendRequest(URI uri, String method, byte[] body, Map<String, List<String>> headers, long id) throws IOException {
        HashMap sHeaders = new HashMap();
        headers.forEach((key, vals) -> sHeaders.put(key, (String)vals.get(0)));
        Object path = uri.getPath();
        String query = uri.getQuery();
        if (query != null && !query.isBlank()) {
            path = (String)path + "?" + query;
        }
        LOG.info("Path = " + (String)path + ", id = " + id);
        ChatConnection.Request request = new ChatConnection.Request(method, (String)path, sHeaders, body, 10000);
        org.signal.libsignal.internal.CompletableFuture respC = this.chatConnection.send(request);
        return CompletableFuture.supplyAsync(() -> {
            try {
                LOG.info("Waiting on response from server, id  = " + id);
                ChatConnection.Response cResponse = (ChatConnection.Response)respC.get();
                LOG.info("Got response from server: " + String.valueOf(cResponse) + ", id = " + id);
                if (id != 0L) {
                    this.createAck(cResponse, id);
                }
                Response answer = new Response(cResponse.body(), cResponse.status());
                return answer;
            }
            catch (ExecutionException ee) {
                LOG.severe("Execution exception " + String.valueOf(ee));
                ee.getCause().printStackTrace();
                LOG.info("Cause = " + ee.getCause().getMessage());
                throw new IllegalArgumentException(ee);
            }
            catch (InterruptedException | CancellationException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException(ex);
            }
        });
    }

    void createAck(ChatConnection.Response cResponse, long id) throws InterruptedException {
        WebSocketProtos.WebSocketMessage msg = WebSocketProtos.WebSocketMessage.newBuilder().setType(WebSocketProtos.WebSocketMessage.Type.RESPONSE).setResponse(WebSocketProtos.WebSocketResponseMessage.newBuilder().setId(id).setStatus(200)).build();
        LOG.info("Create ack for id " + id);
        this.rawByteQueue.put(msg.toByteArray());
    }

    @Override
    public boolean supportsJson() {
        return true;
    }

    @Override
    void implCreateWebSocket(String baseUrl, String auth) throws IOException {
        LOG.info("already connected to websocket");
        this.setWsStatus(NetworkClient.WsStatus.READY);
        this.websocketCreated = true;
    }

    @Override
    protected CompletableFuture<WebSocket> implSendToStream(WebSocketProtos.WebSocketMessage msg, OutgoingPushMessageList list) throws IOException {
        try {
            LOG.info("Send message over stream to " + String.valueOf(this) + " and cred = " + this.cred.isPresent() + " and cc = " + String.valueOf(this.chatConnection) + " and msg = " + String.valueOf(msg));
            WebSocketProtos.WebSocketRequestMessage request = msg.getRequest();
            byte[] payload = request.getBody().toByteArray();
            long id = request.getId();
            LOG.info("path = " + request.getPath());
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (ByteString bs : request.getHeadersList().asByteStringList()) {
                String entry = bs.toStringUtf8();
                int col = entry.indexOf(":");
                String key = entry.substring(0, col);
                String val = entry.substring(col + 1);
                headers.put(key, List.of(val));
            }
            LOG.info("Headers = " + String.valueOf(headers) + " and id = " + id);
            CompletableFuture<Response> implAsyncSendRequest = this.implAsyncSendRequest(new URI(request.getPath()), request.getVerb(), payload, headers, id);
            CompletableFuture<WebSocket> answer = CompletableFuture.supplyAsync(() -> {
                LOG.info("Sending request to stream");
                try {
                    Response r = (Response)implAsyncSendRequest.get();
                    LOG.info("Got response from stream: " + String.valueOf(r));
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    throw new IllegalArgumentException();
                }
                return null;
            });
            return answer;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(LibSignalNetworkClient.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException();
        }
    }
}

