/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal.todo;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentRange {
    private static final Pattern PATTERN = Pattern.compile("versions (\\d+)-(\\d+)\\/(\\d+)");
    private final int rangeStart;
    private final int rangeEnd;
    private final int totalSize;

    public static Optional<ContentRange> parse(String header) {
        Matcher matcher;
        if (header != null && (matcher = PATTERN.matcher(header)).matches()) {
            return Optional.of(new ContentRange(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))));
        }
        return Optional.empty();
    }

    private ContentRange(int rangeStart, int rangeEnd, int totalSize) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.totalSize = totalSize;
    }

    public int getRangeStart() {
        return this.rangeStart;
    }

    public int getRangeEnd() {
        return this.rangeEnd;
    }

    public int getTotalSize() {
        return this.totalSize;
    }
}

