/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.SendGroupMessageResponse;
import com.gluonhq.snl.SendMessageResponse;
import com.google.protobuf.ByteString;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentStream;
import io.privacyresearch.equation.model.json.PreKeyResponse;
import io.privacyresearch.equation.model.json.PreKeyResponseItem;
import io.privacyresearch.equation.net.CancelationSignal;
import io.privacyresearch.equation.net.NetworkAPI;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidRegistrationIdException;
import org.signal.libsignal.protocol.NoSessionException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SessionBuilder;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.UsePqRatchet;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.groups.state.SenderKeyStore;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.protocol.state.PreKeyBundle;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.SignalServiceAccountDataStore;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.Util;
import org.whispersystems.signalservice.api.crypto.ContentHint;
import org.whispersystems.signalservice.api.crypto.EnvelopeContent;
import org.whispersystems.signalservice.api.crypto.SignalGroupSessionBuilder;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.crypto.SignalSessionBuilder;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccessPair;
import org.whispersystems.signalservice.api.crypto.UntrustedIdentityException;
import org.whispersystems.signalservice.api.messages.SendMessageResult;
import org.whispersystems.signalservice.api.push.GroupMismatchedDevices;
import org.whispersystems.signalservice.api.push.GroupStaleDevices;
import org.whispersystems.signalservice.api.push.MismatchedDevices;
import org.whispersystems.signalservice.api.push.OutgoingPushMessage;
import org.whispersystems.signalservice.api.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.StaleDevices;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.GroupMismatchedDevicesException;
import org.whispersystems.signalservice.api.push.exceptions.GroupStaleDevicesException;
import org.whispersystems.signalservice.api.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.StaleDevicesException;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class SignalSender {
    private static final Logger LOG = Logger.getLogger(SignalSender.class.getName());
    static int RETRY_COUNT = 3;
    static long maxEnvelopeSize = 0L;
    private final SignalServiceAccountDataStore aciStore;
    private final NetworkClient identifiedPipe;
    private final NetworkClient unidentifiedPipe;
    private final SignalServiceAddress localAddress;
    private final int localDeviceId;
    private final SignalSessionLock sessionLock;
    private final ServiceId.Pni localPni;
    private final IdentityKeyPair localPniIdentity;
    private final NetworkAPI networkAPI;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public SignalSender(NetworkAPI networkAPI, CredentialsProvider cp, SignalServiceDataStore store, SignalSessionLock lock) {
        LOG.info("Creating SignalSender with cp = " + String.valueOf(cp) + " and aci = " + String.valueOf(cp.getAci()));
        this.networkAPI = networkAPI;
        this.aciStore = store.aci();
        this.localAddress = new SignalServiceAddress((ServiceId)cp.getAci());
        this.localDeviceId = cp.getDeviceId();
        this.identifiedPipe = networkAPI.getIdentifiedClient();
        this.unidentifiedPipe = networkAPI.getUnidentifiedClient();
        this.sessionLock = lock;
        this.localPni = cp.getPni();
        this.localPniIdentity = store.pni().getIdentityKeyPair();
    }

    public SendMessageResult sendDataMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccessPair> unidentifiedAccess, ContentHint contentHint, SignalServiceProtos.DataMessage message, boolean urgent, boolean includePniSignature) throws UntrustedIdentityException, IOException {
        return this.sendDataMessage(recipient, unidentifiedAccess, contentHint, message, urgent, includePniSignature, null);
    }

    public SendMessageResult sendDataMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccessPair> unidentifiedAccess, ContentHint contentHint, SignalServiceProtos.DataMessage message, boolean urgent, boolean includePniSignature, SignalServiceProtos.EditMessage editMessage) throws UntrustedIdentityException, IOException {
        LOG.info("Sending a data message.");
        SignalServiceProtos.Content content = editMessage == null ? SignalServiceProtos.Content.newBuilder().setDataMessage(message).build() : this.createEditMessageContent(editMessage);
        return this.sendContent(recipient, unidentifiedAccess, contentHint, message.getTimestamp(), urgent, includePniSignature, content);
    }

    public SendMessageResult sendCallMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccessPair> unidentifiedAccess, SignalServiceProtos.CallMessage message) throws IOException, UntrustedIdentityException {
        SignalServiceProtos.Content content = SignalServiceProtos.Content.newBuilder().setCallMessage(message).build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)ContentHint.DEFAULT, Optional.empty());
        return this.sendContent(recipient, unidentifiedAccess, ContentHint.DEFAULT, System.currentTimeMillis(), false, false, content);
    }

    public SendMessageResult sendReceipt(SignalServiceAddress recipient, Optional<UnidentifiedAccessPair> unidentifiedAccess, SignalServiceProtos.ReceiptMessage message, SignalServiceProtos.SyncMessage syncMessage, boolean includePniSignature) throws IOException {
        SignalServiceProtos.Content.Builder contentBuilder = SignalServiceProtos.Content.newBuilder().setReceiptMessage(message);
        if (includePniSignature) {
            contentBuilder.setPniSignatureMessage(this.createPniSignatureMessage());
        }
        SignalServiceProtos.Content content = contentBuilder.build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)ContentHint.IMPLICIT, Optional.empty());
        try {
            SendMessageResult answer = this.sendMessage(recipient, this.getTargetUnidentifiedAccess(unidentifiedAccess), envelopeContent, null);
            this.sendSyncMessage(syncMessage);
            return answer;
        }
        catch (UntrustedIdentityException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public SendMessageResult sendSyncMessage(SignalServiceProtos.SyncMessage syncMessage) throws IOException {
        SignalServiceProtos.Content syncContent = SignalServiceProtos.Content.newBuilder().setSyncMessage(syncMessage).build();
        EnvelopeContent syncEnvelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)syncContent, (ContentHint)ContentHint.IMPLICIT, Optional.empty());
        try {
            SendMessageResult answer = this.sendMessage(this.localAddress, Optional.empty(), syncEnvelopeContent, null);
            return answer;
        }
        catch (UntrustedIdentityException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private SendMessageResult sendContent(SignalServiceAddress recipient, Optional<UnidentifiedAccessPair> unidentifiedAccess, ContentHint contentHint, long timestamp, boolean urgent, boolean includePniSignature, SignalServiceProtos.Content content) throws UntrustedIdentityException, IOException {
        LOG.info("Send content to " + recipient.getIdentifier());
        if (includePniSignature) {
            LOG.info("Including PNI signature.");
            content = content.toBuilder().setPniSignatureMessage(this.createPniSignatureMessage()).build();
        }
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)contentHint, Optional.empty());
        LOG.info("Send message to " + recipient.getIdentifier() + " with hint = " + String.valueOf(contentHint));
        SendMessageResult result = this.sendMessage(recipient, this.getTargetUnidentifiedAccess(unidentifiedAccess), timestamp, envelopeContent, false, null, urgent, false, contentHint);
        if (result.getSuccess() != null && result.getSuccess().isNeedsSync()) {
            LOG.info("Result contains needsync");
            SignalServiceProtos.Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, Optional.of(recipient), timestamp, Collections.singletonList(result), false);
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)syncMessage, (ContentHint)ContentHint.IMPLICIT, Optional.empty());
            LOG.finest("send sync with content = " + String.valueOf(syncMessage));
            LOG.info("Sending syncmessage");
            this.sendMessage(this.localAddress, Optional.empty(), timestamp, syncMessageContent, false, null, false, false, ContentHint.IMPLICIT);
            LOG.info("Done sending syncmessage");
        }
        return result;
    }

    private List<SendMessageResult> sendMessage(List<SignalServiceAddress> recipients, List<Optional<UnidentifiedAccess>> unidentifiedAccess, long timestamp, EnvelopeContent content, boolean online, CancelationSignal cancelationSignal, boolean urgent, boolean story) throws UntrustedIdentityException, IOException {
        long startTime = System.currentTimeMillis();
        ArrayList<Future<SendMessageResult>> futureResults = new ArrayList<Future<SendMessageResult>>();
        Iterator<SignalServiceAddress> recipientIterator = recipients.iterator();
        Iterator<Optional<UnidentifiedAccess>> unidentifiedAccessIterator = unidentifiedAccess.iterator();
        while (recipientIterator.hasNext()) {
            SignalServiceAddress recipient = recipientIterator.next();
            Optional<UnidentifiedAccess> access = unidentifiedAccessIterator.next();
            futureResults.add(this.executor.submit(() -> {
                SendMessageResult result = this.sendMessage(recipient, access, timestamp, content, online, cancelationSignal, urgent, story, null);
                return result;
            }));
        }
        ArrayList<SendMessageResult> results = new ArrayList<SendMessageResult>(futureResults.size());
        recipientIterator = recipients.iterator();
        for (Future future : futureResults) {
            SignalServiceAddress recipient = recipientIterator.next();
            try {
                results.add((SendMessageResult)future.get());
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof UntrustedIdentityException) {
                    LOG.log(Level.WARNING, "untrusted!", e);
                    results.add(SendMessageResult.identityFailure((SignalServiceAddress)recipient, (IdentityKey)((UntrustedIdentityException)e.getCause()).getIdentityKey()));
                    continue;
                }
                if (e.getCause() instanceof ProofRequiredException) {
                    LOG.log(Level.WARNING, "exception in sending!", e);
                    results.add(SendMessageResult.proofRequiredFailure((SignalServiceAddress)recipient, (ProofRequiredException)((ProofRequiredException)e.getCause())));
                    continue;
                }
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        double sendsForAverage = 0.0;
        for (SendMessageResult result : results) {
            if (result.getSuccess() == null || result.getSuccess().getDuration() == -1L) continue;
            sendsForAverage += 1.0;
        }
        double average = 0.0;
        if (sendsForAverage > 0.0) {
            for (SendMessageResult result : results) {
                if (result.getSuccess() == null || result.getSuccess().getDuration() == -1L) continue;
                average += (double)result.getSuccess().getDuration() / sendsForAverage;
            }
        }
        LOG.info("[" + timestamp + "] Completed send to " + recipients.size() + " recipients in " + (System.currentTimeMillis() - startTime) + " ms, with an average time of " + Math.round(average) + " ms per send.");
        return results;
    }

    private SendMessageResult sendMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccess> unidentifiedAccess, EnvelopeContent content, ContentHint contentHint) throws UntrustedIdentityException, IOException {
        return this.sendMessage(recipient, unidentifiedAccess, System.currentTimeMillis(), content, false, null, false, false, contentHint);
    }

    protected SendMessageResult sendMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccess> unidentifiedAccess, long timestamp, EnvelopeContent content, boolean online, CancelationSignal cancelationSignal, boolean urgent, boolean story, ContentHint contentHint) throws UntrustedIdentityException, IOException {
        this.enforceMaxContentSize(content);
        long startTime = System.currentTimeMillis();
        LOG.info("Do we have a UA token?" + unidentifiedAccess.isPresent());
        for (int i = 0; i < RETRY_COUNT; ++i) {
            LOG.info("Sending a message to " + String.valueOf(recipient.getServiceId()) + ", retry " + i);
            if (cancelationSignal != null && cancelationSignal.isCanceled()) {
                throw new IOException("Send canceled before try " + i);
            }
            try {
                OutgoingPushMessageList messages = this.getEncryptedMessages(recipient, unidentifiedAccess, timestamp, content, online, urgent, story, contentHint);
                LOG.info("Prepare to send envelopecontent to " + String.valueOf(recipient));
                if (content.getContent().isPresent() && ((SignalServiceProtos.Content)content.getContent().get()).getSyncMessage() != null && ((SignalServiceProtos.Content)content.getContent().get()).getSyncMessage().hasSent()) {
                    LOG.info("Sending a sent sync message to devices: " + String.valueOf(messages.getDevices()));
                } else if (content.getContent().isPresent() && ((SignalServiceProtos.Content)content.getContent().get()).hasSenderKeyDistributionMessage()) {
                    LOG.info("Sending a SKDM to " + messages.getDestination() + " for devices: " + String.valueOf(messages.getDevices()));
                }
                NetworkClient nc = unidentifiedAccess.isPresent() ? this.unidentifiedPipe : this.identifiedPipe;
                LOG.info("ready to send DIRECT message via unidentifiedPipe or not " + unidentifiedAccess.isPresent() + " and nc = " + String.valueOf(nc));
                Future<SendMessageResponse> sendDirectOverStream = nc.sendDirectOverStream(messages, unidentifiedAccess, story);
                try {
                    SendMessageResponse response = sendDirectOverStream.get(10L, TimeUnit.SECONDS);
                    return SendMessageResult.success((SignalServiceAddress)recipient, (List)messages.getDevices(), (boolean)unidentifiedAccess.isPresent(), (response.getNeedsSync() || this.aciStore.isMultiDevice() ? 1 : 0) != 0, (long)(System.currentTimeMillis() - startTime), (Optional)content.getContent());
                }
                catch (ExecutionException ee) {
                    LOG.info("Catched execution exception, throw root which is " + String.valueOf(ee.getCause()));
                    throw ee.getCause();
                }
            }
            catch (InvalidKeyException ike) {
                LOG.log(Level.WARNING, "Invalid key", ike);
                unidentifiedAccess = Optional.empty();
                continue;
            }
            catch (AuthorizationFailedException afe) {
                LOG.log(Level.WARNING, "authorization failed", afe);
                if (unidentifiedAccess.isPresent()) {
                    LOG.log(Level.WARNING, "Got an AuthorizationFailedException when trying to send using sealed sender. Falling back.");
                    unidentifiedAccess = Optional.empty();
                    continue;
                }
                LOG.log(Level.WARNING, "Got an AuthorizationFailedException without using sealed sender!", afe);
                throw afe;
            }
            catch (MismatchedDevicesException mde) {
                LOG.info("Got MMDE, will handle it now");
                this.handleMismatchedDevices(recipient, mde.getMismatchedDevices());
                continue;
            }
            catch (StaleDevicesException ste) {
                LOG.info("Got stale devices, handle those!");
                this.handleStaleDevices(recipient, ste.getStaleDevices());
                LOG.info("Got stale devices, handled those!");
                continue;
            }
            catch (ProofRequiredException pre) {
                throw pre;
            }
            catch (Throwable t) {
                LOG.info("CATCHING a throwable.");
                LOG.info("t = " + String.valueOf(t));
                t.printStackTrace();
            }
        }
        throw new IOException("Failed to resolve conflicts after " + RETRY_COUNT + " attempts!");
    }

    public SignalServiceAttachmentPointer uploadAttachment(SignalServiceAttachmentStream attachment) throws IOException {
        return this.networkAPI.uploadAttachment(attachment);
    }

    private OutgoingPushMessageList getEncryptedMessages(SignalServiceAddress recipient, Optional<UnidentifiedAccess> unidentifiedAccess, long timestamp, EnvelopeContent plaintext, boolean online, boolean urgent, boolean story, ContentHint contentHint) throws IOException, InvalidKeyException, UntrustedIdentityException {
        LinkedList<OutgoingPushMessage> messages = new LinkedList<OutgoingPushMessage>();
        List subDevices = this.aciStore.getSubDeviceSessions(recipient.getIdentifier());
        ArrayList<Integer> deviceIds = new ArrayList<Integer>(subDevices.size() + 1);
        deviceIds.addAll(subDevices);
        if (!deviceIds.contains(1)) {
            deviceIds.add(1);
        }
        if (recipient.matches(this.localAddress)) {
            deviceIds.remove((Object)this.localDeviceId);
        }
        Iterator iterator = deviceIds.iterator();
        while (iterator.hasNext()) {
            int deviceId = (Integer)iterator.next();
            if (deviceId != 1 && !this.aciStore.containsSession(new SignalProtocolAddress(recipient.getIdentifier(), deviceId))) continue;
            messages.add(this.getEncryptedMessage(recipient, unidentifiedAccess, deviceId, plaintext, story, contentHint));
        }
        return new OutgoingPushMessageList(recipient.getIdentifier(), timestamp, messages, online, urgent);
    }

    private EnvelopeContent enforceMaxContentSize(EnvelopeContent content) {
        int size = content.size();
        if (maxEnvelopeSize > 0L && (long)size > maxEnvelopeSize) {
            throw new IllegalArgumentException("Too large! Size: " + size + " bytes");
        }
        return content;
    }

    /*
     * Exception decompiling
     */
    private OutgoingPushMessage getEncryptedMessage(SignalServiceAddress recipient, Optional<UnidentifiedAccess> unidentifiedAccess, int deviceId, EnvelopeContent plaintext, boolean story, ContentHint contentHint) throws IOException, InvalidKeyException, UntrustedIdentityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SignalServiceProtos.Content createMultiDeviceSentTranscriptContent(SignalServiceProtos.Content content, Optional<SignalServiceAddress> recipient, long timestamp, List<SendMessageResult> sendMessageResults, boolean isRecipientUpdate) {
        SignalServiceProtos.Content.Builder container = SignalServiceProtos.Content.newBuilder();
        SignalServiceProtos.SyncMessage.Builder syncMessage = this.createSyncMessageBuilder();
        SignalServiceProtos.SyncMessage.Sent.Builder sentMessage = SignalServiceProtos.SyncMessage.Sent.newBuilder();
        SignalServiceProtos.DataMessage dataMessage = content != null && content.hasDataMessage() ? content.getDataMessage() : null;
        SignalServiceProtos.StoryMessage storyMessage = content != null && content.hasStoryMessage() ? content.getStoryMessage() : null;
        SignalServiceProtos.EditMessage editMessage = content != null && content.hasEditMessage() ? content.getEditMessage() : null;
        sentMessage.setTimestamp(timestamp);
        for (SendMessageResult result : sendMessageResults) {
            if (result.getSuccess() == null) continue;
            sentMessage.addUnidentifiedStatus(SignalServiceProtos.SyncMessage.Sent.UnidentifiedDeliveryStatus.newBuilder().setDestinationServiceId(result.getAddress().getServiceId().toServiceIdString()).setUnidentified(result.getSuccess().isUnidentified()).build());
        }
        if (recipient.isPresent()) {
            sentMessage.setDestinationServiceId(recipient.get().getServiceId().toServiceIdString());
            if (recipient.get().getNumber().isPresent()) {
                sentMessage.setDestinationE164((String)recipient.get().getNumber().get());
            }
        }
        if (dataMessage != null) {
            sentMessage.setMessage(dataMessage);
            if (dataMessage.getExpireTimer() > 0) {
                sentMessage.setExpirationStartTimestamp(System.currentTimeMillis());
            }
            if (dataMessage.getIsViewOnce()) {
                dataMessage = dataMessage.toBuilder().clearAttachments().build();
                sentMessage.setMessage(dataMessage);
            }
        }
        if (storyMessage != null) {
            sentMessage.setStoryMessage(storyMessage);
        }
        if (editMessage != null) {
            sentMessage.setEditMessage(editMessage);
        }
        sentMessage.setIsRecipientUpdate(isRecipientUpdate);
        return container.setSyncMessage(syncMessage.setSent(sentMessage)).build();
    }

    private SignalServiceProtos.SyncMessage.Builder createSyncMessageBuilder() {
        SecureRandom random = new SecureRandom();
        byte[] padding = Util.getRandomLengthBytes((int)512);
        random.nextBytes(padding);
        SignalServiceProtos.SyncMessage.Builder builder = SignalServiceProtos.SyncMessage.newBuilder();
        builder.setPadding(ByteString.copyFrom((byte[])padding));
        return builder;
    }

    private SignalServiceProtos.PniSignatureMessage createPniSignatureMessage() {
        byte[] signature = this.localPniIdentity.signAlternateIdentity(this.aciStore.getIdentityKeyPair().getPublicKey());
        return SignalServiceProtos.PniSignatureMessage.newBuilder().setPni(Util.toByteString((UUID)this.localPni.getRawUUID())).setSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    private Optional<UnidentifiedAccess> getTargetUnidentifiedAccess(Optional<UnidentifiedAccessPair> unidentifiedAccess) {
        if (unidentifiedAccess.isPresent()) {
            return unidentifiedAccess.get().getTargetUnidentifiedAccess();
        }
        return Optional.empty();
    }

    private List<Optional<UnidentifiedAccess>> getTargetUnidentifiedAccess(List<Optional<UnidentifiedAccessPair>> unidentifiedAccess) {
        LinkedList<Optional<UnidentifiedAccess>> results = new LinkedList<Optional<UnidentifiedAccess>>();
        for (Optional<UnidentifiedAccessPair> item : unidentifiedAccess) {
            if (item.isPresent()) {
                results.add(item.get().getTargetUnidentifiedAccess());
                continue;
            }
            results.add(Optional.empty());
        }
        return results;
    }

    private List<PreKeyBundle> getPreKeys(SignalServiceAddress recipient, Optional<UnidentifiedAccess> unidentifiedAccess, int deviceId) throws IOException {
        PreKeyResponse response = this.networkAPI.getPreKey(recipient.getIdentifier(), deviceId);
        LinkedList<PreKeyBundle> bundles = new LinkedList<PreKeyBundle>();
        for (PreKeyResponseItem device : response.getDevices()) {
            ECPublicKey preKey = null;
            ECPublicKey signedPreKey = null;
            byte[] signedPreKeySignature = null;
            int preKeyId = -1;
            int signedPreKeyId = -1;
            int kyberPreKeyId = -1;
            KEMPublicKey kyberPreKey = null;
            byte[] kyberPreKeySignature = null;
            if (device.getSignedPreKey() != null) {
                signedPreKey = device.getSignedPreKey().getPublicKey();
                signedPreKeyId = device.getSignedPreKey().getKeyId();
                signedPreKeySignature = device.getSignedPreKey().getSignature();
            }
            if (device.getPreKey() != null) {
                preKeyId = device.getPreKey().getKeyId();
                preKey = device.getPreKey().getPublicKey();
            }
            if (device.getKyberPreKey() != null) {
                kyberPreKey = device.getKyberPreKey().getPublicKey();
                kyberPreKeyId = device.getKyberPreKey().getKeyId();
                kyberPreKeySignature = device.getKyberPreKey().getSignature();
            }
            bundles.add(new PreKeyBundle(device.getRegistrationId(), device.getDeviceId(), preKeyId, preKey, signedPreKeyId, signedPreKey, signedPreKeySignature, response.getIdentityKey(), kyberPreKeyId, kyberPreKey, kyberPreKeySignature));
        }
        return bundles;
    }

    private void handleMismatchedDevices(SignalServiceAddress recipient, MismatchedDevices mismatchedDevices) throws IOException, UntrustedIdentityException {
        try {
            LOG.warning("Address: " + recipient.getIdentifier() + ", ExtraDevices: " + String.valueOf(mismatchedDevices.getExtraDevices()) + ", MissingDevices: " + String.valueOf(mismatchedDevices.getMissingDevices()));
            this.archiveSessions(recipient, mismatchedDevices.getExtraDevices());
            Iterator iterator = mismatchedDevices.getMissingDevices().iterator();
            while (iterator.hasNext()) {
                int missingDeviceId = (Integer)iterator.next();
                LOG.info("Get prekey for deviceId " + missingDeviceId + " of recipient " + String.valueOf(recipient));
                List<PreKeyBundle> preKeyBundle = this.getPreKeys(recipient, Optional.empty(), missingDeviceId);
                LOG.info("Retrieved #prekeys = " + String.valueOf(preKeyBundle == null ? "NONE" : Integer.valueOf(preKeyBundle.size())));
                PreKeyBundle preKey = preKeyBundle.get(0);
                try {
                    SignalSessionBuilder sessionBuilder = new SignalSessionBuilder(this.sessionLock, new SessionBuilder((SignalProtocolStore)this.aciStore, new SignalProtocolAddress(recipient.getIdentifier(), missingDeviceId)));
                    sessionBuilder.process(preKey);
                }
                catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                    LOG.severe("Untrusted!");
                    throw new UntrustedIdentityException("Untrusted identity key!", recipient.getIdentifier(), preKey.getIdentityKey());
                }
            }
            LOG.info("Done handling mismatchedDevices");
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    private void archiveSessions(SignalServiceAddress recipient, List<Integer> devices) {
        List<SignalProtocolAddress> addressesToClear = this.convertToProtocolAddresses(recipient, devices);
        this.aciStore.clearSenderKeySharedWith(addressesToClear);
        for (SignalProtocolAddress address : addressesToClear) {
            this.aciStore.archiveSession(address);
        }
    }

    private List<SignalProtocolAddress> convertToProtocolAddresses(SignalServiceAddress recipient, List<Integer> devices) {
        ArrayList<SignalProtocolAddress> addresses = new ArrayList<SignalProtocolAddress>(devices.size());
        for (int deviceId : devices) {
            addresses.add(new SignalProtocolAddress(recipient.getServiceId().toServiceIdString(), deviceId));
            if (!recipient.getNumber().isPresent()) continue;
            addresses.add(new SignalProtocolAddress((String)recipient.getNumber().get(), deviceId));
        }
        return addresses;
    }

    public List<SendMessageResult> sendGroupMessage(UUID distributionId, Optional<byte[]> groupId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, boolean isRecipientUpdate, ContentHint contentHint, SignalServiceProtos.DataMessage message, boolean urgent, boolean isForStory, SignalServiceProtos.EditMessage editMessage, SignalServiceProtos.CallMessage callMessage) throws UntrustedIdentityException, IOException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        long timestamp = message == null ? System.currentTimeMillis() : message.getTimestamp();
        LOG.info("[" + timestamp + "] Sending a group data message to " + recipients.size() + " recipients using DistributionId " + String.valueOf(distributionId));
        SignalServiceProtos.Content content = callMessage != null ? this.createCallMessageContent(callMessage) : (editMessage != null ? this.createEditMessageContent(editMessage) : this.createMessageContent(message));
        List<SendMessageResult> results = this.sendGroupMessage(distributionId, recipients, unidentifiedAccess, timestamp, content, contentHint, groupId, false, urgent, isForStory);
        if (this.aciStore.isMultiDevice()) {
            SignalServiceProtos.Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, Optional.empty(), timestamp, results, isRecipientUpdate);
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)syncMessage, (ContentHint)ContentHint.IMPLICIT, Optional.empty());
            LOG.info("Will NOW send sycmessage to our other devices");
            this.sendMessage(this.localAddress, Optional.empty(), timestamp, syncMessageContent, false, null, false, false, null);
            LOG.info("Did sent sycmessage to our other devices");
        }
        System.err.println("SSMS, return results from sendGroupDataMessage: " + String.valueOf(results));
        return results;
    }

    private List<SendMessageResult> sendGroupMessage(UUID distributionId, List<SignalServiceAddress> recipients, List<UnidentifiedAccess> unidentifiedAccess, long timestamp, SignalServiceProtos.Content content, ContentHint contentHint, Optional<byte[]> groupId, boolean online, boolean urgent, boolean story) throws IOException, UntrustedIdentityException, NoSessionException, InvalidKeyException, InvalidRegistrationIdException {
        LOG.info("send to " + String.valueOf(recipients));
        if (recipients.isEmpty()) {
            LOG.warning("Empty recipient list!");
            return Collections.emptyList();
        }
        if (recipients.size() != unidentifiedAccess.size()) {
            LOG.warning("Unidentified access mismatch! recipeints = " + String.valueOf(recipients) + " and ua = " + String.valueOf(unidentifiedAccess));
            throw new IllegalArgumentException("Unidentified access mismatch");
        }
        HashMap<ServiceId, UnidentifiedAccess> accessBySid = new HashMap<ServiceId, UnidentifiedAccess>();
        Iterator<SignalServiceAddress> addressIterator = recipients.iterator();
        Iterator<UnidentifiedAccess> accessIterator = unidentifiedAccess.iterator();
        while (addressIterator.hasNext()) {
            accessBySid.put(addressIterator.next().getServiceId(), accessIterator.next());
        }
        for (int i = 0; i < RETRY_COUNT; ++i) {
            byte[] ciphertext;
            LOG.info("Try to send, retry count = " + i);
            GroupTargetInfo targetInfo = this.buildGroupTargetInfo(recipients);
            Set sharedWith = this.aciStore.getSenderKeySharedWith(distributionId);
            List<SignalServiceAddress> needsSenderKey = targetInfo.destinations.stream().filter(a -> !sharedWith.contains(a)).map(a -> new SignalServiceAddress(a.getServiceId())).distinct().collect(Collectors.toList());
            if (needsSenderKey.size() > 0) {
                LOG.info("Need to send the distribution message to " + needsSenderKey.size() + " addresses.");
                SenderKeyDistributionMessage message = this.getOrCreateNewGroupSession(distributionId);
                List<Optional<UnidentifiedAccessPair>> access = needsSenderKey.stream().map(r -> {
                    UnidentifiedAccess targetAccess = (UnidentifiedAccess)accessBySid.get(r.getServiceId());
                    return Optional.of(new UnidentifiedAccessPair(targetAccess, targetAccess));
                }).collect(Collectors.toList());
                List<SendMessageResult> results = this.sendSenderKeyDistributionMessage(distributionId, needsSenderKey, access, message, groupId, urgent, story && !groupId.isPresent());
                List successes = results.stream().filter(SendMessageResult::isSuccess).map(SendMessageResult::getAddress).collect(Collectors.toList());
                Set successSids = successes.stream().map(a -> a.getServiceId().toServiceIdString()).collect(Collectors.toSet());
                Set successAddresses = targetInfo.destinations.stream().filter(a -> successSids.contains(a.getName())).collect(Collectors.toSet());
                this.aciStore.markSenderKeySharedWith(distributionId, successAddresses);
                LOG.info("Successfully sent sender keys to " + successes.size() + "/" + needsSenderKey.size() + " recipients.");
                int failureCount = results.size() - successes.size();
                if (failureCount > 0) {
                    LOG.warning("Failed to send sender keys to " + failureCount + " recipients. Sending back failed results now.");
                    List trueFailures = results.stream().filter(r -> !r.isSuccess()).collect(Collectors.toList());
                    Set failedAddresses = trueFailures.stream().map(result -> result.getAddress().getServiceId()).collect(Collectors.toSet());
                    List fakeNetworkFailures = recipients.stream().filter(r -> !failedAddresses.contains(r.getServiceId())).map(SendMessageResult::networkFailure).collect(Collectors.toList());
                    LinkedList<SendMessageResult> modifiedResults = new LinkedList<SendMessageResult>();
                    modifiedResults.addAll(trueFailures);
                    modifiedResults.addAll(fakeNetworkFailures);
                    return modifiedResults;
                }
                targetInfo = this.buildGroupTargetInfo(recipients);
            }
            SignalServiceCipher cipher = new SignalServiceCipher(this.localAddress, this.localDeviceId, this.aciStore, this.sessionLock, null, UsePqRatchet.YES);
            SenderCertificate senderCertificate = unidentifiedAccess.get(0).getUnidentifiedCertificate();
            try {
                ciphertext = cipher.encryptForGroup(distributionId, targetInfo.destinations, senderCertificate, content.toByteArray(), contentHint, groupId);
            }
            catch (org.signal.libsignal.protocol.UntrustedIdentityException e) {
                throw new UntrustedIdentityException("Untrusted during group encrypt", e.getName(), e.getUntrustedIdentity());
            }
            byte[] joinedUnidentifiedAccess = new byte[16];
            for (UnidentifiedAccess access : unidentifiedAccess) {
                joinedUnidentifiedAccess = SignalSender.xor(joinedUnidentifiedAccess, access.getUnidentifiedAccessKey());
            }
            LinkedList<Object> headers = new LinkedList<Object>();
            headers.add("content-type:application/vnd.signal-messenger.mrm");
            headers.add("Unidentified-Access-Key:" + Base64.getEncoder().encodeToString(joinedUnidentifiedAccess));
            LOG.info("ready to send groupmessage via unidentifiedPipe with timestamp = " + timestamp);
            Future<SendGroupMessageResponse> sendToGroup = this.unidentifiedPipe.sendToGroup(ciphertext, joinedUnidentifiedAccess, timestamp, online);
            try {
                SendGroupMessageResponse response = sendToGroup.get(10L, TimeUnit.SECONDS);
                List<SendMessageResult> messageResults = this.transformGroupResponseToMessageResults(targetInfo.devices, response, content);
                return messageResults;
            }
            catch (ExecutionException ee) {
                SignalServiceAddress address;
                GroupMismatchedDevicesException e;
                LOG.info("Exception trying to send to group: " + String.valueOf(ee));
                Throwable reason = ee.getCause();
                if (reason instanceof GroupMismatchedDevicesException) {
                    e = (GroupMismatchedDevicesException)reason;
                    LOG.log(Level.WARNING, "[sendGroupMessage][" + timestamp + "] Handling mismatched devices.", (Throwable)e);
                    for (GroupMismatchedDevices mismatched : e.getMismatchedDevices()) {
                        LOG.info("HANDLE " + String.valueOf(mismatched));
                        address = new SignalServiceAddress((ServiceId)new ServiceId.Aci(UUID.fromString(mismatched.getUuid())));
                        this.handleMismatchedDevices(address, mismatched.getDevices());
                    }
                }
                if (reason instanceof GroupStaleDevicesException) {
                    e = (GroupStaleDevicesException)reason;
                    for (GroupStaleDevices stale : e.getStaleDevices()) {
                        address = new SignalServiceAddress((ServiceId)new ServiceId.Aci(UUID.fromString(stale.getUuid())));
                        this.handleStaleDevices(address, stale.getDevices());
                    }
                }
            }
            catch (Exception ex) {
                LOG.info("unknown exception while sending to group: " + String.valueOf(ex));
                ex.printStackTrace();
            }
            LOG.warning("Attempt failed (i = " + i + ")");
        }
        throw new IOException("Failed to resolve conflicts after " + RETRY_COUNT + " attempts!");
    }

    public List<SendMessageResult> sendSenderKeyDistributionMessage(UUID distributionId, List<SignalServiceAddress> recipients, List<Optional<UnidentifiedAccessPair>> unidentifiedAccess, SenderKeyDistributionMessage message, Optional<byte[]> groupId, boolean urgent, boolean story) throws IOException {
        ByteString distributionBytes = ByteString.copyFrom((byte[])message.serialize());
        SignalServiceProtos.Content content = SignalServiceProtos.Content.newBuilder().setSenderKeyDistributionMessage(distributionBytes).build();
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)ContentHint.IMPLICIT, groupId);
        long timestamp = System.currentTimeMillis();
        LOG.info("Sending SKDM to " + recipients.size() + " recipients for DistributionId " + String.valueOf(distributionId));
        try {
            return this.sendMessage(recipients, this.getTargetUnidentifiedAccess(unidentifiedAccess), timestamp, envelopeContent, false, null, urgent, story);
        }
        catch (UntrustedIdentityException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public List<SendMessageResult> sendGroupDataMessage(Optional<byte[]> groupId, List<SignalServiceAddress> recipients, List<Optional<UnidentifiedAccessPair>> unidentifiedAccess, boolean isRecipientUpdate, ContentHint contentHint, SignalServiceProtos.DataMessage message, Object partialListener, CancelationSignal cancelationSignal, boolean urgent) throws UntrustedIdentityException, IOException {
        SignalServiceProtos.Content content = this.createMessageContent(message);
        EnvelopeContent envelopeContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)contentHint, groupId);
        long timestamp = message.getTimestamp();
        List<SendMessageResult> results = this.sendMessage(recipients, this.getTargetUnidentifiedAccess(unidentifiedAccess), timestamp, envelopeContent, false, cancelationSignal, urgent, false);
        boolean needsSyncInResults = false;
        for (SendMessageResult result : results) {
            if (result.getSuccess() == null || !result.getSuccess().isNeedsSync()) continue;
            needsSyncInResults = true;
            break;
        }
        if (needsSyncInResults || this.aciStore.isMultiDevice()) {
            Optional<SignalServiceAddress> recipient = Optional.empty();
            if (!groupId.isPresent() && recipients.size() == 1) {
                recipient = Optional.of(recipients.get(0));
            }
            SignalServiceProtos.Content syncMessage = this.createMultiDeviceSentTranscriptContent(content, recipient, timestamp, results, isRecipientUpdate);
            EnvelopeContent syncMessageContent = EnvelopeContent.encrypted((SignalServiceProtos.Content)syncMessage, (ContentHint)ContentHint.IMPLICIT, Optional.empty());
            this.sendMessage(this.localAddress, Optional.empty(), timestamp, syncMessageContent, false, null, false, false, null);
        }
        return results;
    }

    private SignalServiceProtos.Content createEditMessageContent(SignalServiceProtos.EditMessage editMessage) {
        return SignalServiceProtos.Content.newBuilder().setEditMessage(editMessage).build();
    }

    private SignalServiceProtos.Content createMessageContent(SignalServiceProtos.DataMessage message) {
        return SignalServiceProtos.Content.newBuilder().setDataMessage(message).build();
    }

    private SignalServiceProtos.Content createReceiptContent(SignalServiceProtos.ReceiptMessage message) {
        return SignalServiceProtos.Content.newBuilder().setReceiptMessage(message).build();
    }

    private SignalServiceProtos.Content createCallMessageContent(SignalServiceProtos.CallMessage message) {
        return SignalServiceProtos.Content.newBuilder().setCallMessage(message).build();
    }

    private GroupTargetInfo buildGroupTargetInfo(List<SignalServiceAddress> recipients) {
        List addressNames = recipients.stream().map(SignalServiceAddress::getIdentifier).collect(Collectors.toList());
        Set destinations = this.aciStore.getAllAddressesWithActiveSessions(addressNames);
        LOG.info("destinations is now " + String.valueOf(destinations) + " of size " + destinations.size());
        HashMap devicesByAddressName = new HashMap();
        destinations.addAll(recipients.stream().map(a -> new SignalProtocolAddress(a.getIdentifier(), 1)).collect(Collectors.toList()));
        for (SignalProtocolAddress destination : destinations) {
            LinkedList<Integer> devices = devicesByAddressName.containsKey(destination.getName()) ? (List)devicesByAddressName.get(destination.getName()) : new LinkedList<Integer>();
            devices.add(destination.getDeviceId());
            devicesByAddressName.put(destination.getName(), devices);
        }
        HashMap<SignalServiceAddress, List<Integer>> recipientDevices = new HashMap<SignalServiceAddress, List<Integer>>();
        for (SignalServiceAddress recipient : recipients) {
            if (!devicesByAddressName.containsKey(recipient.getIdentifier())) continue;
            recipientDevices.put(recipient, (List)devicesByAddressName.get(recipient.getIdentifier()));
        }
        return new GroupTargetInfo(new ArrayList<SignalProtocolAddress>(destinations), recipientDevices);
    }

    public SenderKeyDistributionMessage getOrCreateNewGroupSession(UUID distributionId) {
        SignalProtocolAddress self = new SignalProtocolAddress(this.localAddress.getIdentifier(), this.localDeviceId);
        return new SignalGroupSessionBuilder(this.sessionLock, new GroupSessionBuilder((SenderKeyStore)this.aciStore)).create(self, distributionId);
    }

    private List<SendMessageResult> transformGroupResponseToMessageResults(Map<SignalServiceAddress, List<Integer>> recipients, SendGroupMessageResponse response, SignalServiceProtos.Content content) {
        Set<ServiceId> unregistered = response.getUnsentTargets();
        List failures = unregistered.stream().map(SignalServiceAddress::new).map(SendMessageResult::unregisteredFailure).collect(Collectors.toList());
        List success = recipients.keySet().stream().filter(r -> !unregistered.contains(r.getServiceId())).map(a -> SendMessageResult.success((SignalServiceAddress)a, (List)((List)recipients.get(a)), (boolean)true, (boolean)this.aciStore.isMultiDevice(), (long)-1L, Optional.of(content))).collect(Collectors.toList());
        ArrayList<SendMessageResult> results = new ArrayList<SendMessageResult>(success.size() + failures.size());
        results.addAll(success);
        results.addAll(failures);
        return results;
    }

    private void handleStaleDevices(SignalServiceAddress recipient, StaleDevices staleDevices) {
        LOG.warning("Address: " + recipient.getIdentifier() + ", StaleDevices: " + String.valueOf(staleDevices.getStaleDevices()));
        this.archiveSessions(recipient, staleDevices.getStaleDevices());
        LOG.info("Handled stale device");
    }

    public void halt() {
        LOG.info("Need to halt " + String.valueOf(this));
    }

    public void sendNullMessage(SignalServiceAddress addy) {
        LOG.info("Sending a NULL message to " + String.valueOf(addy));
        byte[] secret = new byte[140];
        Random random = new Random();
        random.nextBytes(secret);
        ByteString padding = SignalServiceProtos.DataMessage.newBuilder().setBody(Base64.getEncoder().encodeToString(secret)).build().toByteString();
        SignalServiceProtos.Content content = SignalServiceProtos.Content.newBuilder().setNullMessage(SignalServiceProtos.NullMessage.newBuilder().setPadding(padding)).build();
        try {
            this.sendMessage(addy, Optional.empty(), EnvelopeContent.encrypted((SignalServiceProtos.Content)content, (ContentHint)ContentHint.DEFAULT, Optional.empty()), ContentHint.DEFAULT);
            LOG.info("Done sending null message");
        }
        catch (IOException | UntrustedIdentityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public static byte[] xor(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new AssertionError((Object)"XOR length mismatch");
        }
        byte[] out = new byte[a.length];
        for (int i = a.length - 1; i >= 0; --i) {
            out[i] = (byte)(a[i] ^ b[i]);
        }
        return out;
    }

    private static final class GroupTargetInfo {
        private final List<SignalProtocolAddress> destinations;
        private final Map<SignalServiceAddress, List<Integer>> devices;

        private GroupTargetInfo(List<SignalProtocolAddress> destinations, Map<SignalServiceAddress, List<Integer>> devices) {
            this.destinations = destinations;
            this.devices = devices;
        }
    }
}

