/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model;

public class InfoMessage {
    private final Type type;
    private final String[] args;

    public InfoMessage(Type type, String ... args) {
        this.type = type;
        this.args = args;
    }

    public Type getType() {
        return this.type;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean hasValidInfo() {
        return Type.INFO_NONE != this.type;
    }

    public static String[] parseArgs(String args) {
        if (args == null) {
            return null;
        }
        return args.split(";");
    }

    public static String combineArgs(String[] args) {
        if (args == null) {
            return null;
        }
        return String.join((CharSequence)";", args);
    }

    public static enum Type {
        INFO_NONE(0),
        INFO_TIMER_ME(1),
        INFO_TIMER_OTHER(2),
        INFO_MEMBER_NEW(3),
        INFO_MEMBER_REMOVE(4),
        INFO_GROUP_DESCRIPTION(5),
        INFO_GROUP_TITLE(6),
        INFO_GROUP_NEW_ME(7),
        INFO_GROUP_NEW_OTHER(8),
        INFO_ROLE_ME(9);

        int val;

        private Type(int v) {
            this.val = v;
        }

        public int val() {
            return this.val;
        }

        public static Type from(int v) {
            for (Type candidate : Type.values()) {
                if (candidate.val != v) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Type with value " + v + " does not exist.");
        }
    }
}

