/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.privacyresearch.equation.WaveStore;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMKeyPair;
import org.signal.libsignal.protocol.kem.KEMKeyType;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.protocol.util.Medium;
import org.whispersystems.signalservice.api.crypto.Curve;

public class KeyUtil {
    private static final Logger LOG = Logger.getLogger(KeyUtil.class.getName());
    private final WaveStore store;
    private static int nextSignedPreKeyId = 2;
    private static int nextKyberPreKeyId = 2;
    private static int activeSignedPreKeyId = 1;
    private static SecureRandom sr = new SecureRandom();

    public KeyUtil(WaveStore store) {
        this.store = store;
        List<SignedPreKeyRecord> loadedSignedPreKeys = store.loadSignedPreKeys();
        LOG.info("SignedPreKeys = " + String.valueOf(loadedSignedPreKeys));
        int maxspk = loadedSignedPreKeys.stream().mapToInt(SignedPreKeyRecord::getId).max().orElse(0) + 1;
        LOG.info("maxsp = " + maxspk + ", nspki = " + nextSignedPreKeyId);
        nextSignedPreKeyId = Math.max(maxspk, nextSignedPreKeyId);
        LOG.info("and now maxsp = " + maxspk + ", nspki = " + nextSignedPreKeyId);
        List<KyberPreKeyRecord> loadedKyberPreKeys = store.loadKyberPreKeys();
        loadedKyberPreKeys.addAll(store.loadLastResortKyberPreKeys());
        int maxkpp = loadedKyberPreKeys.stream().mapToInt(KyberPreKeyRecord::getId).max().orElse(0) + 1;
        nextKyberPreKeyId = Math.max(maxkpp, nextKyberPreKeyId);
    }

    public synchronized List<PreKeyRecord> generatePreKeys(int cnt) {
        LinkedList<PreKeyRecord> records = new LinkedList<PreKeyRecord>();
        int preKeyIdOffset = sr.nextInt(0x20000000);
        for (int i = 0; i < cnt; ++i) {
            int preKeyId = (preKeyIdOffset + i) % Medium.MAX_VALUE;
            ECKeyPair keyPair = Curve.generateKeyPair();
            PreKeyRecord record = new PreKeyRecord(preKeyId, keyPair);
            this.store.storePreKey(preKeyId, record);
            records.add(record);
        }
        return records;
    }

    public static String getSecret(int size) {
        byte[] secret = KeyUtil.getSecretBytes(size);
        return Base64.getEncoder().encodeToString(secret);
    }

    public static byte[] getSecretBytes(int size) {
        byte[] secret = new byte[size];
        sr.nextBytes(secret);
        return secret;
    }

    static int getNextSignedPreKeyId() {
        return nextSignedPreKeyId++;
    }

    static void setNextSignedPreKeyId(int v) {
        nextSignedPreKeyId = v;
    }

    static void setActiveSignedPreKeyId(int v) {
        activeSignedPreKeyId = v;
    }

    public synchronized SignedPreKeyRecord generateSignedPreKey(IdentityKeyPair identityKeyPair, boolean active) {
        try {
            int signedPreKeyId = KeyUtil.getNextSignedPreKeyId();
            ECKeyPair keyPair = Curve.generateKeyPair();
            byte[] signature = Curve.calculateSignature((ECPrivateKey)identityKeyPair.getPrivateKey(), (byte[])keyPair.getPublicKey().serialize());
            SignedPreKeyRecord record = new SignedPreKeyRecord(signedPreKeyId, System.currentTimeMillis(), keyPair, signature);
            this.store.storeSignedPreKey(signedPreKeyId, record);
            KeyUtil.setNextSignedPreKeyId((signedPreKeyId + 1) % Medium.MAX_VALUE);
            if (active) {
                KeyUtil.setActiveSignedPreKeyId(signedPreKeyId);
            }
            return record;
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static synchronized SignedPreKeyRecord generateSignedPreKey(ECPrivateKey privateKey) {
        try {
            int id = KeyUtil.getNextSignedPreKeyId();
            ECKeyPair keyPair = Curve.generateKeyPair();
            byte[] signature = Curve.calculateSignature((ECPrivateKey)privateKey, (byte[])keyPair.getPublicKey().serialize());
            return new SignedPreKeyRecord(id, System.currentTimeMillis(), keyPair, signature);
        }
        catch (InvalidKeyException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static synchronized KyberPreKeyRecord generateKyberPreKey(ECPrivateKey privateKey) {
        int id = nextKyberPreKeyId++;
        KEMKeyPair keyPair = KEMKeyPair.generate((KEMKeyType)KEMKeyType.KYBER_1024);
        byte[] signature = privateKey.calculateSignature(keyPair.getPublicKey().serialize());
        return new KyberPreKeyRecord(id, System.currentTimeMillis(), keyPair, signature);
    }

    public synchronized List<KyberPreKeyRecord> generateAndStoreKyberPreKeys(ECPrivateKey privateKey, int cnt) {
        LinkedList<KyberPreKeyRecord> records = new LinkedList<KyberPreKeyRecord>();
        for (int i = 0; i < cnt; ++i) {
            KyberPreKeyRecord record = KeyUtil.generateKyberPreKey(privateKey);
            this.store.storeKyberPreKey(record.getId(), record);
            records.add(record);
        }
        return records;
    }

    public synchronized KyberPreKeyRecord generateAndStoreLastResortKyberPreKey(ECPrivateKey privateKey) {
        KyberPreKeyRecord record = KeyUtil.generateKyberPreKey(privateKey);
        this.store.storeLastResortKyberPreKey(record.getId(), record);
        return record;
    }

    public synchronized KyberPreKeyRecord generateAndStoreKyberPreKey(ECPrivateKey privateKey) {
        KyberPreKeyRecord record = KeyUtil.generateKyberPreKey(privateKey);
        this.store.storeKyberPreKey(record.getId(), record);
        return record;
    }

    public static IdentityKeyPair generateIdentityKeyPair() {
        ECKeyPair keypair = Curve.generateKeyPair();
        ECPublicKey publicKey = keypair.getPublicKey();
        IdentityKey key = new IdentityKey(publicKey);
        IdentityKeyPair answer = new IdentityKeyPair(key, keypair.getPrivateKey());
        return answer;
    }

    public static class ByteArrayAdapter {

        public static class Deserializing
        extends JsonDeserializer<byte[]> {
            public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return Base64.getDecoder().decode(jsonParser.getValueAsString());
            }
        }

        public static class Serializing
        extends JsonSerializer<byte[]> {
            public void serialize(byte[] bytes, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(Base64.getEncoder().withoutPadding().encodeToString(bytes));
            }
        }
    }

    public static class ECPublicKeyAdapter {

        public static class Deserializer
        extends AbstractPublicKeyDeserializer<ECPublicKey> {
            @Override
            protected ECPublicKey deserializePublicKey(byte[] publicKeyBytes) throws InvalidKeyException {
                return new ECPublicKey(publicKeyBytes);
            }
        }

        public static class Serializer
        extends AbstractPublicKeySerializer<ECPublicKey> {
            @Override
            protected byte[] serializePublicKey(ECPublicKey publicKey) {
                return publicKey.serialize();
            }
        }
    }

    public static abstract class AbstractPublicKeyDeserializer<K>
    extends JsonDeserializer<K> {
        private static final String REASON_TAG_NAME = "reason";

        public K deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            byte[] publicKeyBytes;
            try {
                publicKeyBytes = Base64.getDecoder().decode(parser.getValueAsString());
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(parser, "Could not parse public key as a base64-encoded value", (Throwable)e);
            }
            if (publicKeyBytes.length == 0) {
                return null;
            }
            try {
                return this.deserializePublicKey(publicKeyBytes);
            }
            catch (InvalidKeyException e) {
                throw new JsonParseException(parser, "Could not interpret key bytes as a public key", (Throwable)e);
            }
        }

        protected abstract K deserializePublicKey(byte[] var1) throws InvalidKeyException;
    }

    public static abstract class AbstractPublicKeySerializer<K>
    extends JsonSerializer<K> {
        public void serialize(K publicKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(Base64.getEncoder().encodeToString(this.serializePublicKey(publicKey)));
        }

        protected abstract byte[] serializePublicKey(K var1);
    }
}

