/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.attachment;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentRemoteId;
import java.util.Optional;
import java.util.logging.Logger;
import org.thoughtcrime.securesms.backup.v2.proto.Backup;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public final class AttachmentPointerUtil {
    static Logger LOG = Logger.getLogger(AttachmentPointerUtil.class.getName());

    public static SignalServiceAttachmentPointer createSignalAttachmentPointer(byte[] pointer) throws InvalidMessageStructureException, InvalidProtocolBufferException {
        return AttachmentPointerUtil.createSignalAttachmentPointer(SignalServiceProtos.AttachmentPointer.parseFrom((byte[])pointer));
    }

    public static SignalServiceAttachmentPointer createSignalAttachmentPointer(Backup.MessageAttachment att) throws InvalidMessageStructureException {
        int cdnNumber = -1;
        Backup.FilePointer filePointer = att.getPointer();
        int flag = att.getFlagValue();
        String contentType = filePointer.getContentType();
        byte[] key = new byte[]{};
        Optional<byte[]> digest = Optional.empty();
        Optional<Integer> size = Optional.empty();
        Optional<byte[]> thumbnail = Optional.empty();
        long uploadTimestamp = -1L;
        SignalServiceAttachmentRemoteId remoteId = null;
        if (filePointer.hasLocatorInfo()) {
            Backup.FilePointer.LocatorInfo locatorInfo = filePointer.getLocatorInfo();
            LOG.finer("use locatorInfo: " + String.valueOf(locatorInfo));
            cdnNumber = locatorInfo.getTransitCdnNumber();
            key = locatorInfo.getKey().toByteArray();
            digest = Optional.of(locatorInfo.getLegacyDigest().toByteArray());
            size = Optional.of(locatorInfo.getSize());
            remoteId = new SignalServiceAttachmentRemoteId(locatorInfo.getTransitCdnKey());
            uploadTimestamp = locatorInfo.getTransitTierUploadTimestamp();
        } else if (filePointer.hasAttachmentLocator()) {
            Backup.FilePointer.AttachmentLocator attachmentLocator = filePointer.getAttachmentLocator();
            cdnNumber = attachmentLocator.getCdnNumber();
            key = attachmentLocator.getKey().toByteArray();
            digest = Optional.of(attachmentLocator.getDigest().toByteArray());
            size = Optional.of(attachmentLocator.getSize());
            remoteId = new SignalServiceAttachmentRemoteId(attachmentLocator.getCdnKey());
            uploadTimestamp = attachmentLocator.getUploadTimestamp();
        }
        return new SignalServiceAttachmentPointer(cdnNumber, remoteId, contentType, key, size, thumbnail, filePointer.getWidth(), filePointer.getHeight(), digest, filePointer.hasIncrementalMac() ? Optional.of(filePointer.getIncrementalMac().toByteArray()) : Optional.empty(), filePointer.hasIncrementalMacChunkSize() ? filePointer.getIncrementalMacChunkSize() : 0, filePointer.hasFileName() ? Optional.of(filePointer.getFileName()) : Optional.empty(), (flag & AttachmentPointerUtil.toBinaryFlag(1)) != 0, (flag & AttachmentPointerUtil.toBinaryFlag(2)) != 0, (flag & AttachmentPointerUtil.toBinaryFlag(4)) != 0, filePointer.hasCaption() ? Optional.of(filePointer.getCaption()) : Optional.empty(), filePointer.hasBlurHash() ? Optional.of(filePointer.getBlurHash()) : Optional.empty(), uploadTimestamp);
    }

    public static SignalServiceAttachmentPointer createSignalAttachmentPointer(SignalServiceProtos.AttachmentPointer pointer) throws InvalidMessageStructureException {
        return new SignalServiceAttachmentPointer(pointer.getCdnNumber(), SignalServiceAttachmentRemoteId.from(pointer), pointer.getContentType(), pointer.getKey().toByteArray(), pointer.hasSize() ? Optional.of(pointer.getSize()) : Optional.empty(), pointer.hasThumbnail() ? Optional.of(pointer.getThumbnail().toByteArray()) : Optional.empty(), pointer.getWidth(), pointer.getHeight(), pointer.hasDigest() ? Optional.of(pointer.getDigest().toByteArray()) : Optional.empty(), pointer.hasIncrementalMac() ? Optional.of(pointer.getIncrementalMac().toByteArray()) : Optional.empty(), pointer.hasIncrementalMacChunkSize() ? pointer.getIncrementalMacChunkSize() : 0, pointer.hasFileName() ? Optional.of(pointer.getFileName()) : Optional.empty(), (pointer.getFlags() & AttachmentPointerUtil.toBinaryFlag(1)) != 0, (pointer.getFlags() & AttachmentPointerUtil.toBinaryFlag(2)) != 0, (pointer.getFlags() & AttachmentPointerUtil.toBinaryFlag(4)) != 0, pointer.hasCaption() ? Optional.of(pointer.getCaption()) : Optional.empty(), pointer.hasBlurHash() ? Optional.of(pointer.getBlurHash()) : Optional.empty(), pointer.hasUploadTimestamp() ? pointer.getUploadTimestamp() : 0L);
    }

    public static SignalServiceProtos.AttachmentPointer createAttachmentPointer(SignalServiceAttachmentPointer attachment) {
        SignalServiceProtos.AttachmentPointer.Builder builder = SignalServiceProtos.AttachmentPointer.newBuilder().setCdnNumber(attachment.getCdnNumber()).setContentType(attachment.getContentType()).setKey(ByteString.copyFrom((byte[])attachment.getKey())).setDigest(ByteString.copyFrom((byte[])attachment.getDigest().get())).setSize(attachment.getSize().get().intValue()).setUploadTimestamp(attachment.getUploadTimestamp());
        if (attachment.getIncrementalDigest().isPresent()) {
            builder.setIncrementalMac(ByteString.copyFrom((byte[])attachment.getIncrementalDigest().get()));
        }
        if (attachment.getIncrementalMacChunkSize() > 0) {
            builder.setIncrementalMacChunkSize(attachment.getIncrementalMacChunkSize());
        }
        if (attachment.getRemoteId().getV2().isPresent()) {
            builder.setCdnId(attachment.getRemoteId().getV2().get().longValue());
        }
        if (attachment.getRemoteId().getV3().isPresent()) {
            builder.setCdnKey(attachment.getRemoteId().getV3().get());
        }
        if (attachment.getFileName().isPresent()) {
            builder.setFileName(attachment.getFileName().get());
        }
        if (attachment.getPreview().isPresent()) {
            builder.setThumbnail(ByteString.copyFrom((byte[])attachment.getPreview().get()));
        }
        if (attachment.getWidth() > 0) {
            builder.setWidth(attachment.getWidth());
        }
        if (attachment.getHeight() > 0) {
            builder.setHeight(attachment.getHeight());
        }
        int flags = 0;
        if (attachment.getVoiceNote()) {
            flags |= AttachmentPointerUtil.toBinaryFlag(1);
        }
        if (attachment.isBorderless()) {
            flags |= AttachmentPointerUtil.toBinaryFlag(2);
        }
        if (attachment.isGif()) {
            flags |= AttachmentPointerUtil.toBinaryFlag(4);
        }
        builder.setFlags(flags);
        if (attachment.getCaption().isPresent()) {
            builder.setCaption(attachment.getCaption().get());
        }
        if (attachment.getBlurHash().isPresent()) {
            builder.setBlurHash(attachment.getBlurHash().get());
        }
        return builder.build();
    }

    public static int toBinaryFlag(int flag) {
        return 1 << flag - 1;
    }
}

