/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.attachment.AttachmentKey;
import io.privacyresearch.clientdata.attachment.AttachmentRecord;
import io.privacyresearch.clientdata.channel.ChannelKey;
import io.privacyresearch.clientdata.channel.ChannelRecord;
import io.privacyresearch.clientdata.group.GroupRecord;
import io.privacyresearch.clientdata.message.BodyRange;
import io.privacyresearch.clientdata.message.InfoMessage;
import io.privacyresearch.clientdata.message.InsertMessageRequest;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.message.ReceiptDbRecord;
import io.privacyresearch.clientdata.message.ReceiptKey;
import io.privacyresearch.clientdata.message.ReceiptProtocol;
import io.privacyresearch.clientdata.message.ReceiptType;
import io.privacyresearch.clientdata.message.StoryType;
import io.privacyresearch.clientdata.quote.QuoteKey;
import io.privacyresearch.clientdata.quote.QuoteRecord;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.equation.AttachmentUtil;
import io.privacyresearch.equation.CheatManager;
import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.GroupChangeUtil;
import io.privacyresearch.equation.StoryService;
import io.privacyresearch.equation.WaveCallManager;
import io.privacyresearch.equation.attachment.AttachmentPointerUtil;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.Attachment;
import io.privacyresearch.equation.model.AttachmentPointer;
import io.privacyresearch.equation.signal.SignalBridge;
import io.privacyresearch.equation.user.Account;
import io.privacyresearch.equation.user.UserRecord;
import io.privacyresearch.equation.util.SignalServiceProtoUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.storageservice.protos.groups.local.DecryptedGroupChange;
import org.whispersystems.signalservice.api.InvalidMessageStructureException;
import org.whispersystems.signalservice.internal.SignalServiceProtos;

public class MessageContentProcessor {
    private static final Logger LOG = Logger.getLogger(MessageContentProcessor.class.getName());
    private final SqliteStorageBean storageBean;
    private final EquationManager waveManager;
    private final WaveCallManager waveCallManager;
    private final SignalBridge signalBridge;
    private final StoryService storyService;
    private MessagingClient waveClient;
    private boolean enableBackup = false;

    public MessageContentProcessor(SqliteStorageBean storageBean, EquationManager waveManager, StoryService storyService, SignalBridge signalBridge) {
        this.storageBean = storageBean;
        this.waveManager = waveManager;
        this.signalBridge = signalBridge;
        this.storyService = storyService;
        this.waveCallManager = waveManager.getWaveCallManager();
        this.waveClient = waveManager.getWaveClient();
    }

    public void setMessagingClient(MessagingClient client) {
        this.waveClient = client;
    }

    public boolean shouldIgnore(SignalServiceProtos.Content content, RecipientRecord senderRecipient, RecipientRecord channelRecipient) {
        if (content.hasDataMessage()) {
            SignalServiceProtos.DataMessage message = content.getDataMessage();
            if (channelRecipient.isGroup() && channelRecipient.blocked()) {
                return true;
            }
            if (channelRecipient.isGroup()) {
                GroupRecord group = this.storageBean.getGroupData().getGroupByRecipientKey(channelRecipient.key());
                if (group.isUnknown()) {
                    return senderRecipient.blocked();
                }
                boolean isTextMessage = message.hasBody();
                boolean isMediaMessage = message.getAttachmentsCount() > 0 || message.hasQuote() || message.getContactCount() > 0 || message.hasSticker() || message.getBodyRangesCount() > 0 || message.getPreviewCount() > 0;
                boolean isExpireMessage = (message.getFlags() & 2) != 0;
                boolean isGv2Update = SignalServiceProtoUtil.isGroupV2Update(message);
                boolean isContentMessage = !isGv2Update && !isExpireMessage && (isTextMessage || isMediaMessage);
                boolean isGroupActive = group.members().size() > 0;
                return isContentMessage && !isGroupActive || senderRecipient.blocked() && !isGv2Update;
            }
            if (senderRecipient.blocked()) {
                LOG.info("Will ignore this messge due to senderBlocked");
            }
            return senderRecipient.blocked();
        }
        if (content.hasCallMessage()) {
            return senderRecipient.blocked();
        }
        if (content.hasTypingMessage()) {
            if (senderRecipient.blocked()) {
                return true;
            }
        } else if (content.hasStoryMessage()) {
            if (channelRecipient.isGroup() && channelRecipient.blocked()) {
                return true;
            }
            return senderRecipient.blocked();
        }
        return false;
    }

    public void processTypingMessage(SignalServiceProtos.TypingMessage typingMessage, RecipientKey senderRecipientKey, RecipientKey channelRecipientKey) {
        LOG.info("Process typing message for sender = " + String.valueOf(senderRecipientKey) + " and channel = " + String.valueOf(channelRecipientKey));
        boolean started = typingMessage.getAction() == SignalServiceProtos.TypingMessage.Action.STARTED;
        this.waveManager.getWaveClient().gotTypingAction(senderRecipientKey, channelRecipientKey, started, !started);
    }

    public void processReceiptMessage(SignalServiceProtos.ReceiptMessage receiptMessage, long timestamp, RecipientKey senderRecipient) {
        int t = receiptMessage.getType().getNumber() + 1;
        ReceiptType type = ReceiptType.valueOf((int)t);
        long origTimestamp = receiptMessage.getTimestamp(0);
        Account account = this.waveManager.getAccount();
        RecipientKey channelRecipientKey = this.findChannelRecipientBySenderAndTimeStamp(account.getUser(), origTimestamp);
        if (channelRecipientKey == null) {
            return;
        }
        UserRecord userRecord = this.waveManager.getUserByRecipientKey(senderRecipient);
        Iterator iterator = receiptMessage.getTimestampList().iterator();
        while (iterator.hasNext()) {
            long target = (Long)iterator.next();
            MessageDbRecord record = this.storageBean.getMessageData().getByFromRecipientKeyAndDateSent(account.getUser().recipient().key(), target);
            if (record == null) continue;
            LOG.info("Got record from " + String.valueOf(record.senderKey()) + ", to = " + String.valueOf(record.receiverKey()));
            LOG.info("update receiptStatus for " + target + " to " + String.valueOf(type));
            if (record.receiptType() == ReceiptType.SENT || type.compareTo((Enum)record.receiptType()) > 0) {
                this.storageBean.getMessageData().updateReceiptStatus(record.key(), type, timestamp);
            }
            ReceiptDbRecord rdr = new ReceiptDbRecord(new ReceiptKey(), userRecord.key(), record.key(), type, timestamp, ReceiptProtocol.DEFAULT);
            this.storageBean.getReceiptData().addReceipt(rdr);
        }
        if (this.waveClient != null) {
            this.waveClient.gotReceiptMessage(userRecord.key(), channelRecipientKey, t, receiptMessage.getTimestampList(), timestamp);
        }
    }

    public void processDataMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.DataMessage dm, UserRecord sender, RecipientRecord receiver, boolean hasPqRatchet) {
        this.processDataMessage(envelope, dm, sender, receiver, 0L, hasPqRatchet);
    }

    public void processDataMessage(SignalServiceProtos.Envelope envelope, SignalServiceProtos.DataMessage dm, UserRecord sender, RecipientRecord receiver, long targetTimestamp, boolean hasPqRatchet) {
        LOG.info("Process PB datamessage with servertimestamp " + envelope.getServerTimestamp() + " and orig = " + targetTimestamp);
        LOG.finest(" and sender = " + String.valueOf(sender) + " and receiver = " + String.valueOf(receiver) + " with key = " + String.valueOf(receiver.key()));
        boolean self = this.waveManager.getAccount().getUser().key().equals((Object)sender.key());
        long timestamp = dm.getTimestamp();
        InsertMessageRequest messageRequest = new InsertMessageRequest();
        messageRequest.setSenderKey(sender.key());
        messageRequest.setReceiverKey(receiver.key());
        InfoMessage infoMessage = null;
        String content = null;
        LinkedList<AttachmentPointer> attachmentPointers = new LinkedList<AttachmentPointer>();
        if (dm.hasIsViewOnce() && dm.getIsViewOnce()) {
            messageRequest.setViewOnce(true);
        }
        LOG.info("PBGroup message? " + dm.hasGroupV2());
        boolean announceNewGroup = false;
        if (dm.hasGroupV2()) {
            SignalServiceProtos.GroupContextV2 groupV2 = dm.getGroupV2();
            GroupChangeUtil gcu = new GroupChangeUtil(this.waveManager, this.waveManager.getUserService(), this.storageBean, this.waveClient);
            int revision = groupV2.getRevision();
            if (revision == 0 && !dm.hasBody()) {
                announceNewGroup = true;
                gcu.announceNewGroup(receiver, timestamp);
            }
            byte[] masterKeyBytes = groupV2.getMasterKey().toByteArray();
            GroupMasterKey groupMasterKey = this.waveManager.getGroupByMasterKey(masterKeyBytes).map(GroupRecord::getMasterKey).orElseGet(() -> {
                try {
                    return new GroupMasterKey(masterKeyBytes);
                }
                catch (InvalidInputException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                    return null;
                }
            });
            if (groupV2.hasGroupChange()) {
                try {
                    GroupRecord groupRecord = this.waveManager.retrieveGroupFromMasterKeyBytes(masterKeyBytes);
                    DecryptedGroupChange change = this.waveManager.getGroupManager().decryptChange(new GroupMasterKey(masterKeyBytes), groupV2.getGroupChange().toByteArray());
                    this.processGroupChange(groupRecord, change, gcu, sender, receiver, timestamp, masterKeyBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            UserRecord user = this.waveManager.getUserService().getUserByRecipientKey(receiver.key());
            LOG.info("DM, receiver recipient = " + String.valueOf(receiver.key()) + " with user key = " + String.valueOf(user.key()) + " and service id = " + String.valueOf(user.getServiceId().get()));
            String receiverUuid = user.getServiceId().get().toString();
            LOG.info("Now receiveruuid = " + (String)receiverUuid);
        }
        ArrayList<BodyRange> bodyRanges = new ArrayList<BodyRange>();
        for (SignalServiceProtos.BodyRange bodyRange : dm.getBodyRangesList()) {
            if (bodyRange.hasMentionAci()) {
                bodyRanges.add(BodyRange.fromMentionAci((String)bodyRange.getMentionAci(), (int)bodyRange.getStart(), (int)bodyRange.getLength()));
                continue;
            }
            BodyRange.Style style = EquationManager.getStyleFromProto(bodyRange.getStyle().getNumber());
            bodyRanges.add(BodyRange.fromStyle((BodyRange.Style)style, (int)bodyRange.getStart(), (int)bodyRange.getLength()));
        }
        messageRequest.setBodyRanges(bodyRanges);
        if (dm.getAttachmentsCount() > 0) {
            Path destinationDir = this.waveManager.SIGNAL_FX_ATTACHMENT_DIR.resolve(sender.key().toString());
            for (SignalServiceProtos.AttachmentPointer ssa : dm.getAttachmentsList()) {
                try {
                    SignalServiceAttachmentPointer ssap = AttachmentPointerUtil.createSignalAttachmentPointer(ssa);
                    Attachment att = AttachmentUtil.createAttachmentFromPointer(ssap, destinationDir);
                    if (att != null) {
                        attachmentPointers.add(new AttachmentPointer(ssap, att.getPath().toAbsolutePath().toString()));
                        continue;
                    }
                    LOG.severe("Couldn't set attachment!");
                }
                catch (InvalidMessageStructureException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
        if (dm.hasDelete()) {
            SignalServiceProtos.DataMessage.Delete delete = dm.getDelete();
            timestamp = delete.getTargetSentTimestamp();
            LOG.info("We have to delete msg with ts = " + timestamp);
            MessageDbRecord record = this.storageBean.getMessageData().getByFromRecipientKeyAndDateSent(sender.recipient().key(), timestamp);
            if (record != null) {
                if (this.waveManager.hasCheatFor(CheatManager.CHEAT_REMOTE_DELETE)) {
                    LOG.info("We should delete message with timestamp " + record.dateSent() + " but we are cheating");
                } else {
                    this.storageBean.getMessageData().remoteDelete(record.key());
                    if (record.storyType() != StoryType.NONE) {
                        this.storyService.deleteStoryContents(record);
                    }
                    if (this.waveClient != null) {
                        if (record.storyType() != StoryType.NONE) {
                            if (record.receiverKey().equals((Object)this.waveManager.getAccount().getUser().recipient().key())) {
                                this.waveClient.gotStoryRemoved(sender.recipient().key(), record.key());
                            } else {
                                this.waveClient.gotStoryRemoved(record.receiverKey(), record.key());
                            }
                        } else {
                            this.waveClient.gotMessageRemoved(record.receiverKey(), record.key(), true);
                        }
                    }
                }
            } else {
                LOG.warning("Need to delete msg with rec " + String.valueOf(sender) + " and target " + timestamp + " but can't find it");
            }
            return;
        }
        if (dm.hasSticker()) {
            SignalServiceProtos.DataMessage.Sticker sticker = dm.getSticker();
            content = "Sticker support temporarily disabled";
        }
        if (dm.hasFlags() && dm.getFlags() == 2) {
            LOG.info("expireTimer update");
            int newTimer = dm.getExpireTimer();
            this.storageBean.getRecipientData().setExpireMessages(receiver.key(), newTimer);
            infoMessage = this.waveManager.createTimerInfoMessage(newTimer, self ? null : sender.aci());
            messageRequest.setInfoMessage(infoMessage);
            this.waveClient.gotRecipientExpirationUpdate(receiver.key(), newTimer);
        }
        if (dm.hasBody()) {
            content = dm.getBody();
        } else if (dm.getAttachmentsCount() > 0) {
            content = "";
        }
        messageRequest.setContent(content);
        ChannelKey channelKey = this.storageBean.getChannelData().findByRecipientKey(receiver.key());
        messageRequest.setTimestamp(timestamp);
        messageRequest.setExpiration(dm.getExpireTimer());
        this.waveManager.handleEditedMessage(targetTimestamp, sender.recipient().key(), messageRequest);
        if (channelKey != null) {
            if (content != null || infoMessage != null) {
                if (receiver != null) {
                    receiver = this.handleExpireTimer(dm.getExpireTimer(), dm.getExpireTimerVersion(), receiver);
                    messageRequest.setExpiration(receiver.expireMessages());
                    if (self) {
                        messageRequest.setExpireTimestamp(timestamp);
                    }
                } else {
                    LOG.warning("RecipientRecord not found for Recipient " + String.valueOf(receiver));
                }
                MessageKey messageKey = this.storageBean.getMessageData().insertMessage(messageRequest);
                if (hasPqRatchet) {
                    this.storageBean.getMessageData().updateFlag(messageKey, 1, true);
                }
                LOG.info("Inserted message with key " + String.valueOf(messageKey));
                if (self) {
                    this.storageBean.getMessageData().updateReceiptStatus(messageKey, ReceiptType.SENT, timestamp);
                    ChannelRecord channelRecord = (ChannelRecord)this.storageBean.getChannelData().findByKey((EntityKey)channelKey);
                    if (timestamp > channelRecord.lastRead()) {
                        this.storageBean.getChannelData().updateLastRead(channelKey, timestamp);
                    }
                }
                this.waveManager.checkUnreadMessagesForChannel(channelKey);
                if (dm.hasQuote()) {
                    SignalServiceProtos.DataMessage.Quote quote = dm.getQuote();
                    long ts = quote.getId();
                    ServiceId.Aci aci = new ServiceId.Aci(UUID.fromString(quote.getAuthorAci()));
                    UserRecord userRecord = this.waveManager.getUserService().getUserByServiceId((ServiceId)aci).orElse(null);
                    MessageDbRecord orig = this.storageBean.getMessageData().getByFromRecipientKeyAndDateSent(userRecord.recipient().key(), ts);
                    QuoteRecord qr = new QuoteRecord(new QuoteKey(), messageKey, orig == null ? null : orig.key(), quote.getText(), List.of(), QuoteRecord.Type.NORMAL);
                    this.storageBean.getQuoteData().addQuote(qr);
                }
                for (AttachmentPointer attachmentPointer : attachmentPointers) {
                    AttachmentKey aKey = this.storageBean.getAttachmentData().addAttachment(messageKey, attachmentPointer.pointer().toAttachmentPointerBuilder().build(), attachmentPointer.location());
                    AttachmentRecord aRecord = (AttachmentRecord)this.storageBean.getAttachmentData().findByKey((EntityKey)aKey);
                    try {
                        AttachmentUtil.storeAttachmentFromRecord(aRecord, this.waveManager);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                }
                MessageDbRecord dbRecord = (MessageDbRecord)this.storageBean.getMessageData().findByKey((EntityKey)messageKey);
                this.waveClient.gotMessageRecord(this.waveManager.getMessageRecordFromDb(dbRecord));
            }
            if (dm.hasReaction()) {
                this.waveManager.processIncomingReaction(dm.getReaction(), sender.recipient().key(), dm.getTimestamp());
            }
            if (dm.getContactCount() > 0) {
                dm.getContactList().stream().forEach(contact -> this.signalBridge.processContactMessage((SignalServiceProtos.DataMessage.Contact)contact));
            }
            if (dm.hasCanvasMessage()) {
                this.signalBridge.processCanvasMessage(receiver.key(), sender, dm);
            }
        } else {
            LOG.severe("Can't find a channelKey for this message! Not storing it.");
        }
        if (dm.hasExpireTimer() && this.waveManager.getMessageCollector() != null) {
            this.waveManager.getMessageCollector().trigger();
        }
    }

    private RecipientKey findChannelRecipientBySenderAndTimeStamp(UserRecord sender, long timestamp) {
        LOG.log(Level.INFO, "Find message for senderKey {0} and timestamp {1}", new Object[]{sender.key(), timestamp});
        MessageDbRecord message = this.storageBean.getMessageData().getByFromRecipientKeyAndDateSent(sender.recipient().key(), timestamp);
        if (message != null) {
            LOG.log(Level.INFO, "senderKey = {0}, timestamp = {1}", new Object[]{sender.key(), timestamp});
            return message.receiverKey();
        }
        LOG.log(Level.WARNING, "Could not find message with timestamp {0}, maybe too old?", new Object[]{timestamp});
        return null;
    }

    private RecipientRecord handleExpireTimer(int expireTimer, int expireTimerVersion, RecipientRecord recipientRecord) {
        int currentVersion = recipientRecord.expireTimerVersion();
        LOG.info("current = " + currentVersion);
        if (expireTimerVersion == 0) {
            if (expireTimerVersion != recipientRecord.expireMessages()) {
                LOG.info("Need to change timer from " + recipientRecord.expireMessages() + " to " + expireTimer);
                this.storageBean.getRecipientData().setExpireMessages(recipientRecord.key(), expireTimer);
                recipientRecord = (RecipientRecord)this.storageBean.getRecipientData().findByKey((EntityKey)recipientRecord.key());
            }
        } else if (expireTimerVersion >= currentVersion) {
            if (expireTimer != recipientRecord.expireMessages()) {
                LOG.info("Need to change timer from " + recipientRecord.expireMessages() + " to " + expireTimer);
                this.storageBean.getRecipientData().setExpireMessages(recipientRecord.key(), expireTimer);
                LOG.info("And need to update timerversion from " + currentVersion + " to " + expireTimerVersion);
                this.storageBean.getRecipientData().setExpireTimerVersion(recipientRecord.key(), expireTimerVersion);
                recipientRecord = (RecipientRecord)this.storageBean.getRecipientData().findByKey((EntityKey)recipientRecord.key());
            }
        } else {
            LOG.info("other party has an out-of-date view for timer");
        }
        return recipientRecord;
    }

    public void processGroupChange(GroupRecord groupRecord, DecryptedGroupChange change, GroupChangeUtil gcu, UserRecord sender, RecipientRecord receiver, long timestamp, byte[] masterKeyBytes) throws IOException {
        GroupRecord processedGroup = gcu.process(change, sender, receiver, timestamp);
        if (this.waveClient != null) {
            this.waveClient.updateGroupRecord(groupRecord);
        }
    }
}

