/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.snl.doubt;

import com.gluonhq.snl.doubt.MultipartBody;
import com.gluonhq.snl.doubt.State;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Optional;
import java.util.StringJoiner;

class MultipartFormDataChannel
implements ReadableByteChannel {
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    private boolean closed = false;
    private State state = State.Boundary;
    private final String boundary;
    private final Iterator<MultipartBody.Part> parts;
    private ByteBuffer buf = ByteBuffer.allocate(0);
    private MultipartBody.Part current = null;
    private ReadableByteChannel channel = null;
    private final Charset charset;

    MultipartFormDataChannel(String boundary, Iterable<MultipartBody.Part> parts, Charset charset) {
        this.boundary = boundary;
        this.parts = parts.iterator();
        this.charset = charset;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        while (true) {
            int n;
            if (this.buf.hasRemaining()) {
                n = Math.min(this.buf.remaining(), buf.remaining());
                ByteBuffer slice = this.buf.slice();
                slice.limit(n);
                buf.put(slice);
                this.buf.position(this.buf.position() + n);
                return n;
            }
            switch (this.state) {
                case Boundary: {
                    if (this.parts.hasNext()) {
                        this.current = this.parts.next();
                        this.buf = ByteBuffer.wrap(("--" + this.boundary + "\r\n").getBytes(LATIN1));
                        this.state = State.Headers;
                        break;
                    }
                    this.buf = ByteBuffer.wrap(("--" + this.boundary + "--\r\n").getBytes(LATIN1));
                    this.state = State.Done;
                    break;
                }
                case Headers: {
                    this.buf = ByteBuffer.wrap(this.currentHeaders().getBytes(this.charset));
                    this.state = State.Body;
                    break;
                }
                case Body: {
                    if (this.channel == null) {
                        this.channel = this.current.open();
                    }
                    if ((n = this.channel.read(buf)) == -1) {
                        this.channel.close();
                        this.channel = null;
                        this.buf = ByteBuffer.wrap("\r\n".getBytes(LATIN1));
                        this.state = State.Boundary;
                        break;
                    }
                    return n;
                }
                case Done: {
                    return -1;
                }
            }
        }
    }

    static String escape(String s) {
        return s.replaceAll("\"", "\\\"");
    }

    String currentHeaders() {
        MultipartBody.Part current = this.current;
        if (current == null) {
            throw new IllegalStateException();
        }
        Optional<String> contentType = current.contentType();
        Optional<String> filename = current.filename();
        if (contentType.isPresent() && filename.isPresent()) {
            String format = new StringJoiner("\r\n", "", "\r\n").add("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"").add("Content-Type: %s").toString();
            try (Formatter formatter = new Formatter();){
                String string = formatter.format(format, MultipartFormDataChannel.escape(current.name()), MultipartFormDataChannel.escape(filename.get()), MultipartFormDataChannel.escape(contentType.get())).toString() + "\r\n";
                return string;
            }
        }
        if (contentType.isPresent()) {
            String format = new StringJoiner("\r\n", "", "\r\n").add("Content-Disposition: form-data; name=\"%s\"").add("Content-Type: %s").toString();
            try (Formatter formatter = new Formatter();){
                String string = formatter.format(format, MultipartFormDataChannel.escape(current.name()), MultipartFormDataChannel.escape(contentType.get())).toString() + "\r\n";
                return string;
            }
        }
        if (filename.isPresent()) {
            String format = new StringJoiner("\r\n", "", "\r\n").add("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"").toString();
            try (Formatter formatter = new Formatter();){
                String string = formatter.format(format, MultipartFormDataChannel.escape(current.name()), MultipartFormDataChannel.escape(filename.get())).toString() + "\r\n";
                return string;
            }
        }
        String format = new StringJoiner("\r\n", "", "\r\n").add("Content-Disposition: form-data; name=\"%s\"").toString();
        try (Formatter formatter = new Formatter();){
            String string = formatter.format(format, MultipartFormDataChannel.escape(current.name())).toString() + "\r\n";
            return string;
        }
    }
}

