/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.user;

import io.privacyresearch.clientdata.recipient.RecipientRecord;
import io.privacyresearch.clientdata.user.PhoneNumberSharingMode;
import io.privacyresearch.clientdata.user.UnidentifiedAccessMode;
import io.privacyresearch.clientdata.user.UserKey;
import io.privacyresearch.equation.user.BadgeRecord;
import java.util.List;
import java.util.Optional;
import org.signal.libsignal.protocol.ServiceId;

public record UserRecord(UserKey key, RecipientRecord recipient, ServiceId.Aci aci, ServiceId.Pni pni, String e164, byte[] profileKey, String name, String profileGivenName, String profileFamilyName, String username, String systemGivenName, String systemFamilyName, Optional<String> avatarPath, String about, String aboutEmoji, String nickGivenName, String nickFamilyName, String nickNote, String profileAvatarUrl, UnidentifiedAccessMode sealedSenderMode, PhoneNumberSharingMode phoneNumberSharing, List<BadgeRecord> badges) {
    public Optional<ServiceId> getServiceId() {
        return Optional.ofNullable(this.aci != null ? this.aci : this.pni);
    }

    public boolean isSystemContact() {
        return this.systemGivenName != null && !this.systemGivenName.isEmpty() || this.systemFamilyName != null && !this.systemFamilyName.isEmpty();
    }

    public boolean isAccount() {
        return this.recipient.type() == RecipientRecord.Type.ACCOUNT;
    }

    public boolean isContact() {
        return this.recipient.type() == RecipientRecord.Type.CONTACT;
    }

    public static class Builder {
        UserKey key = new UserKey();
        RecipientRecord recipient = new RecipientRecord.Builder().build();
        ServiceId.Aci aci;
        ServiceId.Pni pni;
        String e164;
        byte[] profileKey;
        String name;
        String profileGivenName;
        String profileFamilyName;
        String username;
        String systemGivenName;
        String systemFamilyName;
        Optional<String> avatarPath = Optional.empty();
        String about;
        String aboutEmoji;
        String nickGivenName;
        String nickFamilyName;
        String nickNote;
        String profileAvatarUrl;
        UnidentifiedAccessMode sealedSenderMode = UnidentifiedAccessMode.UNKNOWN;
        PhoneNumberSharingMode phoneNumberSharingMode = PhoneNumberSharingMode.UNKNOWN;
        List<BadgeRecord> badges = List.of();

        public Builder() {
        }

        public Builder(UserRecord user) {
            this.about(user.about()).aboutEmoji(user.aboutEmoji()).aci(user.aci()).avatarPath(user.avatarPath().orElse("")).badges(user.badges()).e164(user.e164()).key(user.key()).name(user.name()).nickFamilyName(user.nickFamilyName()).nickGivenName(user.nickGivenName()).nickNote(user.nickNote()).phoneNumberSharingMode(user.phoneNumberSharing()).pni(user.pni()).profileAvatarUrl(user.profileAvatarUrl()).profileFamilyName(user.profileFamilyName()).profileGivenName(user.profileGivenName()).profileKey(user.profileKey()).recipient(user.recipient()).sealedSenderMode(user.sealedSenderMode()).systemFamilyName(user.systemFamilyName()).systemGivenName(user.systemGivenName()).username(user.username());
        }

        public Builder aci(ServiceId.Aci aci) {
            this.aci = aci;
            return this;
        }

        public Builder e164(String e164) {
            this.e164 = e164;
            return this;
        }

        public Builder key(UserKey key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder nickFamilyName(String nickFamilyName) {
            this.nickFamilyName = nickFamilyName;
            return this;
        }

        public Builder nickGivenName(String nickGivenName) {
            this.nickGivenName = nickGivenName;
            return this;
        }

        public Builder nickNote(String nickNote) {
            this.nickNote = nickNote;
            return this;
        }

        public Builder phoneNumberSharingMode(PhoneNumberSharingMode phoneNumberSharingMode) {
            this.phoneNumberSharingMode = phoneNumberSharingMode;
            return this;
        }

        public Builder pni(ServiceId.Pni pni) {
            this.pni = pni;
            return this;
        }

        public Builder profileFamilyName(String profileFamilyName) {
            this.profileFamilyName = profileFamilyName;
            return this;
        }

        public Builder profileGivenName(String profileGivenName) {
            this.profileGivenName = profileGivenName;
            return this;
        }

        public Builder profileKey(byte[] profileKey) {
            this.profileKey = profileKey;
            return this;
        }

        public Builder recipient(RecipientRecord recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder systemFamilyName(String systemFamilyName) {
            this.systemFamilyName = systemFamilyName;
            return this;
        }

        public Builder systemGivenName(String systemGivenName) {
            this.systemGivenName = systemGivenName;
            return this;
        }

        public Builder sealedSenderMode(UnidentifiedAccessMode sealedSenderMode) {
            this.sealedSenderMode = sealedSenderMode;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder avatarPath(String val) {
            this.avatarPath = Optional.ofNullable(val);
            return this;
        }

        public Builder about(String about) {
            this.about = about;
            return this;
        }

        public Builder aboutEmoji(String aboutEmoji) {
            this.aboutEmoji = aboutEmoji;
            return this;
        }

        public Builder profileAvatarUrl(String val) {
            this.profileAvatarUrl = val;
            return this;
        }

        public Builder badges(List<BadgeRecord> badges) {
            this.badges = badges;
            return this;
        }

        public UserRecord build() {
            if (this.key == null) {
                throw new IllegalStateException("A UserKey must be set.");
            }
            return new UserRecord(this.key, this.recipient, this.aci, this.pni, this.e164, this.profileKey, this.name, this.profileGivenName, this.profileFamilyName, this.username, this.systemGivenName, this.systemFamilyName, this.avatarPath, this.about, this.aboutEmoji, this.nickGivenName, this.nickFamilyName, this.nickNote, this.profileAvatarUrl, this.sealedSenderMode, this.phoneNumberSharingMode, this.badges);
        }
    }

    public static enum RegisteredState {
        UNKNOWN(0),
        REGISTERED(1),
        NOT_REGISTERED(2);

        public int id;

        private RegisteredState(int id) {
            this.id = id;
        }

        public static RegisteredState fromId(int id) {
            return RegisteredState.values()[id];
        }
    }
}

