/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.signal;

import io.privacyresearch.equation.EquationManager;
import io.privacyresearch.equation.WaveStore;
import io.privacyresearch.proto.WireProtos;
import java.util.UUID;
import java.util.logging.Logger;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.metadata.SealedSessionCipher;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.signal.libsignal.protocol.state.SignalProtocolStore;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;

public class MessageAnalyzer {
    static Logger LOG = Logger.getLogger(MessageAnalyzer.class.getName());
    private final EquationManager equation;
    private final WaveStore aciStore;

    public MessageAnalyzer(EquationManager equation) {
        this.equation = equation;
        this.aciStore = equation.getAciStore();
    }

    public void analyze(SignalServiceEnvelope envelope) {
        byte[] content = envelope.getEnvelope().getContent().toByteArray();
        LOG.info("Get message with " + content.length + " bytes");
        try {
            SealedSessionCipher ssc = new SealedSessionCipher((SignalProtocolStore)this.aciStore, UUID.fromString(this.aciStore.getMyUuid()), null, 0);
            UnidentifiedSenderMessageContent usmc = null;
            long pointer = Native.SealedSessionCipher_DecryptToUsmc((byte[])content, (IdentityKeyStore)this.aciStore);
            usmc = new UnidentifiedSenderMessageContent(pointer);
            LOG.info("USMC = " + String.valueOf(usmc) + " with type = " + usmc.getType());
            LOG.info("USMC, csize = " + usmc.getContent().length + " and sersize = " + usmc.getSerialized().length);
            byte[] sc = usmc.getContent();
            LOG.info("version? " + sc[0]);
            byte[] mc = new byte[sc.length - 9];
            System.arraycopy(sc, 1, mc, 0, mc.length);
            WireProtos.SignalMessage signalMessage = WireProtos.SignalMessage.parseFrom((byte[])mc);
            LOG.info("USMCS, has ratchet = " + signalMessage.hasPqRatchet() + " and key? " + signalMessage.hasRatchetKey());
            if (signalMessage.hasPqRatchet()) {
                LOG.info("pq ratchet on message = " + String.valueOf(signalMessage.getPqRatchet()));
            }
        }
        catch (Throwable t) {
            LOG.info("Not a valid signalMessage" + String.valueOf(t));
        }
    }

    public boolean hasPqRatchet(SignalServiceEnvelope envelope) {
        LOG.info("Check pqratchet for envelope with type " + String.valueOf(envelope));
        boolean answer = false;
        try {
            byte[] content = envelope.getEnvelope().getContent().toByteArray();
            SealedSessionCipher ssc = new SealedSessionCipher((SignalProtocolStore)this.aciStore, UUID.fromString(this.aciStore.getMyUuid()), null, 0);
            long pointer = Native.SealedSessionCipher_DecryptToUsmc((byte[])content, (IdentityKeyStore)this.aciStore);
            UnidentifiedSenderMessageContent usmc = new UnidentifiedSenderMessageContent(pointer);
            byte[] sc = usmc.getContent();
            LOG.info("version? " + sc[0]);
            byte[] mc = new byte[sc.length - 9];
            System.arraycopy(sc, 1, mc, 0, mc.length);
            WireProtos.SignalMessage signalMessage = WireProtos.SignalMessage.parseFrom((byte[])mc);
            answer = signalMessage.hasPqRatchet();
            LOG.info("USMCS, has ratchet = " + answer);
        }
        catch (Throwable t) {
            LOG.info("Not a valid signalMessage, envelope type = " + envelope.getType());
        }
        return answer;
    }
}

