/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.ring;

import com.gluonhq.cameracapture.CameraCapture;
import com.gluonhq.cameracapture.Frame;
import io.privacyresearch.equation.ring.CameraManager;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class CaptureCameraManager
implements CameraManager {
    private static final Logger LOG = Logger.getLogger(CaptureCameraManager.class.getName());
    CameraCapture cvs;
    boolean listening = false;

    public CaptureCameraManager() {
        LOG.info("Created CameraManager");
    }

    @Override
    public void startListening(Consumer<CameraManager.Frame> callback) {
        LOG.info("Assume capturecamera lib is already loaded");
        if (this.listening) {
            LOG.info("We are already listening to the camera!");
            return;
        }
        this.listening = true;
        LOG.info("create captureservice");
        this.cvs = new CameraCapture();
        LOG.info("Created!");
        final Consumer<Frame> consumer = frame -> {
            LOG.finest("Got owncameraframe");
            if (!this.listening) {
                LOG.info("We're not listening (anymore)");
                return;
            }
            try {
                if (frame != null) {
                    callback.accept(new CameraManager.Frame(frame.width(), frame.height(), frame.format(), frame.data()));
                }
            }
            catch (Throwable t) {
                LOG.info("major issue processing incoming frame");
                t.printStackTrace();
            }
            LOG.finest("Processed owncameraframe");
        };
        LOG.info("Starting captureVideoService");
        Thread t = new Thread(this){
            final /* synthetic */ CaptureCameraManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.cvs.startListening(consumer);
            }
        };
        t.start();
    }

    @Override
    public void stopListening() {
        this.listening = false;
        if (this.cvs != null) {
            this.cvs.stopListening();
        }
    }
}

