/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gluonhq.snl.AttachmentNetworkClient;
import com.gluonhq.snl.Credentials;
import com.gluonhq.snl.NetworkClient;
import com.gluonhq.snl.Response;
import com.gluonhq.snl.doubt.MediaType;
import com.gluonhq.snl.doubt.RequestBody;
import com.google.protobuf.MessageLite;
import io.privacyresearch.equation.NetworkMonitor;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentPointer;
import io.privacyresearch.equation.attachment.SignalServiceAttachmentStream;
import io.privacyresearch.equation.groups.GroupsV2AuthorizationString;
import io.privacyresearch.equation.model.json.AttachmentUploadForm;
import io.privacyresearch.equation.model.json.AttachmentV2UploadAttributes;
import io.privacyresearch.equation.model.json.CredentialResponse;
import io.privacyresearch.equation.model.json.OneTimePreKeyCounts;
import io.privacyresearch.equation.model.json.PreKeyEntity;
import io.privacyresearch.equation.model.json.PreKeyResponse;
import io.privacyresearch.equation.model.json.PreKeyResponseItem;
import io.privacyresearch.equation.model.json.PreKeyState;
import io.privacyresearch.equation.model.json.SignedPreKeyEntity;
import io.privacyresearch.equation.model.json.StorageAuthResponse;
import io.privacyresearch.equation.net.NetworkConfiguration;
import io.privacyresearch.equation.proxystub.PreKeyEntityMessage;
import io.privacyresearch.equation.proxystub.PreKeyResponseItemMessage;
import io.privacyresearch.equation.proxystub.PreKeyResponseMessage;
import io.privacyresearch.equation.proxystub.SignedPreKeyEntityMessage;
import io.privacyresearch.equation.storage.SignalStorageModels;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyVersion;
import org.signal.storageservice.protos.groups.Group;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupChangeResponse;
import org.signal.storageservice.protos.groups.GroupExternalCredential;
import org.thoughtcrime.securesms.util.JsonUtils;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.messages.calls.GetCallingRelaysResponse;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.storage.ReadOperation;
import org.whispersystems.signalservice.internal.storage.StorageItems;
import org.whispersystems.signalservice.internal.storage.StorageManifest;

public class NetworkAPI {
    private static final String GROUPSV2_CREDENTIAL = "/v1/certificate/auth/group?redemptionStartSeconds=%d&redemptionEndSeconds=%d&pniAsServiceId=true";
    private static final String GROUPSV2_GROUP = "/v1/groups/";
    private static final String GROUPSV2_TOKEN = "/v2/groups/token";
    private static final String GROUPSV2_GROUP_PASSWORD = "/v2/groups/?inviteLinkPassword=%s";
    private static final String GROUPSV2_GROUP_CHANGES = "/v2/groups/logs/%s?maxSupportedChangeEpoch=%d&includeFirstState=%s&includeLastState=false";
    private static final String PREKEY_PATH = "/v2/keys?identity=%s";
    private static final String PROFILE_PATH = "/v1/profile/%s";
    static final String DEFAULT_HOST = "chat.signal.org";
    private Optional<CredentialsProvider> cp;
    private final NetworkMonitor monitor;
    private final String host;
    private String scheme = "https";
    private int port = -1;
    private String endpointUri;
    private String storageEndpointUri;
    private boolean useQuic;
    private final String proxy;
    private final NetworkConfiguration config;
    ObjectMapper objectMapper = new ObjectMapper();
    private NetworkClient unidentifiedNetworkClient;
    private NetworkClient networkClient;
    private NetworkClient storageClient;
    private final AttachmentNetworkClient attachmentNetworkClient;
    private static final Logger LOG = Logger.getLogger(NetworkAPI.class.getName());
    private static final String ATTACHMENT_V2_PATH = "/v2/attachments/form/upload";
    private static final String ATTACHMENT_V4_PATH = "/v4/attachments/form/upload";
    private static final String CALLING_RELAYS = "/v2/calling/relays";

    public NetworkAPI(Optional<CredentialsProvider> cp, NetworkConfiguration config, NetworkMonitor monitor) {
        this.config = config;
        this.monitor = monitor;
        this.proxy = config.getProxy();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        URI endpoint = config.getEndpoint();
        if (endpoint != null) {
            this.host = endpoint.getHost();
            this.scheme = endpoint.getScheme();
            this.port = endpoint.getPort();
            LOG.info("Got endpoint, host = " + this.host + " and scheme = " + this.scheme);
        } else {
            this.host = DEFAULT_HOST;
        }
        URI storageUri = config.getStorageEndpoint();
        this.storageEndpointUri = storageUri.toString();
        LOG.info("Creating new NetworkAPI with host " + this.host + " and proxy = " + this.proxy);
        this.cp = cp;
        this.useQuic = this.useQuic;
        this.endpointUri = this.scheme + "://" + this.host;
        if (this.port > 0) {
            this.endpointUri = this.endpointUri + ":" + this.port;
        }
        LOG.info("Created endpointuri " + this.endpointUri);
        this.attachmentNetworkClient = new AttachmentNetworkClient(this, this.getStorageClient(), config);
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.config;
    }

    public AttachmentNetworkClient getAttachmentNetworkClient() {
        return this.attachmentNetworkClient;
    }

    public String getServerAddress() {
        return this.endpointUri;
    }

    public synchronized NetworkClient getIdentifiedClient() {
        if (this.networkClient == null) {
            this.networkClient = NetworkClient.createNetworkClient(this.monitor, this.config, NetworkConfiguration.Purpose.SERVICE, this.cp);
        }
        return this.networkClient;
    }

    public synchronized NetworkClient getStorageClient() {
        if (this.storageClient == null) {
            this.storageClient = NetworkClient.createStorageClient(this.monitor, this.config, NetworkConfiguration.Purpose.SERVICE, this.cp);
        }
        return this.storageClient;
    }

    public synchronized NetworkClient getUnidentifiedClient() {
        if (this.unidentifiedNetworkClient == null) {
            this.unidentifiedNetworkClient = NetworkClient.createNetworkClient(this.monitor, this.config, NetworkConfiguration.Purpose.SERVICE, Optional.empty());
        }
        return this.unidentifiedNetworkClient;
    }

    public void shutdown() {
        if (this.unidentifiedNetworkClient != null) {
            this.unidentifiedNetworkClient.shutdown();
            this.unidentifiedNetworkClient = null;
        }
        if (this.networkClient != null) {
            this.networkClient.shutdown();
            this.networkClient = null;
        }
        if (this.storageClient != null) {
            this.storageClient.shutdown();
            this.storageClient = null;
        }
    }

    private Response getResponse(String uriString, String method, byte[] payload) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        this.cp.ifPresent(cred -> headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(cred))));
        return this.getResponse(uriString, method, payload, headers);
    }

    private Response getResponse(String uriString, String method, byte[] payload, Map<String, List<String>> headers) throws IOException {
        try {
            URI uri = new URI(uriString);
            NetworkClient client = this.getIdentifiedClient();
            Response response = client.sendRequest(uri, method, payload, headers);
            return response;
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException("Illegal uri: " + uriString);
        }
    }

    public byte[] getSenderCertificate(CredentialsProvider cred) throws IOException {
        LOG.info("GETSENDERCERT");
        Response response = this.getResponse(this.endpointUri + "/v1/certificate/delivery", "GET", new byte[0]);
        if (response.getStatusCode() == 401) {
            throw new AuthorizationFailedException(response.getStatusCode(), "Got a 401 code from server when asking sendercertifcate");
        }
        if (this.getIdentifiedClient().supportsJson()) {
            LOG.fine("Got a json response, length = " + response.body().contentLength());
            LOG.info("Response = " + response.body().string());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode cert = objectMapper.readTree(response.body().string());
            JsonNode certval = cert.get("certificate");
            byte[] answer = certval.binaryValue();
            return answer;
        }
        LOG.fine("Got our bytes immediately, no json conversion");
        byte[] raw = response.body().bytes();
        return raw;
    }

    public String getStorageAuth() throws IOException {
        try {
            URI uri = new URI(this.endpointUri + "/v1/storage/auth");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            this.cp.ifPresent(creds -> headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(creds))));
            NetworkClient client = this.getStorageClient();
            Response response = client.sendRequest(uri, "GET", new byte[0], headers);
            if (client.supportsJson()) {
                StorageAuthResponse authResponse = (StorageAuthResponse)this.objectMapper.readValue(response.body().string(), StorageAuthResponse.class);
                return Credentials.basic(authResponse.getUsername(), authResponse.getPassword());
            }
            throw new RuntimeException("NYI");
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public CompletableFuture<OneTimePreKeyCounts> getNumberOfPreKeys(ServiceId.Kind kind) {
        return CompletableFuture.supplyAsync(() -> {
            String uriString = String.format(Locale.US, PREKEY_PATH, kind);
            try {
                Response response = this.getResponse(this.endpointUri + uriString, "GET", new byte[0]);
                int status = response.getStatusCode();
                LOG.info("Status = " + status);
                OneTimePreKeyCounts otpkc = JsonUtils.fromJson(response.body().string(), OneTimePreKeyCounts.class);
                return otpkc;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public Response registerPreKeys(ServiceId.Kind kind, PreKeyState state) throws IOException {
        String uriString = String.format(Locale.US, PREKEY_PATH, kind);
        byte[] data = JsonUtils.toJson(state).getBytes();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        this.cp.ifPresent(cred -> headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(cred))));
        headers.put("content-type", List.of("application/json"));
        Response response = this.getResponse(this.endpointUri + uriString, "PUT", data, headers);
        int status = response.getStatusCode();
        LOG.info("Status for registerPreKeys = " + status);
        return response;
    }

    public CredentialResponse retrieveGroupsV2Credentials(long todaySeconds) throws IOException {
        LOG.info("Need to retrieve groupsv2credentials");
        long todayPlus7 = todaySeconds + TimeUnit.DAYS.toSeconds(7L);
        String uriString = String.format(Locale.US, GROUPSV2_CREDENTIAL, todaySeconds, todayPlus7);
        Response response = this.getResponse(this.endpointUri + uriString, "GET", new byte[0]);
        LOG.finest("Retrieved credentials: " + response.body().string());
        return (CredentialResponse)this.objectMapper.readValue(response.body().string(), CredentialResponse.class);
    }

    public Group getGroupsV2Group(GroupsV2AuthorizationString authorization) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Authorization", List.of(authorization.toString()));
        Response response = this.getResponse(this.storageEndpointUri + GROUPSV2_GROUP, "GET", new byte[0], headers);
        int status = response.getStatusCode();
        if (status == 403) {
            throw new NonSuccessfulResponseCodeException(403);
        }
        return Group.parseFrom((byte[])response.body().bytes());
    }

    public GroupExternalCredential getGroupExternalCredential(GroupsV2AuthorizationString authorization) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Authorization", List.of(authorization.toString()));
        Response response = this.getResponse(this.storageEndpointUri + GROUPSV2_TOKEN, "GET", new byte[0], headers);
        int status = response.getStatusCode();
        if (status == 403) {
            throw new NonSuccessfulResponseCodeException(403);
        }
        return GroupExternalCredential.parseFrom((byte[])response.body().bytes());
    }

    public GroupChangeResponse patchGroupsV2Group(GroupChange.Actions groupChange, GroupsV2AuthorizationString authorization, Optional<byte[]> groupLinkPassword) throws IOException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", List.of("application/x-protobuf"));
        headers.put("Authorization", List.of(authorization.toString()));
        RequestBody rbody = NetworkAPI.protobufRequestBody((MessageLite)groupChange);
        String path = groupLinkPassword.isPresent() ? String.format(GROUPSV2_GROUP_PASSWORD, new Object[]{Base64.getEncoder().withoutPadding().encode(groupLinkPassword.get())}) : GROUPSV2_GROUP;
        byte[] body = rbody.getRawBytes();
        Response response = this.getResponse(this.storageEndpointUri + path, "PATCH", body, headers);
        GroupChangeResponse answer = GroupChangeResponse.newBuilder().setGroupChange(GroupChange.parseFrom((byte[])response.body().bytes())).build();
        return answer;
    }

    public StorageManifest getStorageManifest(String authToken) throws IOException {
        try {
            NetworkClient client;
            Response response;
            URI uri = new URI(this.storageEndpointUri + "/v1/storage/manifest");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            if ((response = (client = this.getStorageClient()).sendRequest(uri, "GET", new byte[0], headers)) == null) {
                throw new IOException("Missing body!");
            }
            return StorageManifest.parseFrom((InputStream)new ByteArrayInputStream(response.body().bytes()));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public SignalStorageManifest getSignalStorageManifest(String authToken, StorageKey storageKey) throws IOException, InvalidKeyException {
        return SignalStorageModels.remoteToLocalStorageManifest(this.getStorageManifest(authToken), storageKey);
    }

    public StorageItems readStorageItems(String authToken, ReadOperation operation) throws IOException {
        try {
            URI uri = new URI(this.storageEndpointUri + "/v1/storage/read");
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            if (authToken != null) {
                headers.put("Authorization", List.of(authToken));
            }
            headers.put("Content-Type", List.of("application/x-protobuf"));
            NetworkClient client = this.getStorageClient();
            Response response = client.sendRequest(uri, "PUT", operation.toByteArray(), headers);
            if (response == null) {
                throw new IOException("Missing body!");
            }
            return StorageItems.parseFrom((byte[])response.body().bytes());
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public TurnServerInfo getTurnServerInfo() throws IOException {
        Response response = this.getResponse(this.endpointUri + CALLING_RELAYS, "GET", new byte[0]);
        System.err.println("RESP = " + response.body().string());
        GetCallingRelaysResponse answer = JsonUtils.fromJson(response.body().string(), GetCallingRelaysResponse.class);
        return (TurnServerInfo)answer.getRelays().get(0);
    }

    private static RequestBody protobufRequestBody(MessageLite protobufBody) {
        return protobufBody != null ? RequestBody.create(MediaType.parse("application/x-protobuf"), protobufBody.toByteArray()) : null;
    }

    public String reserveUsername(List<Username> usernames) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    public String confirmUsername(String hash, String proof, String link) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    public String getAciByUsernameHash(String hash) {
        Thread.dumpStack();
        throw new RuntimeException();
    }

    public PreKeyResponse getPreKey(String uuid, int deviceId) throws IOException {
        try {
            URI uri = new URI(this.endpointUri + "/v2/keys/" + uuid + "/" + deviceId);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(this.cp.get())));
            Response response = this.getIdentifiedClient().sendRequest(uri, "GET", new byte[0], headers);
            NetworkAPI.checkResponseStatus(response);
            if (this.getIdentifiedClient().supportsJson()) {
                PreKeyResponse answer = JsonUtils.fromJson(response.body().string(), PreKeyResponse.class);
                return answer;
            }
            byte[] raw = response.body().bytes();
            PreKeyResponseMessage pkrm = PreKeyResponseMessage.parseFrom(raw);
            byte[] keyBytes = pkrm.getIdentityKey().toByteArray();
            IdentityKey ik = new IdentityKey(keyBytes);
            ArrayList<PreKeyResponseItem> pkris = new ArrayList<PreKeyResponseItem>();
            for (PreKeyResponseItemMessage item : pkrm.getDevicesList()) {
                int devid = item.getDeviceId();
                int regid = item.getRegistrationId();
                PreKeyEntityMessage pke = item.getPreKeyEntity();
                long keyId = pke.getKeyId();
                if (keyId > Integer.MAX_VALUE) {
                    throw new RuntimeException("Major issue, can't cast a long to an int");
                }
                ECPublicKey pk = new ECPublicKey(pke.getPublicKeyBytes().toByteArray());
                PreKeyEntity preKey = new PreKeyEntity((int)keyId, pk);
                SignedPreKeyEntityMessage spke = item.getSignedPreKeyEntity();
                long skeyId = spke.getKeyId();
                if (skeyId > Integer.MAX_VALUE) {
                    throw new RuntimeException("Major issue, can't cast a long to an int");
                }
                ECPublicKey spk = new ECPublicKey(spke.getPublicKeyBytes().toByteArray());
                byte[] sig = spke.getSignature().toByteArray();
                SignedPreKeyEntity signedPreKey = new SignedPreKeyEntity((int)skeyId, spk, sig);
                PreKeyResponseItem pkItem = new PreKeyResponseItem(devid, regid, preKey, signedPreKey);
                pkris.add(pkItem);
            }
            PreKeyResponse answer = new PreKeyResponse(ik, pkris);
            return answer;
        }
        catch (URISyntaxException | InvalidKeyException ex) {
            Logger.getLogger(NetworkAPI.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public AttachmentV2UploadAttributes getAttachmentV2UploadAttributes() throws IOException {
        try {
            URI uri = new URI(this.endpointUri + ATTACHMENT_V2_PATH);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(this.cp.get())));
            Response response = this.getIdentifiedClient().sendRequest(uri, "GET", new byte[0], headers);
            NetworkAPI.checkResponseStatus(response);
            if (this.getIdentifiedClient().supportsJson()) {
                AttachmentV2UploadAttributes answer = JsonUtils.fromJson(response.body().string(), AttachmentV2UploadAttributes.class);
                return answer;
            }
            return null;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NetworkAPI.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public AttachmentUploadForm getAttachmentV4UploadAttributes() throws IOException {
        try {
            URI uri = new URI(this.endpointUri + ATTACHMENT_V4_PATH);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(this.cp.get())));
            Response response = this.getIdentifiedClient().sendRequest(uri, "GET", new byte[0], headers);
            NetworkAPI.checkResponseStatus(response);
            if (this.getIdentifiedClient().supportsJson()) {
                AttachmentUploadForm answer = JsonUtils.fromJson(response.body().string(), AttachmentUploadForm.class);
                return answer;
            }
            return null;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NetworkAPI.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    public void sendProvisionUrl(String url) throws IOException {
        try {
            URI uri = new URI(this.endpointUri + "/v1/main/provisionurl/" + url);
            LOG.info("Send provisioning url with host " + this.endpointUri + " to " + url);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Response response = this.getIdentifiedClient().sendRequest(uri, "GET", new byte[0], headers);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NetworkAPI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void unlink(int deviceId) throws IOException {
        try {
            LOG.info("Unlink " + deviceId);
            URI uri = new URI(this.endpointUri + "/v1/devices/" + deviceId);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Authorization", List.of(NetworkAPI.getAuthorizationHeader(this.cp.get())));
            Response response = this.getIdentifiedClient().sendRequest(uri, "DELETE", new byte[0], headers);
            LOG.info("Response from delete = " + String.valueOf(response));
            LOG.info("status = " + response.getStatusCode());
            LOG.info("msg = " + response.message());
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public Response sendRequest(HttpRequest request, byte[] payload) throws IOException {
        Response response = this.getIdentifiedClient().sendRequest(request, payload);
        return response;
    }

    private static String getAuthorizationHeader(CredentialsProvider credentialsProvider) {
        try {
            String pwd;
            Object identifier;
            Object object = identifier = credentialsProvider.getAci() != null ? credentialsProvider.getAci().toServiceIdString() : credentialsProvider.getE164();
            if (credentialsProvider.getDeviceId() != 1) {
                identifier = (String)identifier + "." + credentialsProvider.getDeviceId();
            }
            LOG.fine("identifier = " + (String)identifier + " and pw = " + ((pwd = credentialsProvider.getPassword()) == null ? "NULL" : pwd.substring(0, Math.min(3, pwd.length()))));
            return "Basic " + Base64.getEncoder().encodeToString(((String)identifier + ":" + pwd).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void checkResponseStatus(Response response) throws AuthorizationFailedException, IOException {
        int responseCode = response.getStatusCode();
        if (responseCode == 401) {
            throw new AuthorizationFailedException(responseCode, "Authorization failed");
        }
        if (responseCode == 429) {
            LOG.warning("Received HTTP 429 (rate limit) " + response.message());
            LOG.info("response = " + response.body().string());
            throw new IOException("Rate limited");
        }
    }

    private static URI buildConfiguredUrl(String endpoint, String url) throws IOException, URISyntaxException {
        URI endpointUri = URI.create(endpoint);
        URI resumableUri = URI.create(url);
        String combinedPath = endpointUri.getPath() + resumableUri.getPath();
        URI answer = new URI(endpointUri.getScheme(), endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), combinedPath, resumableUri.getQuery(), resumableUri.getFragment());
        LOG.info("ConfiguredUrl = " + String.valueOf(answer));
        return answer;
    }

    public SignalServiceAttachmentPointer uploadAttachment(SignalServiceAttachmentStream attachment) throws IOException {
        return this.attachmentNetworkClient.uploadAttachment(attachment);
    }

    public CompletableFuture<SignalServiceProfile> retrieveVersionedProfile(ServiceId.Aci target, ProfileKey profileKey, Optional<UnidentifiedAccess> unidentifiedAccess, Locale locale) {
        LOG.info("Retrieve profile for ACI = " + String.valueOf(target) + " with lsa = " + String.valueOf(target));
        ProfileKeyVersion profileKeyIdentifier = profileKey.getProfileKeyVersion(target);
        String version = profileKeyIdentifier.serialize();
        String subPath = String.format("%s/%s", target.toServiceIdString(), version);
        return CompletableFuture.supplyAsync(() -> {
            String uriString = String.format(PROFILE_PATH, subPath);
            HttpRequest request = this.buildServiceRequest(uriString, "GET", null, NetworkAPI.getHeadersWithAcceptLanguage(locale), unidentifiedAccess, false);
            NetworkClient client = unidentifiedAccess.isPresent() ? this.getUnidentifiedClient() : this.getIdentifiedClient();
            try {
                Response response = client.sendRequest(request, new byte[0]);
                if (200 == response.getStatusCode()) {
                    try {
                        return (SignalServiceProfile)this.objectMapper.readValue(response.body().string(), SignalServiceProfile.class);
                    }
                    catch (JsonProcessingException ex) {
                        LOG.info("Wrong conversion to json: " + String.valueOf((Object)ex));
                        throw new IllegalArgumentException("wrong json");
                    }
                }
                LOG.info("Failed getting profile for " + String.valueOf(target) + ", return code = " + response.getStatusCode());
                throw new IllegalArgumentException("Wrong responsecode " + response.getStatusCode());
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                throw new RuntimeException("IO Exception");
            }
        });
    }

    private HttpRequest buildServiceRequest(String urlFragment, String method, RequestBody body, Map<String, String> headers, Optional<UnidentifiedAccess> unidentifiedAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) {
        System.err.println("BUILD SERVICE REQUEST results with method " + method + " and headers = " + String.valueOf(headers));
        String endpoint = this.config.getEndpoint().toString();
        HttpRequest.Builder request = HttpRequest.newBuilder();
        try {
            request.uri(new URI(String.format("%s%s", endpoint, urlFragment)));
            if (body == null) {
                request.method(method, HttpRequest.BodyPublishers.noBody());
            } else {
                request.method(method, HttpRequest.BodyPublishers.ofByteArray(body.getRawBytes()));
                if (body.contentType() != null) {
                    request.header("Content-Type", body.contentType().getMediaType());
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.header(header.getKey(), header.getValue());
        }
        if (!headers.containsKey("Authorization") && !doNotAddAuthenticationOrUnidentifiedAccessKey) {
            if (unidentifiedAccess.isPresent()) {
                request.header("Unidentified-Access-Key", Base64.getEncoder().encodeToString(unidentifiedAccess.get().getUnidentifiedAccessKey()));
            } else if (this.cp.get().getPassword() != null) {
                request.header("Authorization", NetworkAPI.getAuthorizationHeader(this.cp.get()));
            }
        }
        System.err.println("BUILD SERVICE REQUEST results in " + String.valueOf(request));
        return request.build();
    }

    public void retrieveProfileAvatar(String path, File destination) throws IOException {
        this.attachmentNetworkClient.retrieveProfileAvatar(path, destination);
    }

    public String requestTransfer(Consumer<String> updates) throws IOException {
        try {
            LOG.info("We will request transfer from primary device");
            String SIGNAL_USER_AGENT = "Signal-Desktop/6.46.0 Linux";
            String HOST = "https://chat.signal.org";
            HashMap myHeaders = new HashMap(4);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
            requestBuilder.header("Authorization", NetworkAPI.getAuthorizationHeader(this.cp.get()));
            requestBuilder.header("User-Agent", SIGNAL_USER_AGENT);
            requestBuilder.header("X-Signal-Agent", SIGNAL_USER_AGENT);
            requestBuilder.header("Content-Type", "application/json");
            requestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
            URI uri = new URI(HOST + "/v1/devices/transfer_archive?timeout=100");
            requestBuilder.uri(uri);
            HttpRequest request = requestBuilder.build();
            LOG.info("Headers = " + String.valueOf(request.headers()));
            updates.accept("start transfer request with 100 seconds timeout");
            Response resp = this.sendRequest(request, new byte[0]);
            String response = resp.body() == null ? null : resp.body().string();
            updates.accept("status code of transfer = " + resp.getStatusCode());
            LOG.info("tranfserresponse = " + response + " and statusCode = " + resp.getStatusCode());
            Map map = (Map)this.objectMapper.readValue(response, Map.class);
            int cdn = (Integer)map.get("cdn");
            String key = (String)map.get("key");
            String url = "https://cdn" + cdn + ".signal.org/attachments/" + key;
            return url;
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
    }

    public static Map<String, String> getHeadersWithAcceptLanguage(Locale locale) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Language", NetworkAPI.formatLanguages(locale.getLanguage(), locale.getCountry(), Locale.US.getLanguage()));
        return headers;
    }

    public static String getAcceptLanguageHeader(Locale locale) {
        return "Accept-Language:" + NetworkAPI.formatLanguages(locale.getLanguage(), locale.getCountry(), Locale.US.getLanguage());
    }

    private static String formatLanguages(String language, String country, String fallback) {
        if (Objects.equals(language, fallback)) {
            return language + ";q=1";
        }
        if (country == null || country.isBlank()) {
            return language + ";q=1," + fallback + ";q=0.5";
        }
        return language + "-" + country + ";q=1," + language + ";q=0.75," + fallback + ";q=0.5";
    }

    private final class ResumeInfo {
        private final String contentRange;
        private final long contentStart;

        private ResumeInfo(NetworkAPI networkAPI, String contentRange, long offset) {
            this.contentRange = contentRange;
            this.contentStart = offset;
        }
    }
}

