/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation.model.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Base64;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;

public class IdentityKeyAdapter {

    public static class Deserializer
    extends JsonDeserializer<IdentityKey> {
        public IdentityKey deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            byte[] identityKeyBytes;
            System.err.println("[IDKEYADD] ");
            try {
                identityKeyBytes = Base64.getDecoder().decode(parser.getValueAsString());
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(parser, "Could not parse identity key as a base64-encoded value", (Throwable)e);
            }
            if (identityKeyBytes.length == 0) {
                System.err.println("[IDKEYADD] 0 bytes");
                return null;
            }
            try {
                IdentityKey answer = new IdentityKey(identityKeyBytes);
                System.err.println("[IDKEYADD] works for " + String.valueOf(answer));
                return answer;
            }
            catch (InvalidKeyException e) {
                throw new JsonParseException(parser, "Could not interpret identity key bytes as an EC public key", (Throwable)e);
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<IdentityKey> {
        public void serialize(IdentityKey identityKey, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            jsonGenerator.writeString(Base64.getEncoder().encodeToString(identityKey.serialize()));
        }
    }
}

