/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.EntityKey;
import io.privacyresearch.clientdata.SqliteStorageBean;
import io.privacyresearch.clientdata.message.MessageDbRecord;
import io.privacyresearch.clientdata.message.MessageKey;
import io.privacyresearch.clientdata.reaction.CreateReactionRequest;
import io.privacyresearch.clientdata.reaction.ReactionDbRecord;
import io.privacyresearch.clientdata.reaction.ReactionKey;
import io.privacyresearch.clientdata.recipient.RecipientKey;
import io.privacyresearch.equation.message.MessagingClient;
import io.privacyresearch.equation.model.ReactionRecord;
import java.util.List;
import java.util.Optional;

public class ReactionService {
    private final SqliteStorageBean storageBean;
    private final MessagingClient client;

    public ReactionService(SqliteStorageBean storageBean, MessagingClient listener) {
        this.storageBean = storageBean;
        this.client = listener;
    }

    public void storeAndNotifyReaction(String emoji, boolean remove, MessageKey originalMessageKey, RecipientKey originalRecipientKey, RecipientKey authorKey, long msgTimestamp) {
        if (remove) {
            List existing = this.storageBean.getReactionData().findByMessageKey(originalMessageKey);
            Optional<ReactionDbRecord> target = existing.stream().filter(rr -> rr.authorRecipientKey().equals((Object)authorKey)).findFirst();
            if (target.isEmpty()) {
                throw new IllegalArgumentException("Can't remove a reaction if we didn't store it yet");
            }
            this.storageBean.getReactionData().removeReaction(originalMessageKey, authorKey);
            this.client.gotReactionRemoved(originalRecipientKey, originalMessageKey, authorKey);
        } else {
            ReactionKey reactionKey = this.storageBean.getReactionData().addReaction(CreateReactionRequest.newBuilder().authorRecipientKey(authorKey).messageKey(originalMessageKey).dateSent(msgTimestamp).dateReceived(msgTimestamp).emoji(emoji).build());
            ReactionDbRecord reaction = (ReactionDbRecord)this.storageBean.getReactionData().findByKey((EntityKey)reactionKey);
            this.client.gotReactionRecord(this.getReactionRecordFromDb(reaction));
        }
    }

    public ReactionRecord getReactionRecordFromDb(ReactionDbRecord db) {
        MessageDbRecord messageRecord = (MessageDbRecord)this.storageBean.getMessageData().findByKey((EntityKey)db.messageKey());
        return new ReactionRecord(db.key(), messageRecord.receiverKey(), db.messageKey(), db.authorRecipientKey(), db.dateSent(), db.dateReceived(), db.emoji());
    }
}

