/*
 * Decompiled with CFR 0.152.
 */
package io.privacyresearch.equation;

import io.privacyresearch.clientdata.keyvalue.PreferenceStorage;
import io.privacyresearch.equation.EquationManager;
import java.util.Arrays;
import java.util.logging.Logger;

public class CheatManager {
    private final EquationManager wave;
    private final PreferenceStorage preferenceStorage;
    public static String CHEATS_ENABLED = "cheats.enabled";
    public static String CHEAT_RECEIPT = "cheats.cheat.receipt";
    public static String CHEAT_REMOTE_DELETE = "cheats.cheat.remotedelete";
    public static String CHEAT_ETERNAL_DELETE = "cheats.cheat.eternaldelete";
    public static String CHEAT_INCOMING_THUMB_SWITCH = "cheats.cheat.incomingthumbswitch";
    public static String CHEAT_OUTGOING_THUMB_SWITCH = "cheats.cheat.outgoingthumbswitch";
    public static String CHEAT_VIEW_ONCE = "cheats.cheat.viewonce";
    public static String CHEAT_SHOW_PHONENUMBER = "cheats.cheat.showphonenumber";
    private static final Logger LOG = Logger.getLogger(CheatManager.class.getName());
    public static final byte[] THUMBS_UP = new byte[]{-16, -97, -111, -115};
    public static final byte[] THUMBS_DOWN = new byte[]{-16, -97, -111, -114};

    public CheatManager(EquationManager wave) {
        this.wave = wave;
        this.preferenceStorage = this.wave.getSqliteStorageBean().preference();
    }

    public boolean enableCheats(boolean enable) {
        LOG.info("Cheats will be " + (enable ? "enabled" : "disabled") + " from now on.");
        this.preferenceStorage.putBoolean(CHEATS_ENABLED, enable);
        return enable;
    }

    public boolean hasCheatsEnabled() {
        return this.preferenceStorage.getBoolean(CHEATS_ENABLED, false);
    }

    public boolean hasCheatFor(String cheat) {
        if (this.preferenceStorage.getBoolean(CHEATS_ENABLED, false)) {
            return this.preferenceStorage.getBoolean(cheat, false);
        }
        return false;
    }

    public boolean setCheatFor(String cheat, boolean val) {
        LOG.info("Set individual cheat for " + cheat + " to " + val);
        this.preferenceStorage.putBoolean(cheat, val);
        return val;
    }

    public static byte[] flipThumbsUpDown(byte[] orig) {
        if (orig == null || orig.length == 0) {
            return orig;
        }
        if (Arrays.equals(orig, THUMBS_UP)) {
            return THUMBS_DOWN;
        }
        if (Arrays.equals(orig, THUMBS_DOWN)) {
            return THUMBS_UP;
        }
        return orig;
    }
}

